InnboundFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceEvent-2.0", "AceDebug-2.0", "FuBarPlugin-2.0")

local loc = AceLibrary("AceLocale-2.2"):new("InnboundFu")
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local crayon = AceLibrary("Crayon-2.0")
local abacus = AceLibrary("Abacus-2.0")
local BS = AceLibrary("Babble-Spell-2.2")

InnboundFu.version = "2.0." .. string.sub("$Revision: 82142 $", 12, -3)
InnboundFu.date = string.sub("$Date$", 8, 17)
InnboundFu.hasIcon = true
InnboundFu.canHideText = true
InnboundFu.hasNoColor = true
InnboundFu.independentProfile = true

--
-- Addon Init/Activate/Deactivate functions
---------------------------------------------

function InnboundFu:OnInitialize()
	self:Debug("InnboundFu initializing...")
	self:RegisterDB("InnboundFuDB")
	self:RegisterDefaults('profile', {
		short = false,
		cooldown = true,
	})
	_, self.Class = UnitClass("player")
end

function InnboundFu:OnEnable()
	self:Debug("InnboundFu now enabled")
	self.NeedsUpdate = {}
	self.METHODS = {}
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateInfo")
	self:RegisterEvent("PLAYER_LEAVING_WORLD", "UpdateInfo")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "UpdateInfo")
	self:RegisterEvent("BAG_UPDATE", "UpdateHearth")
	self:UpdateAstral()
	self:UpdateBind()
	self:RegisterEvent("CHAT_MSG_SYSTEM")
	self:RegisterEvent("SPELLS_CHANGED")
	self:UpdateInfo()
	self:ScheduleRepeatingEvent(self.RunTasks, 1, self)
end

function InnboundFu:OnDisable()
	self:Debug("InnboundFu now disabled")
	self.NeedsUpdate, self.METHODS = nil, nil
end

--
-- Event fired functions
--------------------------

function InnboundFu:UpdateInfo()
	self:Debug("Updating Info")
	self:UpdateHearth()
	self:UpdateCooldowns()
end

function InnboundFu:CHAT_MSG_SYSTEM()
	self:Debug("Scheduling bind update")
	self.NeedsUpdate.UpdateBind = self.UpdateBind
end

function InnboundFu:SPELLS_CHANGED()
	self:Debug("Scheduling Astral Recall update")
	self.NeedsUpdate.UpdateAstral = self.UpdateAstral
end


--
-- Interface Update functions
-------------------------------

function InnboundFu:OnMenuRequest()
	dewdrop:AddLine(
		'text', loc["Short Names"],
		'arg1', self,
		'func', function() self:ToggleOption("short", true) end,
		'checked', self.db.profile.short
	)
	dewdrop:AddLine(
		'text', loc["Cooldown"],
		'arg1', self,
		'func', function() self:ToggleOption("cooldown", true) end,
		'checked', self.db.profile.cooldown
	)
end

function InnboundFu:UpdateData()
	self:Debug("Updating data")
	if self.METHODS.Astral then
		self:Debug("Setting method to Astral Recall")
		self.Method = "Astral"
	elseif self.METHODS.Hearth then
		self:Debug("Setting method to Hearthstone")
		self.Method = "Hearth"
	else
		self:Debug("No method found")
		self.Method = nil
	end
end

function InnboundFu:UpdateText()
	self:Debug("Updating Text")
	local i
	if self.Method then
		i = self.BLOC
		local f, s

		if self.db.profile.short then
			local idx = strfind(i, " ")

			if idx then
				f = strsub(i, 1, idx - 1)
				s = strsub(i, idx + 1)
			else
				f = i
			end

			local m = self.db.profile.length or 2

			if strlen(f) > m then
				f = strsub(f, 1, m)
			end

			if s and strlen(s) > m then
				s = strsub(s, 1, m)
				i = f..s
			else
				i = f
			end

		end

		local my_text, isReady = self:GetCooldown(self.Method)
		if isReady then
			i = crayon:Green(i)
		else
			i = crayon:Orange(i)
			if self.db.profile.cooldown then
				i = i  .. crayon:White(" (") .. my_text .. crayon:White(")")
			end
		end
	else
		i = crayon:Red(loc["N/A"])
	end
	self:SetText(i)
end

function InnboundFu:OnTooltipUpdate()
	self:Debug("Updating Tooltip")
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	local bloc = self.BLOC
	if bloc then
		cat:AddLine('text', loc["Inn"]..": ", 'text2', bloc)
	else
		self.NeedsUpdate.UpdateBind = self.UpdateBind
	end
	for k,v in pairs(self.METHODS) do
		local my_text = v.desc
		if v.cooldown then
			cat:AddLine('text', my_text, 'text2', loc["Ready"])
		else
			cat:AddLine('text', my_text, 'text2', self:GetCooldown(k))
		end
	end
end


--
-- Internal functions
-----------------------

function InnboundFu:RunTasks()
	for k,v in pairs(self.NeedsUpdate) do
		self:Debug(string.format("Executing scheduled function: %s", k))
		v(self)
		self.NeedsUpdate[k] = nil
	end
	if self.db.profile.cooldown then
		self:UpdateText()
	end
end

function InnboundFu:GetLinkInfo(link)
	if type(link) == "string" then
		local _, _, itemid = string.find(link, "item:(%d+)")
		local desc = GetItemInfo(link)
		if itemid and desc then
			return itemid, desc
		end
	end
end

function InnboundFu:ParseItem(b, s, link)
	if link and b and s then
		local itemid, d = self:GetLinkInfo(link)
		if itemid and d then
			if itemid == "6948" then
				self:Debug("Found Hearthstone, processing")
				self.METHODS.Hearth = {bag = b, slot = s, desc = d}
				_, self.METHODS.Hearth.cooldown = self:GetCooldown("Hearth")
			end
		end
	end
end

function InnboundFu:UpdateHearth()
	self:Debug("Updating Hearthstone info")
	for b = 0, NUM_BAG_FRAMES do
		local SLOTS = GetContainerNumSlots(b)
		if SLOTS > 0 then
			for s = 1, SLOTS do
				self:ParseItem(b, s, GetContainerItemLink(b, s))
			end
		end
	end
end

function InnboundFu:UpdateAstral()
	self:Debug("Updating Astral Recall info")
	if self.Class == "SHAMAN" then
		local s
		for i = 1, 180 do
			s = GetSpellName(i, BOOKTYPE_SPELL)
			d = BS["Astral Recall"]
			if s == d then
				self.METHODS.Astral = {sid = i, desc = d}
				_, self.METHODS.Astral.cooldown = self:GetCooldown("Astral")
				return
			end
		end
	end
end

function InnboundFu:GetCooldown(method)
	self:Debug(string.format("Determining cooldown for %s", method))
	local t, d, cat

	if method == "Hearth" then
		local I = self.METHODS[method]
		if (I.bag and I.slot) then
			cat = "UpdateHearth"
			t, d = GetContainerItemCooldown(I.bag, I.slot)
		end
	elseif method == "Astral" then
		cat = "UpdateAstral"
		local sid = self.METHODS[method].sid
		if sid then
			t, d = GetSpellCooldown(sid, BOOKTYPE_SPELL)
		end
	end

	if t and d then
		local cd = d - (GetTime() - t)
		if cd < 1 then
			return crayon:Green(loc["Ready"]), true
		elseif (cd < 60) then
			return abacus:FormatDurationFull(cd, TRUE, FALSE), false
		else
			return abacus:FormatDurationFull(cd, TRUE, TRUE), false
		end
	else
		self.NeedsUpdate[cat] = self[cat]
		return crayon:Red(loc["N/A"]), false
	end
end

function InnboundFu:UpdateBind()
	self:Debug("Updating bind location")
	local bloc = GetBindLocation()
	if bloc then
		if bloc ~= self.BLOC then
			self.BLOC = bloc
			self.NeedsUpdate.UpdateDisplay = self.UpdateDisplay
		end
	else
		self.NeedsUpdate.UpdateBind = self.UpdateBind
	end
end

function InnboundFu:UpdateCooldowns()
	self:Debug("Updating cooldowns")
	for k,v in pairs(self.METHODS) do
		_, v.cooldown = self:GetCooldown(k)
	end
end

--
-- Utils
----------

function InnboundFu:ToggleOption(var, doUpdate)
	self:Debug(string.format("Toggling variable %s", var))
	self.db.profile[var] = not self.db.profile[var]
	if doUpdate then
		self:Update()
	end
	return self.db.profile[var]
end
