local Tablet = AceLibrary("Tablet-2.0")

FuBar_IOPFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceConsole-2.0"); 
 
FuBar_IOPFu.cannotDetachTooltip = true 
FuBar_IOPFu.hasNoColor = true 
FuBar_IOPFu.clickableTooltip = false 
FuBar_IOPFu.cannotAttachToMinimap = true; 
FuBar_IOPFu.hasIcon = "Interface\\Icons\\INV_Relics_IdolofFerocity" 
FuBar_IOPFu.title = "Inventory On Par" 
 
-- ************************** Variables ******************************************* 
FuBar_IOPFu:RegisterDB("FuBar_IOPFuDB"); 
  
-- ************************** Functions ******************************************* 
function FuBar_IOPFu:OnInitialize() 
    self:RegisterEvent("UNIT_INVENTORY_CHANGED") 
end 

function FuBar_IOPFu:UNIT_INVENTORY_CHANGED() 
    self:OnTextUpdate() 
end 

function FuBar_IOPFu:OnClick() 
    if IsShiftKeyDown() then 
		ShowUIPanel(InventoryOnParOptionFrame) 
		PlaySound("GAMEGENERICBUTTONPRESS") 
    elseif IsControlKeyDown() then 
		IOP_ShowPlayerDoll();
		PlaySound("GAMEGENERICBUTTONPRESS") 
    elseif IsAltKeyDown() then 
		local name = UnitName("target") 
		if name and UnitIsPlayer("target")  then 
			IOP_UI_ShowTooltip(name); 
			PlaySound("GAMEGENERICBUTTONPRESS") 
		end 
    else 
		ShowUIPanel(InventoryOnParUIFrame); 
		PlaySound("GAMEGENERICBUTTONPRESS") 
    end 
end 

function FuBar_IOPFu:OnTextUpdate() 
	local iopScore, pvpScore, countText
	_, iopScore, _, pvpScore = IOP_GetItemLevels("player"); 
	if(IOP.Options.pvpValues == 1) then
		countText = format("%.2f", pvpScore);
	else
		countText = format("%.2f", iopScore);
	end
	self:SetText(countText); 
end 

function FuBar_IOPFu:OnTooltipUpdate() 
	local cat = Tablet:AddCategory('columns', 1, 'text');
	tooltiptext = IOP_GetItemLevels("player"); 
	cat:AddLine('text', tooltiptext);
    Tablet:SetHint("Click to show all recorded scores. Shift-Click for options, Ctrl-Click for your details, Alt-Click to show Targets details") 
end 
