local Tablet = AceLibrary("Tablet-2.0")
local Dewdrop = AceLibrary("Dewdrop-2.0")
local Crayon = AceLibrary("Crayon-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_HerbTrackerFu")
local BH = AceLibrary("Babble-Herbs-2.2");

HerbTrackerFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceDB-2.0", "FuBarPlugin-2.0", "AceConsole-2.0")

HerbTrackerFu:RegisterDB("HerbTrackerFuDB")
HerbTrackerFu:RegisterDefaults('realm', {
	chars = {
		['*'] = {
			compactText = false,
			displayOrder = "abc", -- "abc", "skill"
			displayEmpty = false,
			displayCount = 0,
			displayBank = true,
			displayOtherChars = true,
	
			herbs = {
				['*'] = { inv = 0, bank = 0, disp = false, },
			}
		}
	}
})

HerbTrackerFu.displayOrder = {
	abc = {
		BH["Ancient Lichen"],
		BH["Arthas\' Tears"],
		BH["Black Lotus"],
		BH["Blindweed"],
		BH["Briarthorn"],
		BH["Bloodthistle"],
		BH["Bruiseweed"],
		BH["Dreamfoil"],
		BH["Dreaming Glory"],
		BH["Earthroot"],
		BH["Fadeleaf"],
		BH["Fel Lotus"],
		BH["Felweed"],
		BH["Firebloom"],
		BH["Flame Cap"],
		BH["Ghost Mushroom"],
		BH["Golden Sansam"],
		BH["Goldthorn"],
		BH["Grave Moss"],
		BH["Gromsblood"],
		BH["Icecap"],
		BH["Khadgar\'s Whisker"],
		BH["Kingsblood"],
		BH["Liferoot"],
		BH["Mageroyal"],
		BH["Mana Thistle"],
		BH["Mountain Silversage"],
		BH["Netherbloom"],
		BH["Nightmare Vine"],
		BH["Peacebloom"],
		BH["Plaguebloom"],
		BH["Purple Lotus"],
		BH["Ragveil"],
		BH["Silverleaf"],
		BH["Stranglekelp"],
		BH["Sungrass"],
		BH["Swiftthistle"],
		BH["Terocone"],
		BH["Wild Steelbloom"],
		BH["Wildvine"],
		BH["Wintersbite"],
	},
	
	skill = {
		BH["Peacebloom"],
		BH["Silverleaf"],
		BH["Bloodthistle"],
		BH["Earthroot"],
		BH["Mageroyal"],
		BH["Briarthorn"],
		BH["Swiftthistle"],
		BH["Stranglekelp"],
		BH["Bruiseweed"],
		BH["Wild Steelbloom"],
		BH["Grave Moss"],
		BH["Kingsblood"],
		BH["Liferoot"],
		BH["Fadeleaf"],
		BH["Goldthorn"],
		BH["Khadgar\'s Whisker"],
		BH["Wintersbite"],
		BH["Firebloom"],
		BH["Purple Lotus"],
		BH["Wildvine"],
		BH["Arthas\' Tears"],
		BH["Sungrass"],
		BH["Blindweed"],
		BH["Ghost Mushroom"],
		BH["Gromsblood"],
		BH["Golden Sansam"],
		BH["Dreamfoil"],
		BH["Mountain Silversage"],
		BH["Plaguebloom"],
		BH["Icecap"],
		BH["Black Lotus"],
		-- BC
		BH["Felweed"],
		BH["Dreaming Glory"],
		BH["Terocone"],
		BH["Ancient Lichen"],
		BH["Mana Thistle"],
		BH["Netherbloom"],
		BH["Nightmare Vine"],
		BH["Ragveil"],
		BH["Flame Cap"],
		BH["Fel Lotus"],
	},
}

HerbTrackerFu.hasIcon = "Interface\\Icons\\Trade_Herbalism";
HerbTrackerFu.hasNoColor = true;

function HerbTrackerFu:OnInitialize()
	self.bankOpened = false;
	self.charName = UnitName("player");
	
	if self.db.realm.chars[self.charName].order then
		self:ResetDB(); -- Old DB, reset it
	end
	
	--Debugger:RegisterFunction(self, "SaveInv");

	self:SaveInv();
end

function HerbTrackerFu:OnEnable()
    self:RegisterEvents();
end

-- when player disable this addon .bug.
--function HerbTrackerFu:OnDisable()
 --   self:UnRegisterEvents();
--end

function HerbTrackerFu:OnMenuRequest(level, value)
	if level == 1 then
		Dewdrop:AddLine(
			'text', L["Display"],
			'hasArrow', true,
			'value', "display"
		)
		Dewdrop:AddLine(
			'text', L["Sort"],
			'hasArrow', true,
			'value', "displayOrder"
		)
		Dewdrop:AddLine(
			'text', L["Compact text"],
			'func', function()
						self.db.realm.chars[self.charName].compactText = not self.db.realm.chars[self.charName].compactText;
						self:UpdateText();
					end,
			'checked', self.db.realm.chars[self.charName].compactText
		)
		Dewdrop:AddLine(
			'text', L["Show empty stacks"],
			'func', function()
						self.db.realm.chars[self.charName].displayEmpty = not self.db.realm.chars[self.charName].displayEmpty;
					end,
			'checked', self.db.realm.chars[self.charName].displayEmpty
		)
		Dewdrop:AddLine(
			'text', L["Show bank"],
			'func', function()
						self.db.realm.chars[self.charName].displayBank = not self.db.realm.chars[self.charName].displayBank;
					end,
			'checked', self.db.realm.chars[self.charName].displayBank
		)
		Dewdrop:AddLine(
			'text', L["Show other chars"],
			'func', function()
						self.db.realm.chars[self.charName].displayOtherChars = not self.db.realm.chars[self.charName].displayOtherChars;
					end,
			'checked', self.db.realm.chars[self.charName].displayOtherChars
		)
		Dewdrop:AddLine('text', " ")
		
	elseif level == 2 then
		if value == "displayOrder" then
		    Dewdrop:AddLine(
		        'text', L["Alphabetically"],
		        'isRadio', true,
		        'func', function() self:SetdisplayOrder("abc") end,
		        'checked', self:IsdisplayOrder("abc")
		    )
		    Dewdrop:AddLine(
		        'text', L["Skill level"],
		        'isRadio', true,
		        'func', function() self:SetdisplayOrder("skill") end,
		        'checked', self:IsdisplayOrder("skill")
		    )
		    
		elseif value == "display" then
		    for i, herb in pairs(self.displayOrder[self.db.realm.chars[self.charName].displayOrder]) do
		        Dewdrop:AddLine(
		            'text', Crayon:Yellow("[" .. L["short_" .. BH:GetReverseTranslation(herb)] .. "] ") .. herb,
		            'func', function(herb) self:SetDisplayHerb(herb) end,
		            'arg1', herb,
					'checked', self:IsDisplayHerb(herb)
		        )
		    end
		end
	end

end

function HerbTrackerFu:OnTextUpdate()
	local text = "";
	if self.db.realm.chars[self.charName].displayCount > 0 then
     	for i, herb in pairs(self.displayOrder[self.db.realm.chars[self.charName].displayOrder]) do
	        if self.db.realm.chars[self.charName].herbs[herb].disp then
	        	local name;
	        	if self.db.realm.chars[self.charName].compactText then
	        		name = L["short_" .. BH:GetReverseTranslation(herb)];
	        	else
	        		name = herb;
	        	end
	            text = text .. " " .. Crayon:Yellow(name) .. " " .. Crayon:Colorize(Crayon:GetThresholdHexColor(self.db.realm.chars[self.charName].herbs[herb].inv, 0, 5, 10, 15, 20), self.db.realm.chars[self.charName].herbs[herb].inv);
			end
	    end
	    
	   -- text = string.gsub(text, "(%))(%s*)(%w+)", "%1 | %3");
	else
		if self.db.realm.chars[self.charName].compactText then
			text = "HT";
		else
			text = "HerbTrackerFu";
		end	
	end
	
	self:SetText(text);
end

function HerbTrackerFu:OnTooltipUpdate()
	local cat = Tablet:AddCategory('columns', self:CharsCount(self.db.realm.chars) + 1)
	
	if self.db.realm.chars[self.charName].displayOtherChars then cat:AddLine(self:TooltipCharsNames()); end
	for i, herb in pairs(self.displayOrder[self.db.realm.chars[self.charName].displayOrder]) do
		if self.db.realm.chars[self.charName].displayEmpty or self:CharsHaveHerb(herb) then
			cat:AddLine(
    			'text', Crayon:Yellow(herb),
				'justify', "LEFT",		
    			self:TooltipCharsHerbs(herb)
			)
		end
	end
end

function HerbTrackerFu:TooltipCharsNames()
	local res = {'text2', self.charName, 'justify2', "RIGHT"};
	local i = 3;
	
 	if self.db.realm.chars[self.charName].displayOtherChars then
		for char, _ in pairs(self.db.realm.chars) do
	    	if char ~= self.charName then
	   			table.insert(res, 'text' .. i);
	    		table.insert(res, char);
	    	
	    		table.insert(res, 'justify' .. i);
	    		table.insert(res, "RIGHT");
	    
	    		i = i + 1;
	    	end
		end
	end

	return unpack(res);
end

function HerbTrackerFu:TooltipCharsHerbs(herb)
	local res = {'text2', self:CountString(herb), 'justify2', "RIGHT"};
	local i = 3;

	if self.db.realm.chars[self.charName].displayOtherChars then
		for char, _ in pairs(self.db.realm.chars) do
	    	if char ~= self.charName then
	    		tinsert(res, 'text' .. i);
	    		tinsert(res, self:CountString(herb, char));
	    	    	
	    		table.insert(res, 'justify' .. i);
	    		table.insert(res, "RIGHT");
	    
	    		i = i + 1;
	    	end
		end
	end
	
	return unpack(res);
end

function HerbTrackerFu:CharsHaveHerb(herb)
	if self.db.realm.chars[self.charName].herbs[herb].inv > 0 or (self.db.realm.chars[self.charName].displayBank and self.db.realm.chars[self.charName].herbs[herb].bank > 0) then
		return true;
	end
	
    if self.db.realm.chars[self.charName].displayOtherChars then
		for char, _ in pairs(self.db.realm.chars) do
			if self.db.realm.chars[char].herbs[herb].inv > 0 or (self.db.realm.chars[char].displayBank and self.db.realm.chars[char].herbs[herb].bank > 0) then
				return true;
			end
		end
	end
	
	return false;
end

function HerbTrackerFu:CountString(herb, char)
	return self:InvCountString(herb, char) .. self:BankCountString(herb, char);
end

function HerbTrackerFu:BankCountString(herb, char)
	local tempChar = self.db.realm.chars[self.charName];
	
	if char then
		tempChar = self.db.realm.chars[char];
	end
	
	if self.db.realm.chars[self.charName].displayBank then
		return Crayon:Yellow(" (") .. Crayon:Colorize(Crayon:GetThresholdHexColor(tempChar.herbs[herb].bank, 0, 5, 10, 15, 20), tempChar.herbs[herb].bank) .. Crayon:Yellow(")");
	else
		return ""
	end
end 

function HerbTrackerFu:InvCountString(herb, char)
	local tempChar = self.db.realm.chars[self.charName];
	
	if char then
		tempChar = self.db.realm.chars[char];
	end
	
	return Crayon:Colorize(Crayon:GetThresholdHexColor(tempChar.herbs[herb].inv, 0, 5, 10, 15, 20), tempChar.herbs[herb].inv); 
end 

function HerbTrackerFu:SetdisplayOrder(displayOrder)
	self.db.realm.chars[self.charName].displayOrder = displayOrder;
	self:UpdateText();
end

function HerbTrackerFu:IsdisplayOrder(displayOrder)
	return self.db.realm.chars[self.charName].displayOrder == displayOrder;
end

function HerbTrackerFu:SetDisplayHerb(herb)
	self.db.realm.chars[self.charName].herbs[herb].disp = not self.db.realm.chars[self.charName].herbs[herb].disp;
	
	if self.db.realm.chars[self.charName].herbs[herb].disp then
	    self.db.realm.chars[self.charName].displayCount = self.db.realm.chars[self.charName].displayCount + 1;
	else
	    self.db.realm.chars[self.charName].displayCount = self.db.realm.chars[self.charName].displayCount - 1;
	end
	
	self:UpdateText();
end

function HerbTrackerFu:IsDisplayHerb(herb)
	return self.db.realm.chars[self.charName].herbs[herb].disp;
end

function HerbTrackerFu:RegisterEvents()
	self:RegisterEvent("BANKFRAME_OPENED", function() self.bankOpened = true; self:OnBankUpdate(); end);
	self:RegisterEvent("BANKFRAME_CLOSED", function() self.bankOpened = false; end);
	self:RegisterEvent("PLAYERBANKSLOTS_CHANGED", "OnBankUpdate");
	self:RegisterEvent("BAG_UPDATE", "OnBagUpdate");
end

function HerbTrackerFu:OnBankUpdate()	
	self:SaveBank();
	--self:SaveInv();
	
	self:Update();
end

function HerbTrackerFu:OnBagUpdate(arg1)
	if arg1 > 4 then
	    if BankFrame:IsVisible() then
			self:SaveBank();
		end
	else
		self:SaveInv();
	end
	
	self:Update();
end

function HerbTrackerFu:NameFromLink(link)
	return string.match(link, "^|%x+|H.+|h%[(.+)%]");
end

function HerbTrackerFu:GetItemQuantityFromInv(herb)
	local bagSize
	local herbCount = 0;

	for bag = 4, 0, -1 do
		bagSize = GetContainerNumSlots(bag);
		if bagSize > 0 then
			for slot = 1, bagSize, 1 do
				local _, itemQuantity = GetContainerItemInfo(bag, slot);

				if itemQuantity then
					local itemName = HerbTrackerFu:NameFromLink(GetContainerItemLink(bag, slot));
					
					if itemName and itemName ~= "" then

						if itemName == herb then
							herbCount = herbCount + itemQuantity;
						end
					end
				end
			end
		end
	end
	return herbCount;
end

function HerbTrackerFu:GetItemQuantityFromBank(herb)
	local bankSlots, containerItemNum, bagNum, link, quantity, icon, itemName;
	local herbCount = 0;

	bankSlots = GetContainerNumSlots(BANK_CONTAINER);
	if bankSlots then
		for containerItemNum = 1, bankSlots do
			link = GetContainerItemLink(BANK_CONTAINER, containerItemNum);
			_, quantity = GetContainerItemInfo(BANK_CONTAINER, containerItemNum);
			if link then
				--LinkToName
				itemName = HerbTrackerFu:NameFromLink(link);
				if itemName == herb then
					herbCount = herbCount + quantity;
				end
			end
		end

		for bagNum = 5, 10 do
			bankSlots = GetContainerNumSlots(bagNum);
			if bankSlots then
				local id = BankButtonIDToInvSlotID(bagNum, 1);
				link = GetInventoryItemLink("player", id);
				icon = GetInventoryItemTexture("player", id);
				for containerItemNum = 1, bankSlots do
					link = GetContainerItemLink(bagNum, containerItemNum);
					icon, quantity = GetContainerItemInfo(bagNum, containerItemNum);
					if link then
						--LinkToName
						itemName = HerbTrackerFu:NameFromLink(link);
						if itemName == herb then
							herbCount = herbCount + quantity;
						end
					end
				end
			end
		end
	end
	
	if not self.bankOpened then
	    herbCount = self.db.realm.chars[self.charName].herbs[herb].bank;
	end

	return herbCount;
end

function HerbTrackerFu:SaveInv()
	for _, herb in ipairs(self.displayOrder.abc) do
		self.db.realm.chars[self.charName].herbs[herb].inv = HerbTrackerFu:GetItemQuantityFromInv(herb);
	end
end

function HerbTrackerFu:SaveBank()
	for _, herb in ipairs(self.displayOrder.abc) do
		self.db.realm.chars[self.charName].herbs[herb].bank = HerbTrackerFu:GetItemQuantityFromBank(herb);
	end
end

function HerbTrackerFu:CharsCount(tab)
   if not self.db.realm.chars[self.charName].displayOtherChars then return 1; end
   
   local n = 0;
   
   for _ in pairs(tab) do
     n = n + 1;
   end
   
   return n;
end
