local L = AceLibrary("AceLocale-2.2"):new("FuBar_HBFu")
local Tablet = AceLibrary("Tablet-2.0");

HBFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceHook-2.1")
HBFu.hasIcon = "Interface\\AddOns\\FuBar_HBFu\\icon"
HBFu.defaultPosition = "LEFT"
HBFu.defaultMinimapPosition = 180
HBFu.cannotDetachTooltip = true
HBFu.hasNoColor = true
HBFu:RegisterDB("HBFuDB")
HBFu.cannotDetachTooltip = true



function HBFu:OnInitialize()
    self.hasIcon = true
    self:SetIcon(true)
end

function HBFu:OnEnable()
	HealBot_Config.ButtonShown = 0
	HealBot_MMButton_Init()
end

function HBFu:OnDisable()
	HealBot_Config.ButtonShown = 1
	HealBot_MMButton_Init()
end

function HBFu:OnClick(button)
	HealBot_TogglePanel(HealBot_Action)
end

function HBFu:OnTooltipUpdate()
	Tablet:SetHint(L["Click to Show/Hide HealBot"])
end

function HBFu:OnTextUpdate()
    if self:IsTextShown() then
        self:SetText("HealBot")
    end
    if not self:IsIconShown() then
        self:HideIcon()
    end
end

HBFu.OnMenuRequest = {
	type = 'group',
	args = {
		config = {
            	type = 'execute',
            	name = L["Options"],
            	desc = L["Open HealBot Options Frame"],
            	func  = function() HealBot_TogglePanel(HealBot_Options) end,
		},
		reset = {
            	type = 'execute',
            	name = L["Reset HealBot"],
            	desc = L["Reset HealBot to all Defaults"],
            	func  = function() HealBot_SetResetFlag("SOFT") end,
		},
	},
}