--[[
--Thanks to Rabbit for helping me along and getting things right :)
--
--ToDo:
-- * Add support for tracking numer of drops of a selected item.
-- * Add support for logging group kills.
-- * Add localization support.
--]]

local L = AceLibrary("AceLocale-2.2"):new("GrindFu")
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local tourist = AceLibrary("Tourist-2.0")

local defaultIcon = "Interface\\Icons\\Spell_Shadow_DeathCoil"
local xp = 0
local totalKill = 0
local ownKill = 0
local initialXP = 0
local hits = 0
local ilotp = 0
local ilotpheal = 0
local heroism = 0
local heroismheal = 0
local timeReset = time();
local reg = false

local _G = getfenv(0)

local killTable = {}

local goodFlags = {1, 2, 4, 5, 6}

GrindFu = AceLibrary("AceAddon-2.0"):new("AceHook-2.1", "AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0", "FuBarPlugin-2.0")
local GrindFu = GrindFu

GrindFu.hasIcon = defaultIcon
GrindFu.clickableTooltip = true

local options = {
	type = "group",
	name = "FuBar_GrindFu",
	desc = "FuBar_GrindFu",
	args = {
		reset = {
			type = "group",
			name = "Reset",
			desc = "Reset",
			args = {
				resetK = {
					type = "execute",
					name = "Reset Own Kills",
					desc = "Reset the killcount",
					func = "resetKill",
					order = 101,
				},
				resetXP = {
					type = "execute",
					name = "Reset XP",
					desc = "Resets the XP tracker",
					func = "resetXP",
					order = 102,
				},
				resetAll = {
					type = "execute",
					name = "Reset All",
					desc = "Resets both the Killcount and XP tracker",
					func = "resetAll",
					order = 103,
				},
			},
		},
	},
}

function GrindFu:OnInitialize()
	local revision = tonumber((string.match("$Revision: 76076 $", "^.-(%d+).-$"))) or 1
	if not self.version then self.version = "1" end
	self.version = self.version .. "." .. revision
	self.revision = revision

	_G.FUBAR_GRINDFU_VERSION = self.version
	_G.FUBAR_GRINDFU_REVISION = self.revision

	self:RegisterDB("GrindFuPerCharDB")
	
	self:RegisterChatCommand("/GrindFu", options)
	self.OnMenuRequest = options
	
	self:ScheduleRepeatingEvent(self.Update, 1, self)
end

function GrindFu:OnEnable()
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	self:ZONE_CHANGED_NEW_AREA()
	self:doRegister()
	initialXP = UnitXP("player")
end

function GrindFu:doRegister()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "OnEvent")
	self:RegisterEvent("PLAYER_XP_UPDATE", "registerXP")
	reg = true
end

function GrindFu:doUnregister()
	self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:UnregisterEvent("PLAYER_XP_UPDATE")
	reg = false
end

function GrindFu:ZONE_CHANGED_NEW_AREA(msg)
	if tourist:IsInstance(GetZoneText()) then
		if reg == true then
			self:doUnregister()
			self:Print("Disabled: Entering Instance")
		end
	elseif tourist:IsBattleground(GetZoneText()) then
		if reg == true then
			self:doUnregister()
			self:Print("Disabled: Entering Battleground")
		end
	else
		if reg == false then
			self:doRegister()
			self:Print("Enabled: Entering World")
		end
	end
end

function GrindFu:registerXP(msg)
	xp = UnitXP("player") - initialXP
end

function GrindFu:OnEvent(timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, amount)
	if eventType == "UNIT_DIED" then
		partyFlag = string.sub(dstFlags, string.len(dstFlags))
		if not partyFlag == 1 then
			local new = false
			for k in pairs(killTable) do
				if killTable[k][1] == dstName then
					local kills = killTable[k][2]
					killTable[k] = {dstName, kills+1}
					totalKill = totalKill + 1
					new = true
				end
			end
			if new == false then
				table.insert(killTable, {dstName, 1})
				totalKill = totalKill + 1 
			end
		end
	end
end


function GrindFu:registerXP(msg)
	xp = UnitXP("player") - initialXP
end

function GrindFu:resetKill()
	for k in pairs(killTable) do killTable[k] = nil end
	totalKill = 0
	self:Print("Killcount has been reset.")
end

function GrindFu:resetXP()
	xp = 0
	initialXP = UnitXP("player")
	timeReset = time()
	self:Print("XP tracker has been reset.")
end

function GrindFu:resetAll()
	self:resetKill()
	self:resetXP()
end

function GrindFu:OnClick()
	self:resetAll()
end

-- Updates tooltip
function GrindFu:OnTooltipUpdate()
	local cat = tablet:AddCategory("columns", 2)
	-- Adds the kill list
	cat:AddLine('text', "Mob Name", 'textR', 255, 'textG', 0, 'textB', 0, 'text2', "Kills", 'text2R', 255, 'text2G', 0, 'text2B', 0)
	for k,v in ipairs(killTable) do 
		cat:AddLine('text', killTable[k][1], 'text2', killTable[k][2], 'text2R', 255, 'text2G', 255, 'text2B', 255)
	end
	cat:AddLine('text', "Total:", 'text2', totalKill, 'text2R', 255, 'text2G', 255, 'text2B', 255)
	local cat = tablet:AddCategory("columns", 2)
	-- Adds the XP info
	cat:AddLine('text', "Experience", 'textR', 255, 'textG', 255, 'textB', 255)
	cat:AddLine('text', "XP this session:", 'text2', xp, 'text2R', 255, 'text2G', 255, 'text2B', 255)
	-- Calulates XP/H, and rounds the result up.
	xpH = math.ceil((3600/(time()-timeReset))*xp)
	cat:AddLine('text', "XP/Hour:", 'text2', xpH, 'text2R', 255, 'text2G', 255, 'text2B', 255)
	-- Calculates time to level
	local tim = self:makeTime(time() - timeReset)
	local ttl
	if xpH == 0 then
		ttl = "?"
	else
		ttl = self:timeToLevel(xpH)
	end
	cat:AddLine('text', "Time to level:", 'text2', ttl, 'text2R', 255, 'text2G', 255, 'text2B', 255)
	cat:AddLine('text', "Duration of session:", 'text2', tim, 'text2R', 255, 'text2G', 255, 'text2B', 255)
	tablet:SetHint("|cffeda55fClick|r to reset all.")
end

-- Function to calculate time to level
function GrindFu:timeToLevel(xph)
	return self:makeTime(math.ceil(((UnitXPMax("player")-UnitXP("player")) / xpH)*3600))
end

-- Function to convert seconds into HH/MM/SS
function GrindFu:makeTime(t)
	local s = t
	m = 0
	h = 0
	while s >= 60 do
		m = m + 1
		s = s - 60
	end
	while m >= 60 do
		h = h + 1
		m = m - 60
	end
	return h.."h "..m.."m "..s.."s"
end
