GemWatchFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0","AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
local L = AceLibrary("AceLocale-2.2"):new("GemWatchFu")
local self=GemWatchFu
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
GemWatchFu.hasIcon = "Interface\\Icons\\INV_Jewelcrafting_LivingRuby_02"


local slots={
	"HeadSlot",
	"NeckSlot",
	"ShoulderSlot",
	"BackSlot",
	"ChestSlot",
	"ShirtSlot",
	"TabardSlot",
	"WristSlot",
	"HandsSlot", 
	"WaistSlot",
	"LegsSlot",
	"FeetSlot",
	"Finger0Slot",
	"Finger1Slot",
	"Trinket0Slot",
	"Trinket1Slot",
	"MainHandSlot",
	"SecondaryHandSlot",
	"RangedSlot",
	"AmmoSlot",
}

local function CountGem()
	local redgems=0
	local yellowgems=0
	local bluegems=0
	--local meta
	for _,slotname in pairs(slots) do
		local itemlink = GetInventoryItemLink("player", GetInventorySlotInfo(slotname) )
		if itemlink then 
			for i=1,3 do
				local gem=select(2,GetItemGem(itemlink,i))
				if gem then
					local _, _, _, _, _, gemtype, gemcolor = GetItemInfo(gem)
					--if gemcolor==L["Meta"] then meta=gem 
					--elseif gemcolor==L["Purple"] then 
					if gemcolor==L["Purple"] then 
						redgems=redgems+1
						bluegems=bluegems+1
					elseif gemcolor==L["Green"] then 
						yellowgems=yellowgems+1
						bluegems=bluegems+1
					elseif gemcolor==L["Orange"] then 
						yellowgems=yellowgems+1
						redgems=redgems+1
					elseif gemcolor==L["Red"] then redgems=redgems+1
					elseif gemcolor==L["Yellow"] then yellowgems=yellowgems+1
					elseif gemcolor==L["Blue"] then bluegems=bluegems+1
					end
				end
			end
		end
	end
	return redgems, yellowgems, bluegems, meta
end

function GemWatchFu:OnInitialize()
  GemWatchFu:RegisterDB("GemWatchFuDB")
end

function GemWatchFu:OnEnable()
	self:RegisterEvent("UNIT_STATS", function() self:Update() end)
	self:RegisterChatCommand('/gemwatch', 
		function()
			local red,yellow,blue=CountGem()
			self:Print(RED_FONT_COLOR_CODE..L["Red"]..": "..FONT_COLOR_CODE_CLOSE..red)
			self:Print("|cffffff00"..L["Yellow"]..": "..FONT_COLOR_CODE_CLOSE..yellow)
			self:Print("|cff0070dd"..L["Blue"]..": "..FONT_COLOR_CODE_CLOSE..blue)
		end
	)
end


function GemWatchFu:OnDisable()
end

function GemWatchFu:OnTextUpdate()
	local red,yellow,blue=CountGem()
	self:SetText(RED_FONT_COLOR_CODE..red..FONT_COLOR_CODE_CLOSE.." ".."|cffffff00"..yellow..FONT_COLOR_CODE_CLOSE.." ".."|cff0070dd"..blue..FONT_COLOR_CODE_CLOSE)
end

function GemWatchFu:OnTooltipUpdate()
	local red,yellow,blue=CountGem()

	local cat = tablet:AddCategory(
	'columns', 2
	)
	cat:AddLine(
	'text',RED_FONT_COLOR_CODE..L["Red"]..FONT_COLOR_CODE_CLOSE,
	'text2',red
	)
	cat:AddLine(
	'text',"|cffffff00"..L["Yellow"]..FONT_COLOR_CODE_CLOSE,
	'text2',yellow
	)
	cat:AddLine(
	'text',"|cff0070dd"..L["Blue"]..FONT_COLOR_CODE_CLOSE,
	'text2',blue
	)
end
