-----------------
-- Definitions --
-----------------
--[[
GR     = GearRating     ((TCIL2 / 12.585) * 1.3) + 1.3

IL     = ItemLevel
TIL    = Total Item Level (sum of all IL)
AIL    = Array of IL per quality (poor, common, uncommon, rare, epic, legendary, artifact), 

CIL1   = IL compensated for item quality (epic, rare, uncommon, etc.)
TCIL1  = sum of all CIL1
ACIL1  = Array of CIL1 per quality (poor, common, uncommon, rare, epic, legendary, artifact), 

CIL2   = CIL1 compensated for item slot (head, chest, feet, etc.)   (also called IR)
TCIL2  = sum of all CIL2,   IN THE CURRENT VERSION, THIS IS YOUR GR!    (TCIL2 == GR)
ACIL2  = Array of CIL2 per quality (poor, common, uncommon, rare, epic, legendary, artifact), 
  ]]

-----------------
-- Ace2 Locale --
-----------------
local L = AceLibrary("AceLocale-2.2"):new("GearRating")

--------------------------------
-- Public GearRating function --
--------------------------------

-- GetGearRating
---> params:
--[[
    unitID: a unitid as described in http://www.wowwiki.com/UnitId
    silent: optional. If true, do not generate error-messages
  ]]
---> returns:
--[[
    GR: The GearRating of the requested target
        - nil if an error occured
    TIL: see Definitions at the top of this file
    AIL: same
    TCIL1: same
    ACIL1: same
    TCIL2: same
    ACIL2: same
  ]]
function GearRating:GetGearRating(unitID, silent)
    if UnitExists(unitID) then
    
        if UnitIsPlayer(unitID) then
        
--            if UnitIsFriend("player", unitID) then
            
                if CheckInteractDistance(unitID, 1) then
                
                    return self:GR_GetGR(unitID)
                    
                else
                    self:PrintError(self.ERROR_OUTOFRANGE, "'"..UnitName(unitID).."'"..L[" is out of range."], silent)
                    return nil
                end
--            else
--                self:PrintError(self.ERROR_NOTFRIENDLY, "'"..UnitName(unitID).."'"..L[" is not a friendly target."], silent)
--                return nil
--            end
        else
            self:PrintError(self.ERROR_NOTPLAYER, "'"..UnitName(unitID).."'".. L[" is not a player."], silent)
            return nil
        end
    else
        self:PrintError(self.ERROR_NOTEXIST, "'"..unitID.."'".. L[" does not exist."], silent)
        return nil
    end
end

