-----------------
-- Definitions --
-----------------
--[[
GR     = GearRating

IL     = ItemLevel
TIL    = Total Item Level (sum of all IL)
AIL    = Array of IL per quality (poor, common, uncommon, rare, epic, legendary, artifact), 

CIL1   = IL compensated for item quality (epic, rare, uncommon, etc.)
TCIL1  = sum of all CIL1
ACIL1  = Array of CIL1 per quality (poor, common, uncommon, rare, epic, legendary, artifact), 

CIL2   = CIL1 compensated for item slot (head, chest, feet, etc.)
TCIL2  = sum of all CIL2,   THIS IS YOUR GEARRATING!    (TCIL2 == GR)
ACIL2  = Array of CIL2 per quality (poor, common, uncommon, rare, epic, legendary, artifact), 
  ]]

---------------------------------------
-- chars that are used in the TILstr --
---------------------------------------

GearRating.GR_Poor = 0
GearRating.GR_Common = 1
GearRating.GR_Uncommon = 2
GearRating.GR_Rare = 3
GearRating.GR_Epic = 4
GearRating.GR_Legendary = 5
GearRating.GR_Artifact = 6

GearRating.GR_RarityChar = {
    -- poor
    "p",
    -- common
    "c",
    -- uncommon
    "u",
    -- rare
    "r",
    -- epic
    "e",
    -- legendary
    "l",
    -- artifact
    "a" }

GearRating.GR_RarityString = {
    "poor",
    "common",
    "uncommon",
    "rare",
    "epic",
    "legendary",
    "artifact" }

-------------------------------------------------
-- values used to calculate CIL1 ----------------
-------------------------------------------------
------------------- based on: -------------------
-- http://www.wowwiki.com/Formulas:Item_Values --
-------- Calculating item level section ---------
-------------------------------------------------

GearRating.GR_Subtract = {
    -- poor
    0,
    -- common
    0,
    -- uncommon
    4.00,
    -- rare
    1.84,
    -- epic
    1.30,
    -- legendary
    0,
    -- artifact
    0 }
    
GearRating.GR_Factor = {
    -- poor ( poor items are worth 0 )
    0,
    -- common ( common items are worth 0 )
    0,
    -- uncommon ( div 2 == * 0,5 )
    0.5,
    -- rare ( div 1.6 == * 0.625 )
    0.625,
    -- epic ( div 1.3 == * 0.7692 )
    0.7692,
    -- legendary ( legendary items are not compensated )
    1,
    -- artifact ( artifact items are not compensated )
    1 }

GearRating.GR_EpicFactor = 1.3
GearRating.GR_EpicSubtract = 1.30
    
-------------------------------------------------
-- values used to calculate CIL2 ----------------
-------------------------------------------------
------------------- based on: -------------------
-- http://www.wowwiki.com/Formulas:Item_Values --
------------ Slot modifiers section -------------
-------------------------------------------------

GearRating.GR_Head = 1
GearRating.GR_Neck = 2
GearRating.GR_Shoulder = 3
GearRating.GR_Shirt = 4
GearRating.GR_Chest = 5
GearRating.GR_Waist = 6
GearRating.GR_Legs = 7
GearRating.GR_Feet = 8
GearRating.GR_Wrist = 9
GearRating.GR_Hands = 10
GearRating.GR_Finger = 11
GearRating.GR_Trinket = 13
GearRating.GR_Back = 15
GearRating.GR_Weapon = 16
GearRating.GR_Offhand = 17
GearRating.GR_Ranged = 18

GearRating.GR_SlotString = {
    "head",
    "neck",
    "shoulder",
    "shirt",
    "chest",
    "waist",
    "legs",
    "feet",
    "wrist",
    "hands",
    "finger",
    "finger",
    "trinket",
    "trinket",
    "back",
    "weapon",
    "offhand",
    "ranged" }

GearRating.GR_SlotFactor = {
    -- head (1)
    1,
    -- neck (2)
    0.55,
    -- shoulder (3)
    0.777,
    -- shirt (4)
    0,
    -- chest (5)
    1,
    -- waist (6)
    0.777,
    -- legs (7)
    1,
    -- feet (8)
    0.777,
    -- wrist (9)
    0.55,
    -- hands (10)
    0.777,
    -- finger 1 (11)
    0.55,
    -- finger 2 (12)
    0.55,
    -- trinket 1 (13)
    0.70,
    -- trinket 2 (14)
    0.70,
    -- back (15)
    0.55,
    -- weapon (16) (this value has to be 1, because GR_WeaponFactor is used after)
    1,
    -- off hand (17) (this value is combined with the value in GR_WeaponFactor) (note: this value is estimated by the author)
    0.777,
    -- ranged weapon (18) (this value has to be 1, because GR_WeaponFactor is used after)
    1 }

-----------------------------------------------
-- values used to calculate CIL2 --------------
-----------------------------------------------
------------------ based on: ------------------
-- own estimation (so subject to discussion) --
-----------------------------------------------

GearRating.GR_MainhandWeapon = 1
GearRating.GR_OffhandWeapon = 2
GearRating.GR_OnehandWeapon = 3
GearRating.GR_TwohandWeapon = 4
GearRating.GR_Shield = 5
GearRating.GR_Bow = 6
GearRating.GR_Thrown = 7
GearRating.GR_Wand = 8
GearRating.GR_HeldinOffhand = 9
GearRating.GR_Relic = 10

-- Equipment slot
        -- justification
    -- value

GearRating.GR_WeaponFactor = {
    -- Main Hand weapon (1)
            -- a weapon is as important as a chest/helm/legs
        1,
    -- Off-hand weapon (2)
            -- an off-hander usually does less damage, however, this is already compensated by GR_SlotFactor
        1,
    -- One-hand weapon (3)
            -- value is determined by GR_SlotFactor
        1,
    -- 2h weapon (4)
            -- a 2h weapon is counts as a Main-hand + Off-hand
        1.777,
    -- Shield (5)
            -- considered about as important as a belt/gloves/shoulders/boots, however, is already influenced by off-hand penalty
        1,
    -- Bow/Crossbow/Gun (6) Hunter/Rogue/Warrior
            -- a warrior/rogue mainly uses a ranged weapon to pull/kite. the strength of the weapon is therefore quite irrelevant
            -- the ranged weapon is considered just a stat-booster: a ring (0.55)
            -- however, for hunters the weapon is very important, and compensated by GR_HunterRangedFactor (0.55 * 3 = 1.65)
        0.55,
    -- Thrown weapon (7) Hunter/Rogue/Warrior
            -- same as Bow/Crossbow/Gun, but Thrown weapons are a bit less important (0.50 * 3 = 1.5)
        0.55,
    -- Wand (8) Priest/Mage/Warlock
            -- considered a Bow/Crossbow/Gun
        0.55,
    -- Held in off-hand (9)
            -- GR_SlotFactor makes this into 0.777
        1,
    -- Relic (10) Druid (Idol) / Shaman (Totem) / Paladin (Libram) / Warlock (Spellstone)
            -- considered as another ring
        0.55 }
        
GearRating.GR_HunterRangedFactor = 3
GearRating.GR_HunterMeleeFactor = 0.33

-- GearRating = ((tcil2 / 12.585) * 1.3 + 1.3)
-- because (4*1) + (5*0.777) + (6*0.55) + (2*0.7) = 12.585
GearRating.GR_AverageFactor = 12.585

-----------------------------------------------------------------------------------
-- function to convert itemEquipLoc (from GetItemInfo) to integer in above array --
-----------------------------------------------------------------------------------
function GearRating:GR_WeaponStrToInt(str)
    if str == "INVTYPE_WEAPONMAINHAND" then
        return self.GR_MainhandWeapon
    elseif str == "INVTYPE_WEAPONOFFHAND" then
        return self.GR_OffhandWeapon
    elseif str == "INVTYPE_WEAPON" then
        return self.GR_OnehandWeapon
    elseif str == "INVTYPE_2HWEAPON" then
        return self.GR_TwohandWeapon
    elseif str == "INVTYPE_SHIELD" then
        return self.GR_Shield
    elseif str == "INVTYPE_RANGED" then
        return self.GR_Bow
    elseif str == "INVTYPE_THROWN" then
        return self.GR_Thrown
    elseif str == "INVTYPE_RANGEDRIGHT" then
        return self.GR_Wand
    elseif str == "INVTYPE_HOLDABLE" then
        return self.GR_HeldinOffhand
    elseif str == "INVTYPE_RELIC" then
        return self.GR_Relic
    else
        return -1
    end
end

