local function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

-----------------------
-- Private functions --
-----------------------


-- GR_GetGR(unitID)
---> params:
--[[
    same as GearRating:GetGearRating() but without checks on the unitID
  ]]
---> returns
--[[
    same as GearRating:GetGearRating() but without checks on the unitID
  ]]
function GearRating:GR_GetGR(unitID)
    -- Init
    til = 0
    ail = { 0, 0, 0, 0, 0, 0, 0 }
    tcil1 = 0
    acil1 = { 0, 0, 0, 0, 0, 0, 0 }
    tcil2 = 0
    acil2 = { 0, 0, 0, 0, 0, 0, 0 }

    -- Loop
    for i=1,18 do
    
        -- skip "shirt"
        if i < 4 or i > 4 then
        
            if unitID ~= "player" then
                InspectUnit(unitID)
            end
            
            l = GetInventoryItemLink(unitID, i)
            if l then
                itemName, itemLink, itemRarity, il, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc = GetItemInfo(l)
                
                -- skip items with itemLevel 0, example: "Insignia of the Alliance"
                if il and il > 0 then
                    -- compensatie for 1-indexed arrays (itemRarity is 0-indexed)
                    itemRarity = itemRarity + 1
                    
                    -- til/AIL
                    -- keep track of total itemLevel per quality (and thus keep track of til)
                    ail[itemRarity] = ail[itemRarity] + il
                    til = til + il
                    
                    -- CIL1
                    -- compensate item-level for quality
                    cil1 = (il - self.GR_Subtract[itemRarity]) * self.GR_Factor[itemRarity]
                    
                    -- tcil1/ACIL1
                    tcil1 = tcil1 + cil1
                    acil1[itemRarity] = acil1[itemRarity] + cil1
                    
                    -- CIL2
                    -- compensate item-level for slot-index
                    cil2 = cil1 * self.GR_SlotFactor[i]
                    if i > 15 then
                        -- use GR_WeaponFactor too
                        cil2 = cil2 * self.GR_WeaponFactor[self:GR_WeaponStrToInt(itemEquipLoc)]

                        -- compensate for hunter's ranged weapon too
                        localizedClass, englishClass = UnitClass(unitID)
                        if englishClass == "HUNTER" then
                        
                            if i == self.GR_Ranged then
                                cil2 = cil2 * self.GR_HunterRangedFactor
                            else
                                cil2 = cil2 * self.GR_HunterMeleeFactor
                            end
                        end
                    end
                    
                    -- tcil2/ACIL2
                    tcil2 = tcil2 + cil2
                    acil2[itemRarity] = acil2[itemRarity] + cil2
                    
                end
            end
        end
    end

    local gearrating = round(((tcil2 / self.GR_AverageFactor) * self.GR_EpicFactor) + self.GR_EpicSubtract, 1)
    return gearrating, til, ail, tcil1, acil1, tcil2, acil2
end

