--------------------
-- Ace2 Libraries --
--------------------
local L = AceLibrary("AceLocale-2.2"):new("GearRating")
local T = AceLibrary("Tablet-2.0")

------------------
-- Ace2 options --
------------------
local options = { 
    type='group',
    args = {
        broadcast2player = {
            type = 'text',
            name = L["Broadcast to Player"],
            desc = L["Broadcast to the specified player (using /w)."],
            usage = L["<player name>"],
            order = -1,
            get = false,
            set = function(v) GearRating:BroadcastToPlayer(v) end,
            guiHidden = true,
        },
        broadcast2channel = {
            type = 'text',
            name = L["Broadcast to Channel"],
            desc = L["Broadcast to the specified channel."],
            usage = L["<channel name or number>"],
            order = -1,
            get = false,
            set = function(v) GearRating:BroadcastToChannel(v) end,
            guiHidden = true,
        },
        showhints = {
            type = 'toggle',
            name = L["Show hints"],
            desc = L["Toggle showing of hints in the tooltip."],
            order = -10000,
            get = function() return GearRating.db.profile.showhints end,
            set = function(v) GearRating.db.profile.showhints = v end,
            map = { [false] = L["Disabled"], [true] = L["Enabled"] },
        },
        raiddisplay = {
            type = 'group',
            name = L["Raid Display"],
            desc = L["Choose which lists to view for Raids."],
            args = {
                displist = {
                    type = 'toggle',
                    name = L["Show Complete List"],
                    desc = L["Toggle display of a complete list."],
                    order = 1,
                    get = function() return GearRating.db.profile.displist end,
                    set = function(v) GearRating.db.profile.displist = v end,
                    map = { [false] = L["Disabled"], [true] = L["Enabled"] },
                },
                dispclass = {
                    type = 'toggle',
                    name = L["Show Lists per Class"],
                    desc = L["Toggle display of lists per class."],
                    order = 2,
                    get = function() return GearRating.db.profile.dispclass end,
                    set = function(v) GearRating.db.profile.dispclass = v end,
                    map = { [false] = L["Disabled"], [true] = L["Enabled"] },
                },
                disptop = {
                    type = 'toggle',
                    name = L["Show Top 3"],
                    desc = L["Toggle display of the top 3."],
                    order = 2,
                    get = function() return GearRating.db.profile.disptop end,
                    set = function(v) GearRating.db.profile.disptop = v end,
                    map = { [false] = L["Disabled"], [true] = L["Enabled"] },
                },
                dispbottom = {
                    type = 'toggle',
                    name = L["Show Bottom 3"],
                    desc = L["Toggle display of the bottom 3."],
                    order = 3,
                    get = function() return GearRating.db.profile.dispbottom end,
                    set = function(v) GearRating.db.profile.dispbottom = v end,
                    map = { [false] = L["Disabled"], [true] = L["Enabled"] },
                },
            },
            order = 1,
        },
    },
}

GearRating:RegisterChatCommand(L["Slash-Commands"], options) 

-----------------
-- FuBar Stuff --
-----------------
GearRating.hasIcon = true 
GearRating.title = "GearRating v0.5"
GearRating.clickableTooltip = true
GearRating.OnMenuRequest = options

local GR_own, GR_target, GR_partyavg
local GR_party = { }
local GR_PARTYNAME = 1
local GR_PARTYGR = 2
local GR_OUTOFRANGE = -1

local broadcastsubject = nil

function GearRating:OnTooltipUpdate()
	local cat = T:AddCategory(
        'columns', 2,
        'child_text2R', 1,
        'child_text2G', 1,
        'child_text2B', 1,
        'child_justify2', "RIGHT"
    )

    cat:AddLine()
    
    if broadcastsubject then
    
        cat:AddLine(
            'text', L["Broadcast to:"]
        )

        cat:AddLine(
            'text', L["say"],
            'indentation', 10,
            'textR', 1, 'textG', 1, 'textB', 1,
            'func', function() self:BroadcastChooseDestination("SAY") end
        )
        cat:AddLine(
            'text', L["party"],
            'indentation', 10,
            'textR', 0, 'textG', 0.5, 'textB', 1,
            'func', function() self:BroadcastChooseDestination("PARTY") end
        )
        cat:AddLine(
            'text', L["raid"],
            'indentation', 10,
            'textR', 1, 'textG', 0.25, 'textB', 0,
            'func', function() self:BroadcastChooseDestination("RAID") end
        )
        cat:AddLine(
            'text', L["guild"],
            'indentation', 10,
            'textR', 0, 'textG', 0.9, 'textB', 0,
            'func', function() self:BroadcastChooseDestination("GUILD") end
        )
        cat:AddLine(
            'text', L["officer"],
            'indentation', 10,
            'textR', 0, 'textG', 1, 'textB', 0.5,
            'func', function() self:BroadcastChooseDestination("OFFICER") end
        )
        cat:AddLine(
            'text', L["target"],
            'indentation', 10,
            'textR', 0.9, 'textG', 0.9, 'textB', 0,
            'func', function() self:BroadcastChooseDestination("TARGET") end
        )
        cat:AddLine(
            'text', L["whisper"],
            'indentation', 10,
            'textR', 0.9, 'textG', 0, 'textB', 0.9,
            'func', function() self:BroadcastChooseDestination("WHISPER") end
        )
        cat:AddLine(
            'text', L["channel"],
            'indentation', 10,
            'textR', 1, 'textG', 0.8, 'textB', 0.8,
            'func', function() self:BroadcastChooseDestination("CHANNEL") end
        )
    
        cat:AddLine( 'text', " " )
        cat:AddLine(
            'text', L["<<< Back"],
            'textR', 0, 'textG', 0.75, 'textB', 1,
            'func', function()
                        broadcastsubject = nil
                        
                        self:Update()
                    end
        )

    self:ShowHint(L["Clicking 'whisper' or 'channel' opens your chat to specify a destination."])

    
    else
    -- if broadcastsubject then .. else

    
    ------------
    -- Player --
    ------------
    if GR_own then
        cat:AddLine(
            'text', L["Player"],
            'func', function()
                        self:BroadcastChooseSubject("player")
                    end
        )
        local _, class = UnitClass("player")
        local r, g, b = self:GetClassColor(class)
        cat:AddLine(
            'text', UnitName("player"),
            'textR', r, 'textG', g, 'textB', b,
            'indentation', 10,
            'text2', ""..GR_own
        )
    end

    ------------
    -- Target --
    ------------
    if GR_target then
    
        cat:AddLine( 'text', " " )
        cat:AddLine(
            'text', L["Target "],
            'func', function()
                        self:BroadcastChooseSubject("target")
                    end
        )
        local _, class = UnitClass("target")
        local r, g, b = self:GetClassColor(class)
        cat:AddLine(
            'text', UnitName("target"),
            'indentation', 10,
            'textR', r, 'textG', g, 'textB', b,
            'text2', ""..GR_target
        )
        
    elseif UnitExists("target") and UnitIsPlayer("target") then
    
        cat:AddLine( 'text', " " )
        cat:AddLine(
            'text', L["Target "]
        )
        cat:AddLine(
            'text', L["< Get GearRating of Target >"],
            'textR', 0, 'textG', 0.75, 'textB', 1,
            'func', function()
                        GR_target = self:GetGearRating("target")
                        self:Update()
                    end
        )
        
    end

    -----------
    -- Party --
    -----------
    if GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 then
        cat:AddLine( 'text', " " )
        
        if GR_partyavg then

            cat:AddLine(
                'text', L["Party "],
                'func', function()
                            self:BroadcastChooseSubject("party")
                        end
            )
            for i=1,#GR_party do
                local _, class = UnitClass(GR_party[i][GR_PARTYNAME])
                local r, g, b = self:GetClassColor(class)
                local grtext = ""
                if GR_party[i][GR_PARTYGR] == GR_OUTOFRANGE then
                    grtext = "Out of range"
                else
                    grtext = GR_party[i][GR_PARTYGR]
                end
                cat:AddLine(
                    'text', GR_party[i][GR_PARTYNAME],
                    'textR', r, 'textG', g, 'textB', b,
                    'indentation', 10,
                    'text2', ""..grtext
                )
            end
            cat:AddLine(
                'text', L["Party Average"],
                'text2', ""..GR_partyavg,
                'text2R', 0, 'text2G', 1, 'text2B', 0
            )
            cat:AddLine(
                'text2', L["< Refresh >"],
                'text2R', 0, 'text2G', 0.5, 'text2B', 1,
                'func', function()
                            GR_partyavg = self:GetPartyRating("party")
                            
                            self:Update()
                        end
            )
        
        else
            cat:AddLine(
                'text', L["Party "]
            )
            cat:AddLine(
                'text', L["< Get GearRating of Party >"],
                'justify', "CENTER",
                'textR', 0, 'textG', 0.75, 'textB', 1,
                'func', function()
                            GR_partyavg = self:GetPartyRating("party")
                            
                            self:Update()
                        end
            )
        end
    end
    
    ----------
    -- Raid --
    ----------
    if GetNumRaidMembers() > 0 then
        cat:AddLine( 'text', " " )
        
        if GR_partyavg then

            cat:AddLine(
                'text', L["Raid "],
                'func', function()
                            self:BroadcastChooseSubject("raid")
                        end
            )

            -------------------
            -- Complete List --
            -------------------
            
            if self.db.profile.displist then
            for i=1,#GR_party do
                if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
            
                    local _, class = UnitClass(GR_party[i][GR_PARTYNAME])
                    local r, g, b = self:GetClassColor(class)
                    cat:AddLine(
                        'text', "|cffffdd00"..i.."|r. "..GR_party[i][GR_PARTYNAME],
                        'textR', r, 'textG', g, 'textB', b,
                        'indentation', 10,
                        'text2', GR_party[i][GR_PARTYGR]
                    )
                    
                end
            end
            
            end
            --displist

            ---------------
            -- Per Class --
            ---------------
            
            if self.db.profile.dispclass then
            for j=1,9 do
            
                local r, g, b = self:GetClassColor(self.ENGLISHCLASSNAMES[j])
                cat:AddLine(
                    'text', ""..L[self.CLASSPLURALS[j]],
                    'indentation', 10,
                    'textR', r, 'textG', g, 'textB', b
                )
                
                local found = false
                for i=1,#GR_party do
                    if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
                
                        local _, class = UnitClass(GR_party[i][GR_PARTYNAME])
                        
                        if class == self.ENGLISHCLASSNAMES[j] then
                            found = true
                            
                            cat:AddLine(
                                'text', GR_party[i][GR_PARTYNAME],
                                'textR', 0.75, 'textG', 0.75, 'textB', 0.75,
                                'indentation', 20,
                                'text2', GR_party[i][GR_PARTYGR]
                            )
                        end
                    end
                end
                if not found then
                    cat:AddLine(
                        'text', L["< None >"],
                        'textR', 0.5, 'textG', 0.5, 'textB', 0.5,
                        'indentation', 20
                    )
                end
            end

            end
            --dispclass
            
            -----------
            -- Top 3 --
            -----------
            if self.db.profile.disptop then
            cat:AddLine(
                'text', L["Top 3"],
                'indentation', 10,
                'textR', 0.25, 'textG', 1, 'textB', 0
            )
            local i = 1
            local nrfound = 0
            while i <= #GR_party and nrfound < 3 do
                if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
            
                    local _, class = UnitClass(GR_party[i][GR_PARTYNAME])
                    local r, g, b = self:GetClassColor(class)
                    cat:AddLine(
                        'text', GR_party[i][GR_PARTYNAME],
                        'textR', r, 'textG', g, 'textB', b,
                        'indentation', 20,
                        'text2', GR_party[i][GR_PARTYGR]
                    )
                    
                    nrfound = nrfound + 1
                end
                
                i = i + 1
            end

            end
            --disptop

            --------------
            -- Bottom 3 --
            --------------
            if self.db.profile.dispbottom then
            cat:AddLine(
                'text', L["Bottom 3"],
                'indentation', 10,
                'textR', 0.25, 'textG', 1, 'textB', 0
            )
            local i = #GR_party
            local nrfound = 0
            while i > 0 and nrfound < 3 do
                if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
            
                    local _, class = UnitClass(GR_party[i][GR_PARTYNAME])
                    local r, g, b = self:GetClassColor(class)
                    cat:AddLine(
                        'text', GR_party[i][GR_PARTYNAME],
                        'textR', r, 'textG', g, 'textB', b,
                        'indentation', 20,
                        'text2', GR_party[i][GR_PARTYGR]
                    )
                    
                    nrfound = nrfound + 1
                end
                
                i = i - 1
            end

            end
            --dispbottom

            ------------------
            -- Out Of Range --
            ------------------
            local count = 0
            for i=1,#GR_party do
                if GR_party[i][GR_PARTYGR] == GR_OUTOFRANGE then
                    count = count + 1
                end
            end
            local r,g,b = 0,1,0
            if count > 0 then
                r,g,b = 1,0,0
            end
            cat:AddLine(
                'text', L["Out of range"],
                'indentation', 10,
                'textR', 0.25, 'textG', 1, 'textB', 0,
                'text2', ""..count,
                'text2R', r, 'text2G', g, 'text2B', b
            )
            
            -------------
            -- Average --
            -------------
            cat:AddLine(
                'text', L["Raid Average"],
                'text2', ""..GR_partyavg,
                'text2R', 0, 'text2G', 1, 'text2B', 0
            )
            cat:AddLine(
                'text2', L["< Refresh >"],
                'text2R', 0, 'text2G', 0.5, 'text2B', 1,
                'func', function()
                            GR_partyavg = self:GetPartyRating("raid")
                            
                            self:Update()
                        end
            )
        
        else
            cat:AddLine(
                'text', L["Raid "]
            )
            cat:AddLine(
                'text', L["< Get GearRating of Raid >"],
                'textR', 0, 'textG', 0.75, 'textB', 1,
                'func', function()
                            GR_partyavg = self:GetPartyRating("raid")
                            
                            self:Update()
                        end
            )
        end
    end
    
    self:ShowHint(L["Click 'Player', 'Target', 'Party' or 'Raid' to broadcast."])
    
    end
    -- if broadcastsubject then .. else
    
end

function GearRating:ShowHint(hint)
    if self.db.profile.showhints then
        T:SetHint(hint)
    end
end

-- Parameter: "player", "target", "party" or "raid"
function GearRating:BroadcastChooseSubject(subject)
    broadcastsubject = subject
    
    self:Update()
end

function GearRating:BroadcastChooseDestination(destination)
    broadcastdestination = destination

    if destination == "TARGET" then
    
        if UnitExists("target") then
            self:Broadcast("WHISPER", UnitName("target"))
        else
            self:PrintError(self.ERROR_NOTEXIST, L["You do not have a target."] )
        end
        
    elseif destination == "WHISPER" then
    
        self:OpenChat(L["/gearrating broadcast2player "])
    
    elseif destination == "CHANNEL" then    

        self:OpenChat(L["/gearrating broadcast2channel "])

    else
    
        self:Broadcast(destination, nil)
        
    end
end

function GearRating:BroadcastToPlayer(player)
    self:Broadcast("WHISPER", player)
end

function GearRating:BroadcastToChannel(channel)
    id, name = GetChannelName( channel )
    if (id > 0 and name ~= nil) then
        self:Broadcast("CHANNEL", id)
    else
        self:PrintError(self.ERROR_NOSUCHCHANNEL, L["No such channel: '"]..channel.."'")
    end
    
    -- Reset GUI
    broadcastsubject = nil
    
    self:Update()
end

function GearRating:Broadcast(chatType, channel)

    if broadcastsubject == "player" then

        self:SendToChannel(L["GearRating of "]..UnitName("player")..": "..GR_own..self:GetAdvertiseTag(), chatType, channel)
    
    elseif broadcastsubject == "target" then

        self:SendToChannel(L["GearRating of "]..UnitName("target")..": "..GR_target..self:GetAdvertiseTag(), chatType, channel)
    
    elseif broadcastsubject == "party" then
    
        local text = ""
        for i=1,#GR_party do
            text = text .. GR_party[i][GR_PARTYNAME].." ("..GR_party[i][GR_PARTYGR].."), "
        end
        if text ~= "" then text = strsub(text, 1, -3) end
        self:SendToChannel(L["GearRating Party Report: "]..text, chatType, channel)
        self:SendToChannel(L["Party Average"]..": "..GR_partyavg..self:GetAdvertiseTag(), chatType, channel)
    
    elseif broadcastsubject == "raid" then

        self:SendToChannel(L["GearRating Raid Report:"], chatType, channel)
            local text = ""
            local i = 1
            local nrfound = 0
            while i <= #GR_party and nrfound < 3 do
                if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
                    text = text .. GR_party[i][GR_PARTYNAME].." ("..GR_party[i][GR_PARTYGR].."), "
                                        
                    nrfound = nrfound + 1
                end
                
                i = i + 1
            end
            if text ~= "" then text = strsub(text, 1, -3) end
        self:SendToChannel(L["  Top 3: "] .. text, chatType, channel)
            local text = ""
            local i = #GR_party
            local nrfound = 0
            while i > 0 and nrfound < 3 do
                if GR_party[i][GR_PARTYGR] ~= GR_OUTOFRANGE then
                    text = text .. GR_party[i][GR_PARTYNAME].." ("..GR_party[i][GR_PARTYGR].."), "
                    
                    nrfound = nrfound + 1
                end
                
                i = i - 1
            end
            if text ~= "" then text = strsub(text, 1, -3) end
        self:SendToChannel(L["  Bottom 3: "] .. text, chatType, channel)
            local count = 0
            for i=1,#GR_party do
                if GR_party[i][GR_PARTYGR] == GR_OUTOFRANGE then
                    count = count + 1
                end
            end
        if count > 0 then
            self:SendToChannel(L["  Out of range: "] .. count, chatType, channel)
        end
        self:SendToChannel(L["Raid Average"]..": "..GR_partyavg..self:GetAdvertiseTag(), chatType, channel)
    
    else
        self:PrintError(self.ERROR_NOBROADCASTSUBJECT, L["This command is not supposed to be used when the broadcast-frame is closed."])
    end

    -- Reset GUI
    broadcastsubject = nil
    
    self:Update()
end

function GearRating:OpenChat(text)
	if ChatFrameEditBox:IsVisible() then
		ChatFrameEditBox:SetText( text )
	else
		ChatFrame_OpenChat(text)
	end
end

-- Parameter: "party" or "raid"
function GearRating:GetPartyRating(partytype)
    GR_party = { }

    local totalgr = 0
    local nrppl = 0
    
    if partytype == "party" then
        totalgr = self:GetGearRating("player", true)
        tinsert(GR_party, { UnitName("player"), totalgr })
        nrppl = 1
    end
    
    local i = 1
    while UnitExists(partytype..i) do
    
        local gr = self:GetGearRating(partytype..i, true)
        if gr then
            tinsert(GR_party, { UnitName(partytype..i) , gr })
            
            totalgr = totalgr + gr
            nrppl = nrppl + 1
        elseif self.LASTERROR == self.ERROR_OUTOFRANGE then
            tinsert(GR_party, { UnitName(partytype..i) , GR_OUTOFRANGE } )
        end            
    
        i = i + 1
    end

    -- sort arry
    sort(GR_party, function(a,b)
            return a[GR_PARTYGR]>b[GR_PARTYGR]
        end)
    
    return math.floor(totalgr / nrppl)
end

function GearRating:OnDataUpdate()
    
--    if not T:IsAttached(MiniMap) then
--        GearRating:UpdateDisplay()
--    end
end

function GearRating:ClearTargetInfo()
    GR_target = nil
    
    self:Update()
end

function GearRating:ClearPartyInfo()
    GR_partyavg = nil
    GR_party = { }
    
    self:Update()
end

function GearRating:OnTextUpdate()
    if GR_own then
        self:SetText(" "..GR_own)
    else
        self:SetText("GearRating")
    end
end

function GearRating:UpdateOwnGR()
    GR_own = self:GetGearRating("player", true)

    self:Update()
end

-----------------
-- Ace2 Events --
-----------------

function GearRating:OnInitialize()
    -- Called when the addon is loaded
end

function GearRating:OnEnable()
    -- Called when the addon is enabled
    
    self:RegisterBucketEvent({"PLAYER_TARGET_CHANGED"}, 0.2, "ClearTargetInfo")
    self:RegisterBucketEvent({"PARTY_INVITE_REQUEST"}, 0.2, "ClearPartyInfo")
	self:RegisterBucketEvent({"UNIT_INVENTORY_CHANGED"}, 1.5, "UpdateOwnGR")

    self:UpdateOwnGR()
end

function GearRating:OnDisable()
    -- Called when the addon is disabled
end
