-------------------------------
-- Error and Debug functions --
-------------------------------
GearRating.LASTERROR = ""

GearRating.ERROR_OUTOFRANGE = "GR_ERROR_OUTOFRANGE"
GearRating.ERROR_ISENEMY = "GR_ERROR_ISENEMY"
GearRating.ERROR_NOTAPLAYER = "GR_ERROR_NOTAPLAYER"
GearRating.ERROR_NOTEXIST = "GR_ERROR_NOTEXIST"

GearRating.ERROR_NOSUCHCHANNEL = "GR_ERROR_NOSUCHCHANNEL"
GearRating.ERROR_NOBROADCASTSUBJECT = "GR_ERROR_NOBROADCASTSUBJECT"

GearRating.RED = "|cffff0000"
GearRating.YELLOW = "|cffffff00"

function GearRating:PrintError(error, msg, silent)
    if not silent then
        self:Print(self.RED..msg)
    end
    self.LASTERROR = error
end

function GearRating:PrintDebug(msg)
    self:Print(self.YELLOW..msg)
end

--------------------
-- Chat functions --
--------------------

function GearRating:SendToChannel(msg, chattype, channel)
    SendChatMessage( msg, chattype, nil, channel )
end

