--[[                           ]]
--[[  From A View To A Kill Fu ]]
--[[                           ]]



--[[           ]]
--[[ Libraries ]]
--[[           ]]

FuBar_FromAViewToAKillFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
FuBar_FromAViewToAKillFu.hasIcon = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\icon.tga"

local L = AceLibrary("AceLocale-2.2"):new("FuBar_FromAViewToAKillFu", true)
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")


--[[          ]]
--[[ Defaults ]]
--[[          ]]

local defaults = 
{
	UpdateRate		= 0.25,		-- update rate for the changing RTIs, don't change
	
	PriorityList = {			-- [position] = RTI icon number as given by API
		[1] = 1,
		[2] = 2,
		[3] = 3,
		[4] = 4,
		[5] = 5,
		[6] = 6,
		[7] = 7,
		[8] = 8,
	},
}

FuBar_FromAViewToAKillFu:RegisterDB("FuBar_FromAViewToAKillFuDB")
FuBar_FromAViewToAKillFu:RegisterDefaults('profile', defaults )


--[[        ]]
--[[ Locals ]]
--[[        ]]

local RTI = {}			-- this table will carry the RTI's number and the assigned raidmember
local RTISaved = {}		-- this table will carry the RTI's number and the assigned raidmember WHEN SAVED
local ICON = {}			-- this table will carry the raidtargeticon textures

for i = 1, 8 do
	local temp = nil
	if i == 1 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\01_star.tga"
	elseif i == 2 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\02_circle.tga"
	elseif i == 3 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\03_diamond.tga"
	elseif i == 4 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\04_triangle.tga"
	elseif i == 5 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\05_moon.tga"
	elseif i == 6 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\06_square.tga"
	elseif i == 7 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\07_cross.tga"
	elseif i == 8 then temp = "Interface\\AddOns\\FuBar_FromAViewToAKillFu\\textures\\08_skull.tga"
	else temp = nil
	end
		
	ICON[i] = temp	-- filling the table with texture paths. it's done this way, because now you can get them via ICON[i]
	temp = nil	
end

local RTIsSaved = false
local PriorityListSaved = false

local PriorityListText = {			
		[1] = L["HighestPriority"],
		[2] = "---------",
		[3] = "-----",
		[4] = "-",
		[5] = "-",
		[6] = "-----",
		[7] = "---------",
		[8] = L["LowestPriority"]
	}

local SavedPriorityList = {			-- [position] = RTI icon number as given by API
		[1] = 1,					-- this table will carry the temp save for the priority list
		[2] = 2,
		[3] = 3,
		[4] = 4,
		[5] = 5,
		[6] = 6,
		[7] = 7,
		[8] = 8,
	}

--[[                      ]]
--[[ RTI Table Management ]]
--[[                      ]]

function FuBar_FromAViewToAKillFu:RTISetFromMenu(index)
	unit = UnitName("target")

	if unit == nil then
		FuBar_FromAViewToAKillFu:Print(L["NoUnitSelected"])
		return
	end
	
	if not FuBar_FromAViewToAKillFu:GetRaidUnitByName(unit) then
		self:Print (L["unit"].."|cffCC2222<"..unit..">|cffFFFFFF"..L["hasnoRaidID"])
		return
	else
		FuBar_FromAViewToAKillFu:RTISet(index, UnitName("target"))
	end
	return
end

function FuBar_FromAViewToAKillFu:RTISet(index, unit)
	if unit == nil then return end
	RTI[index] = {}										-- creating a new row in the RTI table for this specific player - IMPORTANT -
	RTI[index].name	= UnitName(unit)					-- can only insert stuff into a row that was created
	RTI[index].raidid	= FuBar_FromAViewToAKillFu:GetRaidUnitByName(RTI[index].name)
	RTI[index].draw	= true
	dewdrop:Refresh(1)
	if RTI[index].raidid == nil then
		self:Print (L["unit"].."|cffCC2222<"..RTI[index].name..">|cffFFFFFF"..L["hasnoRaidID"])
		RTI[index] = nil
		return
	end
	self:ScheduleRepeatingEvent("icon"..index, self.MarkTarget, FuBar_FromAViewToAKillFu.db.profile.UpdateRate, self, index)

end

function FuBar_FromAViewToAKillFu:RTIRemove(index)
	self:CancelScheduledEvent("icon"..index)
	if not FuBar_FromAViewToAKillFu:PriorityCheck(index) then
		SetRaidTarget(RTI[index].raidid.."target",0);
	end
	RTI[index]			= nil
end

function FuBar_FromAViewToAKillFu:RTIsAreSet()
	for i = 1, 8 do
		if RTI[i] ~= nil then
			return true;
		end
	end
	return false;
end


--[[                      ]]
--[[ Raid Unit Management ]]
--[[                      ]]

function FuBar_FromAViewToAKillFu:GetRaidUnitByName(name)
	for i = 1, GetNumRaidMembers() do
		local unit = "raid"..i
		if (UnitName(unit) == name) then
			return unit
		end
	end
	return nil
end

function FuBar_FromAViewToAKillFu:GetUnitColor(unit)
	local unitnumber = FuBar_FromAViewToAKillFu:GetRaidUnitByName(unit);
	local classcolor = "000000";	-- setting color to black to see if something goes wrong
	
	if unitnumber == nil then		-- setting the classcolor to dark red for 'out-of-raid-units'
		classcolor = "CC2222"		-- this is just for checking, the plugin won't work with OOR units due to them not having a raidindex
		return classcolor
	end
	
	local _ ,class = UnitClass(unitnumber)

--~ classcolors as defined by oRA_MainTankFrames
	if class == "PALADIN" then classcolor = "F48CBA"
	elseif class == "WARRIOR" then classcolor = "C69B6D"
	elseif class == "WARLOCK" then classcolor = "9382C9"
	elseif class == "PRIEST" then classcolor = "FFFFFF"
	elseif class == "DRUID" then classcolor = "FF7C0A"
	elseif class == "MAGE" then classcolor = "68CCEF"
	elseif class == "ROGUE" then classcolor = "FFF468"
	elseif class == "SHAMAN" then classcolor = "2459FF"
	elseif class == "HUNTER" then classcolor = "AAD372"
	else classcolor = "000000"		-- in case of no proper class: setting color to black to see if something goes wrong
	end
	return classcolor;
end


--[[                        ]]
--[[ Dynamic RTI Management ]]
--[[                        ]]

function FuBar_FromAViewToAKillFu:MarkTarget(index)
	local id		= RTI[index].raidid
	local name		= RTI[index].name
	local target	= UnitName(id.."target")

	if target == nil then
		if RTI[index].draw then
			SetRaidTarget(id,index);
			SetRaidTarget(id,0);
			RTI[index].draw = false
		end
	else
		if FuBar_FromAViewToAKillFu:PriorityCheck(index) and RTI[index].draw then
			SetRaidTarget(id.."target",index);
			RTI[index].draw = true
		else
			if not (GetRaidTargetIndex(id.."target") == index) and RTI[index].draw then
				SetRaidTarget(id,index);
				SetRaidTarget(id,0);
				RTI[index].draw = false
			end
		end
	end
	
	if target ~= nil and FuBar_FromAViewToAKillFu:PriorityCheck(index) then
		RTI[index].draw = true
	end
	
	if index == GetRaidTargetIndex(id) then
		if not (name == target) then
			SetRaidTarget(id,0);
		end
	end
end


--[[               ]]
--[[ Priority List ]]
--[[               ]]

--~ function FuBar_FromAViewToAKillFu:TogglePriorityUse()
--~ end

function FuBar_FromAViewToAKillFu:PriorityCheck(index)
	local raidid = RTI[index].raidid
	local targeticon = GetRaidTargetIndex(raidid.."target")
	
	if targeticon == nil then
		return true
	end
	
	for i = 1, 8 do
		if FuBar_FromAViewToAKillFu.db.profile.PriorityList[i] == targeticon then
			return false
		elseif FuBar_FromAViewToAKillFu.db.profile.PriorityList[i] == index then
			return true
		end
	end
	
end

function FuBar_FromAViewToAKillFu:PriorityChange(listnumber)
	if IsControlKeyDown()then
		
		if listnumber ~= 8 then
			local onemore = listnumber+1
			local temp = FuBar_FromAViewToAKillFu.db.profile.PriorityList[listnumber]
			FuBar_FromAViewToAKillFu.db.profile.PriorityList[listnumber] = FuBar_FromAViewToAKillFu.db.profile.PriorityList[onemore]
			FuBar_FromAViewToAKillFu.db.profile.PriorityList[onemore] = temp
		end
		
	elseif (listnumber ~= 1) then
		local oneless = listnumber-1
		local temp = FuBar_FromAViewToAKillFu.db.profile.PriorityList[listnumber]
		FuBar_FromAViewToAKillFu.db.profile.PriorityList[listnumber] = FuBar_FromAViewToAKillFu.db.profile.PriorityList[oneless]
		FuBar_FromAViewToAKillFu.db.profile.PriorityList[oneless] = temp
	end
end

function FuBar_FromAViewToAKillFu:PrioritySaveList()
	for i = 1, 8 do
		SavedPriorityList[i] = FuBar_FromAViewToAKillFu.db.profile.PriorityList[i]
	end
	PriorityListSaved = true
	FuBar_FromAViewToAKillFu:Print(L["PriorityListSaved"])
end

function FuBar_FromAViewToAKillFu:PriorityLoadList()
	for i = 1, 8 do
		FuBar_FromAViewToAKillFu.db.profile.PriorityList[i] = SavedPriorityList[i]
	end
end

function FuBar_FromAViewToAKillFu:PriorityResetList()
	for i = 1, 8 do
		FuBar_FromAViewToAKillFu.db.profile.PriorityList[i] = i
	end
end


--[[                     ]]
--[[ RTI Setup Load/Save ]]
--[[                     ]]

function FuBar_FromAViewToAKillFu:SetupSave()
	for i = 1,8 do
		if RTI[i] ~= nil then
			RTISaved[i] = {}
			RTISaved[i] = RTI[i]
		end
	end
	
	RTIsSaved = true
	self:Print(L["RTIListSaved"])
end

function FuBar_FromAViewToAKillFu:SetupLoad()
	
	for i = 1, 8 do
		if RTI[i] ~= nil then
			FuBar_FromAViewToAKillFu.RTIRemove(self, i)
		end
	end
	
	for i = 1, 8 do
		if RTISaved[i] ~= nil then
			local id = RTISaved[i].raidid
			FuBar_FromAViewToAKillFu:RTISet(i, id)
		end
	end 
	
	RTI = RTISaved
	
end


--[[         ]]
--[[ Tooltip ]]
--[[         ]]

function FuBar_FromAViewToAKillFu:OnTooltipUpdate()		-- the tooltip is dynamic depending on the player's status (not raid / raid / raid leader)
	local cat = tablet:AddCategory()
	
	if not UnitInRaid("player") then
		cat:AddLine()
		cat:AddLine(
			'text', "|cffff0000"..L["younotinraid"]
		)
		cat:AddLine(
			'text', "|cffff0000"..L["funcdisabled"]
		)
		
	else
		if not IsRaidLeader() then
			cat:AddLine(
				'text', "|cffff0000"..L["younotleader"]
			)
			cat:AddLine(
				'text', "|cffff0000"..L["funcdisabled"]
			)
		else
			cat:AddLine(
				'text', "|cff00ff00"..L["youleader"]
			)
			cat:AddLine(
				'text', "|cff00ff00"..L["funcenabled"]
			)
			cat:AddLine()
			cat:AddLine(
				'text', "|cffffffff"..L["RMBclick"].."|cff00ff00"..L["access"]
			)
			if self.RTIsAreSet() then
				cat:AddLine(
					'text', "|cffffffff"..L["CtrlLMBclick"].."|cff00ff00"..L["clear"]
				)
			else
				cat:AddLine(
					'text', "|cff777777"..L["CtrlLMBclick"].."|cff555555"..L["clear"]
				)
			end
		end
	end
end

function FuBar_FromAViewToAKillFu:OnClick()
	local cleared = 0
	if IsControlKeyDown() then
		if self.RTIsAreSet() then
			for i = 1, 8 do
				if RTI[i] ~= nil then
					self.RTIRemove(self, i)
					cleared = 1
				end
			end
		else
			self:Print(L["noRTIsset"]);
		end
	end
	if cleared == 1 then
		self:Print(L["listcleared"])
	end
end


--[[      ]]
--[[ Menu ]]
--[[      ]]

function FuBar_FromAViewToAKillFu:OnMenuRequest(level, value)
	if level == 1 then
		
		if not UnitInRaid("player")
			then
				dewdrop:AddLine(
					'text', "|cffff0000"..L["younotinraid"],
					'notClickable', true
				)
				dewdrop:AddLine(
					'text', "|cffff0000"..L["funcdisabled"],
					'notClickable', true
				)
		else
			for i=1, 8 do		-- filling the dropdown list with names/unassigned
				local RTInumber = i
				if RTI[i] == nil then
					dewdrop:AddLine(
						'text', "|c00666666"..L["unassigned"],
						'checked', true,
						'checkIcon', ICON[i],
						'func', self.RTISetFromMenu,
						'arg1', self,
						'arg2', RTInumber
					)
				else
					color = FuBar_FromAViewToAKillFu:GetUnitColor(RTI[RTInumber].name)
					dewdrop:AddLine(
						'text', "|cff"..color..RTI[i].name,
						'checked', true,
						'checkIcon', ICON[i],
						'func', self.RTIRemove,
						'arg1', self,
						'arg2', RTInumber
					)
				end
			end
			
			dewdrop:AddLine('text', " ", 'notClickable', true)
			
			dewdrop:AddLine(
				'text', L["PriorityList"],
				'hasArrow', true,
				'value', "prioritylist"
			)
			
			dewdrop:AddLine('text', " ", 'notClickable', true)
			
			dewdrop:AddLine(
				'text', L["SaveRTISetup"],
				'checked', false,
				'func', self.SetupSave,
				'arg1', self
			)
			if RTIsSaved then
				dewdrop:AddLine(
					'text', L["LoadRTISetup"],
					'checked', false,
					'func', self.SetupLoad,
					'arg1', self
				)
			else
				dewdrop:AddLine(
					'text', "|c00666666"..L["LoadRTISetup"],
					'checked', false,
					'notClickable', true
				)
			end
			
			dewdrop:AddLine('text', " ", 'notClickable', true)
		end
		dewdrop:AddLine('text', " ", 'notClickable', true)
		
	elseif level == 2 then
		
		if value == "prioritylist" then
			
			for i = 1, 8 do
				icon = FuBar_FromAViewToAKillFu.db.profile.PriorityList[i]	-- extract var, because func is triggered by icon change
				text = PriorityListText[i]
				var = i
				dewdrop:AddLine(
					'text', text,
					'checked', true,
					'checkIcon', ICON[icon],
					'tooltipTitle', L["PriorityList"],
					'tooltipText', L["PriorityListHowTo"],
					'func', self.PriorityChange,
					'arg1', self,
					'arg2', var
				)
			end
			
			dewdrop:AddLine('text', " ", 'notClickable', true)
			
			dewdrop:AddLine(
	 			'text', L["ResetPriorityList"],
	 			'checked', false,
	 			'func', self.PriorityResetList,
	 			'arg1', self
	 		)
			
			dewdrop:AddLine(
	 			'text', L["SavePriorityList"],
	 			'checked', false,
	 			'func', self.PrioritySaveList,
	 			'arg1', self
	 		)
			
			if PriorityListSaved then
				dewdrop:AddLine(
					'text', L["LoadPriorityList"],
					'checked', false,
					'func', self.PriorityLoadList,
					'arg1', self
				)
			else
				dewdrop:AddLine(
					'text', "|c00666666"..L["LoadPriorityList"],
					'checked', false,
					'notClickable', true
				)
			end
		end
	end
end