FishingBuddyFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "FuBarPlugin-2.0");
local Tablet = AceLibrary("Tablet-2.0");

local tab = FBConstants;
FishingBuddyFu.hasNoText = true;
FishingBuddyFu.hasIcon = true;
FishingBuddyFu.defaultPosition = "RIGHT";
local switchSetting = "ClickToSwitch";

local hint;
if FishingBuddy.GetSetting(switchSetting) == 1 then
	hint = tab.TOOLTIP_HINTSWITCH;
else
	hint = tab.TOOLTIP_HINTTOGGLE;
end
hint = FishingBuddy.Color("GREEN", hint) .. "\n" .. tab.DESCRIPTION1 .. " " .. tab.DESCRIPTION2;

function FishingBuddyFu:OnTooltipUpdate()
	local cat = Tablet:AddCategory(
		"text", "",
		"justify", "CENTER"
	);
	Tablet:SetHint(hint);
end

function FishingBuddyFu:OnClick(value)
	if ( FishingBuddy.IsSwitchClick(switchSetting) ) then
		FishingBuddy.Command(tab.SWITCH)
	else
		FishingBuddy.Command("")
	end
end;

local options = { handle = "FishingBuddyFu", type="group" };
options["args"] = {};

-- save some memory by keeping one copy of each one
local GetterFunctions = {};
-- let's use closures
local function MakeGetter(name)
	if ( not GetterFunctions[name] ) then
		local n = name;
		GetterFunctions[name] = function()
									return (FishingBuddy.GetSetting(n) == 1);
								end;
	end
	return GetterFunctions[name];
end

-- If no outfit frame, we can't switch outfits...
if ( FishingBuddy.OutfitManager.HasManager() ) then
	info = {};
	info.type = "toggle";
	info.name = tab.CLICKTOSWITCH_ONOFF;
	info.desc = tab.CLICKTOSWITCH_INFO;
	info.set = FishingBuddy.MakeToggle(switchSetting);
	info.get = MakeGetter(switchSetting);
	options["args"]["switch"] = info;
end

for name,option in pairs(FishingBuddy.OPTIONS) do
	if ( option.m ) then
		local addthis = true;
		if ( option.check ) then
			addthis = option.check();
		end
		if ( addthis ) then
			info = {};
			info.type = "toggle";
			info.name = option.text;
			info.desc = option.tooltip;
			info.set = FishingBuddy.MakeToggle(name);
			info.get = MakeGetter(name);
			options["args"][name] = info;
		end
	end
end

FishingBuddyFu.OnMenuRequest = options;
