﻿local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local crayon = AceLibrary("Crayon-2.0")

FactionItemsFu.version       = "2.4.0." .. string.sub("$Revision: 72068 $", 12, -3)
FactionItemsFu.releaseDate   = string.sub("$Date: 2008-04-29 09:30:57 -0400 (Tue, 29 Apr 2008) $", 8, 17)
FactionItemsFu.hasIcon = true
FactionItemsFu.loc = FactionItemsFuLocals
FactionItemsFu.defaultPosition = 'LEFT'
FactionItemsFu.canHideText = false
FactionItemsFu.clickableTooltip = false

local V = FactionItemsFu.vars
local currentRealm, currentFaction, currentCharacter

local optionsTable = { 
 	type = 'group',
 	args = { 
    watch = { 
      name = "watch", 
      type = 'group',
      desc = "watch items for desired faction(s)",
      args = {
        ["ArgentDawn"] = {
            name = "Argent Dawn",type = 'toggle',
            desc = "toggles watching items for Argent Dawn",
            usage = "watch ArgentDawn",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Argent Dawn"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Argent Dawn"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Argent Dawn"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["BroodofNozdormu"] = {
            name = "Brood of Nozdormu",type = 'toggle',
            desc = "toggles watching items for Brood of Nozdormu",
            usage = "watch BroodofNozdormu",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Brood of Nozdormu"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Brood of Nozdormu"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Brood of Nozdormu"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["CenarionCircle"] = {
            name = "Cenarion Circle",type = 'toggle',
            desc = "toggles watching items for Cenarion Circle",
            usage = "watch CenarionCircle",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Circle"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Circle"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Circle"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["DarkmoonFaire"] = {
            name = "Darkmoon Faire",type = 'toggle',
            desc = "toggles watching items for Darkmoon Faire",
            usage = "watch DarkmoonFaire",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Darkmoon Faire"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Darkmoon Faire"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Darkmoon Faire"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["Ravenholdt"] = {
            name = "Ravenholdt",type = 'toggle',
            desc = "toggles watching items for Ravenholdt",
            usage = "watch Ravenholdt",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Ravenholdt"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Ravenholdt"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Ravenholdt"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["ThoriumBrotherhood"] = {
            name = "Thorium Brotherhood",type = 'toggle',
            desc = "toggles watching items for Thorium Brotherhood",
            usage = "watch ThoriumBrotherhood",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Thorium Brotherhood"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Thorium Brotherhood"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Thorium Brotherhood"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["TimbermawHold"] = {
            name = "Timbermaw Hold",type = 'toggle',
            desc = "toggles watching items for Timbermaw Hold",
            usage = "watch TimbermawHold",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Timbermaw Hold"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Timbermaw Hold"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Timbermaw Hold"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
--            ["WildhammerClan"] = {
--                name = "Wildhammer Clan",type = 'toggle',
--                desc = "toggles watching items for Wildhammer Clan",
--                usage = "watch WildhammerClan",
--                get = function()
--                    return FactionItemsFu.db.char["Wildhammer Clan"]
--                end,
--                set = function(v)
--                    FactionItemsFu.db.char["Wildhammer Clan"] = not FactionItemsFu.db.char["Wildhammer Clan"]
--                    --- Refresh in place
--                    FactionItemsFu:UpdateDisplay()
--                end,
--                map = { [true] = "Watching", [false] = "Hidden" },
--            }, 
        ["ZandalarTribe"] = {
            name = "Zandalar Tribe",type = 'toggle',
            desc = "toggles watching items for Zandalar Tribe",
            usage = "watch ZandalarTribe",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Zandalar Tribe"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Zandalar Tribe"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Zandalar Tribe"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
			  ["Capitals"] = {
            name = "Capitals",type = 'toggle',
            desc = "toggles watching items for Morrowgrain and Cloth Quests",
            usage = "watch Capitals",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Capitals"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Capitals"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Capitals"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["WintersaberTrainers"] = {
            name = "Wintersaber Trainers",type = 'toggle',
            desc = "toggles watching items for Wintersaber Trainers to get Epic Mount",
            usage = "watch WintersaberTrainers",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Wintersaber Trainers"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Wintersaber Trainers"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Wintersaber Trainers"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["CenarionExpedition"] = {
            name = "Cenarion Expedition",type = 'toggle',
            desc = "toggles watching items for Cenarion Expedition in Outland",
            usage = "watch CenarionExpedition",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Expedition"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Expedition"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Cenarion Expedition"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Consortium"] = {
            name = "The Consortium",type = 'toggle',
            desc = "toggles watching items for The Consortium in Outland",
            usage = "watch Consortium",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Consortium"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Consortium"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Consortium"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Kurenai"] = {
            name = "Kurenai",type = 'toggle',
            desc = "toggles watching items for Kurenai in Outland",
            usage = "watch Kurenai",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Kurenai"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Kurenai"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Kurenai"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["PvP"] = {
            name = "PvP",type = 'toggle',
            desc = "toggles watching awards for PvP in Battleground",
            usage = "watch PvP",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["PvP"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["PvP"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["PvP"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Sporeggar"] = {
            name = "Sporeggar",type = 'toggle',
            desc = "toggles watching items for Sporeggar in Outland",
            usage = "watch Sporeggar",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sporeggar"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sporeggar"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sporeggar"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Mag'har"] = {
            name = "Mag'har",type = 'toggle',
            desc = "toggles watching items for Mag'har in Outland",
            usage = "watch Mag'har",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Mag'har"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Mag'har"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Mag'har"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Aldor"] = {
            name = "The Aldor",type = 'toggle',
            desc = "toggles watching items for The Aldor in Outland",
            usage = "watch Aldor",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Aldor"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Aldor"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Aldor"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["Scryers"] = {
            name = "The Scryers",type = 'toggle',
            desc = "toggles watching items for The Scryers in Outland",
            usage = "watch Scryers",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Scryers"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Scryers"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["The Scryers"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
				["LowerCity"] = {
            name = "Lower City",type = 'toggle',
            desc = "toggles watching items for Lower City in Outland",
            usage = "watch LowerCity",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Lower City"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Lower City"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Lower City"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["Sha'tariSkyguard"] = {
            name = "Sha'tari Skyguard",type = 'toggle',
            desc = "toggles watching items for Sha'tari Skyguard in Outland",
            usage = "watch Sha'tariSkyguard",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sha'tari Skyguard"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sha'tari Skyguard"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Sha'tari Skyguard"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
        ["NetherwingDragonflight"] = {
            name = "Netherwing Dragonflight",type = 'toggle',
            desc = "toggles watching item for Netherwing Dragonflight in Outland",
            usage = "watch NetherwingDragonflight",
            get = function()
                return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Netherwing Dragonflight"]
            end,
            set = function(v)
                FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Netherwing Dragonflight"] = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["Netherwing Dragonflight"]
                --- Refresh in place
                FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Watching", [false] = "Hidden" },
        },
      },
    },
		panelDisplay = {
			name = "Panel_Display", 
      type = 'group',
        desc = "Text display configuration for FuBar panel",
        args = {
					["title"] = {
          	name = "Title",
						type = 'toggle',
            desc = "toggles displaying addon title in FuBar panel",
            usage = "panelDisplay title",
            get = function()
            	return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.title
            end,
            set = function(v)
            	FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.title = not FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.title
              --- Refresh in place
              FactionItemsFu:UpdateDisplay()
            end,
            map = { [true] = "Displayed", [false] = "Hidden" },
          },
          ["countDisplay"] = {
            name = "countDisplay",
						type = 'text',
						desc = "toggles displaying bank and bags item totals in FuBar panel",
						get = function()
  						return FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.countDisplayStyle
						end,
						set = function(option)
  						FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.countDisplayStyle = option
    					--- Refresh in place
  						FactionItemsFu:UpdateDisplay()
						end,
						validate = {"bags", "bank", "bankSlashbag","bagsPlusbank","none"},
					},
  				["AltCharacter"] = {
           	name = "Alternate Characters",
           	type = 'text',
           	desc = "Alternate Character Faction items to view",
           	get = function()
  						return currentCharacter
						end,
           	set = function(altChar)
          		currentCharacter = altChar
							-- displayCharacter = FactionItemsFu.db.account.data[currentFaction][currentRealm].char[currentCharacter]
							FactionItemsFu:UpdateDisplay()
           	end,
           	validate = {"none"},
          },
			  },
		},
 	},
}

--	FactionItemsFu:RegisterChatCommand({"/fi", "/fifu"},optionsTable)
	FactionItemsFu.OnMenuRequest = optionsTable
	
function FactionItemsFu:OnInitialize()
	ItemList = self.loc.TrackItems
	FactionList = self.loc.TrackFactions
	RepUnitNames = self.loc.RepNames
  FactionItemsList = self.loc.FactionItems
  
  V.player = UnitName("player")
	currentRealm = GetRealmName()
	currentFaction = UnitFactionGroup("player")
	-- currentCharacter = V.player		-- name of the alt whose bags should be displayed, default is current player
	
	currentCharacter = UnitName("player") -- name of the alt whose bags should be displayed, default is current player
	self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch.countDisplayStyle = "bankSlashbag"
	
  TextTotals = {
    ["bags"] = 0,
    ["bank"] = 0,
  }
	self:GetCharListByServerId()
	for _,charName in pairs(V.chars) do
		table.insert(optionsTable.args.panelDisplay.args.AltCharacter.validate, charName)
	end
end

function FactionItemsFu:OnEnable()
	-- put something that would be run every time this is enabled. Happens at the very start as well, after Initialize.
	self:RegisterEvent("MERCHANT_SHOW","Inv_Change");
	self:RegisterEvent("MERCHANT_CLOSED","Inv_Change");
	self:RegisterEvent("MAIL_CLOSED","Mail_Change");
	self:RegisterEvent("BAG_UPDATE","Inv_Change");
	self:RegisterEvent("BANKFRAME_CLOSED","Bnk_Change");
	self:RegisterEvent("UNIT_INVENTORY_CHANGED","Inv_Change");
	self:RegisterEvent("BANKFRAME_OPENED","Bnk_Change");
	self:RegisterEvent("PLAYERBANKSLOTS_CHANGED","Bnk_Change");
  self:RegisterEvent("FACTION_STANDING_INCREASED","CheckFactionValue");
  		
end

function FactionItemsFu:OnDisable()
	-- you do not need to unregister the event here, all events/hooks are unregistered on disable implicitly.
end

function FactionItemsFu:CheckFactionValue()
	-- CreateFactionList()
	self:UpdateDisplay()
end

function FactionItemsFu:Inv_Change()
  for _,k in pairs(ItemList)  do
    local ItemCount = GetItemsInInv(k)
    self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].inv = ItemCount
	end
	self:UpdateDisplay()
end

function FactionItemsFu:GetInvCount(k)
  return self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].inv
	
end    

function FactionItemsFu:GetBankCount(k)
    return self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].bank
    
end

function FactionItemsFu:GetMailCount(k)
  return self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].mail
end

function FactionItemsFu:Bnk_Change()
  for _,k in pairs(ItemList)  do
    local ItemCount = GetItemsInBank(k)
    self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].bank = ItemCount
  end
	self:UpdateDisplay()
end

function FactionItemsFu:Mail_Change()
  for _,k in pairs(ItemList)  do
    local ItemCount = GetMailItems(k)
    self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[k].mail = ItemCount
  end
	
end

function FactionItemsFu:OnDataUpdate()
	TextTotals.bags = 0
  TextTotals.bank = 0
  for _,category in ipairs(FactionList) do
    local standing,bottomValue,maxNeeded,repValue = CheckFactionValues(category)
		if standing == nil then standing = 9 end
		if repValue == nil then repValue = 0 end
      if self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch[category] then
        if category == "Darkmoon Faire" then
					if standing == 9 or standing <= 4 then
						if repValue <= 500 then
							for _,items in ipairs(FactionItemsList["FaireTier1"]) do
								TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
                TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
							end
						end
						if repValue <= 1100 then
							for _,items in ipairs(FactionItemsList["FaireTier2"]) do
								TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
							end
						end
						if repValue <= 1700 then
							for _,items in ipairs(FactionItemsList["FaireTier3"]) do
								TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
							end
						end
						if repValue <= 2500 then
							for _,items in ipairs(FactionItemsList["FaireTier4"]) do
								TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
							end
						end
					end
					for _,items in ipairs(FactionItemsList["FaireTier5"]) do
						TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
        		TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
					end
      	elseif category == "Thorium Brotherhood" then
          if standing == 9 or standing <= 8 then
            for _,items in ipairs(FactionItemsList["Brotherhood3"]) do
					    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				    end
          end
          if standing == 9 or standing <= 5 then
            for _,items in ipairs(FactionItemsList["Brotherhood2"]) do
					    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				    end
          end
          if standing == 9 or standing <= 4 then
            for _,items in ipairs(FactionItemsList["Brotherhood1"]) do
					    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				    end
          end
				elseif category == "The Consortium" then
          if standing <= 9 then
            for _,items in ipairs(FactionItemsList["Consortium1"]) do
					    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				    end
          end
          if standing == 9 or standing <= 8 then
            for _,items in ipairs(FactionItemsList["Consortium2"]) do
					    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
              TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				    end
          end
				elseif category == "Sporeggar" then
        	if standing == 9 or standing <= 5 then
          	for _,items in ipairs(FactionItemsList["Sporeggar1"]) do
				    	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
            	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  	end
        	end
        	if standing == 9 or standing <= 8 then
          	for _,items in ipairs(FactionItemsList["Sporeggar2"]) do
				    	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
            	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  	end
					end
				elseif category == "The Aldor" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Aldor3"]) do
					  TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Aldor2"]) do
				  	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end
        if standing == 9 or standing < 4 then
          for _,items in ipairs(FactionItemsList["Aldor1"]) do
				  	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end	
			elseif category == "The Scryers" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Scryers3"]) do
					  TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Scryers2"]) do
				  	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end
        if standing == 9 or standing < 4 then
          for _,items in ipairs(FactionItemsList["Scryers1"]) do
				  	TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end	
			elseif category == "Lower City" then
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Lower City"]) do
				    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end
      elseif category == "Sha'tari Skyguard" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Sha'tari Skyguard"]) do
				    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end	
      elseif category == "Netherwing Dragonflight" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Netherwing Dragonflight"]) do
				    TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
           	TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
				  end
        end				
			else
					for _,items in ipairs(FactionItemsList[category]) do
            TextTotals.bags = TextTotals.bags + self:GetInvCount(items)
            TextTotals.bank = TextTotals.bank + self:GetBankCount(items)
					end
			end
    end
  end
end 

function FactionItemsFu:GetItemTotals(itm)
	return self:GetInvCount(itm) + self:GetBankCount(itm) + self:GetMailCount(itm)
end

function FactionItemsFu:GetTurnInValue(itm)
	local turnInValue
	local temp = self.db.account.data[currentFaction][currentRealm].char[currentCharacter].TrackItems[itm].TurnIn
	if temp == 0 then
		turnInValue = "(Varies)"
	else
		turnInValue = "("..temp..")"
	end
	return turnInValue
end

function FactionItemsFu:OnTextUpdate()
  self:UpdateData()
  textspace = " "
  if self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["title"] then
		text = textspace..crayon:Green(self.loc.TEXT_SET)
  else
  	text = " "
  end
	if self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["countDisplayStyle"] == "bankSlashbag" then
			text1 = textspace..crayon:White(TextTotals.bank).."/"..crayon:White(TextTotals.bags)
	elseif self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["countDisplayStyle"] =="bagsPlusbank" then
			text1 = textspace..crayon:White(TextTotals.bank + TextTotals.bags)
	elseif self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["countDisplayStyle"] =="bags" then
			text1 = textspace..crayon:White(TextTotals.bags)
	elseif self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch["countDisplayStyle"] == "bank" then
			text1 = textspace..crayon:White(TextTotals.bank)
	else
		text1 = ""
  end
	self:SetText(text..text1)
end
	
function FactionItemsFu:OnTooltipUpdate()
	tablet:SetTitle(currentCharacter)
	for _,category in ipairs(FactionList) do
        local standing,bottomValue,maxNeeded,repValue = CheckFactionValues(category)
		if standing == nil then standing = 9 end
		if maxNeeded == nil then maxNeeded = 0 end
		if repValue == nil then repValue = 0 end
    if bottomValue == nil then bottomValue = 0 end
    if self.db.account.data[currentFaction][currentRealm].char[currentCharacter].Watch[category] then
      cat = tablet:AddCategory(
        'columns', 3,
				'text', category,
				'text2',RepUnitNames[standing],
				'text3',(repValue - bottomValue).."/"..(maxNeeded - bottomValue).."   ",
				'text3R',0,
				'text3G',0,
				'text3B',1
			)
			cat:AddLine()
			cat:AddLine('text',"Item ",'text2',"Turn in",'text3'," Qty have")
			cat:AddLine()
			if category == "Darkmoon Faire" then
				if standing == 9 or standing <= 4 then
					if repValue <= 500 then
						for _,items in ipairs(FactionItemsList["FaireTier1"]) do
              cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
						end
					end
					if repValue <= 1000 then
						for _,items in ipairs(FactionItemsList["FaireTier2"]) do
              cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
						end
					end
					if repValue <= 1600 then
						for _,items in ipairs(FactionItemsList["FaireTier3"]) do
              cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
						end
					end
					if repValue <= 2500 then
						for _,items in ipairs(FactionItemsList["FaireTier4"]) do
              cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
						end
					end
				end
				for _,items in ipairs(FactionItemsList["FaireTier5"]) do
              cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				end
      elseif category == "Thorium Brotherhood" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Brotherhood3"]) do
					  cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Brotherhood2"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 4 then
          for _,items in ipairs(FactionItemsList["Brotherhood1"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
			elseif category == "The Consortium" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Consortium2"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 4 then
          for _,items in ipairs(FactionItemsList["Consortium1"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
			elseif category == "Sporeggar" then
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Sporeggar1"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 8 then
          for _,items in ipairs(FactionItemsList["Sporeggar2"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
				end
			elseif category == "The Aldor" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Aldor3"]) do
					  cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Aldor2"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing < 4 then
          for _,items in ipairs(FactionItemsList["Aldor1"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end	
			elseif category == "The Scryers" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Scryers3"]) do
					  cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Scryers2"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
        if standing == 9 or standing < 4 then
          for _,items in ipairs(FactionItemsList["Scryers1"]) do
				  	cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end	
			elseif category == "Lower City" then
        if standing == 9 or standing <= 5 then
          for _,items in ipairs(FactionItemsList["Lower City"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
      elseif category == "Sha'tari Skyguard" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Sha'tari Skyguard"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end
      elseif category == "Netherwing Dragonflight" then
        if standing <= 9 then
          for _,items in ipairs(FactionItemsList["Netherwing Dragonflight"]) do
				    cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				  end
        end	
			else
        for _,items in ipairs(FactionItemsList[category]) do
          cat:AddLine('text',items,'text2',self:GetTurnInValue(items),'text3',self:GetItemTotals(items).."   ",'text2R',1,'text2G',0,'text2B',0)
				end
			end
		end
	end
	tablet:SetHint("Click here will open Faction Grinder Settings if Installed.")
	-- as a rule, if you have an OnClick or OnDoubleClick or OnMouseUp or OnMouseDown, you should set a hint.
end

function FactionItemsFu:OnClick()
  if not IsShiftKeyDown() then
		local frame = getglobal("FactionGrinderSettingsFrame")
		if(frame)then
			if(frame:IsVisible())then
				frame:Hide()
				frame:ClearAllPoints()
      	frame:SetPoint("CENTER",nil,"CENTER",0,0)
			else
				frame:Show()
				frame:ClearAllPoints()
			end
		end
  else
	-- code for Shift Click
		-- local f = CreateFrame("Frame",nil,UIParent)
		-- f:SetFrameStrata("BACKGROUND")
		-- f:SetWidth(128)  -- Set These to whatever height/width is needed 
		-- f:SetHeight(64) -- for your Texture	
		-- f:Show()
  end
end
--------------------------------------------------------------------------------------------------
-- COUNT THE NUMBER OF ITEMS
--------------------------------------------------------------------------------------------------

function NameFromLink(link)
	local name
	if (link) then
		-- for name in string.gmatch(link, "|c%x+|Hitem:%d+:%d+:%d+:%d+|h%[(.-)%]|h|r") do
		name, link, quality, level, requiredlevel, class, subclass, stacksize, inventorytype, icon = GetItemInfo(link)
		return name
		-- end
	end
end 

--function GetBagItems(argItem)
--	local count = 0
--	for bag = 4, 0, -1 do
--		local size = GetContainerNumSlots(bag)
--		if (size > 0) then
--			for slot=1, size, 1 do
--				local texture, itemCount = GetContainerItemInfo(bag, slot)
--				if (itemCount ~= nil) then
--				   local itemName = NameFromLink(GetContainerItemLink(bag, slot))	
--					if  ((itemName) and (itemName ~= "")) then -- if the item has a name
--                        if (itemName == argItem) then 
--							count  = count + itemCount
--						end
--					end
--				end
--			end            
--		end
--	end	
--	return count
--end

function GetItemsInInv(argItem)
	count = GetItemCount(argItem)
  if (count) then
		return count
	else
		return 0
	end 
end

function GetItemsInBank(argItem)
	countBank = GetItemCount(argItem,true)
	countInv = GetItemCount(argItem,false)
  if (countBank) then
		return countBank - countInv
	else
		return 0
	end 
end

function GetMailItems(argItem)
	local count = 0
	local mailItems = GetInboxNumItems()
	if(mailItems > 0) then
		for index = 1, mailItems, 1 do
			itemName, itemIcon, itemQuantity = GetInboxItem(index)
			if( itemName == argItem ) then
			 count = count + itemQuantity
			end
		end
	end
	
	return count
end

--function GetBankItems(argItem)
--	local count = 0
--		maxContainerItems = GetContainerNumSlots(BANK_CONTAINER)
--		if ( maxContainerItems ) then
--			for containerItemNum = 1, maxContainerItems do
--				link = GetContainerItemLink(BANK_CONTAINER, containerItemNum)
--				icon, quantity = GetContainerItemInfo(BANK_CONTAINER, containerItemNum)
--				if( link ) then
--				--LinkToName
--					itemName = NameFromLink(link)
--					if(itemName == argItem) then
--						count = count + quantity
--					end
--				end
--			end
--		end
--		for bagNum = 5, 11 do
--			maxContainerItems = GetContainerNumSlots(bagNum)
--			if( maxContainerItems ) then
--				local id = BankButtonIDToInvSlotID(bagNum, 1)
--				link = GetInventoryItemLink("player", id)
--				icon = GetInventoryItemTexture("player", id)
--				for containerItemNum = 1, maxContainerItems do
--					link = GetContainerItemLink(bagNum, containerItemNum)
--					icon, quantity = GetContainerItemInfo(bagNum, containerItemNum)
--					if( link ) then
--					--LinkToName
--						itemName = NameFromLink(link)
--						if(itemName == argItem) then
--							count = count + quantity
--						end
--					end
--				end
--			end
--		end
--	
--	return count
--end

--------------------------------------------------------------------------------------------------
-- Reputation Functions
--------------------------------------------------------------------------------------------------

function CheckFactionValues(f)
	local numFactions = GetNumFactions()
		for factionIndex=1, numFactions do
			name, _, standingID, bottomValue, topValue, barValue, _, _, isHeader, isCollapsed,_ = GetFactionInfo(factionIndex)
			if isHeader == nil then 
			  isHeader = false
			end
			if isHeader then
				if isCollapsed then
					ExpandFactionHeader(factionIndex)
				end
			elseif name == f then
				return standingID,bottomValue,topValue,barValue
			end
		end
end

--------------------------------------------------------------------------------------------------
-- Alt Char Functions
-------------------------------------------------------------------------------------------------

function FactionItemsFu:GetCharListByServerId()
  if V.chars == nil then	-- if the character table does not exist, populate it
		V.chars = {}
		for CharacterName, c in pairs(self.db.account.data[currentFaction][currentRealm].char) do
			table.insert(V.chars, CharacterName)
		end
	end
end

--------------------------------------------------------------------------------------------------
-- Misc Help Functions
-------------------------------------------------------------------------------------------------

function FactionItemsFu:Round(num)
	if(num - math.floor(num) >= 0.5) then
		num = num + 0.5;
	end
	return math.floor(num)
end

function Min(num1,num2)
  if(num1<=num2) then
	ret=num1
  else
	ret=num2
  end

  return ret
end 


