﻿local CLICK_TO_LOGOUT = "Click to Logout."
local SHIFT_CLICK_TO_EXIT_GAME = "Shift Click to Exit Game."
local LOGOUT = "Logout"
local LOGOUT_DESC = "Logout"
local EXIT = "Exit"
local EXIT_DESC = "Exit Game"
local CHANGE_ICON = "Change Icon"
local CHANGE_ICON_DESC = "Change the icon."

if GetLocale() == 'zhTW' then
	CLICK_TO_LOGOUT = "|cffeda55f左擊: |r返回角色選單。"
	SHIFT_CLICK_TO_EXIT_GAME = "|cffeda55fShift-左擊: |r退出遊戲。"
	LOGOUT = "登出"
	LOGOUT_DESC = "返回角色選單"
	EXIT = "退出"
	EXIT_DESC = "退出遊戲"
	CHANGE_ICON = "變更圖示"
	CHANGE_ICON_DESC = "變更 ExitFu 圖示"
elseif GetLocale() == 'koKR' then
	CLICK_TO_LOGOUT = "접속 종료하려면 클릭하세요."
	SHIFT_CLICK_TO_EXIT_GAME = "게임을 종료하려면 Shift-클릭하세요."
	LOGOUT = "접속 종료"
	LOGOUT_DESC = "접속을 종료합니다."
	EXIT = "게임 종료"
	EXIT_DESC = "게임을 종료합니다."
	CHANGE_ICON = "아이콘 변경"
	CHANGE_ICON_DESC = "아이콘을 변경합니다."
end

local tablet = AceLibrary("Tablet-2.0")

ExitFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "FuBarPlugin-2.0")
ExitFu:RegisterDB("ExitFuDB")
ExitFu:RegisterDefaults("profile", {
	icons = {
	"Interface\\AddOns\\Fubar_ExitFu\\iconyellow",
	"Interface\\AddOns\\Fubar_ExitFu\\iconred",
	"Interface\\AddOns\\Fubar_ExitFu\\X",
	"Interface\\AddOns\\Fubar_ExitFu\\XYellow",
	},
	iconvalue = 1,
	}
)
ExitFu.hasIcon = true
ExitFu.hasNoText = true
ExitFu.defaultPosition = "RIGHT"
ExitFu.cannotDetachTooltip = TRUE


function ExitFu:IsIconvalue()
	return self.db.profile.iconvalue
end

function ExitFu:OnTextUpdate()
	self:SetIcon(self.db.profile.icons[self.db.profile.iconvalue])
end

function ExitFu:OnTooltipUpdate()
	local cat = tablet:AddCategory()
		cat:AddLine(
			"text", CLICK_TO_LOGOUT
		)
		cat:AddLine(
			"text", SHIFT_CLICK_TO_EXIT_GAME
		)
end

function ExitFu:OnClick()
	if IsShiftKeyDown() then
		ForceQuit()
	else
    		Logout()
	end
end

ExitFu.OnMenuRequest = {
    type = 'group',
    args = {
    	log = {
    			type = 'execute',
    			name = LOGOUT,
    			desc = LOGOUT_DESC,
    			func = Logout,
			},
			exit = {
					type = 'execute',
					name = EXIT,
					desc = EXIT_DESC,
					func = ForceQuit,
			},
			change = {
					type = 'range',
    			name = CHANGE_ICON,
    			desc = CHANGE_ICON_DESC,
    			get  = "IsIconvalue",
    			set = "ToggleIconvalue",
    			min = 1,
    			max = 4,
    			step = 1,
    			isPercent = false,
    	}
		}
}

function ExitFu:ToggleIconvalue(value)
	self.db.profile.iconvalue = value
  self:Update()
end


