--[[
Name: FuBar_DungeonDiFu
Version: 1.0.20200
Revision: $Rev: 50990 $
Author(s): Myrathi (myrathi@gmail.com)
Website: http://files.wowace.com/FuBar_DungeonDiFu/
Documentation: None
SVN: http://svn.wowace.com/wowace/trunk/FuBar_DungeonDiFu/
Description: Provides more visible access to dungeon difficulty settings via FuBar.
Dependencies: FuBar, (optional) Ace2, (optional) DewdropLib, (optional) TabletLib, (optional) FuBarPlugin-2.0
Id: $Id: DungeonDiFu.lua 50990 2007-10-05 02:21:49Z myrathi $
]]

local Tab = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_DungeonDiFu")
local DF = AceLibrary("Deformat-2.0")

DungeonDiFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

DungeonDiFu:RegisterDB("DungeonDiFuDB")
DungeonDiFu:RegisterDefaults('profile', 
	{
		ShowHint	= true,
		ShowPrefix	= false
	}
)

DungeonDiFu.version = GetAddOnMetadata("FuBar_DungeonDiFu", "Version").."."..tonumber(("$Rev: 50990 $"):match("(%d+)"))
DungeonDiFu.date = string.sub("$Date: 2007-10-04 22:21:49 -0400 (Thu, 04 Oct 2007) $", 8, 17)
DungeonDiFu.hasIcon = "Interface\\AddOns\\FuBar_DungeonDiFu\\icons\\diff1.tga"
DungeonDiFu.hasNoColor = true
DungeonDiFu.canHideText = true
DungeonDiFu.clickableTooltip = true
DungeonDiFu.cannotDetachTooltip = true
DungeonDiFu.defaultPosition = 'LEFT'

--============================================================================
DungeonDiFu.OnMenuRequest = 
{
	handler = DungeonDiFu,
	type = 'group',
	args = 
	{
		showHint =
		{
			type = "toggle",
			order = 101,
			name = L["Show Hint"],
			desc = L["Show hint at the bottom of the tooltip."],
			get = 'CanShowHint',
			set = 'SetShowHint'
		},
		showPrefix =
		{
			type = "toggle",
			order = 102,
			name = L["Show Prefix"],
			desc = L["Show text prefix before difficulty."],
			get = 'CanShowPrefix',
			set = 'SetShowPrefix'
		},
	},
}

function DungeonDiFu:CanShowHint()
	return self.db.profile.ShowHint
end

function DungeonDiFu:SetShowHint()
	self.db.profile.ShowHint = not self.db.profile.ShowHint
	self:UpdateTooltip()
end

function DungeonDiFu:CanShowPrefix()
	return self.db.profile.ShowPrefix
end

function DungeonDiFu:SetShowPrefix()
	self.db.profile.ShowPrefix = not self.db.profile.ShowPrefix
	self:UpdateText()
end

--============================================================================
function DungeonDiFu:OnInitialize()
end

function DungeonDiFu:OnEnable()
    self:RegisterEvent("PARTY_MEMBERS_CHANGED", "UpdateDisplay")
    self:RegisterEvent("CHAT_MSG_SYSTEM")
end

function DungeonDiFu:OnDisable()
end

--============================================================================
function DungeonDiFu:CHAT_MSG_SYSTEM(message)
    --ERR_DUNGEON_DIFFICULTY_CHANGED_S = "Dungeon difficulty set to %s (All saved instances have been reset)";
	local diff = DF(message, ERR_DUNGEON_DIFFICULTY_CHANGED_S)
	if (diff ~= nil) then
		self:UpdateDisplay()
	end
end

--============================================================================
function DungeonDiFu:OnTextUpdate()
	local curr = GetCurrentDungeonDifficulty()
	self:SetIcon("Interface\\AddOns\\"..self.folderName.."\\icons\\diff"..curr..".tga")

	local text = ""
	if (self.db.profile.ShowPrefix) then
		text = DUNGEON_DIFFICULTY .. ": "
	end
	self:SetText(text .. _G["DUNGEON_DIFFICULTY"..curr])
end

--============================================================================
function DungeonDiFu:OnTooltipUpdate()
	local cantChange = not self:CanAlterDiff()
	local diff = GetCurrentDungeonDifficulty()
	Tab:SetTitle(DUNGEON_DIFFICULTY)
	local cat = Tab:AddCategory('text','')
	for i = 1, 3 do
		cat:AddLine(
			'text', _G["DUNGEON_DIFFICULTY"..i],
			'textR', cantChange and 0.6 or nil,
			'textG', cantChange and 0.6 or nil,
			'textB', cantChange and 0.6 or nil,
			'hasCheck', true,
			'checked', (i == diff),
			'func', self:CanAlterDiff() and 'OnClickDifficulty' or nil,
			'arg1', self,
			'arg2', i
		)
	end

	if self.db.profile.ShowHint then
		Tab:SetHint(L["TOOLTIP_HINT"])
	end
end

function DungeonDiFu:CanAlterDiff()
	-- You can alter dungeon difficulty if you're solo (GetNum* == 0) or
	-- are the party leader.
	return (GetNumPartyMembers() + GetNumRaidMembers() == 0) or IsPartyLeader()
end

function DungeonDiFu:OnClickDifficulty(diff)
	SetDungeonDifficulty(diff)
end

--============================================================================
