﻿
local L 	= AceLibrary("AceLocale-2.2"):new("FuBar_DominosFu")
local KB = LibStub('LibKeyBound-1.0', true)

if not DominosFu then DominosFu = {} end
DominosFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")

if not DominosFu_revision then DominosFu_revision = {} end
DominosFu.version, DominosFu_revision.toc = GetAddOnMetadata("FuBar_DominosFu", "Version"):match("([%a%d%-%.]*)%s*%$Revision:%s(%d+)")
DominosFu_revision.main = ("$Revision: 25 $"):match("(%d+)")

DominosFu.date = ("$Date: 2008-07-27 14:13:29 +0000 (Sun, 27 Jul 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
--DominosFu.hasIcon = "Interface\\Icons\\INV_Misc_Drum_04"
DominosFu.hasIcon = "Interface\\Icons\\INV_Gizmo_GoblingTonkController"
DominosFu.defaultPosition = "RIGHT"
DominosFu.defaultMinimapPosition = 200
DominosFu.hasNoText = true
DominosFu.hasNoColor = true
DominosFu.hideWithoutStandby = true
DominosFu.cannotDetachTooltip = true
DominosFu.independentProfile = false
DominosFu.blizzardTooltip = true

DominosFu.OnMenuRequest = {
   type = 'group',
--   handler = DominosFu,
   args = {
		config = {
         order = 10,
         name = L["Configuration"],
         desc = L["Open Dominos configuration window"],
			type = 'execute',
		   func = function()
				if LoadAddOn('Dominos_Config') then
					InterfaceOptionsFrame_OpenToFrame('Dominos')
				end
			end,
			disabled = function() return not DominosFu.areOptionsEnabled end,
			icon = DominosFu.hasIcon
		},
		blankLine = {
			type = 'header',
			order = 15,
         desc = "",
		},
      lockBars = {
         order = 20,
         name = L["Lock Bar Positions"],
         desc = L["When set, Dominos' bars are locked in place."],
         type = 'toggle',
         get = function() return Dominos:Locked() end,
         set = function(v) Dominos:SetLock(v) end,
      },
      tooltips = {
         order = 30,
         name = L["Show Button Tooltips"],
         desc = L["When set, button tooltips will be displayed."],
         type = 'toggle',
         get = function() return Dominos:ShowTooltips() end,
         set = function(v) Dominos:SetShowTooltips(v) end,
      },
      showHotkeys = {
         order = 40,
         name = L["Show Hotkeys"],
         desc = L["When set, a button's key binding, if any, will be displayed on the button itself."],
         type = 'toggle',
         get = function() return Dominos:ShowBindingText() end,
         set = function(v) Dominos:SetShowBindingText(v) end,
      },
      showMacroText = {
         order = 50,
         name = L["Show Macro Text"],
         desc = L["When set, buttons containing macros will display the macro name on the button itself."],
         type = 'toggle',
         get = function() return Dominos:ShowMacroText() end,
         set = function(v) Dominos:SetShowMacroText(v) end,
      },
      keyBind = {
         order = 60,
         name = L["Enable Key Bindings Mode"],
         desc = L["Enable interactive key bindings mode allowing keys to be assigned to Dominos action bar buttons."],
         type = 'toggle',
         get = function() return (KB and KB:IsShown()) end,
         set = function(v)
         			Dominos:SetLock(true);
         			if v then
         				KB:Activate()
         			else
         				KB:Deactivate()
         			end
         	end,
         disabled = function() return not KB end,
		},
   }
}

DominosFu:RegisterDB("DominosFuDB")

function DominosFu:OnEnable()
   self.areOptionsEnabled = select(4, GetAddOnInfo('Dominos_Config'))

	-- The displayed revision will be the highest revision of all the Fubar_DominosFu revision tags
   self.revision = 0
   if DominosFu_revision then
   	for _, rev in pairs(DominosFu_revision) do
   		local revision = tonumber(rev)
   		if revision and revision > self.revision then self.revision = revision end
   	end
   else
   	assert(false,"No DominosFu_revision")
   end
end


function DominosFu:OnClick(button)
	local shift, ctrl, alt = IsShiftKeyDown(), IsControlKeyDown(), IsAltKeyDown()
	if button == 'LeftButton' then
		if not shift and not ctrl and not alt then
			if LoadAddOn('Dominos_Config') then
				InterfaceOptionsFrame_OpenToFrame('Dominos')
			end
		end

		if shift then
			Dominos:ToggleLockedFrames()
		end

		if ctrl then
			Dominos:SetShowTooltips(not Dominos:ShowTooltips())
		end

		if alt then
			if KB  and alt then
				Dominos:SetLock(true)
				KB:Toggle()
			else
				if KB  then
					KB:Deactivate()
				end
				Dominos:SetLock(not Dominos:Locked())
			end
		end
	end
   self:UpdateTooltip()
end

function DominosFu:OnTooltipUpdate()
   GameTooltip:AddLine("DominosFu (v".. self.version .. " r" .. self.revision ..")")
   GameTooltip:AddLine(" ")
   GameTooltip:AddDoubleLine(L["Bars locked:"], (Dominos:Locked() and L["Yes"] or L["No"]), 1, 1, 0, 1, 1, 1)
   GameTooltip:AddDoubleLine(L["Tooltips shown:"], (Dominos:ShowTooltips() and L["Yes"] or L["No"]), 1, 1, 0, 1, 1, 1)
   if KB then
   	GameTooltip:AddDoubleLine(L["Key bindings mode:"], (KB:IsShown() and L["On"] or L["Off"]), 1, 1, 0, 1, 1, 1)
   end

   GameTooltip:AddLine(" ")
   if self.areOptionsEnabled then
      GameTooltip:AddLine(L["|cffffff00Click|r to open Dominos Options."], 0.2, 1, 0.2)
   end
   if KB then
   	if KB:IsShown() then
			GameTooltip:AddLine(L["|cffffff00Alt-Click|r to disable key bindings mode."], 0.2, 1, 0.2)
		else
			GameTooltip:AddLine(L["|cffffff00Alt-Click|r to enable key bindings mode."], 0.2, 1, 0.2)
		end
	end
   if Dominos:Locked() then
      GameTooltip:AddLine(L["|cffffff00Shift-Click|r to unlock bars."], 0.2, 1, 0.2)
   else
      GameTooltip:AddLine(L["|cffffff00Shift-Click|r to lock bars."], 0.2, 1, 0.2)
   end

	if Dominos:ShowTooltips() then
		GameTooltip:AddLine(L["|cffffff00Control-Click|r to hide button tooltips."], 0.2, 1, 0.2)
	else
		GameTooltip:AddLine(L["|cffffff00Control-Click|r to show button tooltips."], 0.2, 1, 0.2)
	end

   GameTooltip:AddLine(L["|cffffff00Right-Click|r to change Fubar settings."], 0.2, 1, 0.2)
   if not Dominos:Locked() then
   	GameTooltip:AddLine(L["|cffffff00Right-Click on a bar|r to change bar settings."], 0.2, 1, 0.2)
   end
end
