local sformat = string.format
local tonumber = tonumber
local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("DigiCamFu")

DigiCamFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0")

DigiCamFu.clickableTooltip = true
DigiCamFu.hasIcon = "Interface\\Icons\\INV_Misc_Spyglass_03"

DigiCamFu:RegisterDB("DigiCamFuDB")
DigiCamFu:RegisterDefaults("profile", {

})

local function ChangeScreenshotFormat(ssFormat)
	-- Possible formats: tga, jpeg, png
	-- PNG is currently Mac only.
	-- Cycle order: tga -> jpeg -> png
	local newFormat
	
	if ssFormat == "tga" then
		newFormat = "jpeg"
	end

	if ssFormat == "jpeg" then
		if IsMacClient() then
			newFormat = "png"
		else
			newFormat = "tga"
		end
	end

	if ssFormat == "png" then
		newFormat = "tga"
	end

	if newFormat then
		SetCVar("screenshotFormat", newFormat)
	end
end

local function ChangeScreenshotQuality(ssQuality)
	ssQuality = tonumber(ssQuality)
	-- Holt down Alt key to decrease quality
	if IsAltKeyDown() then
		if ssQuality > 0 then
			ssQuality = ssQuality - 1
			SetCVar("screenshotQuality", ssQuality)
		end
	else -- Increase quality
		if ssQuality < 10 then
			ssQuality = ssQuality + 1
			SetCVar("screenshotQuality", ssQuality)
		end
	end
end

function DigiCamFu:OnTooltipUpdate()
	tablet:SetTitle(L["DigiCamFu"])
	tablet:SetHint(L["Shift-Click to take a screenshot. Left-Click Quality to increase, Alt-Left-Click Quality to decrease."])

	local cat = tablet:AddCategory("columns", 2)
	local ssFormat = GetCVar("screenshotFormat")
	local ssQuality = GetCVar("screenshotQuality")

	cat:AddLine(
		'text', L["Image Format"],
		'text2', ssFormat,
		'text2R', 1,
		'text2G', 1,
		'text2B', 1,
		'func', ChangeScreenshotFormat,
		'arg1', ssFormat
	)
	cat:AddLine(
		'text', L["Image Quality"],
		'text2', ssQuality,
		'text2R', 1,
		'text2G', 1,
		'text2B', 1,
		'func', ChangeScreenshotQuality,
		'arg1', ssQuality
	)
end

function DigiCamFu:OnClick()
	if IsShiftKeyDown() and arg1 == "LeftButton" then
		Screenshot()
	end
end
