local Tablet = AceLibrary("Tablet-2.0")

DebugFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0")
local DebugFu = DebugFu

DebugFu.revision = tonumber(("$Revision: 35166 $"):match("(%d+)"))
DebugFu.date = ("$Date: 2007-05-11 23:00:42 -0400 (Fri, 11 May 2007) $"):match("(%d%d%d%d%-%d%d%-%d%d)")

DebugFu.hasIcon = true
DebugFu.hasNoText = true
DebugFu.defaultPosition = "RIGHT"

DebugFu:RegisterDB("FuBar_DebugFuDB")
DebugFu:RegisterDefaults('profile', {
	namespace = "DebugFu",
	sort = "time",
})

function DebugFu:OnEnable()
	self:ScheduleRepeatingEvent("DebugFu-UpdateTooltip", self.UpdateTooltip, 1, self)
end

DebugFu.OnMenuRequest = {
	type = 'group',
	args = {
		scriptProfile = {
			order = 99,
			type = 'toggle',
			name = "Script profiling",
			desc = "Enable script profiling. Note: Reloads UI",
			get = function()
				return GetCVar("scriptProfile") == "1"
			end,
			set = function(value)
				SetCVar("scriptProfile", value and "1" or "0")
				ReloadUI()
			end
		},
		namespace = {
			type = 'text',
			name = "Namespace",
			desc = "Here, choose the namespace you wish to profile. Note: Script profiling must be enabled",
			usage = "<namespace>",
			get = function()
				return DebugFu.db.profile.namespace
			end,
			set = function(value)
				DebugFu.db.profile.namespace = value
				DebugFu:UpdateTooltip()
			end,
			disabled = function()
				return GetCVar("scriptProfile") ~= "1"
			end,
		},
		sort = {
			type = 'text',
			name = "Sort",
			desc = "Sort",
			get = function()
				return DebugFu.db.profile.sort
			end,
			set = function(value)
				DebugFu.db.profile.sort = value
				DebugFu:UpdateTooltip()
			end,
			disabled = function()
				return GetCVar("scriptProfile") ~= "1"
			end,
			validate = {
				name = "Function name",
				time = "Time",
				timeSubs = "Time w/subs",
				calls = "Calls",
				timePerCall = "Time/call",
				timeSubsPerCall = "Time w/subs/call",
			}
		}
	}
}

local new, del
do
	local list = setmetatable({}, {__mode='k'})
	function new()
		local t = next(list)
		if t then
			list[t] = nil
			return t
		else
			return {}
		end
	end
	function del(t)
		for k in pairs(t) do
			t[k] = nil
		end
		list[t] = true
		return nil
	end
end

local sorts = {
	name = function(alpha, bravo)
		return alpha.name:lower() < bravo.name:lower()
	end,
	time = function(alpha, bravo)
		if alpha.time ~= bravo.time then
			return alpha.time < bravo.time
		else
			return alpha.name:lower() < bravo.name:lower()
		end
	end,
	timeSubs = function(alpha, bravo)
		if alpha.timeSubs ~= bravo.timeSubs then
			return alpha.timeSubs < bravo.timeSubs
		else
			return alpha.name:lower() < bravo.name:lower()
		end
	end,
	calls = function(alpha, bravo)
		if alpha.calls ~= bravo.calls then
			return alpha.calls < bravo.calls
		elseif alpha.time ~= bravo.time then
			return alpha.time < bravo.time
		else
			return alpha.name:lower() < bravo.name:lower()
		end
	end,
	timePerCall = function(alpha, bravo)
		if alpha.time/alpha.calls ~= bravo.time/bravo.calls then
			return alpha.time/alpha.calls < bravo.time/bravo.calls
		elseif alpha.time ~= bravo.time then
			return alpha.time < bravo.time
		else
			return alpha.name:lower() < bravo.name:lower()
		end
	end,
	timeSubsPerCall = function(alpha, bravo)
		if alpha.timeSubs/alpha.calls ~= bravo.timeSubs/bravo.calls then
			return alpha.timeSubs/alpha.calls < bravo.timeSubs/bravo.calls
		elseif alpha.timeSubs ~= bravo.timeSubs then
			return alpha.timeSubs < bravo.timeSubs
		else
			return alpha.name:lower() < bravo.name:lower()
		end
	end,
}

function DebugFu:OnTooltipUpdate()
	if GetCVar("scriptProfile") ~= "1" then
		Tablet:AddCategory():AddLine("Error, Script profiling must be enabled")
		return
	end
	local namespace = DebugFu.db.profile.namespace
	local ns = _G[namespace]
	if not ns then
		local func = loadstring("return " .. namespace)
		if func then
			ns = func()
		end
	end
	if not ns then
		Tablet:AddCategory():AddLine(("Error, cannot find namespace: %q"):format(namespace))
		return
	end
	if ns == getfenv(0) then
		Tablet:AddCategory():AddLine(("Error, namespace is global namespace: %q"):format(namespace))
		return
	end
	Tablet:AddCategory():AddLine(namespace)
	local cat = Tablet:AddCategory(
		'columns', 6,
		'text', "Function",
		'text2', "Time",
		'text3', "Time w/subs",
		'text4', "Calls",
		'text5', "Time/call",
		'text6', "Time w/subs/call"
	)
	local list = new()
	local i = 1
	for k,v in pairs(ns) do
		if type(v) == "function" then
			local time, count = GetFunctionCPUUsage(v, false)
			local timesubs = GetFunctionCPUUsage(v, true)
			local t = new()
			t.name = tostring(k)
			t.time = time
			t.timesubs = timesubs
			t.count = count
			list[#list+1] = t
			i = i + 1
			if i > 1000 then
				Tablet:AddCategory():AddLine("Error, more than 1000 entries.")
				break
			end
		end
	end
	table.sort(list, sorts[self.db.profile.sort])
	for i,t in ipairs(list) do
		cat:AddLine(
			'text', t.name,
			'text2', ("%.0f ms"):format(t.time),
			'text3', ("%.0f ms"):format(t.timesubs),
			'text4', t.count,
			'text5', ("%.3f ms"):format(t.time/t.count),
			'text6', ("%.3f ms"):format(t.timesubs/t.count)
		)
		list[i] = del(t)
	end
	list = del(list)
end
