CraftTimersFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local abacus = LibStub("LibAbacus-3.0")
local L = AceLibrary("AceLocale-2.2"):new("CraftTimersFu")
CraftTimersFu.hasIcon = "Interface\\Icons\\INV_Misc_PocketWatch_01"

function CraftTimersFu:OnInitialize()
  CraftTimersFu:RegisterDB("CraftTimersFuDB")
	CraftTimersFu:RegisterDefaults("account", {
		data={},
		loc={},
		showname=true,
		showcraftname=true,
		}
	)  
end

function CraftTimersFu:OnEnable()
	self:RegisterEvent("TRADE_SKILL_UPDATE")
	self:RegisterEvent("CRAFT_UPDATE")
	self:RegisterEvent("PLAYER_LEAVING_WORLD")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED") 	
	self:ScheduleRepeatingEvent("watch", function() self:Update() end, 60)
end

function CraftTimersFu:OnDisable()
	self:UnregisterEvent("TRADE_SKILL_UPDATE")
	self:UnregisterEvent("CRAFT_UPDATE")
	self:UnregisterEvent("PLAYER_LEAVING_WORLD")
	self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED") 	
	self:CancelScheduledEvent("watch")
end


function CraftTimersFu:OnTextUpdate()
	self:SetFirstFinishingCooldownAsWatched()
	if self.db.account.watch == nil or self.db.account.watch.name == nil or self.db.account.watch.craft == nil then
		local ready = 0
		local total = 0
		for name,info in pairs(self.db.account.data) do
			for craft,cd in pairs(info) do
				total = total + 1
				if cd - time() <= 0 then ready = ready + 1 end
			end
		end
		
		self:SetText(ready.."/"..total)
	else
		local watchname = self.db.account.watch["name"]
		local watchcraft = self.db.account.watch["craft"]
		local watchcd = self.db.account.data[watchname][watchcraft]
		
		local string
		if watchcd - time() <=0 then string = "|cff00ff00"..L["Ready"].."|r"
		else
			string = abacus:FormatDurationFull(watchcd-time(),true,true) 
		end
		if self.db.account.showcraftname then string=watchcraft.." - "..string end
		if self.db.account.showname then string=watchname.." - "..string end
		
		self:SetText(string)
	end
end

function CraftTimersFu:OnTooltipUpdate()
	self:UpdateText()
	if self.db.account.data == {} or self.db.account.data == nil then return end
	local cat = tablet:AddCategory(
	'columns', 2
	)
	self:SavePosition()
	
	for playername, playerinfo in pairs(self.db.account.data) do
		if playerinfo ~= nil then
			if playerinfo ~= {} then
				if self.db.account.loc[playername] ~= nil then
					local zone = self.db.account.loc[playername]["loc"]
					local subzone = self.db.account.loc[playername]["subloc"]
					local zonestring = zone
					if subzone ~= nil and subzone ~= "" then zonestring = zonestring..", "..subzone end
					
					cat:AddLine(
						'text', "|cffffffff"..playername.." ("..zonestring..")".."|r"
					)
				else 
					cat:AddLine(
						'text', "|cffffffff"..playername.."|r"
					)
				end
				
				for k,v in pairs(playerinfo) do
					local timeleft = abacus:FormatDurationExtended(v-time(),true,true) 
					if v-time() <= 0 then timeleft = "|cff00ff00"..L["Ready"].."|r" end
					cat:AddLine(
					'text', k ,
					'text2', timeleft 
					)
				end
			end
		end
	end
end

function CraftTimersFu:TRADE_SKILL_UPDATE()
	for i=1,GetNumTradeSkills() do
		local cd = GetTradeSkillCooldown(i)
		if cd ~= nil then 
			local skillName = GetTradeSkillInfo(i)
			if string.sub(skillName,1,string.len(L["Transmute"])) == L["Transmute"] then skillName = L["Transmute"] end
			if self.db.account.data[UnitName("player")] == nil then self.db.account.data[UnitName("player")] = {} end
			self.db.account.data[UnitName("player")][skillName] = ( time() + cd )
		end
	end
	self:SetFirstFinishingCooldownAsWatched()
	self:Update()
end


function CraftTimersFu:CRAFT_UPDATE()
	for i=1,GetNumCrafts() do
		local cd = GetCraftCooldown(i)
		if cd ~= nil then 
			local skillName = GetCraftDisplaySkillLine(i)
			--if string.sub(skillName,1,string.len(L["Transmute"])) == L["Transmute"] then skillName = L["Transmute"] end
			if self.db.account.data[UnitName("player")] == nil then self.db.account.data[UnitName("player")] = {} end
			self.db.account.data[UnitName("player")][skillName] = ( time() + cd )
		end
	end
	self:SetFirstFinishingCooldownAsWatched()
	self:Update()
end

function CraftTimersFu:UNIT_SPELLCAST_SUCCEEDED()
	if arg1 ~= "player" then return end
	if arg2 ~= L["Salt Shaker"] then return end
	if self.db.account.data[UnitName("player")] == nil then self.db.account.data[UnitName("player")] = {} end
	local cd = 259200
	local skillName = L["Salt Shaker"]
	self.db.account.data[UnitName("player")][skillName] = ( time() + cd )
	self:SetFirstFinishingCooldownAsWatched()
	self:Update()
end

function CraftTimersFu:PLAYER_LEAVING_WORLD()
	self:SavePosition()
end

function CraftTimersFu:SavePosition()
	local zone = GetZoneText() 
	local subzone = GetSubZoneText()
	if self.db.account.loc[UnitName("player")] == nil then self.db.account.loc[UnitName("player")] = {} end
	self.db.account.loc[UnitName("player")]["loc"] = zone
	self.db.account.loc[UnitName("player")]["subloc"] = subzone
end

function CraftTimersFu:SetFirstFinishingCooldownAsWatched()
	if not self.db.account.watch then return end
	if not self.db.account.watch["first"] then return end
	local charname
	local craftname
	local tempcd=(10*time())
	for name,info in pairs(self.db.account.data) do
		for craft,cd in pairs(info) do
			if cd < tempcd and (cd - time() > 0) then 
				tempcd=cd
				charname=name
				craftname=craft
			end
		end
	end			
	self.db.account.watch["name"] = charname
	self.db.account.watch["craft"] = craftname
end


function CraftTimersFu:OnMenuRequest(level, value)
	if level == 1 then
		dewdrop:AddLine(
			'text', L["Reset"],
			'hasArrow', true,
			'value', "reset"
		)
		dewdrop:AddLine(
			'text', L["Watch"],
			'hasArrow', true,
			'value', "watch"
		)
		dewdrop:AddLine(
			'text', L["Show character name"],
			'func', function()
				self.db.account.showname = not self.db.account.showname
				self:UpdateText()
				end,
			'checked', self.db.account.showname 
		)
		dewdrop:AddLine(
			'text', L["Show craft name"],
			'func', function()
				self.db.account.showcraftname = not self.db.account.showcraftname
				self:UpdateText()
				end,
			'checked', self.db.account.showcraftname 
		)
		dewdrop:AddLine()
	elseif level == 2 then
		if value== "reset" then 
			for name,v in pairs(self.db.account.data) do
				dewdrop:AddLine(
					'text', name,
					'hasArrow', true,
					'value', name
				)
			end
		elseif value== "watch" then
			dewdrop:AddLine(
					'text',L["First cooldown up"],
					'func', function()
						self.db.account.watch = {}
						self.db.account.watch["first"] = true
						self:SetFirstFinishingCooldownAsWatched()
						self:Update()
					end,
					'isRadio',true,
					'checked', self.db.account.watch and self.db.account.watch["first"]
				)
			for name,info in pairs(self.db.account.data) do
				for craft,cd in pairs(info) do
					dewdrop:AddLine(
						'text',name.." - "..craft,
						'arg1',name,
						'arg2', craft,
						'func', function(name,craft)
							self.db.account.watch={}
							self.db.account.watch["name"]=name
							self.db.account.watch["craft"]=craft
							self.db.account.watch["first"] = false
							self:Update()
						end,
						'isRadio',true,
						'checked', self.db.account.watch and self.db.account.watch["name"] == name and self.db.account.watch["craft"]==craft and not self.db.account.watch["first"]
					)
				end
			end
			dewdrop:AddLine(
				'text',L["Nothing"],
				'func', function()
					self.db.account.watch=nil
					self:Update()
				end,
				'isRadio',true,
				'checked', self.db.account.watch == nil
			)
		end
	elseif level==3 then
		for name,info in pairs(self.db.account.data) do
			if value==name then
				dewdrop:AddLine(
					'text', L["Everything"],
					'arg1', name,
					'func', function(name)
						self.db.account.data[name] = nil
						self:Print(L["%s has been reset."]:format(name))
					end,
					'closeWhenClicked', true
				)
				for craft,cd in pairs(info) do
					dewdrop:AddLine(
						'text', craft,
						'arg1', craft,
						'func', function(craft)
							self.db.account.data[name][craft] = nil
							self:Print(L["%s has been reset."]:format(name.." - "..craft))
						end,
						'closeWhenClicked', true
					)
				end
			end
		end			
	end
end
