ConvergeFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceEvent-2.0"); 
local L = AceLibrary("AceLocale-2.2"):new("ConvergeFu"); 
local Tablet = AceLibrary("Tablet-2.0"); 

ConvergeFu:RegisterDB("ConvergeFuDB");
ConvergeFu:RegisterDefaults("profile", {
  guildName        = "Converge",
  searchTarget     = "Broliant",
  skullType        = "None",
  skullName        = "-",
  crossType        = "None",
  crossName        = "-",
  squareType       = "None",
  squareName       = "-",
  moonType         = "None",
  moonName         = "-",
  triangleType     = "None",
  triangleName     = "-",
  diamondType      = "None",
  diamondName      = "-",
  circleType       = "None",
  circleName       = "-",
  starType         = "None",
  starName         = "-",
  ccChannel        = "RAID",
  responderStatus  = "Off",
  responderGuild   = "Off",
  responderOfficer = "Off",
  responderParty   = "Off",
  responderRaid    = "Off",
  responderFriend  = "Off",
  responderMessage = L["tools-busy-responder-message-first"]..L["tools-busy-responder-message-stdrd"],
  versionString    = L["versionName"]..":"..L["versionNumber"],
  versionQuiet     = "0",
  versionDispChat  = "0",
  versionDispWin   = "1",
  recruitCharName  = "",
  recruitCharRank  = "",
  recruitCharMain  = "",
  recruitStatus    = "Dormant",
  recruitPromotes  = "0",
} )
ConvergeFu.hasIcon = true; 
ConvergeFu.defaultPosition = "RIGHT"; 

local versionCheckFrame
local versionCheckFrameCreated = "0"

ConvergeFu.consoleOptions = { 
   type = 'group', 
   args = { 
      announce = { 
         name = L["mainmenu-announce-title"], 
         type = 'group', 
         desc = L["mainmenu-announce-descr"], 
         args = { 
            guild = { 
               name = L["ann-guild-title"], 
               type = 'group', 
               desc = L["ann-guild-descr"], 
               args = {
                  invites = { 
                     name = L["ann-guild-raid-invite-title"], 
                     type = 'group', 
                     desc = L["ann-guild-raid-invite-descr"], 
                     args = {
                        banasea ={ 
                           name = L["common-officer-name-banasea"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-banasea"], "GUILD")
                           end
                        },
                        broliant ={ 
                           name = L["common-officer-name-broliant"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-broliant"], "GUILD")
                           end
                        },
                        jawa ={ 
                           name = L["common-officer-name-jawa"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-jawa"], "GUILD")
                           end
                        },     
                        letita ={ 
                           name = L["common-officer-name-letita"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-letita"], "GUILD")
                           end 
                        },                     
                        lyamblade ={ 
                           name = L["common-officer-name-lyamblade"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-lyamblade"], "GUILD")
                           end 
                        },            
                        paraply ={ 
                           name = L["common-officer-name-paraply"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-paraply"], "GUILD")
                           end 
                        },            
                        vanhelgan ={ 
                           name = L["common-officer-name-vanhelgan"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-vanhelgan"], "GUILD")
                           end
                        },
                        zmall ={ 
                           name = L["common-officer-name-zmall"], 
                           desc = L["ann-guild-raid-invite-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceRaidInvite(L["common-officer-name-zmall"], "GUILD")
                           end 
                        }
                     }
                  },
                  queue = { 
                     name = L["ann-guild-wait-list-title"], 
                     type = 'group', 
                     desc = L["ann-guild-wait-list-descr"], 
                     args = {
                        banasea ={ 
                           name = L["common-officer-name-banasea"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                              ConvergeFu:AnnounceWaitList(L["common-officer-name-banasea"], "GUILD")
                           end
                        },
                        broliant ={ 
                           name = L["common-officer-name-broliant"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-broliant"], "GUILD")
                           end 
                        },
                        jawa ={ 
                           name = L["common-officer-name-jawa"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-jawa"], "GUILD")
                           end
                        },     
                        letita ={ 
                           name = L["common-officer-name-letita"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-letita"], "GUILD")
                           end 
                        },                     
                        lyamblade ={ 
                           name = L["common-officer-name-lyamblade"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-lyamblade"], "GUILD")
                           end 
                        },            
                        paraply ={ 
                           name = L["common-officer-name-paraply"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-paraply"], "GUILD")
                           end 
                        },            
                        vanhelgan ={ 
                           name = L["common-officer-name-vanhelgan"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-vanhelgan"], "GUILD")
                           end
                        }, 
                        zmall ={ 
                           name = L["common-officer-name-zmall"], 
                           desc = L["ann-guild-wait-list-officer-descr"], 
                           type = 'execute', 
                           func = function() 
                             ConvergeFu:AnnounceWaitList(L["common-officer-name-zmall"], "GUILD")
                           end 
                        } 
                     }
                  },
                  welcome_new_trial = { 
                     name = L["ann-guild-new-trial-title"], 
                     desc = L["ann-guild-new-trial-descr"], 
                     type = 'execute', 
                     func = function() 
                        SendChatMessage(L["ann-guild-new-trial-01-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-02-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-03-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-04-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-05-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-06-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-07-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-08-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-09-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-10-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-new-trial-11-msg"], "GUILD")
                     end 
                  },
                  welcome_new_alt = { 
                     name = L["ann-guild-new-alt-title"], 
                     desc = L["ann-guild-new-alt-descr"], 
                     type = 'execute', 
                     func = function() 
                       SendChatMessage(L["ann-guild-new-alt-01-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-02-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-03-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-04-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-05-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-06-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-07-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-08-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-09-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-10-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-new-alt-11-msg"], "GUILD")
                     end 
                  },  
                  trial_ended ={ 
                     name = L["ann-guild-trial-ended-title"], 
                     desc = L["ann-guild-trial-ended-descr"], 
                     type = 'execute', 
                     func = function() 
                       SendChatMessage(L["ann-guild-trial-ended-01-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-02-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-03-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-04-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-05-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-06-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-07-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-08-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-09-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-10-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-trial-ended-11-msg"], "GUILD")
                     end
                  },             
                  promote_trial ={ 
                     name = L["ann-guild-promote-title"], 
                     desc = L["ann-guild-promote-descr"], 
                     type = 'execute', 
                     func = function() 
                       SendChatMessage(L["ann-guild-promote-01-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-02-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-03-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-04-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-05-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-06-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-07-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-08-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-09-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-10-msg"], "GUILD")
                       SendChatMessage(L["ann-guild-promote-11-msg"], "GUILD")
                     end
                  },
                  registration_keyword = { 
                     name = L["ann-guild-reg-keyword-title"], 
                     desc = L["ann-guild-reg-keyword-descr"], 
                     type = 'execute', 
                     func = function() 
                        SendChatMessage(L["ann-guild-reg-keyword-01-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-02-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-03-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-04-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-05-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-06-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-07-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-08-msg"], "GUILD")
                        SendChatMessage(L["ann-guild-reg-keyword-09-msg"], "GUILD")
                     end 
                  }                                    
               }
            },
            raid = {
               name = L["ann-raid-title"], 
               type = 'group', 
               desc = L["ann-raid-descr"], 
               args = {             
                 quest = {
                    name = L["ann-raid-quest-title"], 
                    type = 'group', 
                    desc = L["ann-raid-quest-descr"], 
                    args = { 
                       quest_01 = { 
                          name = L["ann-common-promotion-quest-01-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-01-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-01-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-01-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-01-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_02 = { 
                          name = L["ann-common-promotion-quest-02-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-02-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-02-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-02-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-02-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_03 = { 
                          name = L["ann-common-promotion-quest-03-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-03-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-03-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-03-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-03-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_04 = { 
                          name = L["ann-common-promotion-quest-04-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-04-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-04-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-04-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-04-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_05 = { 
                          name = L["ann-common-promotion-quest-05-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-05-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-05-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-05-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-05-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_06 = { 
                          name = L["ann-common-promotion-quest-06-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-06-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-06-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-06-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-06-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_07 = { 
                          name = L["ann-common-promotion-quest-07-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-07-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-07-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-07-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-07-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_08 = { 
                          name = L["ann-common-promotion-quest-08-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-08-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-08-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-08-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-08-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_09 = { 
                          name = L["ann-common-promotion-quest-09-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-09-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-09-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-09-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-09-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_10 = { 
                          name = L["ann-common-promotion-quest-10-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-10-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-10-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-10-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-10-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_11 = { 
                          name = L["ann-common-promotion-quest-11-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-11-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-11-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-11-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-11-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_12 = { 
                          name = L["ann-common-promotion-quest-12-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-12-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-12-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-12-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-12-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_13 = { 
                          name = L["ann-common-promotion-quest-13-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-13-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-13-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-13-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-13-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_14 = { 
                          name = L["ann-common-promotion-quest-14-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-14-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-14-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-14-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-14-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_15 = { 
                          name = L["ann-common-promotion-quest-15-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-15-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-15-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-15-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-15-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_16 = { 
                          name = L["ann-common-promotion-quest-16-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-16-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-16-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-16-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-16-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_17 = { 
                          name = L["ann-common-promotion-quest-17-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-17-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-17-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-17-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-17-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_18 = { 
                          name = L["ann-common-promotion-quest-18-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-18-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-18-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-18-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-18-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_19 = { 
                          name = L["ann-common-promotion-quest-19-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-19-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-19-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-19-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-19-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       },
                       quest_20 = { 
                          name = L["ann-common-promotion-quest-20-title"], 
                          desc = L["ann-common-promotion-quest-descr"], 
                          type = 'execute', 
                          func = function() 
                             SendChatMessage(L["ann-common-promotion-quest-txt-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-20-01-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-20-02-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-20-03-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-20-04-msg"], "RAID")
                             SendChatMessage(L["ann-common-promotion-quest-txt-05-msg"], "RAID")
                          end 
                       }
                    }
                 },
                 kill_order = { 
                    name = L["ann-common-kill-order-title"], 
                    desc = L["ann-common-kill-order-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-kill-order-01-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-02-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-03-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-04-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-05-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-06-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-07-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-08-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-09-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-10-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-11-msg"], "RAID")
                       SendChatMessage(L["ann-common-kill-order-12-msg"], "RAID")
                    end 
                 },
                 ventrilo = { 
                    name = L["ann-common-ventrilo-title"], 
                    desc = L["ann-common-ventrilo-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-ventrilo-01-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-02-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-03-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-04-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-05-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-06-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-07-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-08-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-09-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-10-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-11-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-12-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-13-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-14-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-15-msg"], "RAID")
                       SendChatMessage(L["ann-common-ventrilo-16-msg"], "RAID")
                    end 
                 },               
                 raid_begin = { 
                    name = L["ann-raid-raid-begin-title"], 
                    desc = L["ann-raid-raid-begin-descr"], 
                    type = 'execute', 
                    func = function() 
                      SendChatMessage(L["ann-raid-raid-begin-02-msg"], "RAID_WARNING")
                      SendChatMessage(L["ann-raid-raid-begin-14-msg"], "RAID_WARNING")
  
                      SendChatMessage(L["ann-raid-raid-begin-01-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-02-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-03-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-04-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-05-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-06-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-07-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-08-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-09-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-10-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-11-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-12-msg"], "RAID")
                      SendChatMessage(L["ann-raid-raid-begin-13-msg"], "RAID")
                    end 
                 },               
                 raid_end = { 
                    name = L["ann-raid-raid-end-title"], 
                    desc = L["ann-raid-raid-end-descr"], 
                    type = 'execute', 
                    func = function() 
                      ConvergeFu:AnnounceRaidEnd("RAID")
                    end 
                 },
                 priority = { 
                    name = L["ann-common-looting-order-title"], 
                    desc = L["ann-common-looting-order-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-looting-order-01-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-02-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-03-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-04-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-05-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-06-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-07-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-08-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-09-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-10-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-11-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-12-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-13-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-14-msg"], "RAID")
                       SendChatMessage(L["ann-common-looting-order-15-msg"], "RAID")
                    end 
                 }
              }
          },
            party = {
               name = L["ann-party-title"], 
               type = 'group', 
               desc = L["ann-party-descr"], 
               args = {             
                 kill_order ={ 
                    name = L["ann-common-kill-order-title"], 
                    desc = L["ann-common-kill-order-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-kill-order-01-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-02-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-03-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-04-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-05-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-06-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-07-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-08-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-09-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-10-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-11-msg"], "PARTY")
                       SendChatMessage(L["ann-common-kill-order-12-msg"], "PARTY")
                    end 
                 },
                 ventrilo ={ 
                    name = L["ann-common-ventrilo-title"], 
                    desc = L["ann-common-ventrilo-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-ventrilo-01-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-02-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-03-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-04-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-05-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-06-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-07-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-08-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-09-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-10-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-11-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-12-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-13-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-14-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-15-msg"], "PARTY")
                       SendChatMessage(L["ann-common-ventrilo-16-msg"], "PARTY")
                    end 
                 },               
                 party_begin ={ 
                    name = L["ann-raid-raid-begin-title"], 
                    desc = L["ann-raid-raid-begin-descr"], 
                    type = 'execute', 
                    func = function() 
                      SendChatMessage(L["ann-raid-raid-begin-02-msg"], "RAID_WARNING")
                      SendChatMessage(L["ann-raid-raid-begin-14-msg"], "RAID_WARNING")
  
                      SendChatMessage(L["ann-raid-raid-begin-01-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-02-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-03-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-04-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-05-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-06-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-07-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-08-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-09-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-10-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-11-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-12-msg"], "PARTY")
                      SendChatMessage(L["ann-raid-raid-begin-13-msg"], "PARTY")
                    end 
                 },               
                 party_end ={ 
                    name = L["ann-raid-raid-end-title"], 
                    desc = L["ann-raid-raid-end-descr"], 
                    type = 'execute', 
                    func = function() 
                      ConvergeFu:AnnounceRaidEnd("PARTY")
                    end 
                 },
                 priority ={ 
                    name = L["ann-common-looting-order-title"], 
                    desc = L["ann-common-looting-order-descr"], 
                    type = 'execute', 
                    func = function() 
                       SendChatMessage(L["ann-common-looting-order-01-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-02-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-03-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-04-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-05-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-06-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-07-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-08-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-09-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-10-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-11-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-12-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-13-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-14-msg"], "PARTY")
                       SendChatMessage(L["ann-common-looting-order-15-msg"], "PARTY")
                    end 
                 }
              }
           },
           say = {
              name = L["ann-say-title"], 
              type = 'group', 
              desc = L["ann-say-descr"], 
              args = { 
                 threat = { 
                    name = L["ann-say-threat-title"], 
                    desc = L["ann-say-threat-descr"], 
                    type = 'execute', 
                    func = function() SendChatMessage(L["ann-say-threat-msg"], "SAY") end
                 },
                 evasion = { 
                    name = L["ann-say-evasion-title"], 
                    desc = L["ann-say-evasion-descr"], 
                    type = 'execute', 
                    func = function() SendChatMessage(L["ann-say-evasion-msg"], "SAY") end
                 },
                 granny = { 
                    name = L["ann-say-granny-title"], 
                    desc = L["ann-say-granny-descr"], 
                    type = 'execute', 
                    func = function() SendChatMessage(L["ann-say-granny-msg"], "SAY") end
                 },
                 fireball = { 
                    name = L["ann-say-fireball-title"], 
                    desc = L["ann-say-fireball-descr"], 
                    type = 'execute', 
                    func = function() SendChatMessage(L["ann-say-fireball-msg"], "SAY") end
                 }                 
              }
           }         
         }
      },
      chat = { 
         name = L["mainmenu-chat-title"], 
         type = 'group', 
         desc = L["mainmenu-chat-descr"], 
         args = { 
            join = { 
               name = L["chat-join-title"], 
               type = 'group', 
               desc = L["chat-join-descr"], 
               args = {
                  condknight = { 
                     name = L["chat-condknight-title"], 
                     desc = L["chat-condknight-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join condknight") end 
                  },               
                  condruid = { 
                     name = L["chat-condruid-title"], 
                     desc = L["chat-condruid-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join condruid") end 
                  }, 
                  conhunter = { 
                     name = L["chat-conhunter-title"], 
                     desc = L["chat-conhunter-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conhunter") end 
                  }, 
                  conmage = { 
                     name = L["chat-conmage-title"], 
                     desc = L["chat-conmage-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conmage") end 
                  }, 
                  conpaladin = { 
                     name = L["chat-conpaladin-title"], 
                     desc = L["chat-conpaladin-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conpaladin") end 
                  }, 
                  conpriest = { 
                     name = L["chat-conpriest-title"], 
                     desc = L["chat-conpriest-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conpriest") end 
                  }, 
                  conrogue = { 
                     name = L["chat-conrogue-title"], 
                     desc = L["chat-conrogue-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conrogue") end 
                  }, 
                  conshaman = { 
                     name = L["chat-conshaman-title"], 
                     desc = L["chat-conshaman-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conshaman") end 
                  },
                  contank = { 
                     name = L["chat-contank-title"], 
                     desc = L["chat-contank-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join contank") end 
                  },                  
                  conlock = { 
                     name = L["chat-conlock-title"], 
                     desc = L["chat-conlock-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conlock") end 
                  }, 
                  conwarrior = { 
                     name = L["chat-conwarrior-title"], 
                     desc = L["chat-conwarrior-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conwarrior") end 
                  },
                  conhealer = { 
                     name = L["chat-conhealer-title"], 
                     desc = L["chat-conhealer-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/join conhealer") end 
                  }
               }
            },
            leave = { 
               name = L["chat-leave-title"], 
               type = 'group', 
               desc = L["chat-leave-descr"], 
               args = {
                  condknight = { 
                     name = L["chat-condknight-title"], 
                     desc = L["chat-condknight-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave condknight") end 
                  },                
                  condruid = { 
                     name = L["chat-condruid-title"], 
                     desc = L["chat-condruid-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave condruid") end 
                  }, 
                  conhunter = { 
                     name = L["chat-conhunter-title"], 
                     desc = L["chat-conhunter-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conhunter") end 
                  }, 
                  conmage = { 
                     name = L["chat-conmage-title"], 
                     desc = L["chat-conmage-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conmage") end 
                  }, 
                  conpaladin = { 
                     name = L["chat-conpaladin-title"], 
                     desc = L["chat-conpaladin-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conpaladin") end 
                  }, 
                  conpriest = { 
                     name = L["chat-conpriest-title"], 
                     desc = L["chat-conpriest-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conpriest") end 
                  }, 
                  conrogue = { 
                     name = L["chat-conrogue-title"], 
                     desc = L["chat-conrogue-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conrogue") end 
                  }, 
                  conshaman = { 
                     name = L["chat-conshaman-title"], 
                     desc = L["chat-conshaman-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conshaman") end 
                  },
                  contank = { 
                     name = L["chat-contank-title"], 
                     desc = L["chat-contank-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave contank") end 
                  },                  
                  conlock = { 
                     name = L["chat-conlock-title"], 
                     desc = L["chat-conlock-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conlock") end 
                  }, 
                  conwarrior = { 
                     name = L["chat-conwarrior-title"], 
                     desc = L["chat-conwarrior-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conwarrior") end 
                  },
                  conhealer = { 
                     name = L["chat-conhealer-title"], 
                     desc = L["chat-conhealer-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/leave conhealer") end 
                  }
               }
            },
            who = {
               name = L["chat-who-title"], 
               type = 'group', 
               desc = L["chat-who-descr"], 
               args = {
                  condknight = { 
                     name = L["chat-condknight-title"], 
                     desc = L["chat-condknight-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho condknight") end 
                  },                
                  condruid = { 
                     name = L["chat-condruid-title"], 
                     desc = L["chat-condruid-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho condruid") end 
                  }, 
                  conhunter = { 
                     name = L["chat-conhunter-title"], 
                     desc = L["chat-conhunter-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conhunter") end 
                  }, 
                  conmage = { 
                     name = L["chat-conmage-title"], 
                     desc = L["chat-conmage-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conmage") end 
                  }, 
                  conpaladin = { 
                     name = L["chat-conpaladin-title"], 
                     desc = L["chat-conpaladin-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conpaladin") end 
                  }, 
                  conpriest = { 
                     name = L["chat-conpriest-title"], 
                     desc = L["chat-conpriest-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conpriest") end 
                  }, 
                  conrogue = { 
                     name = L["chat-conrogue-title"], 
                     desc = L["chat-conrogue-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conrogue") end 
                  }, 
                  conshaman = { 
                     name = L["chat-conshaman-title"], 
                     desc = L["chat-conshaman-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conshaman") end 
                  },
                  contank = { 
                     name = L["chat-contank-title"], 
                     desc = L["chat-contank-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho contank") end 
                  },                   
                  conlock = { 
                     name = L["chat-conlock-title"], 
                     desc = L["chat-conlock-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conlock") end 
                  }, 
                  conwarrior = { 
                     name = L["chat-conwarrior-title"], 
                     desc = L["chat-conwarrior-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conwarrior") end 
                  },
                  conhealer = { 
                     name = L["chat-conhealer-title"], 
                     desc = L["chat-conhealer-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/chatwho conhealer") end 
                  }
               }            
            },
            list = {
               name = L["chat-list-title"], 
               desc = L["chat-list-descr"], 
               type = 'execute', 
               func = function() ConvergeFu:ExecuteChatCommand("/chatlist") end 
            },
            announce = {
               name = L["chat-announce-title"], 
               desc = L["chat-announce-descr"], 
               type = 'execute', 
               func = function() 
                  SendChatMessage(L["chat-announce-01-msg"], "RAID")
                  SendChatMessage(L["chat-announce-02-msg"], "RAID")
                  SendChatMessage(L["chat-announce-03-msg"], "RAID")
                  SendChatMessage(L["chat-announce-04-msg"], "RAID")
                  SendChatMessage(L["chat-announce-05-msg"], "RAID")
                  SendChatMessage(L["chat-announce-06-msg"], "RAID")
                  SendChatMessage(L["chat-announce-07-msg"], "RAID")
                  SendChatMessage(L["chat-announce-08-msg"], "RAID")
                  SendChatMessage(L["chat-announce-09-msg"], "RAID")
                  SendChatMessage(L["chat-announce-10-msg"], "RAID")
                  SendChatMessage(L["chat-announce-11-msg"], "RAID")
                  SendChatMessage(L["chat-announce-12-msg"], "RAID")
                  SendChatMessage(L["chat-announce-13-msg"], "RAID")
                  SendChatMessage(L["chat-announce-14-msg"], "RAID")
               end 
            }            
         }
      },
      addons = { 
         name = L["mainmenu-addons-title"], 
         type = 'group', 
         desc = L["mainmenu-addons-descr"], 
         args = { 
            ra = {
               name = L["addon-ra-title"],
               type = 'group',
               desc = L["addon-ra-descr"],
               args = {
                  ready = { 
                     name = L["addon-ra-ready-title"], 
                     desc = L["addon-ra-ready-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/raready")  end 
                  },
                  dura = { 
                     name = L["addon-ra-dura-title"], 
                     desc = L["addon-ra-dura-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/radur") end 
                  }, 
                  resist = { 
                     name = L["addon-ra-resist-title"], 
                     desc = L["addon-ra-resist-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/raresist") end 
                  },
                  item = { 
                     name = L["addon-ra-item-title"], 
                     desc = L["addon-ra-item-descr"], 
                     type = 'execute', 
                     func = function()
                        SendChatMessage(L["addon-ra-item-01-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-02-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-03-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-04-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-05-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-06-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-07-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-08-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-09-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-10-msg"], "OFFICER")
                        SendChatMessage(L["addon-ra-item-11-msg"], "OFFICER")                     
                     end 
                  },                  
                  version = { 
                     name = L["addon-ra-version-title"], 
                     desc = L["addon-ra-version-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/raversion")  end 
                  }               
               }
            },
            dbm = {
               name = L["addon-dbm-title"],
               type = 'group',
               desc = L["addon-dbm-descr"],
               args = {
                  timer_bio_02min = { 
                     name = L["addon-dbm-timer-bio-03m-title"], 
                     desc = L["addon-dbm-timer-bio-03m-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h3m "..L["addon-dbm-timer-bio-03m-msg"])  end 
                  }, 
                  timer_bio_05min = { 
                     name = L["addon-dbm-timer-bio-05m-title"], 
                     desc = L["addon-dbm-timer-bio-05m-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h5m "..L["addon-dbm-timer-bio-05m-msg"]) end 
                  }, 
                  timer_raid_begins_05m = { 
                     name = L["addon-dbm-timer-raid-start-05m-title"], 
                     desc = L["addon-dbm-timer-raid-start-05m-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h5m "..L["addon-dbm-timer-raid-start-msg"]) end 
                  },
                  timer_raid_begins_10m = { 
                     name = L["addon-dbm-timer-raid-start-10m-title"], 
                     desc = L["addon-dbm-timer-raid-start-10m-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h10m "..L["addon-dbm-timer-raid-start-msg"]) end 
                  }, 
                  timer_raid_begins_15m = { 
                     name = L["addon-dbm-timer-raid-start-15m-title"], 
                     desc = L["addon-dbm-timer-raid-start-15m-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h15m "..L["addon-dbm-timer-raid-start-msg"]) end 
                  }, 
                  timer_pull_05s_quiet = { 
                     name = L["addon-dbm-timer-pull-quiet-05s-title"], 
                     desc = L["addon-dbm-timer-pull-quiet-05s-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h0m5s "..L["addon-dbm-timer-pull-msg"]) end 
                  }, 
                  timer_pull_10s_quiet = { 
                     name = L["addon-dbm-timer-pull-quiet-10s-title"], 
                     desc = L["addon-dbm-timer-pull-quiet-10s-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm broadcast timer 0h0m10s "..L["addon-dbm-timer-pull-msg"]) end 
                  }, 
                  timer_pull_05s_loud = { 
                     name = L["addon-dbm-timer-pull-loud-05s-title"], 
                     desc = L["addon-dbm-timer-pull-loud-05s-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm pull 5s") end 
                  },             
                  timer_pull_10s_loud = { 
                     name = L["addon-dbm-timer-pull-loud-10s-title"], 
                     desc = L["addon-dbm-timer-pull-loud-10s-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm pull 10s") end 
                  }, 
                  timer_bar_unlock = { 
                     name = L["addon-dbm-unlock-title"], 
                     desc = L["addon-dbm-unlock-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/dbm unlock") end 
                  },
                  stop = { 
                     name = L["addon-dbm-stop-title"], 
                     desc = L["addon-dbm-stop-descr"], 
                      type = 'execute', 
                      func = function() ConvergeFu:ExecuteChatCommand("/dbm stop") end 
                  },                   
                  version = { 
                     name = L["addon-dbm-version-title"], 
                     desc = L["addon-dbm-version-descr"], 
                      type = 'execute', 
                      func = function() ConvergeFu:ExecuteChatCommand("/dbm ver") end 
                  }               
               }            
            },
            omen = {
               name = L["addon-omen-title"],
               type = 'group',
               desc = L["addon-omen-descr"],
               args = {
                  version = { 
                     name = L["addon-omen-version-title"], 
                     desc = L["addon-omen-version-descr"], 
                     type = 'execute', 
                     func = function()
                        Omen:VersionCheck(false)
                     end               
                  }               
               }            
            },
            questhelper = {
               name = L["addon-questhelper-title"],
               type = 'group',
               desc = L["addon-questhelper-descr"],
               args = {
                  toggle = { 
                     name = L["addon-questhelper-toggle-title"], 
                     desc = L["addon-questhelper-toggle-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/qh hide") end               
                  }               
               }
            },
            raidbuffstatus = {
               name = L["addon-raidbuffstatus-title"],
               type = 'group',
               desc = L["addon-raidbuffstatus-descr"],
               args = {
                  toggle = { 
                     name = L["addon-raidbuffstatus-toggle-title"], 
                     desc = L["addon-raidbuffstatus-toggle-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/rbs toggle") end               
                  },
                  report = { 
                     name = L["addon-raidbuffstatus-report-title"], 
                     desc = L["addon-raidbuffstatus-report-descr"], 
                     type = 'execute', 
                     func = function() ConvergeFu:ExecuteChatCommand("/rbs report") end               
                  }                   
               }
            }            
         }
      },
      macro = { 
         name = L["mainmenu-macro-title"], 
         type = 'group', 
         desc = L["mainmenu-macro-descr"], 
         args = { 
            karazhan = { 
               name = L["macro-karazhan-title"], 
               type = 'group', 
               desc = L["macro-karazhan-descr"], 
               args = {
                  curator = { 
                     name = L["macro-karazhan-curator-title"], 
                     type = 'group', 
                     desc = L["macro-karazhan-curator-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-karazhan-curator-link-title"], 
                           desc = L["macro-karazhan-curator-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-karazhan-curator-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-karazhan-curator-run-title"], 
                           desc = L["macro-karazhan-curator-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:ExecuteChatCommand("/target astral flare")
                           end
                        },
                        show ={ 
                           name = L["macro-karazhan-curator-show-title"], 
                           desc = L["macro-karazhan-curator-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-karazhan-curator-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-curator-show-09-msg"], "RAID")
                           end
                        }                        
                     }
                  },
                  illhoof = { 
                     name = L["macro-karazhan-illhoof-title"], 
                     type = 'group', 
                     desc = L["macro-karazhan-illhoof-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-karazhan-illhoof-link-title"], 
                           desc = L["macro-karazhan-illhoof-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-karazhan-illhoof-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-karazhan-illhoof-run-title"], 
                           desc = L["macro-karazhan-illhoof-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:ExecuteChatCommand("/target Demon Chains")
                           end
                        },
                        show ={ 
                           name = L["macro-karazhan-illhoof-show-title"], 
                           desc = L["macro-karazhan-illhoof-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-karazhan-illhoof-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-karazhan-illhoof-show-09-msg"], "RAID")
                           end
                        }                        
                     }
                  }
               }
            },
            ssc = { 
               name = L["macro-ssc-title"], 
               type = 'group', 
               desc = L["macro-ssc-descr"], 
               args = {
                  karathress = { 
                     name = L["macro-ssc-karathress-title"], 
                     type = 'group', 
                     desc = L["macro-ssc-karathress-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-ssc-karathress-link-title"], 
                           desc = L["macro-ssc-karathress-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-ssc-karathress-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-ssc-karathress-run-title"], 
                           desc = L["macro-ssc-karathress-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:ExecuteChatCommand("/target Spitfire Totem")
                           end
                        },
                        show ={ 
                           name = L["macro-ssc-karathress-show-title"], 
                           desc = L["macro-ssc-karathress-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-ssc-karathress-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-karathress-show-09-msg"], "RAID")
                           end
                        }                        
                     }
                  },
                  vashj = { 
                     name = L["macro-ssc-vashj-title"], 
                     type = 'group', 
                     desc = L["macro-ssc-vashj-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-ssc-vashj-link-title"], 
                           desc = L["macro-ssc-vashj-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-ssc-vashj-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-ssc-vashj-run-title"], 
                           desc = L["macro-ssc-vashj-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:ExecuteChatCommand("/use Tainted Core")
                              ConvergeFu:ExecuteChatCommand("/y <------- TAINTED CORE TO: %t ! ! !")
                              ConvergeFu:ExecuteChatCommand("/s <------- TAINTED CORE TO: %t ! ! !")
                              SendChatMessage("!!! YOU HAVE THE CORE !!!", "WHISPER", nil, UnitName("target"))
                           end
                        },
                        show ={ 
                           name = L["macro-ssc-vashj-show-title"], 
                           desc = L["macro-ssc-vashj-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-ssc-vashj-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-09-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-10-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-11-msg"], "RAID")
                              SendChatMessage(L["macro-ssc-vashj-show-12-msg"], "RAID")
                           end
                        }                        
                     }
                  }
               }
            },
            bt = { 
               name = L["macro-bt-title"], 
               type = 'group', 
               desc = L["macro-bt-descr"], 
               args = {
                  najentus_spine = { 
                     name = L["macro-bt-najentus-spine-title"], 
                     type = 'group', 
                     desc = L["macro-bt-najentus-spine-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-bt-najentus-spine-link-title"], 
                           desc = L["macro-bt-najentus-spine-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-najentus-spine-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-bt-najentus-spine-run-title"], 
                           desc = L["macro-bt-najentus-spine-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:ExecuteChatCommand("/use Naj'entus Spine")
                           end
                        },
                        show ={ 
                           name = L["macro-bt-najentus-spine-show-title"], 
                           desc = L["macro-bt-najentus-spine-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-najentus-spine-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-spine-show-09-msg"], "RAID")
                           end
                        }                        
                     }
                  },
                  najentus_hp = { 
                     name = L["macro-bt-najentus-hp-title"], 
                     type = 'group', 
                     desc = L["macro-bt-najentus-hp-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-bt-najentus-hp-link-title"], 
                           desc = L["macro-bt-najentus-hp-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-najentus-hp-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-06-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-07-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-08-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-09-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-link-10-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-bt-najentus-hp-run-title"], 
                           desc = L["macro-bt-najentus-hp-run-descr"],  
                           type = 'execute', 
                           func = function()
                              for i = 1, 40 do
                                local u = "raid"..i;
                                local hp = UnitHealthMax(u);
                                local _, _, grp = GetRaidRosterInfo(i);
                                if UnitExists(u) and hp < 9500 and grp <= 5 then
                                  ChatFrame1:AddMessage(UnitName(u)..": "..hp.." HP");
                                end
                              end 
                           end
                        },
                        show ={ 
                           name = L["macro-bt-najentus-hp-show-title"], 
                           desc = L["macro-bt-najentus-hp-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-najentus-hp-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-09-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-10-msg"], "RAID")                              
                              SendChatMessage(L["macro-bt-najentus-hp-show-11-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-12-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-13-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-14-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-15-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-16-msg"], "RAID")
                              SendChatMessage(L["macro-bt-najentus-hp-show-17-msg"], "RAID")                              
                           end
                        }                        
                     }
                  },
                  gorefiend = { 
                     name = L["macro-bt-gorefiend-const-title"], 
                     type = 'group', 
                     desc = L["macro-bt-gorefiend-const-descr"], 
                     args = {
                        link ={ 
                           name = L["macro-bt-gorefiend-const-link-title"], 
                           desc = L["macro-bt-gorefiend-const-link-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-gorefiend-const-link-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-link-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-link-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-link-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-link-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-link-06-msg"], "RAID")
                           end
                        },
                        run ={ 
                           name = L["macro-bt-gorefiend-const-run-title"], 
                           desc = L["macro-bt-gorefiend-const-run-descr"],  
                           type = 'execute', 
                           func = function()
                              ConvergeFu:SendChatMessage(L["macro-bt-gorefiend-const-run-01-msg"], "CHAT")
                           end
                        },
                        show ={ 
                           name = L["macro-bt-gorefiend-const-show-title"], 
                           desc = L["macro-bt-gorefiend-const-show-descr"], 
                           type = 'execute', 
                           func = function()
                              SendChatMessage(L["macro-bt-gorefiend-const-show-01-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-02-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-03-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-04-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-05-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-06-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-07-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-08-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-09-msg"], "RAID")
                              SendChatMessage(L["macro-bt-gorefiend-const-show-10-msg"], "RAID")                              
                              SendChatMessage(L["macro-bt-gorefiend-const-show-11-msg"], "RAID")
                           end
                        }                        
                     }
                  }                  
               }
            }
         }         
      },
      tools = {
         name = L["mainmenu-tools-title"], 
         type = 'group', 
         desc = L["mainmenu-tools-descr"], 
         args = {
            recruiter = {
               name = L["tools-recruiter-title"],
               desc = L["tools-recruiter-descr"],
               type = 'group',
               args = {
                  start = {
                     name = L["tools-recruiter-start-title"],
                     desc = L["tools-recruiter-start-descr"],
                     type = 'execute',
                     func = function()
                        ConvergeFu:RecruitCharacterCancel()
                        ConvergeFu:RecruitCharacter()
                     end
                  },
                  report = {
                     name = L["tools-recruiter-report-title"],
                     desc = L["tools-recruiter-report-descr"],
                     type = 'execute',
                     func = function()
                        ConvergeFu:RecruitReportStatus()
                     end
                  },
                  reset = {
                     name = L["tools-recruiter-reset-title"],
                     desc = L["tools-recruiter-reset-descr"],
                     type = 'execute',
                     func = function()
                        ConvergeFu:RecruitCharacterCancel()
                     end
                  }                                    
               }
            },
            responder = {
               name = L["tools-busy-responder-title"],
               desc = L["tools-busy-responder-title"],
               type = 'group',
               args = {
                  enabled = {
                     name     = L["tools-busy-responder-status-title"],
                     desc     = L["tools-busy-responder-status-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-status-usage"],
                     get      = function() return ConvergeFu.db.profile.responderStatus end,
                     set      = function(newValue) ConvergeFu.db.profile.responderStatus = newValue end,                              
                     validate = {"On", "Off"}
                  },
                  guild = {
                     name     = L["tools-busy-responder-guild-title"],
                     desc     = L["tools-busy-responder-guild-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-guild-usage"],
                     get      = function() return ConvergeFu.db.profile.responderGuild end,
                     set      = function(newValue) ConvergeFu.db.profile.responderGuild = newValue end,                              
                     validate = {"On", "Off"}
                  },
                  officer = {
                     name     = L["tools-busy-responder-officer-title"],
                     desc     = L["tools-busy-responder-officer-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-officer-usage"],
                     get      = function() return ConvergeFu.db.profile.responderOfficer end,
                     set      = function(newValue) ConvergeFu.db.profile.responderOfficer = newValue end,                              
                     validate = {"On", "Off"}
                  },  
                  party = {
                     name     = L["tools-busy-responder-party-title"],
                     desc     = L["tools-busy-responder-party-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-party-usage"],
                     get      = function() return ConvergeFu.db.profile.responderParty end,
                     set      = function(newValue) ConvergeFu.db.profile.responderParty = newValue end,                              
                     validate = {"On", "Off"}
                  },  
                  raid = {
                     name     = L["tools-busy-responder-raid-title"],
                     desc     = L["tools-busy-responder-raid-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-raid-usage"],
                     get      = function() return ConvergeFu.db.profile.responderRaid end,
                     set      = function(newValue) ConvergeFu.db.profile.responderRaid = newValue end,                              
                     validate = {"On", "Off"}
                  },
                  friend = {
                     name     = L["tools-busy-responder-friend-title"],
                     desc     = L["tools-busy-responder-friend-descr"],
                     type     = 'text',
                     usage    = L["tools-busy-responder-friend-usage"],
                     get      = function() return ConvergeFu.db.profile.responderFriend end,
                     set      = function(newValue) ConvergeFu.db.profile.responderFriend = newValue end,                              
                     validate = {"On", "Off"}
                  },                  
                  message = {
                     name  = L["tools-busy-responder-message-title"],
                     desc  = L["tools-busy-responder-message-descr"],
                     type  = 'text',
                     usage = L["tools-busy-responder-message-usage"],
                     get   = function() return ConvergeFu.db.profile.responderMessage end,
                     set   = function(newValue) ConvergeFu.db.profile.responderMessage = newValue end,                  
                  },
                  test = {
                     name = L["tools-busy-responder-test-title"],
                     desc = L["tools-busy-responder-test-descr"],
                     type = 'execute',
                     func = function() 
                        local testMessage = L["tools-busy-responder-message-first"]..ConvergeFu.db.profile.responderMessage
                        local playerName  = UnitName("player")
                        ConvergeFu:SendMessage(testMessage, "WHISPER", " ", playerName)
                     end
                  },                  
                  reset = {
                     name = L["tools-busy-responder-reset-title"],
                     desc = L["tools-busy-responder-reset-descr"],
                     type = 'execute',
                     func = function() 
                        ConvergeFu.db.profile.responderMessage = L["tools-busy-responder-message-stdrd"] 
                     end
                  }
               }
            },
            version = {
               name = L["tools-versioncheck-title"],
               desc = L["tools-versioncheck-descr"],
               type = 'group',
               args = {
                  run = {
                     name = L["tools-versioncheck-run-title"],
                     desc = L["tools-versioncheck-run-descr"],
                     type = 'execute',
                     func = function()
                        ConvergeFu:DoVersionCheck("GUILD")
                     end
                  },
                  display_chat = {
                     name     = L["tools-versioncheck-chat-title"],
                     desc     = L["tools-versioncheck-chat-descr"],
                     type     = 'text',
                     usage    = L["tools-versioncheck-chat-usage"],
                     get      = function() return ConvergeFu.db.profile.versionDispChat end,
                     set      = function(newValue) ConvergeFu.db.profile.versionDispChat = newValue end,                              
                     validate = {["0"]=L["tools-versioncheck-option-off"], ["1"] = L["tools-versioncheck-option-on"]} 
                  },
                  display_window = {
                     name     = L["tools-versioncheck-win-title"],
                     desc     = L["tools-versioncheck-win-descr"],
                     type     = 'text',
                     usage    = L["tools-versioncheck-win-usage"],
                     get      = function() return ConvergeFu.db.profile.versionDispWin end,
                     set      = function(newValue) ConvergeFu.db.profile.versionDispWin = newValue end,                              
                     validate = {["0"]=L["tools-versioncheck-option-off"], ["1"] = L["tools-versioncheck-option-on"]}
                  }
               }
            },            
            rank = {
               name = L["tools-rank-title"],
               desc = L["tools-rank-descr"],
               type = 'group',
               args = {
                  warning = {
                      name = "Warning - Under Development!",
                      desc = "These features are still under development and using them my mess up the guild's ranks. Therefore, please do not use them at this time.",
                      type = 'header',
                      order = 1,
                  },
                  officer = {
                      name = L["tools-rank-officer-title"],
                      desc = L["tools-rank-officer-descr"],
                      type = 'group',
                      args = {
                         listall = {
                            name = L["tools-rank-officer-listall-title"],
                            desc = L["tools-rank-officer-listall-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:ListAllOfficers("OFFICER")
                            end
                         },
                         matchalts = {
                            name = L["tools-rank-officer-matchalts-title"],
                            desc = L["tools-rank-officer-matchalts-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:SetAllAltCharacterRanks()
                            end                         
                         }
                      }
                  },
                  hero = {
                      name = L["tools-rank-hero-title"],
                      desc = L["tools-rank-hero-descr"],
                      type = 'group',
                      args = {
                         listall = {
                            name = L["tools-rank-hero-listall-title"],
                            desc = L["tools-rank-hero-listall-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:ListAllHeroes("OFFICER")
                            end
                         },
                         announce = {
                            name = L["tools-rank-hero-ann-changes-title"],
                            desc = L["tools-rank-hero-ann-changes-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:AnnounceRankChanges("GUILD")
                            end                         
                         },
                         demoteall = {
                            name = L["tools-rank-hero-demote-all-title"],
                            desc = L["tools-rank-hero-demote-all-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:DemoteAllHeroes()
                            end                         
                         },
                         matchalts = {
                            name = L["tools-rank-hero-matchalts-title"],
                            desc = L["tools-rank-hero-matchalts-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:SetAllAltCharacterRanks()
                            end                         
                         }                      
                      }                 
                  },
                  normal = {
                      name = L["tools-rank-normal-title"],
                      desc = L["tools-rank-normal-descr"],
                      type = 'group',
                      args = {
                         listall = {
                            name = L["tools-rank-normal-listall-title"],
                            desc = L["tools-rank-normal-listall-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:ListAllNormals("OFFICER")
                            end
                         },
                         matchalts = {
                            name = L["tools-rank-normal-matchalts-title"],
                            desc = L["tools-rank-normal-matchalts-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:SetAllAltCharacterRanks()
                            end                         
                         }                      
                      }                 
                  },
                  trial = {
                      name = L["tools-rank-trial-title"],
                      desc = L["tools-rank-trial-descr"],
                      type = 'group',
                      args = {
                         listall = {
                            name = L["tools-rank-trial-listall-title"],
                            desc = L["tools-rank-trial-listall-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:ListAllTrials("OFFICER")
                            end
                         },
                         matchalts = {
                            name = L["tools-rank-officer-matchalts-title"],
                            desc = L["tools-rank-officer-matchalts-descr"],
                            type = 'execute',
                            func = function()
                              ConvergeFu:SetAllAltCharacterRanks()
                            end                         
                         }                      
                      }                 
                  }
               }
            },
            cc = {
               name = L["tools-crowd-control-title"],
               desc = L["tools-crowd-control-descr"],
               type = 'group',
               args = {
                  header  = {
                    name  = " ",
                    type  = "header",
                    order = 9,
                  },               
                  announce = {
                    name = L["tools-crowd-control-announce-title"],
                    desc = L["tools-crowd-control-announce-descr"],
                    type = 'execute',
                    order = 100,
                    func = function()
                      ConvergeFu:AnnounceCrowdControlTargets(ConvergeFu.db.profile.ccChannel)
                    end
                  },
                  channel = {
                    name = L["tools-crowd-control-channel-title"],
                    desc = L["tools-crowd-control-channel-descr"],
                    type     = 'text',
                    order = 102,
                    usage    = L["tools-crowd-control-channel-usage"],
                    get      = function() return ConvergeFu.db.profile.ccChannel end,
                    set      = function(newValue) ConvergeFu.db.profile.ccChannel = newValue end,                              
                    validate = { ["RAID"] = "Raid", ["PARTY"] = "Party", ["OFFICER"] = "Officer", ["GUILD"] = "Guild", ["SAY"] = "Say", ["CHAT"] = "Chat"}
                  },
                  gui = {
                     name = L["tools-crowd-control-gui-title"],
                     desc = L["tools-crowd-control-gui-descr"],
                     type = 'execute',
                     order = 105,
                     func = function()
                        FuBar:OpenConfigMenu(self)
                     end
                  },
                  test = {
                     name = L["tools-crowd-control-test-title"],
                     desc = L["tools-crowd-control-test-descr"],
                     type = 'execute',
                     order = 104,
                     func = function()
                        ConvergeFu:AnnounceCrowdControlTargets("CHAT")
                     end
                  },                  
                  clearall = {
                    name = L["tools-crowd-control-clearall-title"],
                    desc = L["tools-crowd-control-clearall-descr"],
                    type = 'execute',
                    order = 103,
                    func = function()
                       ConvergeFu.db.profile.skullType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.skullName = L["tools-crowd-control-common-clear-name-default"]
                       ConvergeFu.db.profile.crossType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.crossName = L["tools-crowd-control-common-clear-name-default"]
                       ConvergeFu.db.profile.squareType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.squareName = L["tools-crowd-control-common-clear-name-default"]
                       ConvergeFu.db.profile.moonType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.moonName = L["tools-crowd-control-common-clear-name-default"]
                       ConvergeFu.db.profile.triangleType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.triangleName = L["tools-crowd-control-common-clear-name-default"]   
                       ConvergeFu.db.profile.diamondType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.diamondName = L["tools-crowd-control-common-clear-name-default"]   
                       ConvergeFu.db.profile.circleType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.circleName = L["tools-crowd-control-common-clear-name-default"]
                       ConvergeFu.db.profile.starType = L["tools-crowd-control-common-clear-type-default"]
                       ConvergeFu.db.profile.starName = L["tools-crowd-control-common-clear-name-default"]                                 
                    end,
                    order = 9
                  },                      
                  skull = {
                     name = L["tools-crowd-control-skull-title"],
                     desc = L["tools-crowd-control-skull-descr"],
                     type = 'group',
                     order = 1,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.skullType end,
                          set      = function(newValue) ConvergeFu.db.profile.skullType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.skullName end,
                          set   = function(newValue) ConvergeFu.db.profile.skullName = newValue end,                            
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.skullType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.skullName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       } 
                     }
                  },
                  cross = {
                     name = L["tools-crowd-control-cross-title"],
                     desc = L["tools-crowd-control-cross-descr"],
                     type = 'group',
                     order = 2,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.crossType end,
                          set      = function(newValue) ConvergeFu.db.profile.crossType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.crossName end,
                          set   = function(newValue) ConvergeFu.db.profile.crossName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.crossType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.crossName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  square = {
                     name = L["tools-crowd-control-square-title"],
                     desc = L["tools-crowd-control-square-descr"],
                     type = 'group',
                     order = 3,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.squareType end,
                          set      = function(newValue) ConvergeFu.db.profile.squareType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.squareName end,
                          set   = function(newValue) ConvergeFu.db.profile.squareName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.squareType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.squareName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  moon = {
                     name = L["tools-crowd-control-moon-title"],
                     desc = L["tools-crowd-control-moon-descr"],
                     type = 'group',
                     order = 4,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.moonType end,
                          set      = function(newValue) ConvergeFu.db.profile.moonType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.moonName end,
                          set   = function(newValue) ConvergeFu.db.profile.moonName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.moonType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.moonName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  triangle = {
                     name = L["tools-crowd-control-triangle-title"],
                     desc = L["tools-crowd-control-triangle-descr"],
                     type = 'group',
                     order = 5,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.triangleType end,
                          set      = function(newValue) ConvergeFu.db.profile.triangleType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.triangleName end,
                          set   = function(newValue) ConvergeFu.db.profile.triangleName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.triangleType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.triangleName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  diamond = {
                     name = L["tools-crowd-control-diamond-title"],
                     desc = L["tools-crowd-control-diamond-descr"],
                     type = 'group',
                     order = 6,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.diamondType end,
                          set      = function(newValue) ConvergeFu.db.profile.diamondType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.diamondName end,
                          set   = function(newValue) ConvergeFu.db.profile.diamondName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.diamondType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.diamondName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  circle = {
                     name = L["tools-crowd-control-circle-title"],
                     desc = L["tools-crowd-control-circle-descr"],
                     type = 'group',
                     order = 7,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.circleType end,
                          set      = function(newValue) ConvergeFu.db.profile.circleType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.circleName end,
                          set   = function(newValue) ConvergeFu.db.profile.circleName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.circleType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.circleName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  },
                  star = {
                     name = L["tools-crowd-control-star-title"],
                     desc = L["tools-crowd-control-star-descr"],
                     type = 'group',
                     order = 8,
                     args = {
                       type = {
                          name     = L["tools-crowd-control-common-type-title"],
                          desc     = L["tools-crowd-control-common-type-descr"],
                          type     = 'text',
                          usage    = L["tools-crowd-control-common-type-usage"],
                          get      = function() return ConvergeFu.db.profile.starType end,
                          set      = function(newValue) ConvergeFu.db.profile.starType = newValue end,                              
                          validate = {"None", "Sheep", "Banish", "Fear", "Seduce", "Enslave", "Shackle", "Mind Control", "Hibernate", "Trap", "Sap", "Turn Evil", "MT", "OT"}
                       },
                       name = {
                          name  = L["tools-crowd-control-common-name-title"],
                          desc  = L["tools-crowd-control-common-name-descr"],
                          type  = 'text',
                          usage = L["tools-crowd-control-common-name-usage"],
                          get   = function() return ConvergeFu.db.profile.starName end,
                          set   = function(newValue) ConvergeFu.db.profile.starName = newValue end,                           
                       },
                       clear = {
                          name  = L["tools-crowd-control-common-clear-title"],
                          desc  = L["tools-crowd-control-common-clear-descr"],
                          type  = 'execute',
                          func = function() 
                             ConvergeFu.db.profile.starType = L["tools-crowd-control-common-clear-type-default"]
                             ConvergeFu.db.profile.starName = L["tools-crowd-control-common-clear-name-default"]
                          end
                       }                          
                     }
                  }                                                                  
               }
            },
            search = {
              name = L["tools-searchtarget-title"],
              desc = L["tools-searchtarget-descr"],
              type = 'group',
              args = {
                set = {
                   name  = L["tools-searchtarget-set-title"],
                   desc  = L["tools-searchtarget-set-descr"],
                   type  = 'text',
                   usage = L["tools-searchtarget-set-usage"],
                   get   = function() return ConvergeFu.db.profile.searchTarget end,
                   set   = function(newValue) ConvergeFu.db.profile.searchTarget = newValue end,
                },
                findall = {
                   name = L["tools-searchtarget-findall-title"],
                   desc = L["tools-searchtarget-findall-descr"],
                   type = 'execute',
                   func = function()
                      ConvergeFu:ListAssociatedCharacters(ConvergeFu.db.profile.searchTarget,"Officer");
                   end
                },
                findonline = {
                   name = L["tools-searchtarget-findonline-title"],
                   desc = L["tools-searchtarget-findonline-descr"],
                   type = 'execute',
                   func = function()
                      SendChatMessage(ConvergeFu:FindPlayerByCharacterName(ConvergeFu.db.profile.searchTarget), "Officer")
                   end
                }
              }
            },
            misc = {
              name = L["tools-misc-title"],
              desc = L["tools-misc-descr"],
              type = 'group',
              args = {
                rogue_avoidance = {
                   name = L["tools-misc-rogueav-title"],
                   desc = L["tools-misc-rogueav-descr"],
                   type = 'execute',
                   func = function()
                      ConvergeFu:ShowAvoidanceForLevel70Rogues()   
                   end
                }
              }
            }
         }
      }
   } 
} 

ConvergeFu:RegisterChatCommand({"/confu"}, ConvergeFu.consoleOptions);
ConvergeFu.OnMenuRequest = ConvergeFu.consoleOptions; 

-- ============================================================================
-- == OnEnable()                                                             ==
-- ==                                                                        ==
-- == This function is part of the provided API.                             ==
-- ============================================================================

function ConvergeFu:OnEnable()

    self:RegisterEvent("ZONE_CHANGED")
    self:RegisterEvent("CHAT_MSG_WHISPER")
    self:RegisterEvent("CHAT_MSG_ADDON")
    
    ConvergeFu:DoUpToDateCheck("GUILD")
    ConvergeFu:RecruitCharacterCancel()

end 

-- ============================================================================
-- == ZONE_CHANGED()                                                         ==
-- ==                                                                        ==
-- == This function performs actions when the ZONE_CHANGED event is          ==
-- == triggered. It is triggered when the player's character changes zones.  ==
-- ============================================================================

function ConvergeFu:ZONE_CHANGED()

    if GetRealZoneText() == L["event-zone-change-instance-kara-name"] then
      self:Print(L["event-zone-change-instance-kara-emote"])
    end

    if GetRealZoneText() == L["event-zone-change-instance-gruul-name"] then
      self:Print(L["event-zone-change-instance-gruul-emote"])
    end
    
    if GetRealZoneText() == L["event-zone-change-instance-maggy-name"] then
      self:Print(L["event-zone-change-instance-maggy-emote"])
    end
    
    if GetRealZoneText() == L["event-zone-change-instance-ssc-name"] then
      self:Print(L["event-zone-change-instance-ssc-emote"])
    end
    
    if GetRealZoneText() == L["event-zone-change-instance-tk-name"] then
      self:Print(L["event-zone-change-instance-tk-emote"])
    end
    
    if GetRealZoneText() == L["event-zone-change-instance-mh-name"] then
      self:Print(L["event-zone-change-instance-mh-emote"])
    end
    
    if GetRealZoneText() == L["event-zone-change-instance-bt-name"] then
      self:Print(L["event-zone-change-instance-bt-emote"])
    end
    
end

-- ============================================================================
-- == CHAT_MSG_WHISPER(msg, sender)                                          ==
-- ==                                                                        ==
-- == This function performs actions when the CHAT_MSG_WHISPER event is      ==
-- == triggered. It is triggered when the player's character receives a      ==
-- == message via the whisper 'channel.'                                     ==
-- ============================================================================

function ConvergeFu:CHAT_MSG_WHISPER(msg, sender)
  
  local Args = self:GetArgs(msg, " ")
  -- if #(Args) < 1 then return; end

  -- == -----------------------------------------------------------------------
  -- == -- Check if the sender requested guild information.                  --
  -- == -----------------------------------------------------------------------
  if string.lower(Args[1]) == L["event-command-name-guildinfo"] then
    ConvergeFu:SendWhisperGuildInfo(sender)
    return
  end

  -- == -----------------------------------------------------------------------
  -- == -- Check if the sender issued a 'confu' command.                     --
  -- == -----------------------------------------------------------------------
  if string.lower(Args[1]) ~= L["event-command-name-confu"] then
    
    if ConvergeFu.db.profile.responderStatus == "On" then
      ConvergeFu:DoBusyResponder(sender, msg)
    end
    
    return;
  end

  -- == -----------------------------------------------------------------------
  -- == -- Process the 'confu' command.                                      --
  -- == -----------------------------------------------------------------------
  local command; if Args[2] then command = string.lower(Args[2]); end

  -- == -----------------------------------------------------------------------
  -- == -- Sender requested confu command help.                              --
  -- == -----------------------------------------------------------------------  
  if command == nil then
    ConvergeFu:SendWhisperCommandHelp(sender)
    return
  end
  
  -- == -----------------------------------------------------------------------
  -- == -- Sender requested cctargets info.                                  --
  -- == -----------------------------------------------------------------------  
  if command == "cctargets" then
    ConvergeFu:AnnounceCrowdControlTargets("WHISPER", sender)
    return
  end
  
  -- == -----------------------------------------------------------------------
  -- == -- If we haven't returned yet, command must have been unrecognised.  --
  -- == ----------------------------------------------------------------------- 
  ConvergeFu:SendMessage(L["event-command-unknown-01-msg"], "WHISPER", " ", sender)
  ConvergeFu:SendMessage(L["event-command-unknown-02-msg"], "WHISPER", " ", sender)
  
end

-- ============================================================================
-- == SendWhisperCommandHelp(recipient)                                      ==
-- ==                                                                        ==
-- == This function sends hints via whispers on the available whisper-based  ==
-- == commands currently recognised by ConvergeFu to the named recipient.    ==
-- ============================================================================

function ConvergeFu:SendWhisperCommandHelp(recipient)

   ConvergeFu:SendMessage(L["event-helpinfo-01-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-helpinfo-02-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-helpinfo-03-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-helpinfo-04-msg"], "WHISPER", " ", recipient)
   
end

-- ============================================================================
-- == SendWhisperGuildInfo(recipient)                                        ==
-- ==                                                                        ==
-- == This function sends a summary of guild information via the whisper     ==
-- == channel to the named recipient.                                        ==
-- ============================================================================

function ConvergeFu:SendWhisperGuildInfo(recipient)

   ConvergeFu:SendMessage(L["event-guildinfo2-01-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-guildinfo2-02-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-guildinfo2-03-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-guildinfo2-04-msg"], "WHISPER", " ", recipient)
   ConvergeFu:SendMessage(L["event-guildinfo2-05-msg"], "WHISPER", " ", recipient)
   
end

-- ============================================================================
-- == GetArgs(message, separator)                                            ==
-- ==                                                                        ==
-- == This function receives a string and converts it into a list of         ==
-- == arguments, using space as the separator character.                     ==
-- ============================================================================

function ConvergeFu:GetArgs(message, separator)
 
   if message == nil then
     message = ""
   end
   
   local args = {}
   local i = 0


   -- search for seperators in the string and return the separated data
   for value in string.gmatch(message, "[^"..separator.."]+") do
      i = i + 1
      args[i] = value
   end

   return args
   
end

-- ============================================================================
-- == DoBusyResponder(sender, msg)                                           ==
-- ==                                                                        ==
-- == This function aims to send a response to the 'sender' of the whispered ==
-- == message that was received. Before it sends the response however, it    ==
-- == first checks whether the sender is in one of several possible groups   ==
-- == that are currently excluded from receiving Responder messages.         ==
-- ==                                                                        ==
-- == Current flags the responder can be configured to notice:               ==
-- ==                                                                        ==
-- == If the sender is in our guild.                                         ==
-- == If the sender is an officer of our guild.                              ==
-- == If the sender is in our party.                                         ==
-- == If the sender is in our raid.                                          ==
-- == If the sender is on our friends-list.                                  ==
-- ==                                                                        ==
-- == Each of these options may be toggled by the user individually.         ==
-- ============================================================================

function ConvergeFu:DoBusyResponder(sender, msg)
  
   -- == ----------------------------------------------------------------------
   -- == Perform the guild-member exclusion check.                           --
   -- == ----------------------------------------------------------------------
   if  ConvergeFu:IsCharacterInGuild(sender)
   and ConvergeFu.db.profile.responderGuild == "Off" then
      return
   end

   -- == ----------------------------------------------------------------------
   -- == Perform the officer-member exclusion check.                         --
   -- == ----------------------------------------------------------------------
   if  ConvergeFu:IsCharacterInGuild(sender)
   and ConvergeFu:IsOfficerRankedCharacter(sender)
   and ConvergeFu.db.profile.responderOfficer == "Off" then
      return
   end
    
   -- == ----------------------------------------------------------------------
   -- == Perform the party-member exclusion check.                           --
   -- == ----------------------------------------------------------------------
   if  ConvergeFu:IsCharacterInParty(sender)
   and ConvergeFu.db.profile.responderParty == "Off" then
      return  
   end
  
   -- == ----------------------------------------------------------------------
   -- == Perform the raid-member exclusion check.                            --
   -- == ----------------------------------------------------------------------
   if  ConvergeFu:IsCharacterInRaid(sender)
   and ConvergeFu.db.profile.responderRaid == "Off" then
      return  
   end
  
   -- == ----------------------------------------------------------------------
   -- == Perform the friends-list exclusion check.                           --
   -- == ----------------------------------------------------------------------
   if  ConvergeFu:IsCharacterAFriend(sender)
   and ConvergeFu.db.profile.responderFriend == "Off" then
      return  
   end  
  
   -- == ----------------------------------------------------------------------
   -- == Perform the "responding to a [BusyResponder] message" check.        --
   -- == ----------------------------------------------------------------------
   local brMessageTest = string.find(msg, "BusyResponder")
   if brMessageTest then
     return
   end
  
   -- == ----------------------------------------------------------------------
   -- == Send the response message.                                          --
   -- == ----------------------------------------------------------------------
   messageText = L["tools-busy-responder-message-first"]..ConvergeFu.db.profile.responderMessage    
   ConvergeFu:SendMessage(messageText, "WHISPER", nil, sender)

end

-- ============================================================================
-- == ToggleBusyResponder()                                                  ==
-- ==                                                                        ==
-- == This function simply toggles the BusyResponder tool on or off and      ==
-- == reports the outcome of the 'toggle' to the chat window.                ==
-- ============================================================================

function ConvergeFu:ToggleBusyResponder()

  if ConvergeFu.db.profile.responderStatus == "On" then
    ConvergeFu.db.profile.responderStatus = "Off"
    statusMessage1 = L["tools-busy-responder-toggle-01-msg"]
                   ..ConvergeFu:ColourStatusOnOff("Off")
    self:Print(statusMessage1)
  else
    ConvergeFu.db.profile.responderStatus = "On"
    statusMessage1 = L["tools-busy-responder-toggle-01-msg"]
                   ..ConvergeFu:ColourStatusOnOff("On")
    statusMessage2 = L["tools-busy-responder-toggle-02-msg"]
                   ..L["tools-busy-responder-toggle-03-msg"]
                   ..ConvergeFu:ColourStatusOnOff(ConvergeFu.db.profile.responderGuild)
                   ..ConvergeFu:ColourTextWhite(L["tools-busy-responder-toggle-04-msg"])
                   ..ConvergeFu:ColourStatusOnOff(ConvergeFu.db.profile.responderOfficer)
                   ..ConvergeFu:ColourTextWhite(L["tools-busy-responder-toggle-05-msg"])
                   ..ConvergeFu:ColourStatusOnOff(ConvergeFu.db.profile.responderParty)
                   ..ConvergeFu:ColourTextWhite(L["tools-busy-responder-toggle-06-msg"])
                   ..ConvergeFu:ColourStatusOnOff(ConvergeFu.db.profile.responderRaid)
                   ..ConvergeFu:ColourTextWhite(L["tools-busy-responder-toggle-07-msg"])
                   ..ConvergeFu:ColourStatusOnOff(ConvergeFu.db.profile.responderFriend)
                   .."."
                   
    self:Print(statusMessage1)
    self:Print(statusMessage2)
  end
  
end

-- ============================================================================
-- == CHAT_MSG_ADDON(prefix, msg, channel, sender)                           ==
-- ==                                                                        ==
-- == This function performs actions when the CHAT_MSG_ADDON event is        ==
-- == triggered. It is triggered when the player's character receives a      ==
-- == message via the addon 'channel' that was introduced circa patch 1.12.  ==
-- ==                                                                        ==
-- == Currently, this event is monitored to permit communication between     ==
-- == instances of ConvergeFu being run by different players.                ==
-- ==                                                                        ==
-- == The following prefix codes will be intercepted by this function:       ==
-- ==                                                                        ==
-- == Prefix Code: CFUVCQ                                                    ==
-- == Description: ConvegeFu Version Check Query.                            ==
-- == Message fmt: "sender"                                                  ==
-- ==                                                                        ==
-- == Prefix Code: CFUVCR                                                    ==
-- == Description: ConvegeFu Version Check Response.                         ==
-- == Message fmt: "sender-version"                                          ==
-- ==                                                                        ==
-- ============================================================================

function ConvergeFu:CHAT_MSG_ADDON(prefix, msg, channel, sender)

  if prefix == L["event-addon-vc-query"] then
    ConvergeFu:DoProcessVersionCheckQuery(msg, channel, sender)
  end  

  if prefix == L["event-addon-vc-response"] then
    ConvergeFu:DoProcessVersionCheckResponse(msg, channel, sender)
  end 
end

-- ============================================================================
-- == DoProcessVersionCheckQuery(msg, channelName, sender)                   ==
-- ==                                                                        ==
-- == This function processes the inter-addon version check request event.   ==
-- == It constructs a response containing the version number of the instance ==
-- == of this addon being run by the user and sends the response out via the ==
-- == addon channel, using the same channel-focus as the receive message.    ==
-- ==                                                                        ==
-- == Message format: RECIPIENT-VERSIONSTRING                                ==
-- == RECIPIENT:      The person to whom this response is targeted.          ==
-- == VERSIONSTRING:  The version details for this instance of ConvergeFu.   ==
-- ==                 in "versionName:versionNumber" format.                 ==
-- ============================================================================

function ConvergeFu:DoProcessVersionCheckQuery(msg, channelName, sender)

   myName = UnitName("player")
   
   if myName == sender then
     return
   end
   
   messageText = sender.."-"..ConvergeFu.db.profile.versionString
   
   SendAddonMessage(L["event-addon-vc-response"], messageText, channelName)

end

-- ============================================================================
-- == DoProcessVersionCheckResponse(msg, channel, sender)                    ==
-- ==                                                                        ==
-- == This function processes the inter-addon version check response event.  ==
-- == It determines whether this is a response sent to the user and if it is ==
-- == it then displays that response in the user's chat window.              ==
-- ============================================================================

function ConvergeFu:DoProcessVersionCheckResponse(msg, channel, sender)

   myName = UnitName("player")
   
   -- == ----------------------------------------------------------------------
   -- == -- Decode the message text into its component parts.                --
   -- == ----------------------------------------------------------------------
   local Args               = self:GetArgs(msg, "-")
   local recipient          = Args[1]
   local versionInformation = Args[2]
   
   local Args               = self:GetArgs(versionInformation, ":")
   local versionName        = Args[1]
   local versionNumber      = Args[2]

   -- == ----------------------------------------------------------------------
   -- == -- Confirm whether we are expected to respond to this message.      --
   -- == ----------------------------------------------------------------------
   if myName ~= recipient then
      return
   end
   
   -- == ----------------------------------------------------------------------
   -- == -- Pre-colour the version number, w.r.t. this version.              --
   -- == ----------------------------------------------------------------------
   local colouredVersionNumber = ConvergeFu:ColourTextYellow(versionNumber)
   
   if versionNumber > L["versionNumber"] then
     colouredVersionNumber = ConvergeFu:ColourTextGreen(versionNumber)
   end
   
   if versionNumber < L["versionNumber"] then
     colouredVersionNumber = ConvergeFu:ColourTextRed(versionNumber)
   end
      
   -- == ----------------------------------------------------------------------
   -- == -- Configure the message strings to be used.                        --   
   -- == ----------------------------------------------------------------------
   messageText1 = ConvergeFu:ColourTextWhite(sender..": ")
                ..ConvergeFu:ColourTextBlizzard(versionName..": ")
                ..colouredVersionNumber

   versionText = ConvergeFu:ColourTextBlizzard(versionName..": ")
               ..colouredVersionNumber
               
   -- == ----------------------------------------------------------------------
   -- == -- Perform the response for a standard version-check.               --
   -- == ----------------------------------------------------------------------            
   if ConvergeFu.db.profile.versionQuiet == "0" then
     
     if ConvergeFu.db.profile.versionDispChat == "1" then
        self:Print(messageText1)
     end     
     
     if versionCheckFrameCreated == "0" then
        ConvergeFu:CreateVersionCheckFrame(sender, versionText)
     else
        versionCheckFrame:AddLine(sender, versionText)
     end
     
     if ConvergeFu.db.profile.versionDispWin == "1" then
        versionCheckFrame:Show()
     end
   end
   
   -- == ----------------------------------------------------------------------
   -- == -- Perform the response for an up-to-date version-check.            --
   -- == ----------------------------------------------------------------------
   if ConvergeFu.db.profile.versionQuiet == "1" then
     if versionNumber > L["versionNumber"] then

       messageText2 = ConvergeFu:ColourTextPurple("Newer version detected!")
       messageText3 = ConvergeFu:ColourTextWhite("Yours: ")
                    ..ConvergeFu:ColourTextBlizzard(L["versionName"]..": ")
                    ..ConvergeFu:ColourTextRed(L["versionNumber"])
       messageText4 = ConvergeFu:ColourTextWhite(sender.."'s: ")
                    ..ConvergeFu:ColourTextBlizzard(versionName..": ")
                    ..ConvergeFu:ColourTextGreen(versionNumber)
       
       self:Print(messageText2)
       self:Print(messageText3)
       self:Print(messageText4)
              
       ConvergeFu:CreateVersionCheckFrame(sender, versionText)
       versionCheckFrame:Show()
     end
   end
end

-- ============================================================================
-- == DoVersionCheck(channelName)                                            ==
-- ==                                                                        ==
-- == This function outputs an inter-addon message to trigger a version      ==
-- == check response from any other instances of ConvergeFu that are within  == 
-- == 'earshot', depending upon the channel on which the message is sent out ==
-- == on.                                                                    ==
-- ============================================================================

function ConvergeFu:DoVersionCheck(channelName)

   -- -------------------------------------------------------------------------
   -- -- Check if both output methods are switched off, such that the        --
   -- -- results of the version check could not be displayed.                --
   -- -------------------------------------------------------------------------
   if  ConvergeFu.db.profile.versionDispWin == "0"
   and ConvergeFu.db.profile.versionDispChat == "0" then
      self:Print(L["tools-versioncheck-muted-01-msg"])
   end

   local Args               = self:GetArgs(ConvergeFu.db.profile.versionString, ":")
   local versionName        = Args[1]
   local versionNumber      = Args[2]
   
   myName = UnitName("player")

   messageText = ConvergeFu:ColourTextWhite(myName..": ")
               ..ConvergeFu:ColourTextBlizzard(versionName..":")
               ..ConvergeFu:ColourTextYellow(versionNumber)

   if ConvergeFu.db.profile.versionDispChat == "1" then
      self:Print(L["common-separator-dashed-line"])
      self:Print(L["tools-versioncheck-msg-01"])
      self:Print(L["common-separator-dashed-line"])
      self:Print(messageText)
   end

   ConvergeFu.db.profile.versionQuiet = "0"
   
   SendAddonMessage(L["event-addon-vc-query"], myName, channelName)
   
   if versionCheckFrameCreated == "0" then
      ConvergeFu:CreateVersionCheckFrame(sender, versionText)
      versionCheckFrame:PrepareForVersionCheck()
   else
      versionCheckFrame:PrepareForVersionCheck()
   end
   
   if ConvergeFu.db.profile.versionDispWin == "1" then
     versionCheckFrame:Show()
   end
      
end

-- ============================================================================
-- == DoUpToDateCheck(channelName)                                           ==
-- ==                                                                        ==
-- == This function sends out a version check request at the noted level of  == 
-- == visibility and reports via chat-window messages if there is anyone     ==
-- == who responds that has a more recent copy of the addon.                 ==
-- ============================================================================

function ConvergeFu:DoUpToDateCheck(channelName)
   
   local Args               = self:GetArgs(ConvergeFu.db.profile.versionString, ":")
   local versionName        = Args[1]
   local versionNumber      = Args[2]
   
   myName = UnitName("player")

   messageText = ConvergeFu:ColourTextWhite(myName..": ")
               ..ConvergeFu:ColourTextBlizzard(versionName..":")
               ..ConvergeFu:ColourTextYellow(versionNumber)

   if ConvergeFu.db.profile.versionDispChat == "1" then
      self:Print(L["common-separator-dashed-line"])
      self:Print(L["tools-versioncheck-msg-01"])
      self:Print(L["common-separator-dashed-line"])
      self:Print(messageText)
   end

   ConvergeFu.db.profile.versionQuiet = "1"
   
   SendAddonMessage(L["event-addon-vc-query"], messageText, channelName)
      
end

-- ============================================================================
-- == OnTextUpdate()                                                         ==
-- ==                                                                        ==
-- == This function is part of the provided API.                             ==
-- ============================================================================

function ConvergeFu:OnTextUpdate() 
   if (self:IsTextShown()) then 
      self:ShowText(); 
      self:SetText(ConvergeFu:ColourTextWhite(L["labelName"]).."|r"); 
   else 
      self:HideText(); 
   end 
end 

-- ============================================================================
-- == OnTooltipUpdate()                                                      ==
-- ==                                                                        ==
-- == This function is part of the provided API. It is called when the user  ==
-- == action requires the tooltip to be displayed.                           ==
-- ============================================================================

function ConvergeFu:OnTooltipUpdate() 

   cat = Tablet:AddCategory(
     'columns', 1,
     'text', L["tablet-cat-01-title"],
     'textR', 1, 'textG', 1, 'textB', 0
   )
   cat:AddLine('text', L["tablet-cat-01-line-01"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-02"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-03"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-04"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-05"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-06"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-07"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-08"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-09"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-10"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-01-line-11"], 'textR', 1, 'textG', 1, 'textB', 1)
   
   cat = Tablet:AddCategory(
     'columns', 1,
     'text', L["tablet-cat-02-title"],
     'textR', 1, 'textG', 1, 'textB', 0
   )  
   cat:AddLine('text', L["tablet-cat-02-line-01"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-02-line-02"]..ConvergeFu:GetNumberOfGuildOfficers()..L["tablet-cat-02-line-03"], 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-02-line-04"], 'textR', 1, 'textG', 1, 'textB', 1)
   
   ConvergeFu:GetGuildOfficerNamesForTooltip(cat)
   
   cat = Tablet:AddCategory(
     'columns', 1,
     'text', L["tablet-cat-03-title"],
     'textR', 1, 'textG', 1, 'textB', 0
   )    
   cat:AddLine('text', L["tablet-cat-03-line-01"]..UnitName("player"), 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-03-line-02"]..ConvergeFu:GetGuildName(), 'textR', 1, 'textG', 1, 'textB', 1)
   cat:AddLine('text', L["tablet-cat-03-line-03"]..ConvergeFu:GetGuildRankName(), 'textR', 1, 'textG', 1, 'textB', 1)
      
   Tablet:SetHint(L["tabletHint"]); 
end 

-- ============================================================================
-- == OnClick()                                                              ==
-- ==                                                                        ==
-- == This function is part of the provided API. It is called when the user  ==
-- == clicks on the addon's icon.                                            ==
-- ==                                                                        ==
-- == <click>           : Toggle RaidBuffStatus Dashboard.                   ==
-- == <alt><click>      : Generate a RaidBuffStatus report.                  ==
-- == <ctrl><click>     : Toggle the BusyResponder tool on/off.              ==
-- == <ctrl><alt><click : <currently nothing>                                ==
-- ============================================================================

function ConvergeFu:OnClick()
  if IsAltKeyDown() and IsControlKeyDown() then
    -- Do nothing.
  elseif IsAltKeyDown() then
    ConvergeFu:ExecuteChatCommand("/rbs report")
    return
  elseif IsControlKeyDown() then
    ConvergeFu:ToggleBusyResponder()
    return
  end
  ConvergeFu:ExecuteChatCommand("/rbs toggle")  
end

-- ============================================================================
-- == ExecuteChatCommand(arg)                                                ==
-- ==                                                                        ==
-- == This function attempts to execute the supplied argument as though it   ==
-- == were a command entered by the user in the chat window.                 ==
-- ============================================================================

function ConvergeFu:ExecuteChatCommand(arg)
  if( not DEFAULT_CHAT_FRAME ) then return end
  DEFAULT_CHAT_FRAME.editBox:SetText(arg);
  ChatEdit_SendText(DEFAULT_CHAT_FRAME.editBox);
end

-- ============================================================================
-- == GetGuildName()                                                         ==
-- ==                                                                        ==
-- == This function retrieves the Guild name of the user, if they are in a   ==
-- == guild, otherwise it returns "Unguilded".                               ==
-- ============================================================================

function ConvergeFu:GetGuildName()
  if IsInGuild() then
    local guildName, guildRankName, guildRankIndex = GetGuildInfo("player")
    return guildName 
  else
    return L["common-guildname-unguilded"]
  end
end

-- ============================================================================
-- == GetGuildRankName()                                                     ==
-- ==                                                                        ==
-- == This function retrieves the rank name of the user, if they are in a    ==
-- == guild, otherwise it returns "Unranked".                                ==
-- ============================================================================
 
function ConvergeFu:GetGuildRankName()
  if IsInGuild() then
    local guildName, guildRankName, guildRankIndex = GetGuildInfo("player")
    return guildRankName  
  else
    return L["common-rankname-unguilded"]
  end
end 

-- ============================================================================
-- == GetNumberOfGuildOfficers()                                             ==
-- ==                                                                        ==
-- == This function looks for characters holding the Officer rank and then   ==
-- == simply performs a count to determine how many such characters there    ==
-- == are.                                                                   ==
-- ============================================================================

function ConvergeFu:GetNumberOfGuildOfficers()
  local numOfficers = 0
  if IsInGuild() then
    for index = 1, (GetNumGuildMembers(true)) do
      name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
      if rank == L["common-rankname-officer"] or rank == L["common-rankname-gm"] or rankIndex == 0 or rankIndex == 1 then
        numOfficers = numOfficers + 1
      end
    end
  end
  return numOfficers
end

-- ============================================================================
-- == GetGuildOfficerNamesForTooltip(cat)                                    ==
-- ==                                                                        ==
-- == This function looks for characters holding the Officer rank and then   ==
-- == adds a line to the provided "Category" object, which simply contains   ==
-- == that officer's name.                                                   ==
-- ============================================================================

function ConvergeFu:GetGuildOfficerNamesForTooltip(cat)
  if IsInGuild() then
    for index = 1, (GetNumGuildMembers(true)) do
      name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
      if rank == L["common-rankname-officer"] or rank == L["common-rankname-gm"] or rankIndex == 0 or rankIndex == 1 then
        cat:AddLine('text', ConvergeFu:FindPlayerByCharacterName(name), 'textR', 1, 'textG', 0, 'textB', 1)
      end
    end 
  end
end

-- ============================================================================
-- == FindPlayerByCharacterName(mainCharacterName)                           ==
-- ==                                                                        ==
-- == This function takes a character name as input and searchs through the  ==
-- == guild's roster, looking to find if the player that owns that character ==
-- == is currently online, either on the character named or on an alt        ==
-- == character associated with the character named.                         ==
-- ==                                                                        ==
-- == This assumes that for a given main character, all associated alt       ==
-- == characters will have the main character's name in the public note      ==
-- == field.                                                                 ==
-- ============================================================================

function ConvergeFu:FindPlayerByCharacterName(characterName)

  characterNameToReturn = characterName.." (Offline)"
  
  totalNumberOfGuildMembers = GetNumGuildMembers(true)
  
  for index=1, totalNumberOfGuildMembers, 1 do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index)
    if name == characterName and online == 1 then
      characterNameToReturn = characterName
    elseif note == characterName and online == 1 then
      characterNameToReturn = name.." (aka: "..characterName..")"
    end
  end
  
  return characterNameToReturn

end

-- ============================================================================
-- == ListAssociatedCharacters(characterName)                                ==
-- ==                                                                        ==
-- == This function outputs a list of characters associated with a single    ==
-- == player. It takes as input the name of any character associated with    ==
-- == the player who is on the guild roster and it then searches the roster  ==
-- == to find the main and alt characters belonging to the same player.      ==
-- ============================================================================

function ConvergeFu:ListAssociatedCharacters(characterName,channelName)

  strMainCharName = characterName;
  
  if ConvergeFu:IsAltRankedCharacter(characterName) then
    for index = 1, (GetNumGuildMembers(true)) do
      name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
      if name == characterName then
        strMainCharName = note
      end
    end
  end

  SendChatMessage("Main: "..strMainCharName, channelName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if string.match (note, strMainCharName) ~= nil then
      SendChatMessage("Alt : "..name, channelName)
    end
  end  
end

-- ============================================================================
-- == ListAllOfficers()                                                      ==
-- ==                                                                        ==
-- == This function iterates through the roster and lists all characters     ==
-- == holding the "Guild Master" or "Officer" rank.                          ==
-- ============================================================================

function ConvergeFu:ListAllOfficers(channelName)

  SendChatMessage(L["common-separator-dashed-line"], channelName)
  SendChatMessage(L["tools-rank-officer-listall-01-msg"], channelName)
  SendChatMessage(L["common-separator-dashed-line"], channelName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if    rank == L["common-rankname-gm"]
       or rank == L["common-rankname-officer"] then
      SendChatMessage(" "..name, channelName)
    end
  end
  
  SendChatMessage(L["common-separator-dashed-line"], channelName)
end

-- ============================================================================
-- == ListAllHeroes()                                                        ==
-- ==                                                                        ==
-- == This function iterates through the roster and lists all characters     ==
-- == holding the "Hero Member" rank.                                        ==
-- ============================================================================

function ConvergeFu:ListAllHeroes(channelName)

  SendChatMessage(L["common-separator-dashed-line"], channelName)
  SendChatMessage(L["tools-rank-hero-listall-01-msg"], channelName)
  SendChatMessage(L["common-separator-dashed-line"], channelName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if rank == L["common-rankname-member-hero"] then
      SendChatMessage(" "..name, channelName)
    end
  end
  
  SendChatMessage(L["common-separator-dashed-line"], channelName)
end

-- ============================================================================
-- == ListAllNormals()                                                       ==
-- ==                                                                        ==
-- == This function iterates through the roster and lists all characters     ==
-- == holding the "Normal Member" rank.                                      ==
-- ============================================================================

function ConvergeFu:ListAllNormals(channelName)

  SendChatMessage(L["common-separator-dashed-line"], channelName)
  SendChatMessage(L["tools-rank-normal-listall-01-msg"], channelName)
  SendChatMessage(L["common-separator-dashed-line"], channelName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if rank == L["common-rankname-member-normal"] then
      SendChatMessage(" "..name, channelName)
    end
  end
  
  SendChatMessage(L["common-separator-dashed-line"], channelName)
end

-- ============================================================================
-- == ListAllTrials()                                                        ==
-- ==                                                                        ==
-- == This function iterates through the roster and lists all characters     ==
-- == holding the "Trial Member" rank.                                       ==
-- ============================================================================

function ConvergeFu:ListAllTrials(channelName)

  SendChatMessage(L["common-separator-dashed-line"], channelName)
  SendChatMessage(L["tools-rank-trial-listall-01-msg"], channelName)
  SendChatMessage(L["common-separator-dashed-line"], channelName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if rank == L["common-rankname-member-trial"] then
      SendChatMessage(" "..name, channelName)
    end
  end
  
  SendChatMessage(L["common-separator-dashed-line"], channelName)
end

-- ============================================================================
-- == DemoteAllHeroes()                                                      ==
-- ==                                                                        ==
-- == This function iterates through the roster and demotes all characters   ==
-- == holding either the "Hero Member" or "Alt-Hero" ranks in preparation    ==
-- == for the month-end changes.                                             ==
-- ==                                                                        ==
-- == It is assumed that the normal member and alt ranks lie one level below ==
-- == the hero versions respectively.                                        ==
-- ============================================================================

function ConvergeFu:DemoteAllHeroes()

  self:Print("DemoteAllHeroes() starting...")
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if rank == L["common-rankname-member-hero"] then
      self:Print("Attempting to demote Hero member: "..name)
      GuildDemote(name)
    end  
    
    if rank == L["common-rankname-alt-hero"] then
      self:Print("Attempting to demote Alt-Hero member: "..name)
      GuildDemote(name)
    end
    
  end
end

-- ============================================================================
-- == PromoteAltsOfHeroes()                                                  ==
-- ==                                                                        ==
-- == This function iterates through the roster and promotes all characters  ==
-- == holding the "Alt-Normal" rank that belong to main characters holding   ==
-- == the "Hero Member" rank.                                                ==
-- ==                                                                        ==
-- == It is assumed that the normal member and alt ranks lie one level below ==
-- == the hero versions respectively.                                        ==
-- ============================================================================

function ConvergeFu:PromoteAltsOfHeroes()
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if rank == L["common-rankname-member-hero"] then
      for index2 = 1, (GetNumGuildMembers(true)) do
        name2, rank2, rankIndex2, level2, class2, zone2, note2, officernote2, online2, status2 = GetGuildRosterInfo(index2);
        
        if note2 == name then
          if rank2 == L["common-rankname-alt-normal"] then
            GuildPromote(name2)
          end
        end
      end
    end
  end
end

-- ============================================================================
-- == SetCharacterRank(characterName, targetRankName, channelName)           ==
-- ==                                                                        ==
-- == This function sets the rank of a named character to a selected rank    ==
-- == by first demoting it all the way down to the lowest guild rank before  ==
-- == promoting it iteratively back up to the desired rank.                  ==
-- ==                                                                        ==
-- == This function assumes that the 'benched' rank is the lowest rank. The  ==
-- == channelName is simply used for directing update messages.              ==
-- ============================================================================

function ConvergeFu:SetCharacterRank(characterName, targetRankName, channelName)
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
    if name == characterName then
      if rank ~= targetRankName then

        messageText = L["common-setrank-msg-01"]
                   .. characterName
                   .. L["common-setrank-msg-02"]
                   .. rank
                   .. L["common-setrank-msg-03"] 
                   .. targetRankName
                   .. L["common-setrank-msg-04"]
                   
        self:Print(messageText)
        
        repeat
          name2, rank2, rankIndex2, level2, class2, zone2, note2, officernote2, online2, status2 = GetGuildRosterInfo(index);
          SendChatMessage(characterName .. ", rank: " .. rank2 .. ", target: " .. targetRank .. ", Demoting...", "OFFICER")
          GuildDemote(name)
          name2, rank2, rankIndex2, level2, class2, zone2, note2, officernote2, online2, status2 = GetGuildRosterInfo(index);
        until rank2 == L["common-rankname-benched"]

        repeat
          name3, rank3, rankIndex3, level3, class3, zone3, note3, officernote3, online3, status3 = GetGuildRosterInfo(index);
          SendChatMessage(characterName .. ", rank: " .. rank2 .. ", target: " .. targetRank .. ", Promoting...", "OFFICER")
          GuildPromote(name)
          name3, rank3, rankIndex3, level3, class3, zone3, note3, officernote3, online3, status3 = GetGuildRosterInfo(index);
        until rank3 == targetRankName

      end
    end
  end
end

-- ============================================================================
-- == GetCharacterRank(characterName)                                        ==
-- ==                                                                        ==
-- == This function gets the rank of a named character.                      ==
-- ============================================================================

function ConvergeFu:GetCharacterRank(characterName)
  characterRank = L["common-rankname-benched"]

  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
    if name == characterName then
      characterRank = rank
    end
  end  
  
  return characterRank
end

-- ============================================================================
-- == GetCorrespondingAltRank(rankName)                                      ==
-- ==                                                                        ==
-- == This function gets the name of the alt rank that corresponds to the    ==
-- == supplied rank name, which is assumed to be the rank of a 'main'        ==
-- == character. If it cannot find the corresponding rank, it returns the    ==
-- == name of the lowest guild rank (the 'benched' rank typically) instead.  ==
-- ============================================================================

function ConvergeFu:GetCorrespondingAltRank(rankName)
  correspondingAltRank = L["common-rankname-benched"] 

  if rankName == L["common-rankname-gm"] then
    correspondingAltRank = L["common-rankname-alt-officer"]
    
  elseif rankName == L["common-rankname-officer"] then
    correspondingAltRank = L["common-rankname-alt-officer"]
    
  elseif rankName == L["common-rankname-member-hero"] then
    correspondingAltRank = L["common-rankname-alt-hero"]
    
  elseif rankName == L["common-rankname-member-normal"] then
    correspondingAltRank = L["common-rankname-alt-normal"]
    
  elseif rankName == L["common-rankname-member-trial"] then
    correspondingAltRank = L["common-rankname-alt-trial"]
  end
  
  return correspondingAltRank
end

-- ============================================================================
-- == IsMainRankedCharacter(characterName)                                   ==
-- ==                                                                        ==
-- == This function determines whether the named character is 'main' ranked  ==
-- == character and returns true if it is, otherwise it returns false.       ==
-- ==                                                                        ==
-- == A specific set of main-class ranks are assumed due to there being      ==
-- == no exacting method to check for "main status" in the provided API      ==
-- == from Blizzard, presumably because the concept of "main status" is not  ==
-- == fixed.                                                                 ==
-- ============================================================================

function ConvergeFu:IsMainRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-gm"]
         or rank == L["common-rankname-officer"]
         or rank == L["common-rankname-member-hero"]
         or rank == L["common-rankname-member-normal"]
         or rank == L["common-rankname-member-trial"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsAltRankedCharacter(characterName)                                    ==
-- ==                                                                        ==
-- == This function determines whether the named character is an 'alt'       ==
-- == ranked character and returns true if it is, otherwise it returns false.==
-- ==                                                                        ==
-- == A specific set of alt-class ranks are assumed due to there being       ==
-- == no exacting method to check for "alt status" in the provided API       ==
-- == from Blizzard, presumably because the concept of "alt status" is not   ==
-- == fixed.                                                                 ==
-- ============================================================================

function ConvergeFu:IsAltRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-alt-officer"]
         or rank == L["common-rankname-alt-hero"]
         or rank == L["common-rankname-alt-normal"]
         or rank == L["common-rankname-alt-trial"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsOfficerRankedCharacter(characterName)                                ==
-- ==                                                                        ==
-- == This function determines whether the named character is an 'officer'   ==
-- == ranked character and returns true if it is, otherwise it returns false.==
-- ==                                                                        ==
-- == A specific set of officer-class ranks are assumed due to there being   ==
-- == no exacting method to check for "officer status" in the provided API   ==
-- == from Blizzard, presumably because the concept of "officer status" is   ==
-- == not fixed.                                                             ==
-- ============================================================================

function ConvergeFu:IsOfficerRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-gm"]
         or rank == L["common-rankname-officer"]
         or rank == L["common-rankname-alt-officer"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsHeroRankedCharacter(characterName)                                   ==
-- ==                                                                        ==
-- == This function determines whether the named character is a 'hero'       ==
-- == ranked character and returns true if it is, otherwise it returns false.==
-- ==                                                                        ==
-- == A specific set of hero-class ranks are assumed due to there being      ==
-- == no exacting method to check for "hero status" in the provided API      ==
-- == from Blizzard, presumably because the concept of "alt status" is not   ==
-- == fixed.                                                                 ==
-- ============================================================================

function ConvergeFu:IsHeroRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-member-hero"]
         or rank == L["common-rankname-alt-hero"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsNormalRankedCharacter(characterName)                                 ==
-- ==                                                                        ==
-- == This function determines whether the named character is a 'normal'     ==
-- == ranked character and returns true if it is, otherwise it returns false.==
-- ==                                                                        ==
-- == A specific set of normal-class ranks are assumed due to there being    ==
-- == no exacting method to check for "normal status" in the provided API    ==
-- == from Blizzard, presumably because the concept of "alt status" is not   ==
-- == fixed.                                                                 ==
-- ============================================================================

function ConvergeFu:IsNormalRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-member-normal"]
         or rank == L["common-rankname-alt-normal"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsTrialRankedCharacter(characterName)                                  ==
-- ==                                                                        ==
-- == This function determines whether the named character is a 'trial'      ==
-- == ranked character and returns true if it is, otherwise it returns false.==
-- ==                                                                        ==
-- == A specific set of trial-class ranks are assumed due to there being     ==
-- == no exacting method to check for "trial status" in the provided API     ==
-- == from Blizzard, presumably because the concept of "alt status" is not   ==
-- == fixed.                                                                 ==
-- ============================================================================

function ConvergeFu:IsTrialRankedCharacter(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      if    rank == L["common-rankname-member-trial"]
         or rank == L["common-rankname-alt-trial"] then
        return true
      end
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsCharacterInGuild(characterName)                                      ==
-- ==                                                                        ==
-- == This function determines whether the named character is in the same    ==
-- == guild as the person running ConvergeFu.                                ==
-- ============================================================================

function ConvergeFu:IsCharacterInGuild(characterName)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    if name == characterName then
      return true
    end
  end   
  
  return false  
end

-- ============================================================================
-- == IsCharacterInParty(characterName)                                      ==
-- ==                                                                        ==
-- == This function determines whether the named character is in the same    ==
-- == party as the person running ConvergeFu.                                ==
-- ============================================================================

function ConvergeFu:IsCharacterInParty(characterName)
  
  if UnitInParty(characterName) then
     return true
  end
  
  return false  
end

-- ============================================================================
-- == IsCharacterInRaid(characterName)                                       ==
-- ==                                                                        ==
-- == This function determines whether the named character is in the same    ==
-- == raid as the person running ConvergeFu.                                 ==
-- ============================================================================

function ConvergeFu:IsCharacterInRaid(characterName)
  
  if UnitInRaid(characterName) then
     return true
  end
  
  return false  
end

-- ============================================================================
-- == IsCharacterAFriend(characterName)                                      ==
-- ==                                                                        ==
-- == This function determines whether the named character is a friend of    ==
-- == the person running ConvergeFu.                                         ==
-- ============================================================================

function ConvergeFu:IsCharacterAFriend(characterName)
  
  local numFriends = GetNumFriends()
  local name, level, class, zone, online, status, note
  
  for i = 1, numFriends, 1 do
    name, level, class, zone, online, status, note = GetFriendInfo(i)
    if online then
      if name == characterName then
        return true
      end
    end
  end 
  
  return false  
end

-- ============================================================================
-- == SetAllAltCharacterRanks()                                              ==
-- ==                                                                        ==
-- == This function attempts to set the rank of all alt characters correctly ==
-- == to the alt-rank corresponding to the rank of the main character with   ==
-- == which they are associated.                                             ==
-- ============================================================================

function ConvergeFu:SetAllAltCharacterRanks()

  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);

    if ConvergeFu:IsAltRankedCharacter(name) then
      
      self:Print(name .. " IS an alt-ranked character")
      mainCharacterRank = ConvergeFu:GetCharacterRank(note)
      self:Print("MainCharacterRank is " .. mainCharacterRank)
      altCharacterRank  = ConvergeFu:GetCorrespondingAltRank(mainCharacterRank)
      self:Print(altCharacterRank .. " is the correct rank.")
      
      if rank ~= altCharacterRank then
          self:Print("Attempting to set rank of "..name.." to correct "..altCharacterRank.."...")
        ConvergeFu:SetCharacterRank(name, altCharacterRank, "Officer")    
      end
    end
  end   
end

-- ============================================================================
-- == SendChatMessage(messageText, channelName)                              ==
-- ==                                                                        ==
-- == This function is ostensibly a simpler wrapper to the more featureful   ==
-- == SendMessage function, this version ignores the language and recipient  ==
-- == parameters.
-- ============================================================================

function ConvergeFu:SendChatMessage(messageText, channelName)
   ConvergeFu:SendMessage(messageText, channelName, " ", " ")
end

-- ============================================================================
-- == ConvergeFu:SendMessage(messageText, channelName, language, recipient)  ==
-- ==                                                                        ==
-- == This function is ostensibly a wrapper to the normal SendChatMessage    ==
-- == function with minor changes as follows:                                ==
-- ==                                                                        ==
-- == 1: Language is checked because it may not be passed in.                ==
-- == 2: If channelName = "CHAT", output is routed to self:Print() instead.  ==
-- == 3: If channelName = "NULL", output is muted.                           ==
-- ==                                                                        ==
-- == The intention for the existence of the NULL option for the channel     ==
-- == name is to allow for functions to pass a parameter that can be         ==
-- == switched between a normal channel and null to turn on/off debug mode   ==
-- == features.                                                              ==
-- ============================================================================

function ConvergeFu:SendMessage(messageText, channelName, language, recipient)
  
  -- == -----------------------------------------------------------------------
  -- == -- Check whether the language option has been provided.              --
  -- == -----------------------------------------------------------------------
  if language == nil or language == " " then
    language = nil
  end
  
  -- == -----------------------------------------------------------------------
  -- == -- Send chat output to 'chat' or to intended channel if not 'NULL'.  --
  -- == -----------------------------------------------------------------------  
  if channelName == "CHAT" then
    self:Print(messageText)
  elseif channelName ~= "NULL" then
    SendChatMessage(messageText, channelName, language, recipient)
  end
  
end

-- ============================================================================
-- == ShowAvoidanceForLevel70Rogues()                                        ==
-- ==                                                                        ==
-- == Simply outputs some text to the default chat frame listing the         ==
-- == player's current 'avoidance' level. This version is configured for use ==
-- == by rogues and will not produce accurate values for other classes.      ==
-- ============================================================================

function ConvergeFu:ShowAvoidanceForLevel70Rogues()

  DEFAULT_CHAT_FRAME:AddMessage(L["tools-misc-rogueav-01-msg"],0.8,0.8,1)
  DEFAULT_CHAT_FRAME:AddMessage(GetDodgeChance()+GetParryChance()+12+(GetCombatRating(CR_DEFENSE_SKILL)*150/355)*0.04,1,0.5,0)

end

-- ============================================================================
-- == AnnounceRankChanges(channelName)                                       ==
-- ==                                                                        ==
-- == This function outputs an announcement in the channel specified by the  ==
-- == channelName parameter (typically "Guild") to inform players that the   ==
-- == month end processing to update the players that are awarded the hero   ==
-- == status is about to begin.                                              ==
-- ============================================================================

function ConvergeFu:AnnounceRankChanges(channelName)
  SendChatMessage(L["common-rankchange-announce-01-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-02-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-03-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-04-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-05-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-06-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-07-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-08-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-09-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-10-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-11-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-12-msg"], channelName)
  SendChatMessage(L["common-rankchange-announce-13-msg"], channelName)
end

-- ============================================================================
-- == AnnounceRaidInvite(officerName,channelName)                            ==
-- ==                                                                        ==
-- == This function outputs an announcement in the channel specified by the  ==
-- == channelName parameter (typically "Guild") to inform players that the   ==
-- == invitation period for the next raid has begun and that players should  ==
-- == whisper the officer indicated to get an invitation to the raid.        ==
-- ============================================================================

function ConvergeFu:AnnounceRaidInvite(officerName,channelName)

  strOfficerName = ConvergeFu:FindPlayerByCharacterName(officerName)
  
  strGMOTD = L["common-motd-raidinvites-01"]
          .. strOfficerName
          .. L["common-motd-raidinvites-02"]
          
  GuildSetMOTD(strGMOTD)
  
  SendChatMessage(L["ann-guild-raid-invite-01-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-02-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-03-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-04-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-05-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-06-msg"], channelName)
          
  SendChatMessage(" "..strOfficerName, channelName)

  SendChatMessage(L["ann-guild-raid-invite-07-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-08-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-09-msg"], channelName)
  SendChatMessage(L["ann-guild-raid-invite-10-msg"], channelName)
end

-- ============================================================================
-- == AnnounceWaitList(officerName,channelName)                              ==
-- ==                                                                        ==
-- == This function outputs an announcement in the channel specified by the  ==
-- == channelName parameter (typically "Guild") to inform players that the   ==
-- == invitation period for the next raid has closed but that the wait list  ==
-- == is now open and that they should whisper a named officer if they wish  ==
-- == to join the raid's wait list (queue).                                  ==
-- ============================================================================

function ConvergeFu:AnnounceWaitList(officerName,channelName)
  
  strOfficerName = ConvergeFu:FindPlayerByCharacterName(officerName)
  
  strGMOTD = L["common-motd-raidinprogress-01"]
          .. strOfficerName
          .. L["common-motd-raidinprogress-02"]
          
  GuildSetMOTD(strGMOTD)
  
  SendChatMessage(L["ann-guild-wait-list-01-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-02-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-03-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-04-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-05-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-06-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-07-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-08-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-09-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-10-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-11-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-12-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-13-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-14-msg"], channelName)
  
  SendChatMessage(" "..strOfficerName, channelName)
  
  SendChatMessage(L["ann-guild-wait-list-15-msg"], channelName)
  SendChatMessage(L["ann-guild-wait-list-16-msg"], channelName)
end

-- ============================================================================
-- == AnnounceRaidEnd(channelName)                                           ==
-- ==                                                                        ==
-- == This function outputs an announcement in the channel specified by the  ==
-- == channelName parameter (typically "RAID") to inform players that the    ==
-- == raid has now ended.                                                    ==
-- ============================================================================

function ConvergeFu:AnnounceRaidEnd(channelName)
  
  strGMOTD = L["common-motd-raidended-01"]
          
  GuildSetMOTD(strGMOTD)
  
  SendChatMessage(L["ann-raid-raid-end-02-msg"], "RAID_WARNING")
  SendChatMessage(L["ann-raid-raid-end-04-msg"], "RAID_WARNING")
  SendChatMessage(L["ann-raid-raid-end-10-msg"], "RAID_WARNING")
  SendChatMessage(L["ann-raid-raid-end-12-msg"], "RAID_WARNING")

  SendChatMessage(L["ann-raid-raid-end-01-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-02-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-03-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-04-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-05-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-06-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-07-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-08-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-09-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-10-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-11-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-12-msg"], channelName)
  SendChatMessage(L["ann-raid-raid-end-13-msg"], channelName)

end

-- ============================================================================
-- == AnnounceCrowdControlTargets(channelName, sender)                       ==
-- ==                                                                        ==
-- == This function outputs an announcement in the channel specified by the  ==
-- == channelName parameter (typically "RAID") to inform players of the      ==
-- == crowd control target responsibilities that have been setup.            ==
-- ============================================================================

function ConvergeFu:AnnounceCrowdControlTargets(channelName, sender)

  countNumberSetup = 0
  
  ConvergeFu:SendMessage(L["tools-crowd-control-announce-01-msg"], channelName, nil, sender)
  ConvergeFu:SendMessage(L["tools-crowd-control-announce-02-msg"], channelName, nil, sender)
  ConvergeFu:SendMessage(L["tools-crowd-control-announce-03-msg"], channelName, nil, sender)
  
  if ConvergeFu.db.profile.skullType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-04-msg"]..ConvergeFu.db.profile.skullType.." - "..ConvergeFu.db.profile.skullName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.crossType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-05-msg"]..ConvergeFu.db.profile.crossType.." - "..ConvergeFu.db.profile.crossName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.squareType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-06-msg"]..ConvergeFu.db.profile.squareType.." - "..ConvergeFu.db.profile.squareName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.moonType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-07-msg"]..ConvergeFu.db.profile.moonType.." - "..ConvergeFu.db.profile.moonName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.triangleType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-08-msg"]..ConvergeFu.db.profile.triangleType.." - "..ConvergeFu.db.profile.triangleName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.diamondType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-09-msg"]..ConvergeFu.db.profile.diamondType.." - "..ConvergeFu.db.profile.diamondName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.circleType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-10-msg"]..ConvergeFu.db.profile.circleType.." - "..ConvergeFu.db.profile.circleName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end

  if ConvergeFu.db.profile.starType ~= L["tools-crowd-control-common-clear-type-default"] then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-11-msg"]..ConvergeFu.db.profile.starType.." - "..ConvergeFu.db.profile.starName, channelName, nil, sender)
    countNumberSetup = countNumberSetup + 1
  end
  
  if countNumberSetup == 0 then
    ConvergeFu:SendMessage(L["tools-crowd-control-announce-12-msg"], channelName, nil, sender)
  end
  
  ConvergeFu:SendMessage(L["tools-crowd-control-announce-13-msg"], channelName, nil, sender)

end

-- ============================================================================
-- == GetSpecialMenu()                                                       ==
-- ==                                                                        ==
-- == This function is a work-in-progress. For now, it should be paid little ==
-- == heed and unscrupulously ignored, except where circumstance and urgent  ==
-- == necessity demand otherwise.                                            ==
-- ============================================================================

function ConvergeFu:GetSpecialMenu()
  return { 
    threat = { 
       name = L["ann-say-threat-title"], 
       desc = L["ann-say-threat-descr"], 
       type = 'execute', 
       func = function() SendChatMessage(L["ann-say-threat-msg"], "SAY") end
    }
  }
end

-- ============================================================================
-- == ColourTextRed(text)                                                    ==
-- ==                                                                        ==
-- == This function simply colours text in red.                              ==
-- ============================================================================

function ConvergeFu:ColourTextRed(text)
   return "|cffff0000"..text
end

-- ============================================================================
-- == ColourTextGreen(text)                                                  ==
-- ==                                                                        ==
-- == This function simply colours text in green.                            ==
-- ============================================================================

function ConvergeFu:ColourTextGreen(text)
   return "|cff00ff00"..text
end

-- ============================================================================
-- == ColourTextBlue(text)                                                   ==
-- ==                                                                        ==
-- == This function simply colours text in blue.                             ==
-- ============================================================================

function ConvergeFu:ColourTextBlue(text)
   return "|cff0000ff"..text
end

-- ============================================================================
-- == ColourTextWhite(text)                                                  ==
-- ==                                                                        ==
-- == This function simply colours text in white.                            ==
-- ============================================================================

function ConvergeFu:ColourTextWhite(text)
   return "|cffffffff"..text
end

-- ============================================================================
-- == ColourTextYellow(text)                                                 ==
-- ==                                                                        ==
-- == This function simply colours text in yellow.                           ==
-- ============================================================================

function ConvergeFu:ColourTextYellow(text)
   return "|cffffff00"..text
end

-- ============================================================================
-- == ColourTextPurple(text)                                                 ==
-- ==                                                                        ==
-- == This function simply colours text in purple.                           ==
-- ============================================================================

function ConvergeFu:ColourTextPurple(text)
   return "|cffff00ff"..text
end

-- ============================================================================
-- == ColourTextBlizzard(text)                                               ==
-- ==                                                                        ==
-- == This function simply colours text in Blizzard blue.                    ==
-- ============================================================================

function ConvergeFu:ColourTextBlizzard(text)
   return "|cff00c0ff"..text
end

-- ============================================================================
-- == ColourStatusOnOff(text)                                                ==
-- ==                                                                        ==
-- == This function simply colours a status flag to an appropriate colour.   ==
-- ==                                                                        ==
-- == Green = On                                                             ==
-- == Red   = Off                                                            ==
-- == White = All other values.                                              ==
-- ============================================================================

function ConvergeFu:ColourStatusOnOff(text)
   if text == "On" then
      return ConvergeFu:ColourTextGreen(text)
   elseif text == "Off" then
      return ConvergeFu:ColourTextRed(text)
   else
      return ConvergeFu:ColourTextWhite(text)
   end
end

-- ============================================================================
-- == ColourStatusOnOff(text)                                                ==
-- ==                                                                        ==
-- == This function simply colours a status flag to an appropriate colour.   ==
-- ==                                                                        ==
-- == Green = On                                                             ==
-- == Red   = Off                                                            ==
-- == White = All other values.                                              ==
-- ============================================================================

function ConvergeFu:ColourStatusOnOff(text)
   if text == "On" then
      return ConvergeFu:ColourTextGreen(text)
   elseif text == "Off" then
      return ConvergeFu:ColourTextRed(text)
   else
      return ConvergeFu:ColourTextWhite(text)
   end
end

-- ============================================================================
-- == ColourStatusOneZero(text)                                              ==
-- ==                                                                        ==
-- == This function simply colours a status flag to an appropriate colour.   ==
-- ==                                                                        ==
-- == Green = 1                                                              ==
-- == Red   = 0                                                              ==
-- == White = All other values.                                              ==
-- ============================================================================

function ConvergeFu:ColourStatusOneZero(text)
   if text == "1" then
      return ConvergeFu:ColourTextGreen(text)
   elseif text == "0" then
      return ConvergeFu:ColourTextRed(text)
   else
      return ConvergeFu:ColourTextWhite(text)
   end
end

-- ============================================================================
-- == RecruitCharacter()                                                     ==
-- ==                                                                        ==
-- == This function is the 'gatekeeper' function for the character           ==
-- == recruitment functionality. Its job is to ensure that several key       ==
-- == pieces of information have been gathered before it kicks off the       ==
-- == actual invitation process.                                             ==
-- ============================================================================

function ConvergeFu:RecruitCharacter()

   if ConvergeFu.db.profile.recruitCharName == "" then
      ConvergeFu.db.profile.recruitStatus = L["tools-recruiter-status-getname"]
      ConvergeFu:RecruitNameFetch()
      return
   end

   if ConvergeFu.db.profile.recruitCharRank == "" then
      ConvergeFu.db.profile.recruitStatus = L["tools-recruiter-status-getrank"]
      ConvergeFu:RecruitRankFetch()
      return
   end
   
   if  ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-alt"]
   and ConvergeFu.db.profile.recruitCharMain == "" then
      ConvergeFu.db.profile.recruitStatus = L["tools-recruiter-status-getmain"]
      ConvergeFu:RecruitMainFetch()
      return
   end   

   if  ConvergeFu.db.profile.recruitStatus == L["tools-recruiter-status-checkok"] then
      ConvergeFu:RecruitConfirmContinue()
   end
   
   if ConvergeFu.db.profile.recruitStatus == L["tools-recruiter-status-recruit"] then
      ConvergeFu:DoRecruitCharacter() 
   end
   
end

-- ============================================================================
-- == RecruitCharacterCancel()                                               ==
-- ==                                                                        ==
-- == This function is called when, for some reason, the user has cancelled  ==
-- == out of the character recruitment process. It performs simple 'tidying' ==
-- == operations to undo whatever changes the process may have been in the   ==
-- == middle of.                                                             ==
-- ============================================================================

function ConvergeFu:RecruitCharacterCancel()

   ConvergeFu.db.profile.recruitCharName = ""
   ConvergeFu.db.profile.recruitCharRank = ""
   ConvergeFu.db.profile.recruitCharMain = ""
   ConvergeFu.db.profile.recruitStatus   = L["tools-recruiter-status-dormant"]
   ConvergeFu.db.profile.recruitPromotes = "0"
 
end

-- ============================================================================
-- == RecruitReportStatus()                                                  ==
-- ==                                                                        ==
-- == This function reports the current status of the Recruiter tool to the  ==
-- == chat window. It enables to the user to understand if the recruitment   ==
-- == process has stalled, which may them prompt them to choose to reset the ==
-- == tool, via the RecruitCharacterCancel() function.                       ==
-- ============================================================================

function ConvergeFu:RecruitReportStatus()

   self:Print(L["tools-recruiter-report-01-msg"]..ConvergeFu.db.profile.recruitStatus)
   
   if ConvergeFu.db.profile.recruitStatus ~= L["tools-recruiter-status-dormant"] then
     self:Print(L["tools-recruiter-report-02-msg"]..ConvergeFu.db.profile.recruitCharName)
     self:Print(L["tools-recruiter-report-03-msg"]..ConvergeFu.db.profile.recruitCharRank)
     if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-alt"] then
        self:Print(L["tools-recruiter-report-04-msg"]..ConvergeFu.db.profile.recruitCharMain)
     end
     self:Print(L["tools-recruiter-report-05-msg"]..ConvergeFu.db.profile.recruitPromotes)
   end

end

-- ============================================================================
-- == RecruitNameFetch()                                                     ==
-- ==                                                                        ==
-- == This function creates a simple dialog box which it uses to request the ==
-- == value of the name of the character to be recruited.                    ==
-- ============================================================================

function ConvergeFu:RecruitNameFetch()
   
   StaticPopupDialogs[L["tools-recruiter-window-getname"]] = {
      
      text         = L["tools-recruiter-window-title-getname"],
      button1      = L["tools-recruiter-button-continue"],
      button2      = L["tools-recruiter-button-cancel"],
      timeout      = 0,
      whileDead    = 1,
      hideOnEscape = 1,
      hasEditBox   = 1,

      OnShow = function()
         getglobal(this:GetName().."EditBox"):SetText("")
      end,

      OnAccept = function()
         ConvergeFu.db.profile.recruitCharName = getglobal(this:GetParent():GetName().."EditBox"):GetText()
         ConvergeFu:RecruitCharacter()
      end,

      OnCancel = function()
         ConvergeFu:RecruitCharacterCancel()
      end
   }

   StaticPopup_Show (L["tools-recruiter-window-getname"])
   
end

-- ============================================================================
-- == RecruitRankFetch()                                                     ==
-- ==                                                                        ==
-- == This function creates a simple dialog box which it uses to request the ==
-- == value of the intended rank of the character to be recruited.           ==
-- ==                                                                        ==
-- == ie: 'Alt' or 'Main'                                                    ==
-- ============================================================================

function ConvergeFu:RecruitRankFetch()

   StaticPopupDialogs[L["tools-recruiter-window-getrank"]] = {
      
      text         = L["tools-recruiter-window-title-getrank"],
      button1      = L["tools-recruiter-button-main"],
      button2      = L["tools-recruiter-button-alt"],
      timeout      = 0,
      whileDead    = 1,
      hideOnEscape = 1,

      OnAccept = function()
         ConvergeFu.db.profile.recruitCharRank = L["tools-recruiter-button-main"]
         ConvergeFu.db.profile.recruitStatus   = L["tools-recruiter-status-checkok"]
         ConvergeFu:RecruitCharacter()
      end,

      OnCancel = function()
         ConvergeFu.db.profile.recruitCharRank = L["tools-recruiter-button-alt"]
         ConvergeFu:RecruitCharacter()
      end
   }

   StaticPopup_Show (L["tools-recruiter-window-getrank"])

end

-- ============================================================================
-- == RecruitMainFetch()                                                     ==
-- ==                                                                        ==
-- == This function creates a simple dialog box which it uses to request the ==
-- == value of the name of the main character to whom the player being       ==
-- == invited will belong.                                                   ==
-- ============================================================================

function ConvergeFu:RecruitMainFetch()

   StaticPopupDialogs[L["tools-recruiter-window-getmain"]] = {
      
      text         = L["tools-recruiter-window-title-getmain"],
      button1      = L["tools-recruiter-button-continue"],
      button2      = L["tools-recruiter-button-cancel"],
      timeout      = 0,
      whileDead    = 1,
      hideOnEscape = 1,
      hasEditBox   = 1,

      OnShow = function()
         getglobal(this:GetName().."EditBox"):SetText("")
      end,

      OnAccept = function()
         ConvergeFu.db.profile.recruitCharMain = getglobal(this:GetParent():GetName().."EditBox"):GetText()
         ConvergeFu.db.profile.recruitStatus   = L["tools-recruiter-status-checkok"]
         ConvergeFu:RecruitCharacter()
      end,

      OnCancel = function()
         ConvergeFu:RecruitCharacterCancel()
      end
   }

   StaticPopup_Show (L["tools-recruiter-window-getmain"])
   
end

-- ============================================================================
-- == RecruitConfirmContinue()                                               ==
-- ==                                                                        ==
-- == This function asks the user to confirm the information collected is    ==
-- == correct before continuing with the recruitment process.                ==
-- ============================================================================

function ConvergeFu:RecruitConfirmContinue()

   local winText = L["tools-recruiter-window-title-getconf-01"]
                 ..ConvergeFu.db.profile.recruitCharName
                 
   if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-alt"] then
      winText = winText
              ..L["tools-recruiter-window-title-getconf-03"]
              ..ConvergeFu:GetCorrespondingAltRank(ConvergeFu:GetCharacterRank(ConvergeFu.db.profile.recruitCharMain))
              ..L["tools-recruiter-window-title-getconf-04"]
              ..ConvergeFu.db.profile.recruitCharMain
              .."?"
   else
      winText = winText
              ..L["tools-recruiter-window-title-getconf-02"]
              ..L["common-rankname-member-trial"]
              .."?"   
   end

   StaticPopupDialogs[L["tools-recruiter-window-getconf"]] = {
      
      text         = winText,
      button1      = L["tools-recruiter-button-continue"],
      button2      = L["tools-recruiter-button-cancel"],
      timeout      = 0,
      whileDead    = 1,
      hideOnEscape = 1,

      OnAccept = function()
         ConvergeFu.db.profile.recruitStatus = L["tools-recruiter-status-recruit"]
         ConvergeFu:RecruitCharacter()
      end,

      OnCancel = function()
         ConvergeFu:RecruitCharacterCancel()
      end
   }

   StaticPopup_Show (L["tools-recruiter-window-getconf"])

end

-- ============================================================================
-- == DoRecruitCharacter()                                                   ==
-- ==                                                                        ==
-- == This function kicks off the actual recruitment process and is called   ==
-- == once all the required information has been properly collected.         ==
-- ============================================================================

function ConvergeFu:DoRecruitCharacter()

   ConvergeFu:DoRecruitGuildAnnouncement()
      
   messageText1 = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                ..ConvergeFu:ColourTextWhite(" - ")
                ..L["tools-recruiter-commentary-01-msg"]
                ..ConvergeFu:ColourTextYellow(ConvergeFu.db.profile.recruitCharName)
                ..ConvergeFu:ColourTextWhite("...")
                
   self:Print(messageText1)
   ConvergeFu:ExecuteChatCommand("/ginvite "..ConvergeFu.db.profile.recruitCharName)
   self:RegisterEvent("CHAT_MSG_SYSTEM")

end

-- ============================================================================
-- == DoRecruitGuildAnnouncement()                                           ==
-- ==                                                                        ==
-- == This function makes an announcement in guild chat, warning players to  ==
-- == be ready to welcome the new recruit.                                   ==
-- ============================================================================

function ConvergeFu:DoRecruitGuildAnnouncement()

   -- == ----------------------------------------------------------------------
   -- == -- Make an announcement in guild chat...                            --
   -- == ----------------------------------------------------------------------
   ConvergeFu:SendChatMessage(L["common-separator-dashed-line"], "GUILD")
   ConvergeFu:SendChatMessage(L["tools-recruiter-getready-01-msg"], "GUILD")
   ConvergeFu:SendChatMessage(L["common-separator-dashed-line"], "GUILD")
   ConvergeFu:SendChatMessage(L["tools-recruiter-getready-02-msg"], "GUILD")
   ConvergeFu:SendChatMessage(L["tools-recruiter-getready-03-msg"], "GUILD")
   ConvergeFu:SendChatMessage(L["common-separator-empty-line"], "GUILD")
   ConvergeFu:SendChatMessage(" "..ConvergeFu.db.profile.recruitCharName, "GUILD")
   ConvergeFu:SendChatMessage(L["common-separator-empty-line"], "GUILD")
   ConvergeFu:SendChatMessage(L["tools-recruiter-getready-04-msg"], "GUILD")
   
   if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-main"] then
      ConvergeFu:SendChatMessage(L["tools-recruiter-getready-05-msg"], "GUILD")
   else
      ConvergeFu:SendChatMessage(L["tools-recruiter-getready-06-msg"]..ConvergeFu.db.profile.recruitCharMain..".", "GUILD")
   end
   ConvergeFu:SendChatMessage(L["common-separator-dashed-line"], "GUILD")
   
end

-- ============================================================================
-- == CHAT_MSG_SYSTEM(msg)                                                   ==
-- ==                                                                        ==
-- == This function performs actions when the CHAT_MSG_SYSTEM event is       ==
-- == triggered. It is triggered when the player's character receives a      ==
-- == message via the system 'channel.'                                      ==
-- ==                                                                        ==
-- == Currently, this event is monitored when waiting for a player to join   ==
-- == the guild, after an invitation has been issued via the recruiter tool. ==
-- ============================================================================

function ConvergeFu:CHAT_MSG_SYSTEM(msg)

   recruitHasJoinedText = ConvergeFu.db.profile.recruitCharName
                        ..L["tools-recruiter-system-message"]
                        
   if msg == recruitHasJoinedText then
      GuildRoster()
      ConvergeFu:RecruitConfirmPostJoin()
      -- ConvergeFu:DoRecruitPostJoinActions()
   end
end

-- ============================================================================
-- == RecruitConfirmPostJoin()                                               ==
-- ==                                                                        ==
-- == This function asks the user to confirm they should continue to process ==
-- == the recruit who has just joined. Really, this step exists only to give ==
-- == the server time to update the guild roster.                            ==
-- ============================================================================

function ConvergeFu:RecruitConfirmPostJoin()

   StaticPopupDialogs[L["tools-recruiter-window-getcont"]] = {
      
      text         = L["tools-recruiter-window-title-getcont"],
      timeout      = 30,
      whileDead    = 1,
      hideOnEscape = 1,

      OnAccept = function()
         ConvergeFu:DoRecruitPostJoinActions("first")
      end,
      
      OnCancel = function()
         ConvergeFu:DoRecruitPostJoinActions("first")
      end      
   }

   StaticPopup_Show (L["tools-recruiter-window-getcont"])

end

-- ============================================================================
-- == DoRecruitPostJoinActions(task)                                         ==
-- ==                                                                        ==
-- == This function performs several tasks after a recruit has joined the    ==
-- == guild in order to configure their character correctly.                 ==
-- ==                                                                        ==
-- == 1: Set the character's rank.                                           ==
-- == 2: Set the character's officer note if a trial member.                 ==
-- == 3: Set the character's public note if an alt member.                   ==
-- == 4: Whisper the 'registration keyword' if the recruit is a trial.       ==
-- == 5: Reset all 'recruitXXX' properties, set status to 'Dormant'.         ==
-- ============================================================================

function ConvergeFu:DoRecruitPostJoinActions(task)

   -- == ----------------------------------------------------------------------
   -- == -- Set the recruited character's rank.                              --
   -- == ----------------------------------------------------------------------
   local numberOfRankIncreases = 5
   if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-alt"] then
      local mainCharRank = ConvergeFu:GetCharacterRank(ConvergeFu.db.profile.recruitCharMain)
      local thisCharRank = ConvergeFu:GetCorrespondingAltRank(mainCharRank)
  
      if thisCharRank == L["common-rankname-alt-trial"] then
         numberOfRankIncreases = 1
      elseif thisCharRank == L["common-rankname-alt-normal"] then
         numberOfRankIncreases = 2
      elseif thisCharRank == L["common-rankname-alt-hero"] then
         numberOfRankIncreases = 3
      elseif thisCharRank == L["common-rankname-alt-officer"] then
         numberOfRankIncreases = 4
      end
   end
      
   ConvergeFu.db.profile.recruitPromotes = numberOfRankIncreases
   
   promotionText = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                 .." "
                 ..ConvergeFu:ColourTextWhite(L["tools-recruiter-num-promotions"])
                 ..ConvergeFu:ColourTextYellow(numberOfRankIncreases)
             
  self:Print(promotionText)
  
   
   promotedByOneText = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                     .." "
                     ..ConvergeFu:ColourTextWhite(L["tools-recruiter-promoted-by-one"])
   
   -- == ----------------------------------------------------------------------
   -- == -- Set the recruited character's public or officer note.            --
   -- == ----------------------------------------------------------------------   
   if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-main"] then
      officerNoteText = "Trial "..date("%m/%d/%Y");
      noteSettingText = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                      .." "
                      ..ConvergeFu:ColourTextWhite(L["tools-recruiter-set-note-officer"])
                      ..ConvergeFu:ColourTextYellow(officerNoteText)
      self:Print(noteSettingText)
      ConvergeFu:SetCharacterOfficerNote(ConvergeFu.db.profile.recruitCharName, officerNoteText)
   else
      noteSettingText = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                      .." "
                      ..ConvergeFu:ColourTextWhite(L["tools-recruiter-set-note-public"])
                      ..ConvergeFu:ColourTextYellow(ConvergeFu.db.profile.recruitCharMain)
      self:Print(noteSettingText)
      ConvergeFu:SetCharacterPublicNote(ConvergeFu.db.profile.recruitCharName, ConvergeFu.db.profile.recruitCharMain)
   end

   -- == ----------------------------------------------------------------------
   -- == -- Whisper the guild registration keyword if recruit is a trial.    --
   -- == ---------------------------------------------------------------------- 
   if ConvergeFu.db.profile.recruitCharRank == L["tools-recruiter-rank-main"] then
      ConvergeFu:SendMessage(L["tools-recruiter-keyword-01-msg"], "WHISPER", nil, ConvergeFu.db.profile.recruitCharName)
      ConvergeFu:SendMessage(L["tools-recruiter-keyword-02-msg"], "WHISPER", nil, ConvergeFu.db.profile.recruitCharName)
      ConvergeFu:SendMessage(L["tools-recruiter-keyword-03-msg"], "WHISPER", nil, ConvergeFu.db.profile.recruitCharName)
      ConvergeFu:SendMessage(L["tools-recruiter-keyword-04-msg"], "WHISPER", nil, ConvergeFu.db.profile.recruitCharName)
   end

   ConvergeFu:RecruitRankChange()

end

-- ============================================================================
-- == ConvergeFu:RecruitRankChange()                                         ==
-- ==                                                                        ==
-- == This function promotes the new recruit if he/she still needs to be     ==
-- == promoted.                                                              ==
-- ============================================================================

function ConvergeFu:RecruitRankChange()

  local promotionsRemaining = ConvergeFu.db.profile.recruitPromotes
  
  if promotionsRemaining > 0 then
    self:Print("Promoting: "..promotionsRemaining.." left to do...")
    GuildPromote(ConvergeFu.db.profile.recruitCharName)
    ConvergeFu.db.profile.recruitPromotes = promotionsRemaining - 1
    ConvergeFu:RecruitRankChangePause()
    return
  else
     ConvergeFu:RecruitAllDone()
  end
end

-- ============================================================================
-- == RecruitRankChangePause()                                               ==
-- ==                                                                        ==
-- == This function pauses briefly during the rank changing process.         ==
-- ============================================================================

function ConvergeFu:RecruitRankChangePause()

   StaticPopupDialogs[L["tools-recruiter-window-waiting"]] = {
      
      text         = L["tools-recruiter-window-title-waiting"],
      timeout      = 7,
      whileDead    = 1,
      hideOnEscape = 0,

      OnAccept = function()
         ConvergeFu:RecruitRankChange()
      end,
      
      OnCancel = function()
         ConvergeFu:RecruitRankChange()
      end      
   }

   StaticPopup_Show (L["tools-recruiter-window-waiting"])

end

-- ============================================================================
-- == ConvergeFu:RecruitAllDone()                                         ==
-- ==                                                                        ==
-- == This function promotes the new recruit if he/she still needs to be     ==
-- == promoted.                                                              ==
-- ============================================================================

function ConvergeFu:RecruitAllDone()

   -- == ----------------------------------------------------------------------
   -- == -- Reset all internal properties so that we can finish cleanly.     --
   -- == ---------------------------------------------------------------------- 
   completionText = ConvergeFu:ColourTextPurple(L["tools-recruiter-tag"])
                  .." "
                  ..ConvergeFu:ColourTextWhite(L["tools-recruiter-all-done"])
   
   self:Print(completionText)
   PlaySound("DwarfExploration")
   ConvergeFu:RecruitCharacterCancel()
end

-- ============================================================================
-- == SetCharacterPublicNote(characterName, messageText)                     ==
-- ==                                                                        ==
-- == This function sets the public note field of the named character.       ==
-- ============================================================================

function ConvergeFu:SetCharacterPublicNote(characterName, messageText)

  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
    if name == characterName then
       GuildRosterSetPublicNote(index, messageText)  
    end
    
    index = index + 1
  end
end

-- ============================================================================
-- == SetCharacterOfficerNote(characterName, messageText)                    ==
-- ==                                                                        ==
-- == This function sets the public note field of the named character.       ==
-- ============================================================================

function ConvergeFu:SetCharacterOfficerNote(characterName, messageText)
  
  for index = 1, (GetNumGuildMembers(true)) do
    name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
    
    if name == characterName then
       GuildRosterSetOfficerNote(index, messageText)  
    end
    
    index = index + 1
  end
end

-- ============================================================================
-- == CreateVersionCheckFrame(sender, versionText)                           ==
-- ==                                                                        ==
-- == This function creates the version check frame and populates it with    ==
-- == the details of the player whose version is more up-to-date than the    ==
-- == one being used by the user.                                            ==
-- ==                                                                        ==
-- == This function was adapted from the similar function provided in the    ==
-- == ACE library API for creating an 'About' information window for a FuBar ==
-- == compatible plugin addon.                                               ==
-- ============================================================================

function ConvergeFu:CreateVersionCheckFrame(sender, versionText)
  
   -- == ----------------------------------------------------------------------
   -- == -- Create the window frame object and configure its properties.     --
   -- == ----------------------------------------------------------------------
   versionCheckFrame = CreateFrame("Frame", "AceAddon20versionCheckFrame", UIParent, "DialogBoxFrame")
   versionCheckFrame:SetWidth(500)
   versionCheckFrame:SetHeight(400)
   versionCheckFrame:SetPoint("CENTER")
   versionCheckFrame:SetBackdrop({
      bgFile   = [[Interface\DialogFrame\UI-DialogBox-Background]],
      edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
      tile     = true, tileSize = 16, edgeSize = 16,
      insets   = { left = 5, right = 5, top = 5, bottom = 5 }
   })
   versionCheckFrame:SetBackdropColor(0,0,0,1)

   -- == ----------------------------------------------------------------------
   -- == -- Set the window's title text.                                     --
   -- == ----------------------------------------------------------------------
   local text = versionCheckFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
   versionCheckFrame.title = text
   text:SetPoint("TOP", 0, -5)

   -- == ----------------------------------------------------------------------
   -- == -- Initialise the window's text arrays.                             --
   -- == ----------------------------------------------------------------------
   versionCheckFrame.lefts = {}
   versionCheckFrame.rights = {}
   versionCheckFrame.textLefts = {}
   versionCheckFrame.textRights = {}

   -- == ----------------------------------------------------------------------
   -- == -- Object function: Clear the window.                               --
   -- == ----------------------------------------------------------------------
   function versionCheckFrame:Clear()
      self.title:SetText("")
      for i = 1, #self.lefts do
         self.lefts[i] = nil
         self.rights[i] = nil
      end
   end
  
   -- == ----------------------------------------------------------------------
   -- == -- Object function: Prepare the window for a new version check.     --
   -- == ----------------------------------------------------------------------
   function versionCheckFrame:PrepareForVersionCheck()
      versionCheckFrame.rights[1] = L["event-addon-vc-uptodate-02-msg"]
      
      for i = 4, #self.lefts do
         self.lefts[i] = nil
         self.rights[i] = nil
      end
   end  

   -- == ----------------------------------------------------------------------
   -- == -- Object function: Add a line of text to the window.               --
   -- == ----------------------------------------------------------------------
   function versionCheckFrame:AddLine(left, right)
      versionCheckFrame.lefts[#versionCheckFrame.lefts+1] = left
      versionCheckFrame.rights[#versionCheckFrame.rights+1] = right
   end

   -- == ----------------------------------------------------------------------
   -- == -- Object function: Show the window.                                --
   -- == ----------------------------------------------------------------------
   local versionCheckFrame_Show = versionCheckFrame.Show
   function versionCheckFrame:Show(...)
      local maxLeftWidth = 0
      local maxRightWidth = 0
      local textHeight = 0
      for i = 1, #self.lefts do
         if not self.textLefts[i] then
            local left = versionCheckFrame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
            self.textLefts[i] = left
            local right = versionCheckFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
            self.textRights[i] = right
            if i == 1 then
              left:SetPoint("TOPRIGHT", versionCheckFrame, "TOPLEFT", 75, -35)
            else
              left:SetPoint("TOPRIGHT", self.textLefts[i-1], "BOTTOMRIGHT", 0, -5)
            end
            right:SetPoint("LEFT", left, "RIGHT", 5, 0)
         end
         if self.lefts[i] == "@NULL@" then
            self.textLefts[i]:SetText(" ")
         else
            self.textLefts[i]:SetText(self.lefts[i] .. ":")
         end
      
         -- self.textLefts[i]:SetText(self.lefts[i] .. ":")
         self.textRights[i]:SetText(self.rights[i])
         local leftWidth = self.textLefts[i]:GetWidth()
         local rightWidth = self.textRights[i]:GetWidth()
         textHeight = self.textLefts[i]:GetHeight()
         if maxLeftWidth < leftWidth then
            maxLeftWidth = leftWidth
         end
         if maxRightWidth < rightWidth then
            maxRightWidth = rightWidth
         end
      end
      for i = #self.lefts+1, #self.textLefts do
         self.textLefts[i]:SetText('')
         self.textRights[i]:SetText('')
      end
      versionCheckFrame:SetWidth(75 + maxRightWidth + 20)
      versionCheckFrame:SetHeight(#self.lefts * (textHeight + 5) + 100)

      versionCheckFrame_Show(self, ...)
   end

   -- == ----------------------------------------------------------------------
   -- == -- Initialise the window configuration.                             --
   -- == ----------------------------------------------------------------------
   myVersionText = ConvergeFu:ColourTextBlizzard(L["versionName"]..": ")
                 ..ConvergeFu:ColourTextYellow(L["versionNumber"])

   versionCheckFrame.title:SetText(tostring(self.title))
   versionCheckFrame:AddLine(L["event-addon-vc-uptodate-title"], L["event-addon-vc-uptodate-01-msg"])
   versionCheckFrame:AddLine("@NULL@", " ")
   versionCheckFrame:AddLine(UnitName("player"), myVersionText)
  
   if sender ~= nil and sender ~= "@NULL@" then 
      versionCheckFrame:AddLine(sender, versionText)
   end

   -- == ----------------------------------------------------------------------
   -- == -- Set a flag indicating that the window has been created.          --
   -- == ----------------------------------------------------------------------
   versionCheckFrameCreated = "1"
end

-- ============================================================================
-- == ShowAPI(channelName)                                                   ==
-- ==                                                                        ==
-- == This function simply lists all the functions of ConvergeFu in order to ==
-- == help the user remind themselves of the functionality that is available ==
-- == through this addon.                                                    ==
-- ============================================================================

function ConvergeFu:ShowAPI(channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:OnEnable()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ZONE_CHANGED()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:CHAT_MSG_WHISPER(msg, sender)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SendWhisperCommandHelp(recipient)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SendWhisperGuildInfo(recipient)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetArgs(message, separator)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DoBusyResponder(sender, msg)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ToggleBusyResponder()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:CHAT_MSG_ADDON(prefix, msg, channel, sender)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DoProcessVersionCheckQuery(msg, channelName, sender)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DoProcessVersionCheckResponse(msg, channel, sender)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DoVersionCheck(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DoUpToDateCheck(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:OnTextUpdate()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:OnTooltipUpdate()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:OnClick()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ExecuteChatCommand(arg)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetGuildName()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetNumberOfGuildOfficers()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetGuildOfficerNamesForTooltip(cat)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:FindPlayerByCharacterName(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAssociatedCharacters(characterName,channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAllHeroes(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAllOfficers(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAllHeroes(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAllNormals(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ListAllTrials(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:DemoteAllHeroes()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:PromoteAltsOfHeroes()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SetCharacterRank(characterName, targetRankName, channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetCharacterRank(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetCorrespondingAltRank(rankName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsMainRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsAltRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsOfficerRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsHeroRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsNormalRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsTrialRankedCharacter(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsCharacterInGuild(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsCharacterInParty(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsCharacterInRaid(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:IsCharacterAFriend(characterName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SetAllAltCharacterRanks()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SendChatMessage(messageText, channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:SendMessage(messageText, channelName, token, recipient)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ShowAvoidanceForLevel70Rogues()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:AnnounceRankChanges(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:AnnounceRaidInvite(officerName,channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:AnnounceWaitList(officerName,channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:AnnounceRaidEnd(channelName)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:AnnounceCrowdControlTargets(channelName, recipient)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:GetSpecialMenu()", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextRed(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextGreen(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextBlue(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextWhite(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextYellow(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextPurple(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourTextBlizzard(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourStatusOnOff(text)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ColourStatusOneZero(text)", channelName)  
  ConvergeFu:SendChatMessage("ConvergeFu:CreateVersionCheckFrame(sender, versionText)", channelName)
  ConvergeFu:SendChatMessage("ConvergeFu:ShowAPI(channelName)", channelName)
end


