local tablet = AceLibrary("Tablet-2.0")

CombatTimeFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0")

local mod = CombatTimeFu

function mod:OnInitialize()
		self.combatStart = 0
		self.combatEnd = 0

		self.name = "CombatTimeFu"
end

function mod:OnEnable()
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "PLAYER_REGEN_ENABLED")	
end

function mod:OnDisable()
	self:UnRegisterEvent("PLAYER_REGEN_DISABLED")
	self:UnRegisterEvent("PLAYER_REGEN_ENABLED")
	self:UnRegisterEvent("PLAYER_ENTERING_WORLD")
end

-- Leaving combat
function mod:PLAYER_REGEN_ENABLED()
	if self.combatStart <= 0 then return end -- We've never been in combat
	
	self.combatEnd = GetTime()
	self:Update()
	self:CancelScheduledEvent(self.name)
end

-- Entering combat
function mod:PLAYER_REGEN_DISABLED()
	self.combatStart = GetTime()
	self.combatEnd = 0
	self:Update()
	
	self:ScheduleRepeatingEvent(self.name, self.Update, 0.1, self)	
end

function mod:GetCurrentCombatTime()
	local sec = 0
	
	if InCombatLockdown() then
		sec = GetTime()-self.combatStart
	else
		sec = self.combatEnd-self.combatStart
	end
	
	if(sec < 0) then
		sec = 0
	end
	
	local s = math.floor(sec)
	local frac = (sec - s)*100
	local m = math.floor(sec/60)
	sec = math.fmod(sec, 60)
	
	return ("%d:%02d:%02d"):format(m, sec, frac)
end

function mod:OnTextUpdate()
	if InCombatLockdown() then
		self:SetText("|cffff0000".. self:GetCurrentCombatTime() .."|r")
	else
		self:SetText("|cff00ff00".. self:GetCurrentCombatTime() .."|r")
	end
end

function mod:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	cat:AddLine(
		'text', "Combat status",
		'text2', InCombatLockdown() and "|cffff0000In combat|r" or "|cff00ff00Not in combat|r"
	)
	cat:AddLine(
		'text', "Combat time",
		'text2', self.combatStart > 0 and self:GetCurrentCombatTime() or "None"
	)
end