﻿--[[
	FuBar - CombatInfoFu
	by Dire of Ravencrest
	updated by Detritis of Quel'Thalas
	
	Special thanks to Fleurette for bug fixes.

	Installation: Unzip to your WoW\Interface\Addons folder, enable in FuBar
	Note: Due to the name changing, old settings won't load

	Based on Titan Combat Info 1.51 and used several FuBar plugins as base.
	Added weapon skills, since it was missing.

	Thanks to Neriak for helping with several optimizations.
]]


local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local L = AceLibrary("AceLocale-2.2"):new("CombatInfoFu")

CombatInfoFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

CombatInfoFu:RegisterDB("FuBar_CombatInfoFuDB")

CombatInfoFu:RegisterDefaults('profile', {
	showBlock		= nil,
	showCrit		= nil,
	showDodge		= nil,
	showParry		= nil,
	showAvoid		= nil,
	showRCrit		= nil,
	showArmorPerc	= nil,
	showArmor		= nil,
	showAP			= nil,
	showRap			= nil,
	showValue		= nil,
	showStatLabel 	= true,
	hideChances		= false,
	hideMelee		= false,
	hideRanged		= false,
	hideSpells		= false,
	hideDefense		= false,
})
local optionsTable = {
	handler = CombatInfoFu,
	type = 'group',
	args = {
		show = {
			order = 97,
			type = 'group', 
			name = L["MENU_STATS"],
			desc = L["MENU_STATS_D"],
			args = {
				block = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWBLOCK_TEXT"],
					desc = L["OPTIONS_SHOWBLOCK_TEXT"],
					get = "IsShowingBlock",
					set = "ToggleShowBlock",
				},
				crit = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWCRIT_TEXT"],
					desc = L["OPTIONS_SHOWCRIT_TEXT"],
					get = "IsShowingCrit",
					set = "ToggleShowCrit",
				},
				critap = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWCRITAP_TEXT"],
					desc = L["OPTIONS_SHOWCRITAP_TEXT"],
					get = "IsShowingCritAp",
					set = "ToggleShowCritAp",
				},
				dodge = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWDODGE_TEXT"],
					desc = L["OPTIONS_SHOWDODGE_TEXT"],
					get = "IsShowingDodge",
					set = "ToggleShowDodge",
				},
				parry = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWPARRY_TEXT"],
					desc = L["OPTIONS_SHOWPARRY_TEXT"],
					get = "IsShowingParry",
					set = "ToggleShowParry",
				},
				avoid = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWAVOIDANCE_TEXT"],
					desc = L["OPTIONS_SHOWAVOIDANCE_TEXT"],
					get = "IsShowingAvoid",
					set = "ToggleShowAvoid",
				},
				rcrit = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWRCRIT_TEXT"],
					desc = L["OPTIONS_SHOWRCRIT_TEXT"],
					get = "IsShowingRCrit",
					set = "ToggleShowRCrit",
				},
				armorperc = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWARMORPERC_TEXT"],
					desc = L["OPTIONS_SHOWARMORPERC_TEXT"],
					get = "IsShowingArmorPerc",
					set = "ToggleShowArmorPerc",
				},
				armor = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWARMOR_TEXT"],
					desc = L["OPTIONS_SHOWARMOR_TEXT"],
					get = "IsShowingArmor",
					set = "ToggleShowArmor",
				},
				ap = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWAP_TEXT"],
					desc = L["OPTIONS_SHOWAP_TEXT"],
					get = "IsShowingAP",
					set = "ToggleShowAP",
				},
				rap = {
					type = 'toggle', 
					name = L["OPTIONS_SHOWRAP_TEXT"],
					desc = L["OPTIONS_SHOWRAP_TEXT"],
					get = "IsShowingRap",
					set = "ToggleShowRap",
				},
			}
		},
		["-blank-"] = {
			order = 98,
			type = 'header',
		},
		label = {
			order = 99,
			type = 'toggle',
			name = L["OPTIONS_SHOWSTATLABEL_TEXT"],
			desc = L["MENU_STATS_D"],
			get = "IsShowingStatLabel",
			set = "ToggleShowStatLabel",
		}
	}
}

CombatInfoFu.version = "2.3."..string.sub("$Revision: 24459 $", 12, -3)
CombatInfoFu.date = string.sub("$Date: 2006-11-05 11:05:48 -0400 (Sat, 5 Nov 2006) $", 8, 17)
CombatInfoFu.hasIcon = L["BUTTON_ICON"]
CombatInfoFu.clickableTooltip = true
CombatInfoFu.defaultPosition = "CENTER"
CombatInfoFu.OnMenuRequest = optionsTable

function CombatInfoFu:GetResilience()
	local melee = GetCombatRating(CR_CRIT_TAKEN_MELEE);
	local ranged = GetCombatRating(CR_CRIT_TAKEN_RANGED);
	local spell = GetCombatRating(CR_CRIT_TAKEN_SPELL);

	local minResilience = min(melee, ranged);
	minResilience = min(minResilience, spell);
	
	local lowestRating = CR_CRIT_TAKEN_MELEE;
	if ( melee == minResilience ) then
		lowestRating = CR_CRIT_TAKEN_MELEE;
	elseif ( ranged == minResilience ) then
		lowestRating = CR_CRIT_TAKEN_RANGED;
	else
		lowestRating = CR_CRIT_TAKEN_SPELL;
	end

	return lowestRating
end


	
function CombatInfoFu:IsShowingBlock()
	if (self.db.profile.showValue == L["MENU_BLOCK"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingCrit()
	if (self.db.profile.showValue == L["MENU_CRIT"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingCritAp()
	if (self.db.profile.showValue == L["MENU_CRITAP"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingDodge()
	if (self.db.profile.showValue == L["MENU_DODGE"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingParry()
	if (self.db.profile.showValue == L["MENU_PARRY"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingAvoid()
	if (self.db.profile.showValue == L["MENU_AVOID"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingRCrit()
	if (self.db.profile.showValue == L["MENU_RCRIT"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingArmorPerc()
	if (self.db.profile.showValue == L["MENU_ARMORPERC"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingArmor()
	if (self.db.profile.showValue == L["MENU_ARMOR"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingAP()
	if (self.db.profile.showValue == L["MENU_AP"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingRap()
	if (self.db.profile.showValue == L["MENU_RAP"]) then
		return self.db.profile.showValue
	end
end

function CombatInfoFu:IsShowingStatLabel()
	return self.db.profile.showStatLabel
end
	

function CombatInfoFu:ToggleShowBlock()
	if ( self.db.profile.showValue == L["MENU_BLOCK"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_BLOCK"]	
	end
	self.db.profile.showBlock = nil
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowCrit()
	if ( self.db.profile.showValue == L["MENU_CRIT"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_CRIT"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowCritAp()
	if ( self.db.profile.showValue == L["MENU_CRITAP"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_CRITAP"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowDodge()
	if ( self.db.profile.showValue == L["MENU_DODGE"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_DODGE"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end
		
function CombatInfoFu:ToggleShowParry()
	if ( self.db.profile.showValue == L["MENU_PARRY"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_PARRY"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowAvoid()
	if ( self.db.profile.showValue == L["MENU_AVOID"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_AVOID"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowRCrit()
	if ( self.db.profile.showValue == L["MENU_RCRIT"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_RCRIT"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowArmorPerc()
	if ( self.db.profile.showValue == L["MENU_ARMORPERC"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_ARMORPERC"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowArmor()
	if ( self.db.profile.showValue == L["MENU_ARMOR"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_ARMOR"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowAP()
	if ( self.db.profile.showValue == L["MENU_AP"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_AP"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowRap()
	if ( self.db.profile.showValue == L["MENU_RAP"] ) then
		self.db.profile.showValue = nil
	else
		self.db.profile.showValue = L["MENU_RAP"]	
	end
	
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showValue
end

function CombatInfoFu:ToggleShowStatLabel()
	self.db.profile.showStatLabel = not self.db.profile.showStatLabel
	self.datachanged = 1
	self:UpdateText()
	return self.db.profile.showStatLabel
end

local function PrintMsg(message)
	DEFAULT_CHAT_FRAME:AddMessage(message or "error");
end

function CombatInfoFu:OnEvent()
    self:UpdateData()
    self:UpdateText()
end

function CombatInfoFu:Initialize()
	self:RegisterEvent("PLAYER_LEAVING_WORLD","UnregisterEvents")
    self:RegisterEvent("PLAYER_ENTERING_WORLD","RegisterEvents")
end

function CombatInfoFu:RegisterEvents()
    self:RegisterEvent("UNIT_INVENTORY_CHANGED","OnEvent")
	self:RegisterEvent("UNIT_AURA","OnEvent")
	self:RegisterEvent("UNIT_AURASTATE","OnEvent")
	self:RegisterEvent("CHAT_MSG_SKILL","OnEvent")
end

function CombatInfoFu:UnregisterEvents()
	--self:UnregisterEvent("UNIT_INVENTORY_CHANGED")
	--self:UnregisterEvent("UNIT_AURA")
	--self:UnregisterEvent("UNIT_AURASTATE")
	--self:UnregisterEvent("CHAT_MSG_SKILL")
end

function CombatInfoFu:OnEnable()
	self:RegisterEvents()
end

function CombatInfoFu:OnDisable()
	--self:UnregisterEvents()
end

function CombatInfoFu:UpdateData()
	self.update = GetTime()
	if(not self.lastupdate) then
		self.lastupdate = 0
	end
	if(self.lastupdate >=  self.update + 1) then
		return
	end
	self.lastupdate = GetTime()

	self.blockChance = format("%.2f",GetBlockChance())
	self.critChance = format("%.2f",GetCritChance())
	self.dodgeChance = format("%.2f",GetDodgeChance())
	self.parryChance = format("%.2f",GetParryChance())
	self.playerLevel = UnitLevel("player")

	self.meleeAPbase, self.meleeAPpos, self.meleeAPneg = UnitAttackPower("player")
	self.meleeAPtotal = self.meleeAPbase + self.meleeAPpos + self.meleeAPneg
	self.meleeAPpos = nil
	self.meleeAPneg = nil
	
	self.meleeMainSpeed, self.meleeOffSpeed = UnitAttackSpeed("player")
	self.meleeOffHasWeapon = OffhandHasWeapon()
	self.meleeMainLowDmg, self.meleeMainHiDmg, self.meleeOffLowDmg, self.meleeOffHiDmg, self.meleePosDmg, self.meleeNegDmg, self.percent = UnitDamage("player")
	self.meleeMainAvgDmg = ((self.meleeMainHiDmg + self.meleeMainLowDmg) * .5) / self.meleeMainSpeed
	self.meleeMainLowDmg = floor(self.meleeMainLowDmg)
	self.meleeMainHiDmg = floor(self.meleeMainHiDmg)
	
	self.meleeOffhand = OffhandHasWeapon()
	if(self.meleeOffhand) then
		self.meleeOffAvgDmg = ((self.meleeOffHiDmg + self.meleeOffLowDmg) * .5) / self.meleeOffSpeed
		self.meleeOffHiDmg = ceil(self.meleeOffHiDmg)
		self.meleeOffLowDmg = floor(self.meleeOffLowDmg)
	end
	
	self.meleeMainSkillBase, self.meleeMainSkillMod, self.meleeOffhandSkillBase, self.meleeOffhandSkillMod = UnitAttackBothHands("player")
	self.meleeMainSkill = self.meleeMainSkillBase + self.meleeMainSkillMod
	self.meleeOffhandSkill = self.meleeOffhandSkillBase + self.meleeOffhandSkillMod
	self.meleeMainSkillMod = nil
	self.meleeOffhandSkillMod = nil
	
	self.rangedAPbase, self.rangedAPpos, self.rangedAPneg = UnitRangedAttackPower("player")
	self.rangedAPtotal = self.rangedAPbase + self.rangedAPpos + self.rangedAPneg
	self.rangedAPpos = nil
	self.rangedAPneg = nil
	
	self.rangedBase, self.rangedModifier = UnitRangedAttack("player")
	self.rangedSpeed, self.rangedLowDmg, self.rangedHiDmg = UnitRangedDamage("player")
	self.rangedBaseDamage = (self.rangedLowDmg + self.rangedHiDmg) * 0.5
	self.rangedFullDamage = (self.rangedBaseDamage + self.meleePosDmg + self.meleeNegDmg) * self.percent
	self.rangedAvgDmg = (max(self.rangedFullDamage,1) / self.rangedSpeed)
	self.rangedBonus = (self.rangedFullDamage - self.rangedBaseDamage)
	self.rangedLowDmg = max(floor(self.rangedLowDmg + self.rangedBonus),1)
	self.rangedHiDmg = max(ceil(self.rangedHiDmg + self.rangedBonus),1)
	self.rangedBonus = nil
	
	self.rangedSkillBase, self.rangedSkillMod = UnitRangedAttack("player")
	self.rangedSkill = self.rangedSkillBase + self.rangedSkillMod
	self.rangedSkillMod = nil
	
	self.armorBase, self.armorEffective, _, _, _ = UnitArmor("player")
	self.armorReduction = self.armorEffective / ((85 * self.playerLevel) + 400)
	self.armorReduction = 100 * (self.armorReduction / (self.armorReduction + 1))
	
	self.defenseBase, self.defenseMod = UnitDefense("player")
	self.defenseTotal = self.defenseBase + self.defenseMod
	self.defenseMod = nil
	
	self.rangedCrit =  format("%.2f",GetRangedCritChance())--self.critChance + self:GetHunterExtraRangedCrit()
						
	self.datachanged = 1
end

function CombatInfoFu:UpdateText()
	local stattext, statlabel, color
	color = "|cffffffff"
	if(self.db.profile.showValue == L["MENU_BLOCK"]) then
		stattext = self.blockChance.."%"
		statlabel = L["BLOCK_TEXT"]
		self:SetIcon(L["BLOCK_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_CRIT"]) then
		stattext = self.critChance.."%"
		statlabel = L["CRIT_TEXT"]
		self:SetIcon(L["CRIT_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_CRITAP"]) then
		statlabel = L["CRITAP_TEXT"]
		if(self.meleeAPtotal < self.meleeAPbase) then
		    stattext = self.critChance.."% / |r|cffff0000"..self.meleeAPtotal
		elseif(self.meleeAPtotal > self.meleeAPbase) then
		    stattext = self.critChance.."% / |r|cff00ff00"..self.meleeAPtotal
		else
		    stattext = self.critChance.."% / "..self.meleeAPtotal
		end
		self:SetIcon(L["CRITAP_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_DODGE"]) then
		stattext = self.dodgeChance.."%"
		statlabel = L["DODGE_TEXT"]
		self:SetIcon(L["DODGE_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_PARRY"]) then
		stattext = self.parryChance.."%"
		statlabel = L["PARRY_TEXT"]
		self:SetIcon(L["PARRY_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_ARMORPERC"]) then
		stattext = format("%.1f%%", self.armorReduction)
		statlabel = L["ARMORPERC_TEXT"]..": "
		if(self.armorEffective < self.armorBase) then
			color = "|cffff0000"
		elseif(self.armorEffective > self.armorBase) then
			color = "|cff00ff00"
		end
		self:SetIcon(L["ARMORPERC_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_ARMOR"]) then
		stattext = self.armorEffective
		statlabel = L["ARMOR_TEXT"]..": "
		if(self.armorEffective < self.armorBase) then
			color = "|cffff0000"
		elseif(self.armorEffective > self.armorBase) then
			color = "|cff00ff00"
		end
		self:SetIcon(L["ARMOR_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_AP"]) then
		stattext = self.meleeAPtotal
		statlabel = L["AP_TEXT"]
		if(self.meleeAPtotal < self.meleeAPbase) then
			color = "|cffff0000"
		elseif(self.meleeAPtotal > self.meleeAPbase) then
			color = "|cff00ff00"
		end
		self:SetIcon(L["AP_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_RAP"]) then
		stattext = self.rangedAPtotal
		statlabel = L["RAP_TEXT"]
		if(self.rangedAPtotal < self.rangedAPbase) then
			color = "|cffff0000"
		elseif(self.rangedAPtotal > self.rangedAPbase) then
			color = "|cff00ff00"
		end
		self:SetIcon(L["RAP_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_AVOID"]) then
		stattext = self.dodgeChance + self.parryChance.."%"
		statlabel = L["AVOIDANCE_TEXT"]
		self:SetIcon(L["AVOID_ICON"])
	elseif(self.db.profile.showValue ==  L["MENU_RCRIT"]) then
		stattext = self.rangedCrit.."%"
		statlabel = L["RCRIT_TEXT"]
		self:SetIcon(L["CRIT_ICON"])
	else
		stattext = ""
		statlabel = L["BUTTON_LABEL"]
		self:SetIcon(L["BUTTON_ICON"])
	end
	if(self.db.profile.showStatLabel) then
		self:SetText(statlabel..color..stattext.."|r")
	else
		self:SetText(color..stattext.."|r")
	end

	self.datachanged = nil

end

function CombatInfoFu:OnTooltipUpdate()
  	self:UpdateData()
	local r, g, b = 1, 1, 0
  	local cat

-- chances
	cat = tablet:AddCategory(
		'text', "Chances: ",
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'columns', 2,
		'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
		'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
		'func', function() CombatInfoFu.db.profile.hideChances = not CombatInfoFu.db.profile.hideChances end,
		'hasCheck', true,
		'checked', true,
		'checkIcon', CombatInfoFu.db.profile.hideChances and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
	)
	if CombatInfoFu.db.profile.hideChances == false then
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["CRIT_TEXT"],
			'text2',self.critChance.."%"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["RCRIT_TEXT"],
			'text2',self.rangedCrit.."%"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["CRITSPELL_TEXT"],
			'text2',format("%.2f",GetSpellCritChance(2)).."%"
		)
		cat:AddLine()
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["BLOCK_TEXT"],
			'text2',self.blockChance.."%"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["DODGE_TEXT"],
			'text2',self.dodgeChance.."%"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["PARRY_TEXT"],
			'text2',self.parryChance.."%"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["AVOIDANCE_TEXT"],
			'text2',format("%.2f",self.dodgeChance + self.parryChance).."%"
		)
	else
		cat:AddLine()
	end

-- melee
	cat = tablet:AddCategory(
		'text', "Melee: ",
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'columns', 2,
		'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
		'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
		'func', function() CombatInfoFu.db.profile.hideMelee = not CombatInfoFu.db.profile.hideMelee end,
		'hasCheck', true,
		'checked', true,
		'checkIcon', CombatInfoFu.db.profile.hideMelee and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
	)
	if CombatInfoFu.db.profile.hideMelee == false then
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_TEXT"],
			'text2',format(" (+%.1f DPS)",self.meleeAPtotal / L["AP2DPS"])
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_POWER_TEXT"],
			'text2',self.meleeAPtotal.." ("..self.meleeAPbase.." base)"
		)
		cat:AddLine()
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_MAINSKILL_TEXT"],
			'text2',self.meleeMainSkill.." ("..self.meleeMainSkillBase.." base)"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_MAINSPEED_TEXT"],
			'text2',format("%.2f",self.meleeMainSpeed)
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_MAINDMG_TEXT"],
			'text2',self.meleeMainLowDmg.." - "..self.meleeMainHiDmg
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["MELEE_MAINAVGDMG_TEXT"],
			'text2',format("%.1f",self.meleeMainAvgDmg)
		)
	
	-- offhand
		if(self.meleeOffhand) then
			cat:AddLine()
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["MELEE_OFFHANDSKILL_TEXT"],
				'text2',self.meleeOffhandSkill.." ("..self.meleeOffhandSkillBase.." base)"
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["MELEE_OFFHANDSPEED_TEXT"],
				'text2',format("%.2f",self.meleeOffSpeed)
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["MELEE_OFFHANDDMG_TEXT"],
				'text2',self.meleeOffLowDmg.." - "..self.meleeOffHiDmg
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["MELEE_OFFAVGDMG_TEXT"],
				'text2',format("%.1f",self.meleeOffAvgDmg)
			)
		end
	else
		cat:AddLine()
	end

-- ranged
	if(self.rangedSpeed > 0) then
		cat = tablet:AddCategory(
			'text', "Ranged: ",
			'textR', 0,
			'textG', 1,
			'textB', 0,
			'columns', 2,
			'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
			'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
			'func', function() CombatInfoFu.db.profile.hideRanged = not CombatInfoFu.db.profile.hideRanged end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', CombatInfoFu.db.profile.hideRanged and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
		)
		if CombatInfoFu.db.profile.hideRanged == false then
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGE_TEXT"],
				'text2',format(" (+%.1f DPS)",self.rangedAPtotal / L["AP2DPS"])
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGEPWR_TEXT"],
				'text2',self.rangedAPtotal.." ("..self.rangedAPbase.." base)"
			)
			cat:AddLine()
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGESKILL_TEXT"],
				'text2',self.rangedSkill.." ("..self.rangedSkillBase.." base)"
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGEATTACKSPEED"],
				'text2',format("%.2f",self.rangedSpeed)
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGEDMG_TEXT"],
				'text2',self.rangedLowDmg.." - "..self.rangedHiDmg
			)
			cat:AddLine(
				'text',L["CFU_SPACER"]..L["RANGEAVGDMG_TEXT"],
				'text2',format("%.1f",self.rangedAvgDmg)
			)
		else
			cat:AddLine()
		end
	end
	
--Spell
	cat = tablet:AddCategory(
		'text', "Spells: ",
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'columns', 2,
		'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
		'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
		'func', function() CombatInfoFu.db.profile.hideSpells = not CombatInfoFu.db.profile.hideSpells end,
		'hasCheck', true,
		'checked', true,
		'checkIcon', CombatInfoFu.db.profile.hideSpells and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
	)
	if CombatInfoFu.db.profile.hideSpells == false then
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["SPELL_DAMAGE_TEXT"],
			'text2', GetSpellBonusDamage(2)
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["SPELL_HEALING_TEXT"],
			'text2', GetSpellBonusHealing()
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["SPELL_HITRATING_TEXT"],
			'text2',GetCombatRating(CR_HIT_SPELL)
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["SPELL_PENETRATION_TEXT"],
			'text2', GetSpellPenetration()
		)
	else
		cat:AddLine()
	end
	
--Defense
	cat = tablet:AddCategory(
		'text', "Defense: ",
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'columns', 2,
		'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
		'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
		'func', function() CombatInfoFu.db.profile.hideDefense = not CombatInfoFu.db.profile.hideDefense end,
		'hasCheck', true,
		'checked', true,
		'checkIcon', CombatInfoFu.db.profile.hideDefense and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
	)
	if CombatInfoFu.db.profile.hideDefense == false then
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["ARMOR_TEXT"],
			'text2',self.armorEffective.." ("..self.armorBase.." base)"
		)
		cat:AddLine(
			'text',L["CFU_SPACER"].."Dmg vs. lvl "..self.playerLevel.." reduced by: ",
			'text2',format("%.2f%%",self.armorReduction)
		)
		cat:AddLine(
			'text',L["CFU_SPACER"]..L["DEFENSE_TEXT"],
			'text2',self.defenseTotal.." ("..self.defenseBase.." base)"
		)
		--[[cat:AddLine(
			'text',L["CFU_SPACER"]..L["RESILIENCE_TEXT"],
			'text2',format("%.2f%%",self:GetResilience())
		)]]
	else
		cat:AddLine()
	end
end
