
-- Load the needed libraries and create our plugin --
ChatLockFu = AceLibrary("AceAddon-2.0"):new(
	"AceConsole-2.0",
	"AceDB-2.0",
	"AceDebug-2.0",
	"FuBarPlugin-2.0"
)
local L = AceLibrary("AceLocale-2.2"):new("ChatLockFu")
local tablet = AceLibrary("Tablet-2.0")

-- Binding variables --
BINDING_HEADER_CHATLOCKFU = "ChatLockFu"
BINDING_NAME_LOCKCHATFRAMES = L["Lock Chat Frames"]

-- Set some misc. FuBar options --
ChatLockFu.cannotDetachTooltip = true
ChatLockFu.defaultPosition = "RIGHT"
ChatLockFu.hasIcon = "Interface\\AddOns\\FuBar_ChatLockFu\\icon.tga"

-- Get our settings DB ready --
local defaults = {
	["sound"] = "Interface\\AddOns\\FuBar_ChatLockFu\\sounds\\click.mp3",
	["playSound"] = true
}
ChatLockFu:RegisterDB("ChatLockFuDB")
ChatLockFu:RegisterDefaults("profile", defaults)

-- Easy chat lock function --
function ChatLockFu:ToggleChatLock()
	if CHAT_LOCKED == "1" then
		CHAT_LOCKED = "0"
	else
		CHAT_LOCKED = "1"
	end
end
	
-- Set up the menu/chat command options --
local optionsTable = {
	["handler"] = ChatLockFu,
	["type"] = 'group',
	["args"] = {
		["chat"] = {
			["type"] = 'toggle',
			["name"] = L["Chat Lock"],
			["desc"] = L["Toggle the lock on the chat frames."],
			["get"] = function()
				return (CHAT_LOCKED == "1")
			end,
			["set"] = "ToggleChatLock",
			["order"] = 1
		},
		["space"] = {
			["type"] = 'header',
			["order"] = 2
		},
		["sound"] = {
			["type"] = 'toggle',
			["name"] = L["Play Sound"],
			["desc"] = L["Toggles the sound effect when locking/unlocking."],
			["get"] = function()
				return ChatLockFu.db.profile.playSound
			end,
			["set"] = function()
				ChatLockFu.db.profile.playSound = not ChatLockFu.db.profile.playSound
			end,
			["order"] = 3
		}
	}
}
local chatCmd = {
	[1] = "/chatlockfu"
}
ChatLockFu:RegisterChatCommand(chatCmd, optionsTable)
ChatLockFu.OnMenuRequest = optionsTable

-- Start of actual functions --

-- Toggle the lock if we've been clicked --
function ChatLockFu:OnClick()
	self:ToggleChatLock()
	if self.db.profile.playSound then
		PlaySoundFile(self.db.profile.sound)
	end
end

-- Set up the tooltip --
function ChatLockFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	if CHAT_LOCKED == "1" then
		cat:AddLine(
			'text', L["Chat:"],
			'text2', "|cffff0000" .. L["Locked"] .. "|r"
		)
	else
		cat:AddLine(
			'text', L["Chat:"],
			'text2', "|cff00ff00" .. L["Unlocked"] .. "|r"
		)
	end
	tablet:SetHint(L["Left-click to toggle the chat frame lock."])
end
