local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

ChatAlertsFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1","AceConsole-2.0","FuBarPlugin-2.0","AceDB-2.0")

-- LOCAL VARIABLES
local optionsTable
local current_channelID = {}
local old_channels = {}

-- This is the default maximum number of channels I search
local maxAlertChannels = 10

-- This is where I name the default blizzard channels my custom names
local blizzard_chat_channels = {
	"General",
	"Trade",
	"LocalDefense",
	"WorldDefense",
	"GuildRecruitment",
}


-- EVENT LIST
-- Here is my custom groupings of the different chat events.
local events = {
  ['system'] = {
    "CHAT_MSG_SYSTEM",
    "CHAT_MSG_BG_SYSTEM_ALLIANCE",
    "CHAT_MSG_BG_SYSTEM_HORDE",
    "CHAT_MSG_BG_SYSTEM_NEUTRAL",
  --  "CHAT_MSG_SKILL",
    },
  ['whisper'] = {
    "CHAT_MSG_WHISPER",
    },
  ['party'] = {
    "CHAT_MSG_PARTY",
    },
  ['raid'] = {
    "CHAT_MSG_RAID",
   -- "CHAT_MSG_RAID_LEADER",
    },
  ['bg'] = {
     "CHAT_MSG_BATTLEGROUND",
   -- "CHAT_MSG_BATTLEGROUND_LEADER",
    },
  ['say'] = {
     "CHAT_MSG_SAY",
     "CHAT_MSG_YELL",
    },
  ['emote'] = {
    "CHAT_MSG_EMOTE",
    "CHAT_MSG_TEXT_EMOTE",
    },
  ['guild'] = {
    "CHAT_MSG_GUILD",
    "CHAT_MSG_OFFICER",
    },
  ['monster'] = {
    "CHAT_MSG_MONSTER_SAY",
    "CHAT_MSG_MONSTER_WHISPER",
    "CHAT_MSG_MONSTER_YELL",
    "CHAT_MSG_MONSTER_EMOTE",
    "CHAT_MSG_RAID_BOSS_EMOTE",
    },
  ['loot'] = {
	"CHAT_MSG_LOOT",
    },
  }

-- LOOT PATTERNS
-- Here is where I define which loot messages to show
local loot_strings = {
   item = { pattern = LOOT_ITEM:gsub('%%s', '(.*)'),
             multiple = false,
             self = false,
             roll = false,        
           },
   multiple = { pattern = LOOT_ITEM_MULTIPLE:gsub('%%s', '(.*)'):gsub('%%d', '(%%d+)'),
             multiple = true,
             self = false,         
             roll = false,
           },
   pushItem = { pattern = LOOT_ITEM_PUSHED_SELF:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = false,
           },
   pushMultiple = { pattern = LOOT_ITEM_PUSHED_SELF_MULTIPLE:gsub('%%s', '(.*)'):gsub('%%d', '(%%d+)'),
             multiple = true,
             self = true,         
             roll = false,
           },
   selfItem = { pattern = LOOT_ITEM_SELF:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = false,
           },
   selfMultiple = { pattern = LOOT_ITEM_SELF_MULTIPLE:gsub('%%s', '(.*)'):gsub('%%d', '(%%d+)'),
             multiple = true,
             self = true,         
             roll = false,
           },
   greed = { pattern = LOOT_ROLL_GREED:gsub('%%s', '(.*)'),
             multiple = false,
             self = false,         
             roll = "greed",
           },
   selfGreed = { pattern = LOOT_ROLL_GREED_SELF:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = "greed",
           },
   need = { pattern = LOOT_ROLL_NEED:gsub('%%s', '(.*)'),
             multiple = false,
             self = false,         
             roll = "need",
           },
   selfNeed = { pattern = LOOT_ROLL_NEED_SELF:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = "need",
           },
   won = { pattern = LOOT_ROLL_WON:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = "won",
           },
   selfWon = { pattern = LOOT_ROLL_YOU_WON:gsub('%%s', '(.*)'),
             multiple = false,
             self = true,         
             roll = "won",
           },
}


ChatAlertsFu.hasIcon = true

-- ON ENABLE
function ChatAlertsFu:OnEnable()
   self:EnableTextAlerts()
   self:UpdateAlertEvents()
   self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")
   self:RegisterEvent("PLAYER_ENTERING_WORLD","CHAT_MSG_CHANNEL_NOTICE")
   self:RegisterEvent("CHAT_MSG_CHANNEL")
end

-- ON INIT
function ChatAlertsFu:OnInitialize()
	self:RegisterDB("ChatAlertsFuDB")
	self:RegisterDefaults('char', {
	  msg = {
	    text = {
	       system = true,
	       whisper = true,
	       party = true,
	       raid = true,
	       bg = false,
	       say = false,
               emote = false,
               guild = false,
               monster = false,
               loot = true,
           },
	    sound = {
	       system = false,
	       whisper = true,
	       party = false,
	       raid = false,
	       bg = false,
	       say = false,
               emote = false,
               guild = false,
               monster = false,
               loot = false,
           },
        channel = {
                text = { },
                sound = { },
           },
        },
      scrollarea = {
	   system = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   whisper = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   party = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   raid = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   bg = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   say = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
           emote = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
           guild = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
           monster = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
           loot = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },
	   channels = {
                     sct = false,
                     msbt = false,
                     blizz = false,
                     default = true, 
			  },	          
           },

      drops = {
           minPlayer = 1,
           minOther = 1,
           onlyMyLoot = false,
           countEm = true,
           needy = true,
           },
      reportSpam = true,
      })
    optionsTable = {
    handler = ChatAlertsFu,
	type = 'group',
	args = {
      textalerts = {
		   type = 'group',
		   name = "Text Message Alerts",
		   order = 90,
		   desc = "Choose message types where you want text displayed.",
		   args = {
                    system = {
                      type = "toggle",
                      name = "System",
                      desc = "Toggle System Messages",
                      get = function() return self.db.char.msg.text.system end,
                      set = function(t) self.db.char.msg.text.system = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    whisper = {
                      type = "toggle",
                      name = "Whispers",
                      desc = "Toggle Whispers",
                      get = function() return self.db.char.msg.text.whisper end,
                      set = function(t) self.db.char.msg.text.whisper = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    party = {
                      type = "toggle",
                      name = "Party",
                      desc = "Toggle Party Messages",
                      get = function() return self.db.char.msg.text.party end,
                      set = function(t) self.db.char.msg.text.party = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    raid = {
                      type = "toggle",
                      name = "Raid",
                      desc = "Toggle Raid Messages",
                      get = function() return self.db.char.msg.text.raid end,
                      set = function(t) self.db.char.msg.text.raid = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    bg = {
                      type = "toggle",
                      name = "Battleground",
                      desc = "Toggle Battleground Messages",
                      get = function() return self.db.char.msg.text.bg end,
                      set = function(t) self.db.char.msg.text.bg = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    say = {
                      type = "toggle",
                      name = "Say",
                      desc = "Toggle Say Messages",
                      get = function() return self.db.char.msg.text.say end,
                      set = function(t) self.db.char.msg.text.say = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    emote = {
                      type = "toggle",
                      name = "Emotes",
                      desc = "Toggle Emote Messages",
                      get = function() return self.db.char.msg.text.emote end,
                      set = function(t) self.db.char.msg.text.emote = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    guild = {
                      type = "toggle",
                      name = "Guild",
                      desc = "Toggle Guild Messages",
                      get = function() return self.db.char.msg.text.guild end,
                      set = function(t) self.db.char.msg.text.guild = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    monster = {
                      type = "toggle",
                      name = "Monster",
                      desc = "Toggle Monster Messages",
                      get = function() return self.db.char.msg.text.monster end,
                      set = function(t) self.db.char.msg.text.monster = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    loot = {
                      type = "toggle",
                      name = "Loot",
                      desc = "Toggle Loot Messages",
                      get = function() return self.db.char.msg.text.loot end,
                      set = function(t) self.db.char.msg.text.loot = t; self:UpdateAlertEvents(); self:Update() end,
                      },
				   },
				},
      sound = {
		   type = 'group',
		   name = "Sound Alerts",
		   order = 91,
		   desc = "Choose message types where you to hear a notify sound.",
		   args = {
                    system = {
                      type = "toggle",
                      name = "System",
                      desc = "Toggle System Messages",
                      get = function() return self.db.char.msg.sound.system end,
                      set = function(t) self.db.char.msg.sound.system = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    whisper = {
                      type = "toggle",
                      name = "Whispers",
                      desc = "Toggle Whispers",
                      get = function() return self.db.char.msg.sound.whisper end,
                      set = function(t) self.db.char.msg.sound.whisper = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    party = {
                      type = "toggle",
                      name = "Party",
                      desc = "Toggle Party Messages",
                      get = function() return self.db.char.msg.sound.party end,
                      set = function(t) self.db.char.msg.sound.party = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    raid = {
                      type = "toggle",
                      name = "Raid",
                      desc = "Toggle Raid Messages",
                      get = function() return self.db.char.msg.sound.raid end,
                      set = function(t) self.db.char.msg.sound.raid = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    bg = {
                      type = "toggle",
                      name = "Battleground",
                      desc = "Toggle Battleground Messages",
                      get = function() return self.db.char.msg.sound.bg end,
                      set = function(t) self.db.char.msg.sound.bg = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    say = {
                      type = "toggle",
                      name = "Say",
                      desc = "Toggle Say Messages",
                      get = function() return self.db.char.msg.sound.say end,
                      set = function(t) self.db.char.msg.sound.say = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    emote = {
                      type = "toggle",
                      name = "Emotes",
                      desc = "Toggle Emote Messages",
                      get = function() return self.db.char.msg.sound.emote end,
                      set = function(t) self.db.char.msg.sound.emote = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    guild = {
                      type = "toggle",
                      name = "Guild",
                      desc = "Toggle Guild Messages",
                      get = function() return self.db.char.msg.sound.guild end,
                      set = function(t) self.db.char.msg.sound.guild = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    monster = {
                      type = "toggle",
                      name = "Monster",
                      desc = "Toggle Monster Messages",
                      get = function() return self.db.char.msg.sound.monster end,
                      set = function(t) self.db.char.msg.sound.monster = t; self:UpdateAlertEvents(); self:Update() end,
                      },
                    loot = {
                      type = "toggle",
                      name = "Loot",
                      desc = "Toggle Loot Messages",
                      get = function() return self.db.char.msg.sound.loot end,
                      set = function(t) self.db.char.msg.sound.loot = t; self:UpdateAlertEvents(); self:Update() end,
                      },
				   },
				},
 	  channels = {
		  type = 'group',
		  name = "Channel Alerts",
		  order = 92,
		  desc = "Set alerts for specific channels",
		  args = {
                    text = {
                    		type = 'group',
		                    name = "Text Message Alerts",
		               --     order = 99,
		                    desc = "Set text alerts for specific channels",
		                    args = {
                             -- blank until channels learned
		                    },
					},
                    sound = {
                    		type = 'group',
		                    name = "Sound Alerts",
		               --     order = 99,
		                    desc = "Set sounds for specific channels",
		                    args = {
							 -- blank until channels learned
		                    },
					},
		     },
	    },


      drops = {
		   type = 'group',
		   name = "Loot Options",
 		   order = 94,
		   desc = "Choose message types where you want text displayed.",
		   args = {
                   rarity = {
		      type = 'group',
		      name = "Minimum Rarity - Self",
 		      order = 90,
		      desc = "Choose the minimum rarity to alert when looting.",
		      args = {
                             poor  = {
                                       type = "toggle",
                                       name = "|cff9d9d9dPoor|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 99,
                                       get = function() if self.db.char.drops.minPlayer == 0 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 0; self:Update() end,
                                       },
                             common  = {
                                       type = "toggle",
                                       name = "|cffffffffCommon|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 98,
                                       get = function() if self.db.char.drops.minPlayer == 1 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 1; self:Update() end,
                                       },
                             uncommon  = {
                                       type = "toggle",
                                       name = "|cff1eff00Uncommon|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 97,
                                       get = function() if self.db.char.drops.minPlayer == 2 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 2; self:Update() end,
                                       },
                             rare  = {
                                       type = "toggle",
                                       name = "|cff0070ddRare|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 96,
                                       get = function() if self.db.char.drops.minPlayer == 3 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 3; self:Update() end,
                                       },
                             epic  = {
                                       type = "toggle",
                                       name = "|cffa334eeEpic|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 95,
                                       get = function() if self.db.char.drops.minPlayer == 4 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 4; self:Update() end,
                                       },
                             legendary  = {
                                       type = "toggle",
                                       name = "|cffff8000Legendary|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 94,
                                       get = function() if self.db.char.drops.minPlayer == 5 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 5; self:Update() end,
                                       },
                             artifact  = {
                                       type = "toggle",
                                       name = "|cffe6cc80Artifact|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 93,
                                       get = function() if self.db.char.drops.minPlayer == 6 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minPlayer = 6; self:Update() end,
                                       },
                             },
                      },
                   others = {
		      type = 'group',
		      name = "Minimum Rarity - Others",
 		      order = 91,
		      desc = "Choose the minimum rarity to alert when OTHERS are looting.",
		      args = {
                             poor  = {
                                       type = "toggle",
                                       name = "|cff9d9d9dPoor|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 99,
                                       get = function() if self.db.char.drops.minOther == 0 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 0; self:Update() end,
                                       },
                             common  = {
                                       type = "toggle",
                                       name = "|cffffffffCommon|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 98,
                                       get = function() if self.db.char.drops.minOther == 1 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 1; self:Update() end,
                                       },
                             uncommon  = {
                                       type = "toggle",
                                       name = "|cff1eff00Uncommon|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 97,
                                       get = function() if self.db.char.drops.minOther == 2 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 2; self:Update() end,
                                       },
                             rare  = {
                                       type = "toggle",
                                       name = "|cff0070ddRare|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 96,
                                       get = function() if self.db.char.drops.minOther == 3 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 3; self:Update() end,
                                       },
                             epic  = {
                                       type = "toggle",
                                       name = "|cffa334eeEpic|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 95,
                                       get = function() if self.db.char.drops.minOther == 4 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 4; self:Update() end,
                                       },
                             legendary  = {
                                       type = "toggle",
                                       name = "|cffff8000Legendary|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 94,
                                       get = function() if self.db.char.drops.minOther == 5 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 5; self:Update() end,
                                       },
                             artifact  = {
                                       type = "toggle",
                                       name = "|cffe6cc80Artifact|r",
		                       desc = "Choose the minimum rarity to alert when looting.",
                                       order = 93,
                                       get = function() if self.db.char.drops.minOther == 6 then return true; else return false; end end,
                                       set = function() self.db.char.drops.minOther = 6; self:Update() end,
                                       },
                             },
                      },
                   myloot  = {
                      type = "toggle",
                      name = "Show my loot only",
                      order = 93,
                      desc = "Toggle whether or not to show other looters or just your own.",
                      get = function() return self.db.char.drops.onlyMyLoot end,
                      set = function(t) self.db.char.drops.onlyMyLoot = t; self:Update() end,
                      },
                   count  = {
                      type = "toggle",
                      name = "Show total quanity",
                      order = 92,
                      desc = "Toggle whether the total quantity in your bags should be shown in the loot text alert.",
                      get = function() return self.db.char.drops.countEm end,
                      set = function(t) self.db.char.drops.countEm = t; self:Update() end,
                      },
                   needy  = {
                      type = "toggle",
                      name = "Show need and winner only",
                      order = 94,
                      desc = "Toggle whether to show only Need and Winner on rolls.",
                      get = function() return self.db.char.drops.needy end,
                      set = function(t) self.db.char.drops.needy = t; self:Update() end,
                      },
                   },
      },
      reportSpam  = {
                type = "toggle",
                name = "Auto-report Gold & Power-Level spam to GM",
                order = 95,
                desc = "Toggle whether or not to auto-report spam for gold or power leveling services. The auto-report simply opens up a GM ticket on your behalf reporting the offender.",
                get = function() return self.db.char.reportSpam end,
                set = function(t) self.db.char.reportSpam = t; self:Update() end,
                },      

	},}
    self:RegisterChatCommand({"/chatalerts", "/chatalert" }, optionsTable)
    self.OnMenuRequest = optionsTable
end

-- FUBAR
-- These are functions from the Fubar API
function ChatAlertsFu:OnDataUpdate()
  -- For now, do nothing on Data Update
end

function ChatAlertsFu:OnTextUpdate()
    self:SetText("ChatAlerts")
end

function ChatAlertsFu:OnTooltipUpdate()
    local cat = tablet:AddCategory(
      --  'text', "Event Types",
        'columns', 3,
        'child_textR', 1,
        'child_textG', 1,
        'child_textB', 0,
        'child_textR2', 1,
        'child_textG2', 1,
        'child_textB2', 1,
        'child_textR3', 1,
        'child_textG3', 1,
        'child_textB3', 1
    )

	cat:AddLine(
          'text', "|cFFFFFFFFEVENT|r",
          'text2', "|cFFFFFFFFTEXT|r",
          'text3', "|cFFFFFFFFSOUND|r"
           )

    local chat_type
    local text_status
    local sound_status
    
    for k,v in pairs(self.db.char.msg.text) do
      chat_type = strupper(k)..":"
      if v then text_status = "enabled"; else text_status = "|cFFFF0000disabled|r"; end
	  for b,z in pairs (self.db.char.msg.sound) do
	     if b == k then
            if z then sound_status = "enabled"; else sound_status = "|cFFFF0000disabled|r"; end
		 else
		    sound_status = "|cFFFF0000disabled|r";
		 end
	  end
	  cat:AddLine(
          'text', chat_type,
          'text2', text_status,
          'text3', sound_status
           )
    end


    local cat = tablet:AddCategory(
      --  'text', "Event Types",
        'columns', 3,
        'child_textR', 1,
        'child_textG', 1,
        'child_textB', 0,
        'child_textR2', 1,
        'child_textG2', 1,
        'child_textB2', 1,
        'child_textR3', 1,
        'child_textG3', 1,
        'child_textB3', 1
    )

	cat:AddLine(
          'text', "|cFFFFFFFFCHANNEL|r",
          'text2', "|cFFFFFFFFTEXT|r",
          'text3', "|cFFFFFFFFSOUND|r"
           )

	for id = 1,maxAlertChannels do
       local name = self:GetAlertChannelName(id)
	   if name then
         chat_type = name..":"
         if self.db.char.msg.channel.text[name] then text_status = "enabled"; else text_status = "|cFFFF0000disabled|r"; end
         if self.db.char.msg.channel.sound[name] then sound_status = "enabled"; else sound_status = "|cFFFF0000disabled|r"; end
	   	 cat:AddLine(
           'text', chat_type,
           'text2', text_status,
           'text3', sound_status
            )
	   end
	end
end

function ChatAlertsFu:OnClick()
    self:OpenMenu()
end


-- FIND CHAT TYPE
-- This is my function to find my defined type for event
function ChatAlertsFu:GetMyChatType(event)
   for type,v in pairs(events) do
      for num,check in pairs(v) do
        if event == check then
          return type
        end
      end
   end
end

-- SCT, MSBT, Default ST, or Error Frame
-- Enable up to 4 different methods for displaying text alerts
function ChatAlertsFu:EnableTextAlerts()
  if SCT then
     if SCT.DisplayMessage then
       self.sct_colors = { }
       function ChatAlertsFu:SCTmsg(msg, r, g, b)
         self.sct_colors = { ["r"] = r , ["g"] = g, ["b"] = b }
         SCT:DisplayMessage(msg, self.sct_colors)
       end
     end
  end

  if MikSBT then
     local scrollAreas = MikSBT.GetScrollAreaList()
     for k,v in pairs(scrollAreas) do
        local orig_scroll_name = v
        v = strlower(v)
        if v == "chatalertsfu" then
        self.MikSBTscrollArea = orig_scroll_name
        end
     end
     if not self.MikSBTscrollArea then
        self.MikSBTscrollArea = MikSBT.DISPLAYTYPE_NOTIFICATION 
     end
     if self.MikSBTscrollArea then
        function ChatAlertsFu:MikSBTmsg(msg, r, g, b)
           r = r * 255
           g = g * 255
           b = b * 255
           MikSBT.DisplayMessage(msg,self.MikSBTscrollArea,nil,r,g,b)
        end
     end
  end

  if CombatText_AddMessage then
      function ChatAlertsFu:BlizzardSCTmsg(msg, r, g, b)
        --ScrollingMessageFrame:AddMessage("text", r, g, b)  
        CombatText_AddMessage(msg, COMBAT_TEXT_SCROLL_FUNCTION, r, g, b)
      end
  end

  function ChatAlertsFu:DefaultUImsg(msg, r, g, b)
     UIErrorsFrame:AddMessage(msg, r, g, b, 1, 1.75);
  end
  self.AddMsg = {} 
  self:CreateAreaOptions()
end

function ChatAlertsFu:UpdateScrollArea(type)
    if self.db.char.scrollarea[type]["sct"] and self.SCTmsg then
      return
    elseif self.db.char.scrollarea[type]["msbt"] and self.MikSBTmsg then
      return
    elseif self.db.char.scrollarea[type]["blizz"] and self.BlizzardSCTmsg then
      return
    else
      self.db.char.scrollarea[type]["default"] = true
      return  
    end
end


function ChatAlertsFu:ResetScrollValues(type)
   self.db.char.scrollarea[type]["sct"] = false
   self.db.char.scrollarea[type]["msbt"] = false
   self.db.char.scrollarea[type]["blizz"] = false
   self.db.char.scrollarea[type]["default"] = false
end


function ChatAlertsFu:CreateAreaOptions()
  -- if any of the scrolling text types are available, create options
  if self.SCTmsg or self.MikSBTmsg or self.BlizzardSCTmsg then
    -- start by creating default options
    local scrollOptions = {
		   type = 'group',
		   name = "Alert Location",
		   order = 93,
		   desc = "Choose what method you would like to use for displaying text alerts. SCT, Mik's Scrolling Battle Text, Blizzard Scrolling Text, and the default UI are all supported.",
		   args = {
		       system = { type = 'group',
		                  name = "System Messages",
		                  --  order = 99,
		                  desc = "Choose method for System Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.system.default end,
                                         set = function() self:ResetScrollValues("system"); self.db.char.scrollarea.system.default = true; self:UpdateScrollArea("system"); self:Update() end,
                                        },   
                          },         
                        },                 
		       whisper = { type = 'group',
		                  name = "Whispers",
		                  --  order = 99,
		                  desc = "Choose method for Whispers",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.whisper.default end,
                                         set = function() self:ResetScrollValues("whisper"); self.db.char.scrollarea.whisper.default = true; self:UpdateScrollArea("whisper"); self:Update() end,
                                        },   
                          },         
                        },  
		       party = { type = 'group',
		                  name = "Party",
		                  --  order = 99,
		                  desc = "Choose method for Party Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.party.default end,
                                         set = function() self:ResetScrollValues("party"); self.db.char.scrollarea.party.default = true; self:UpdateScrollArea("party"); self:Update() end,
                                        },   
                          },         
                        },  
		       raid = { type = 'group',
		                  name = "Raid",
		                  --  order = 99,
		                  desc = "Choose method for Raid Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.raid.default end,
                                         set = function() self:ResetScrollValues("raid"); self.db.char.scrollarea.raid.default = true; self:UpdateScrollArea("raid"); self:Update() end,
                                        },   
                          },         
                        },  
		       bg = { type = 'group',
		                  name = "Battlegrounds",
		                  --  order = 99,
		                  desc = "Choose method for Battleground Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.bg.default end,
                                         set = function() self:ResetScrollValues("bg"); self.db.char.scrollarea.bg.default = true; self:UpdateScrollArea("bg"); self:Update() end,
                                        },   
                          },         
                        },  
		       say = { type = 'group',
		                  name = "Say",
		                  --  order = 99,
		                  desc = "Choose method for Say Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.say.default end,
                                         set = function() self:ResetScrollValues("say"); self.db.char.scrollarea.say.default = true; self:UpdateScrollArea("say"); self:Update() end,
                                        },   
                          },         
                        },  
		       emote = { type = 'group',
		                  name = "Emotes",
		                  --  order = 99,
		                  desc = "Choose method for Emotes",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.emote.default end,
                                         set = function() self:ResetScrollValues("emote"); self.db.char.scrollarea.emote.default = true; self:UpdateScrollArea("emote"); self:Update() end,
                                        },   
                          },         
                        },  
		       guild = { type = 'group',
		                  name = "Guild",
		                  --  order = 99,
		                  desc = "Choose method for Guild Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.guild.default end,
                                         set = function() self:ResetScrollValues("guild"); self.db.char.scrollarea.guild.default = true; self:UpdateScrollArea("guild"); self:Update() end,
                                        },   
                          },         
                        },  
		       monster = { type = 'group',
		                  name = "Monster",
		                  --  order = 99,
		                  desc = "Choose method for Monster Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.monster.default end,
                                         set = function() self:ResetScrollValues("monster"); self.db.char.scrollarea.monster.default = true; self:UpdateScrollArea("monster"); self:Update() end,
                                        },   
                          },         
                        },  
		       loot = { type = 'group',
		                  name = "Loot",
		                  --  order = 99,
		                  desc = "Choose method for Loot Messages",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.loot.default end,
                                         set = function() self:ResetScrollValues("loot"); self.db.char.scrollarea.loot.default = true; self:UpdateScrollArea("loot"); self:Update() end,
                                        },   
                          },         
                        },      
		       channels = { type = 'group',
		                  name = "Channel Alerts",
		                  --  order = 99,
		                  desc = "Choose method for displaying default and custom Channels (General, Trade, etc.)",
		                  args = {
                              default = {
                                         type = "toggle",
                                         name = "Default UI Frame",
                                         desc = "Use the default UI Error Frame to display text alerts",
                                         get = function() return self.db.char.scrollarea.channels.default end,
                                         set = function() self:ResetScrollValues("channels"); self.db.char.scrollarea.channels.default = true; self:UpdateScrollArea("channels"); self:Update() end,
                                        },   
                          },         
                        },
                  },
           }
     
       -- and end by inserting options for SCT, MSBT or Blizzard CT 
       for k,v in pairs(scrollOptions.args) do
         if self.SCTmsg then
            scrollOptions.args[k]["args"]["sct"] = {
               type = "toggle",
               name = "SCT - Scrolling Combat Text",
               desc = "Use SCT to display text alerts.",
               get = function() return self.db.char.scrollarea[k]["sct"] end,
               set = function() self:ResetScrollValues(k); self.db.char.scrollarea[k]["sct"] = true; self:UpdateScrollArea(k); self:Update() end,
           }
         end
         if self.MikSBTmsg then
            scrollOptions.args[k]["args"]["msbt"] = {
               type = "toggle",
               name = "Mik's Scrolling Battle Text",
               desc = "Use MSBT to display text alerts.",
               get = function() return self.db.char.scrollarea[k]["msbt"] end,
               set = function() self:ResetScrollValues(k); self.db.char.scrollarea[k]["msbt"] = true; self:UpdateScrollArea(k); self:Update() end,
           }
         end
         if self.BlizzardSCTmsg then
            scrollOptions.args[k]["args"]["blizz"] = {
               type = "toggle",
               name = "Blizzard Scrolling Text",
               desc = "Use the Blizzard Scrolling Text to display text alerts.",
               get = function() return self.db.char.scrollarea[k]["blizz"] end,
               set = function() self:ResetScrollValues(k); self.db.char.scrollarea[k]["blizz"] = true; self:UpdateScrollArea(k); self:Update() end,
           }
         end 
         self:UpdateScrollArea(k)
       end
     optionsTable.args["scrollareas"] = scrollOptions
   -- if the other text alert areas are unavailable, just setup the default UI error frame
   else
      self:UpdateScrollArea("system")
      self:UpdateScrollArea("whisper")
      self:UpdateScrollArea("party")
      self:UpdateScrollArea("raid")
      self:UpdateScrollArea("bg")
      self:UpdateScrollArea("say")
      self:UpdateScrollArea("emote")
      self:UpdateScrollArea("guild")
      self:UpdateScrollArea("monster")
      self:UpdateScrollArea("loot")
      self:UpdateScrollArea("channels")
   end
end


-- TEXT ALERTS
-- This is my function to display chat messages in the Error Frame as alerts
function ChatAlertsFu:ChatAlertMessage(msg,author,event,id)
    -- determine if id is a channel or type
    -- channels are numbers, types are not
	local type = "channels"
	if not (string.find(id, '%d')) then
	   type = id
       id = nil
	end
    -- set colors based on chat frames
    local r, g, b = self:GetColorsFromChatUI(event,id)
    -- check to see if there is an author
    local person = true
    if not author or (strlen(author) == 0) then
  	    person = false
    end
    -- display message 
    if person then
       msg = author .. ":  " .. msg
    end
    if self.db.char.scrollarea[type]["sct"] and self.SCTmsg then
      self:SCTmsg(msg, r, g, b)
    elseif self.db.char.scrollarea[type]["msbt"] and self.MikSBTmsg then
      self:MikSBTmsg(msg, r, g, b)
    elseif self.db.char.scrollarea[type]["blizz"] and self.BlizzardSCTmsg then
      self:BlizzardSCTmsg(msg, r, g, b)
    else
      self.db.char.scrollarea[type]["default"] = true
      self:DefaultUImsg(msg, r, g, b)    
    end
end


-- TEXT MESSAGE COLORS
-- This is my attempt at making the text alerts the same color as the Chat frame
function ChatAlertsFu:GetColorsFromChatUI(event,id)
    local color
	if id then
      color = ChatTypeInfo["CHANNEL"..id];
    elseif ( strsub(event, 1, 8) == "CHAT_MSG" ) then
      local type = strsub(event, 10);
      color = ChatTypeInfo[type];
    end
    if color then
	  return color.r, color.g, color.b
	else
	  return 0.9, 0.9, 0.9
	end
end


-- CHANNEL FUNCTIONS
-- I use this function to build a custom list of ids
function ChatAlertsFu:RefreshChannelIDs()
   current_channelID = { }
   local id, name, found
   for i = 1,maxAlertChannels do
     id, name = GetChannelName(i);
     if (id > 0 and name ~= nil) then
	 -- channel exists
        current_channelID[id] = name
	 else
	 -- channel does not exist
	    current_channelID[id] = nil
     end
   end
end


-- This function gets MY name for the channel
function ChatAlertsFu:GetAlertChannelName(id)
		local name = current_channelID[id]
		if name then
		  for k,v in pairs(blizzard_chat_channels) do
		     if string.find(name, v) then
			    name = v
             end
		  end
		  return name
		else
		  return name
		end
end


-- This checks to see if the channel is in MY list of active IDs
function ChatAlertsFu:IsActiveChannel(name)
   local found = false
   for i = 1,maxAlertChannels do
	   local name_check = ChatAlertsFu:GetAlertChannelName(i)
       if name == name_check then
		 found = true
       end
   end
   return found
end

-- This function updates my list of IDs and updates my Fubar
function ChatAlertsFu:CHAT_MSG_CHANNEL_NOTICE()
     self:RefreshChannelIDs()
	 local name
	 for id = 1,maxAlertChannels do
         name = self:GetAlertChannelName(id)
         if name then
           if self.db.char.msg.channel.text[name] == nil then
              self.db.char.msg.channel.text[name] = false
           end
           if self.db.char.msg.channel.sound[name] == nil then
              self.db.char.msg.channel.sound[name] = false
           end
	   if (optionsTable.args.channels.args.text.args[name] == nil and optionsTable.args.channels.args.sound.args[name] == nil) or (old_channels[name]) then
              old_channels[name] = false
              self:InsertCustomChannelOpts(name)
	   end
        end
     end
     -- removed code that used to remove channels from options list
     -- this will happen on it's own whenever someone reloads UI
end


-- INSERT AND REMOVING CHANNELS FROM FUBAR
-- These Insert and Remove function are what I use to put custom channels
-- into and out of the options menu
function ChatAlertsFu:InsertCustomChannelOpts(name)
   local desc_text = "Toggle text for "..name
   local text_opts = {
                      type = "toggle",
                      name = name,
                      desc = desc_text,
                      get = function() return self.db.char.msg.channel.text[name] end,
                      set = function(t) self.db.char.msg.channel.text[name] = t; self:Update() end,
                 }
   local desc_sound = "Toggle sound for "..name
   local sound_opts = {
                      type = "toggle",
                      name = name,
                      desc = desc_sound,
                      get = function() return self.db.char.msg.channel.sound[name] end,
                      set = function(t) self.db.char.msg.channel.sound[name] = t; self:Update() end,
                 }
   optionsTable.args.channels.args.text.args[name] = text_opts;
   optionsTable.args.channels.args.sound.args[name] = sound_opts;
end

function ChatAlertsFu:RemoveAlertChannel(name)
    old_channels[name] = true
    optionsTable.args.channels.args.text.args[name] = {}
    optionsTable.args.channels.args.sound.args[name] = {}
end


-- IS CHANNEL ON ALERT
-- These are used to tell if a channel is enabled for Text or Sound alerts
function ChatAlertsFu:IsChannelTextAlert(id)
      local name = self:GetAlertChannelName(id)
	  if self.db.char.msg.channel.text[name] then
		 return true
	  else
		 return false
	  end
end

function ChatAlertsFu:IsChannelSoundAlert(id)
      local name = self:GetAlertChannelName(id)
	  if self.db.char.msg.channel.sound[name] then
		 return true
	  else
		 return false
	  end
end


-- EVENT REGISTRATION
-- Register or uregister events based on what is enabled
function ChatAlertsFu:UpdateAlertEvents()
   for k,v in pairs(events) do
     if self.db.char.msg.text[k] or self.db.char.msg.sound[k] then
	   -- check to see that it is registered and register if not
       for num,event in pairs(v) do
	 if not self:IsEventRegistered(event) then
           self:RegisterEvent(event)
	 end
       end
     else
       -- check to see that it is registered and unregister
       for num,event in pairs(v) do
	 if self:IsEventRegistered(event) then
           self:UnregisterEvent(event)
	     end
 	 end
       end
   end
end

-- EVENT HANDLER
-- Determines if text alert or sound to be played (or both)
function ChatAlertsFu:ChatEventHandler(message,author,event)
   if not (UnitName("player") == author) then
     local text = false
     local sound = false
     local type = self:GetMyChatType(event)
     if self.db.char.msg.text[type] then text = true; end
     if self.db.char.msg.sound[type] then sound = true; end
     if text then self:ChatAlertMessage(message,author,event,type); end
     if sound then PlaySoundFile("Interface\\AddOns\\Fubar_ChatAlertsFu\\blip.wav"); end
   end
end

-- ON CHAT EVENT FUNCTIONS
-- This first one is for handling channels and acts it's own event handler
function ChatAlertsFu:CHAT_MSG_CHANNEL(message,author,arg3,arg4,arg5,arg6,arg7,id)
   if not (UnitName("player") == author) then
     local isSpam
     if self:IsChannelTextAlert(id) then
          if self:SpamBot(message,author) then
            self:ChatAlertMessage(message,author,"CHAT_MSG_CHANNEL",id)
	        isSpam = false
          else
	        isSpam = true
	  end
     end
     if self:IsChannelSoundAlert(id) then
          if isSpam == nil then
             isSpam = self:SpamBot(message,author)
	  end
          if not isSpam then
            PlaySoundFile("Interface\\AddOns\\Fubar_ChatAlertsFu\\blip.wav")
	  end
     end
   end
end

-- These ones all use the ChatEventHandler function
function ChatAlertsFu:CHAT_MSG_SYSTEM(message)
   self:ChatEventHandler(message,nil,"CHAT_MSG_SYSTEM")
end

function ChatAlertsFu:CHAT_MSG_BG_SYSTEM_ALLIANCE(message)
   self:ChatEventHandler(message,nil,"CHAT_MSG_BG_SYSTEM_ALLIANCE")
end

function ChatAlertsFu:CHAT_MSG_BG_SYSTEM_HORDE(message)
   self:ChatEventHandler(message,nil,"CHAT_MSG_BG_SYSTEM_HORDE")
end

function ChatAlertsFu:CHAT_MSG_BG_SYSTEM_NEUTRAL(message)
   self:ChatEventHandler(message,nil,"CHAT_MSG_BG_SYSTEM_NEUTRAL")
end

function ChatAlertsFu:CHAT_MSG_SKILL(message)
   self:ChatEventHandler(message,nil,"CHAT_MSG_SKILL")
end

function ChatAlertsFu:CHAT_MSG_WHISPER(message,author)
  if not self:SpamBot(message,author) then
     self:ChatEventHandler(message,author,"CHAT_MSG_WHISPER")
  end
end

function ChatAlertsFu:CHAT_MSG_PARTY(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_PARTY")
end

function ChatAlertsFu:CHAT_MSG_RAID(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_RAID")
end

function ChatAlertsFu:CHAT_MSG_BATTLEGROUND(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_BATTLEGROUND")
end

function ChatAlertsFu:CHAT_MSG_BATTLEGROUND_LEADER(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_BATTLEGROUND_LEADER")
end

function ChatAlertsFu:CHAT_MSG_SAY(message,author)
  if not self:SpamBot(message,author) then
     self:ChatEventHandler(message,author,"CHAT_MSG_SAY")
  end
end

function ChatAlertsFu:CHAT_MSG_YELL(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_YELL")
end

function ChatAlertsFu:CHAT_MSG_EMOTE(message)
   local author = "Alert"
   self:ChatEventHandler(message,author,"CHAT_MSG_EMOTE")
end

function ChatAlertsFu:CHAT_MSG_TEXT_EMOTE(message)
   self:ChatEventHandler(message,author,"CHAT_MSG_TEXT_EMOTE")
end

function ChatAlertsFu:CHAT_MSG_GUILD(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_GUILD")
end

function ChatAlertsFu:CHAT_MSG_OFFICER(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_OFFICER")
end

function ChatAlertsFu:CHAT_MSG_MONSTER_SAY(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_MONSTER_SAY")
end

function ChatAlertsFu:CHAT_MSG_MONSTER_WHISPER(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_MONSTER_WHISPER")
end

function ChatAlertsFu:CHAT_MSG_MONSTER_YELL(message,author)
   self:ChatEventHandler(message,author,"CHAT_MSG_MONSTER_YELL")
end

function ChatAlertsFu:CHAT_MSG_MONSTER_EMOTE(message,author)
   message = message:gsub('%%s', author)
   self:ChatEventHandler(message,nil,"CHAT_MSG_MONSTER_EMOTE")
end

function ChatAlertsFu:CHAT_MSG_RAID_BOSS_EMOTE(message,author)
   message = message:gsub('%%s', author)
   self:ChatEventHandler(message,nil,"CHAT_MSG_RAID_BOSS_EMOTE")
end

function ChatAlertsFu:CHAT_MSG_LOOT(message)
   local item_link, item_name, rarity, qty, count, who, roll
   for k,v in pairs(loot_strings) do
      if message:find(v.pattern) then
         if not v.self then
            if v.multiple then
              who, item_link, qty = message:match(v.pattern)
            else
              who, item_link = message:match(v.pattern)
              qty = 1
            end
         else
            if v.multiple then
              item_link, qty = message:match(v.pattern)
              who = "You"
            else
              item_link = message:match(v.pattern)
              qty = 1
              who = "You"
            end
         end
        if v.roll then roll = v.roll; end
          item_name, _, rarity = GetItemInfo(item_link)
          count = qty + GetItemCount(item_link)
	end
   end
   if item_name and count and who then
     local min_quality
     if who == "You" then
        if (self.db.char.drops.countEm) and (count > 1) then message = message.." |cFFFFFF00("..count..")|r"; end
        min_quality = self.db.char.drops.minPlayer
     elseif not self.db.char.drops.onlyMyLoot then
        min_quality = self.db.char.drops.minOther
     else
        min_quality = 8        
     end
     if roll then
       if roll == "need" then
          message = string.gsub(message, "Need", "|cFFFFFFFFNEED|r")
       end
       if self.db.char.drops.needy then
         if roll == "need" or roll == "won" then
           self:ChatEventHandler(message,nil,"CHAT_MSG_LOOT")
         end
       else
         self:ChatEventHandler(message,nil,"CHAT_MSG_LOOT")
       end
     elseif rarity >= min_quality then
       self:ChatEventHandler(message,nil,"CHAT_MSG_LOOT")
     end 
   else
     return
   end
end


-- This function checks for gold spam and reports them
-- Any msg with www. that includes gold or power will be reported
function ChatAlertsFu:SpamBot(msg,author)
  local spambot = msg:lower()
  if spambot:find("www.") or spambot:find("ww2.") or spambot:find(".com") or spambot:find(". c o m") then
     if spambot:find("gold") or spambot:find("power") then
       spambot = true
     else
       spambot = false
     end
  else
     spambot = false
  end
  if spambot and self.db.char.reportSpam then
    local gm_msg = "The player, "..author..", is a spambot and sent me the following tell: "..msg.." - (just reporting it, no need to contact me)"
    local my_msg = "|cFFFFFF00ChatAlertsFu:|r The message from |cFFFF00FF"..author.."|r appears to be spam and a GM ticket has been opened to report it. If this is not spam, close the ticket.";
    NewGMTicket(2,gm_msg)
    DEFAULT_CHAT_FRAME:AddMessage(my_msg);
  end
  return spambot;
end


-- Simple formatted message for debugging
function ChatAlertsFu:DebugMsgText(text)
   text = "|cFFFFFF00SID67 DEBUG:|r "..text;
   DEFAULT_CHAT_FRAME:AddMessage(text);
end