local Tablet = AceLibrary("Tablet-2.0")

CharmsFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceConsole-2.0")

CharmsFu.version = "0.2" .. string.sub("$Revision: 25921 $", 12, -3)
CharmsFu.date = string.sub("$Date: 2007-02-26 12:00:43 -0500 (Mon, 26 Feb 2007) $", 8, 17)
CharmsFu.hasNoText = true
CharmsFu.hideWithoutStandby = true
CharmsFu.hasIcon = false
CharmsFu.frame = CharmsFu:CreateBasicPluginFrame("FuBar_CharmsFuFrame")

CharmsFu:RegisterDB("CharmsFuDB")
CharmsFu:RegisterDefaults("profile", {
	buttonSize = 3,
	buttonSpacing = 1,
	visible = {
		["Star"] = true,
		["Circle"] = true,
		["Diamond"] = true,
		["Triangle"] = true,
		["Moon"] = true,
		["Square"] = true,
		["Cross"] = true,
		["Skull"] = true,
		["None"] = true,
		["AutoCharms"] = true,
	},
})


local L = AceLibrary("AceLocale-2.2"):new("FuBar_CharmsFu")
local _G = getfenv(0)

local buttons = {
	{
		id = "Star",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm1.tga",
		exec = function() SetRaidTarget("target", 1); end,
		key  = "RAIDTARGET1",
		name = "Yellow 4-point Star",
		tip  = "Click to place Star on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Circle",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm2.tga",
		exec = function() SetRaidTarget("target", 2); end,
		key  = "RAIDTARGET2",
		name = "Orange Circle",
		tip  = "Click to place Circle on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Diamond",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm3.tga",
		exec = function() SetRaidTarget("target", 3); end,
		key  = "RAIDTARGET3",
		name = "Purple Diamond",
		tip  = "Click to place Diamond on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Triangle",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm4.tga",
		exec = function() SetRaidTarget("target", 4); end,
		key  = "RAIDTARGET4",
		name = "Green Triangle",
		tip  = "Click to place Triangle on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Moon",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm5.tga",
		exec = function() SetRaidTarget("target", 5); end,
		key  = "RAIDTARGET5",
		name = "White Crescent Moon",
		tip  = "Click to place Moon on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Square",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm6.tga",
		exec = function() SetRaidTarget("target", 6); end,
		key  = "RAIDTARGET6",
		name = "Blue Square",
		tip  = "Click to place Square on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Cross",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm7.tga",
		exec = function() SetRaidTarget("target", 7); end,
		key  = "RAIDTARGET7",
		name = "Red X",
		tip  = "Click to place Cross on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "Skull",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm8.tga",
		exec = function() SetRaidTarget("target", 8); end,
		key  = "RAIDTARGET8",
		name = "White Skull",
		tip  = "Click to place Skull on your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "None",
		icon = "Interface\\AddOns\\Fubar_CharmsFu\\Charms\\charm0.tga",
		exec = function() SetRaidTarget("target", 0); end,
		key  = "RAIDTARGETNONE",
		name = "No Icon",
		tip  = "Remove icons from your target",
	--	texcoord = {0.1, 0.9, 0.1, 0.9},
	},
	{
		id = "AutoCharms",
		icon = "Interface\\Buttons\\UI-MicroButton-Help-Up",
		exec = function() CharmsFu:AutoTargets(); end,
		key  = "",
		name = "Auto Charms",
		tip  = "Click to auto assign icons for your group. Icons are placed on each members current TARGET. If in a RAID, only officer TARGETs will be assigned.",
		texcoord = {0.1, 0.9, 0.5, 0.9},
	},
}

local options = {
	handler = CharmsFu,
	type = 'group',
	args = {
		spacing = {
			type = 'range',
			name = L["Button Spacing"],
			desc = L["Set Button Spacing"],
			min  = 0,
			max  = 10,
			step = 0.5,
			set  = function(size) CharmsFu:SetButtonSpacing(size) end,
			get  = function() return CharmsFu:GetButtonSpacing() end,
		},
		visibility = {
			type = 'group',
			name = L["Button Visibility"],
			desc = L["Toggle Button Visibility"],
			args = {
			}
		},
	},
}

for _, data in ipairs(buttons) do
	local name = data.id
	local key_name = string.gsub(name, "%s+", "-")
	local button_name = name

	local subtbl = {}
	options.args.visibility.args[key_name] = subtbl
	subtbl.type = "toggle"
	subtbl.name = data.name
	subtbl.desc = string.format(L["Toggle visibility of %s"], data.name)
	subtbl.get = function() return CharmsFu:IsShowingButton(button_name) end
	subtbl.set = function() CharmsFu:ToggleShowingButton(button_name) end
end

CharmsFu.OnMenuRequest = options
CharmsFu:RegisterChatCommand({ "/charmsfu" }, options)

function CharmsFu:OnEnable()
	self.fontSize = FuBar:GetFontSize()
	self:BuildButtons()
end

function CharmsFu:IsShowingButton(button)
	return self.db.profile.visible[button]
end

function CharmsFu:ToggleShowingButton(button)
	self.db.profile.visible[button] = not self.db.profile.visible[button]
	self:CheckWidth(true)
	return self.db.profile.visible[button]
end

function CharmsFu:OnTooltipUpdate()
	if self.current_mouseover then
		local data
		for _,v in ipairs(buttons) do
			if v.id == self.current_mouseover then
				data = v
				break
			end
		end
		if not data then
			return
		end
		local key = GetBindingKey(data.key)
		if key then
			key = " (" .. key .. ")"
		else
			key = ""
		end
		Tablet:SetTitle(format("|cffffffff%s|r%s", data.name, key))
		Tablet:AddCategory():AddLine(
			'text', data.tip,
			'wrap', true
		)
	end
end

function CharmsFu:GetButtonSpacing()
	return self.db.profile.buttonSpacing
end

function CharmsFu:SetButtonSpacing(spacing)
	if spacing then
		self.db.profile.buttonSpacing = spacing
		self:SetFontSize(self.fontSize)
	end
end

function CharmsFu:BuildButtons()
	local last
	local frameWidth = 0
	for _, data in ipairs(buttons) do
		local name = data.id
		if self:IsShowingButton(name) then
			local button_name = name
			local frame_name = "CharmsFuFrame" .. name
			local button = _G[frame_name] or self:CreatePluginChildFrame("Button", frame_name, self.frame)
			button:Show()
			button:EnableMouse(true)
			if last then
				button:SetPoint("LEFT", last, "RIGHT", self:GetButtonSpacing(), 0)
			else
				button:SetPoint("LEFT", self.frame, "LEFT", self:GetButtonSpacing(), 0)
			end

			local texture = _G[frame_name .. "Texture"] or button:CreateTexture(frame_name .. "Texture")
			texture:SetTexture(data.icon)
			if data.texcoord then
				texture:SetTexCoord(unpack(data.texcoord))
			end

			texture:SetAllPoints(button)

			local OnEnter = button:GetScript("OnEnter")
			button:SetScript("OnEnter", function()
				self.current_mouseover = button_name
				OnEnter()
			end)

			local OnLeave = button:GetScript("OnLeave")
			button:SetScript("OnLeave", function()
				self.current_mouseover = nil
				OnLeave()
			end)

			button:SetScript("OnClick", data.exec)

			button:SetWidth(FuBar:GetFontSize())
			button:SetHeight(FuBar:GetFontSize())
			frameWidth = frameWidth + button:GetWidth() + self:GetButtonSpacing()

			last = button
		else
			local button = _G["CharmsFuFrame" .. name]
			if button then
				button:Hide()
			end
		end
	end

	if frameWidth > 0 then
		self:SetFontSize(self.fontSize)
	else
		self:ToggleShowingButton("Star")
		self:BuildButtons()
	end
end

function CharmsFu:CheckWidth(force)
	if force then
		self:SetFontSize(self.fontSize)
		if self.panel and self.panel:GetPluginSide(self) == "CENTER" then
			self.panel:UpdateCenteredPosition()
		end
	end
end

function CharmsFu:SetFontSize(fsize)
	if fsize then
		local frameWidth = 0
		local last
		local newIconSize = FuBar:GetFontSize()
		for _, v in ipairs(buttons) do
			local name = v.id
			local button = _G["CharmsFuFrame" .. name]
			if button then
				if self:IsShowingButton(name) then
					button:SetWidth(newIconSize)
					button:SetHeight(newIconSize)
					button:Show()

					if last then
						button:SetPoint("LEFT", last, "RIGHT", self:GetButtonSpacing(), 0)
					else
						button:SetPoint("LEFT", self.frame, "LEFT", self:GetButtonSpacing(), 0)
					end

					frameWidth = frameWidth + button:GetWidth() + self:GetButtonSpacing()
					last = button
				else
					button:Hide()
				end
			end
		end

		self.fontSize = fsize
		self.frame:SetWidth(frameWidth)
	end
end

-- All code below this line is to support AutoTargets
--
function CharmsFu:AutoTargets()
   local oType = CharmsFu:GetGroupType()
   if oType == "raid" then
      CharmsFu:AutoForRaid();
   elseif oType == "party" then
      CharmsFu:AutoForParty();
   end
end

function CharmsFu:GetGroupType()
    if UnitInRaid("player") then
       if IsRaidOfficer() or IsRaidLeader() then
          local oType = "raid";
           return oType;
       end
    elseif UnitInParty("player") then
       if UnitIsPartyLeader("player") then
          local oType = "party";
           return oType;
       end
    end
end

-- Auto assign icons for raid officers
function CharmsFu:AutoForRaid()
   local oIcon = {}
   local oMax = GetNumRaidMembers();
   -- set officer icons by class
   for oNum = 1,oMax do
      local _,oRank,_,_,_,oClass = GetRaidRosterInfo(oNum);
      if oRank > 0 then
         -- mage1 is moon
	     if oClass == "MAGE" and (oIcon[5] == nil) then        
            oIcon[5] = oNum
	     -- mage2 is square
	     elseif oClass == "MAGE" and (oIcon[6] == nil) then        
            oIcon[6] = oNum
	     -- mage3 is triangle
	     elseif oClass == "MAGE" and (oIcon[4] == nil) then        
            oIcon[4] = oNum
	     -- warlock is cross
	     elseif oClass == "WARLOCK" and (oIcon[7] == nil) then        
            oIcon[7] = oNum    
	     -- hunter is diamond
	     elseif oClass == "HUNTER" and (oIcon[5] == nil) then        
            oIcon[3] = oNum
	     -- hunter is diamond
	     elseif oClass == "ROGUE" and (oIcon[1] == nil) then        
            oIcon[1] = oNum        
	     -- priest is circle
	     elseif oClass == "PRIEST" and (oIcon[2] == nil) then        
            oIcon[2] = oNum    
         end
      end   
   end
   -- check for officers that didn't get an icon and assign them an empty one
   for oNum = 1,oMax do
      local _,oRank = GetRaidRosterInfo(oNum);
	  local oHasIcon = false
	  if oRank > 0 then
      -- check to see if icon exists
        for oIndex = 1,7 do 
             if oIcon[oIndex] == oNum then
                oHasIcon = true
             end
        end
      -- assign an icon
        if oHasIcon == false then
            local oIndex = 1
  	    while oIndex < 8 do 
		  if oIcon[oIndex] == nil then
		      oIcon[oIndex] = oNum;
		      oIndex = 8;
		  end
		  oIndex = oIndex + 1;
            end
        end
      end
   end    
   -- create icons (last one will get the icon)
     -- priority is based on icon type
     -- moon, square, triangle, cross, diamond, star, circle
   CharmsFu:CreateIcon(oIcon[2],2,"raid");
   CharmsFu:CreateIcon(oIcon[1],1,"raid");
   CharmsFu:CreateIcon(oIcon[3],3,"raid");
   CharmsFu:CreateIcon(oIcon[7],7,"raid");
   CharmsFu:CreateIcon(oIcon[4],4,"raid");
   CharmsFu:CreateIcon(oIcon[6],6,"raid");
   CharmsFu:CreateIcon(oIcon[5],5,"raid");
end


-- Auto assign icons for party members
function CharmsFu:AutoForParty()
DEFAULT_CHAT_FRAME:AddMessage("Autoparty");
   local oIcon = {}
   -- set party icons by class
   -- party5 assigned to 'player'
   for oNum = 1,5 do
      local oClass = nil
      if oNum == 5 then 
	     oNum = "player";
	     _,oClass = UnitClass(oNum);
	  elseif UnitExists("party"..oNum) then
             _,oClass = UnitClass("party"..oNum);
	  end
      -- mage1 is moon
      if oClass == "MAGE" and (oIcon[5] == nil) then        
         oIcon[5] = oNum
      -- mage2 is square
      elseif oClass == "MAGE" and (oIcon[6] == nil) then        
         oIcon[6] = oNum
      -- mage3 is triangle
      elseif oClass == "MAGE" and (oIcon[4] == nil) then        
         oIcon[4] = oNum
      -- warlock is cross
      elseif oClass == "WARLOCK" and (oIcon[7] == nil) then        
         oIcon[7] = oNum    
      -- hunter is diamond
      elseif oClass == "HUNTER" and (oIcon[5] == nil) then        
         oIcon[3] = oNum
      -- hunter is star
      elseif oClass == "ROGUE" and (oIcon[1] == nil) then        
         oIcon[1] = oNum        
      -- priest is circle
      elseif oClass == "PRIEST" and (oIcon[2] == nil) then        
         oIcon[2] = oNum    
      end
   end
   -- check for party members that didn't get an icon
   -- party5 assigned to 'player'
   for oNum = 1,5 do
      local oHasIcon = false
      if oNum == 5 then
	    oNum = "player";
	  elseif not UnitExists("party"..oNum) then
	    -- party member doesn't exist
	    oHasIcon = true;
      end
      -- check to see if icon exists
      for oIndex = 1,7 do 
             if oIcon[oIndex] == oNum then
                oHasIcon = true
             end
      end
      -- assign an icon
      if oHasIcon == false then
          local oIndex = 1
          while oIndex < 8 do 
	       if oIcon[oIndex] == nil then
	         oIcon[oIndex] = oNum;
	         oIndex = 8;
	       end
	       oIndex = oIndex + 1;
          end
      end
   end    
   -- create icons (last one will get the icon)
     -- priority is based on icon type
     -- moon, square, triangle, cross, diamond, star, circle
   CharmsFu:CreateIcon(oIcon[2],2,"party");
   CharmsFu:CreateIcon(oIcon[1],1,"party");
   CharmsFu:CreateIcon(oIcon[3],3,"party");
   CharmsFu:CreateIcon(oIcon[7],7,"party");
   CharmsFu:CreateIcon(oIcon[4],4,"party");
   CharmsFu:CreateIcon(oIcon[6],6,"party");
   CharmsFu:CreateIcon(oIcon[5],5,"party");
end


-- display an icon for party/raid num or player
-- don't display icon if target is a player
function CharmsFu:CreateIcon(oNum,oIconNum,oType)
    local oTarget = nil
    if oNum and oIconNum and oType then
      if oNum == "player" then
         oTarget = "playertarget"
      else
         oTarget = oType..oNum.."target";
      end
	  if UnitExists(oTarget) then
            if not UnitIsPlayer(oTarget) then
	        SetRaidTarget(oTarget,oIconNum);
            end
	  end
    end
end