CRDelayFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0")

CRDelayFu.version = "2.1." .. string.sub("$Revision: 1$", 12, -3)
CRDelayFu.date    = string.sub("$Date: 2007-03-13 15:06:57 -0400 (Tue, 13 Mar 2007) $", 8, 17)
CRDelayFu.hasIcon = "Interface\\Icons\\Ability_Vanish"
CRDelayFu.cannotDetachTooltip = true

CRDelayFu:RegisterDB("CRDelayFuDB")
CRDelayFu:RegisterDefaults('profile', {})

local L = AceLibrary("AceLocale-2.2"):new("FuBar_CRDelayFu")
L:RegisterTranslations("enUS", function() return {
--	["No Delay"] = true,
	["AceConsole-Commands"] = {"/crdelayfu", "/crdfu"},
} end)

local Abacus = AceLibrary("Abacus-2.0")
local Crayon = AceLibrary("Crayon-2.0")

CRDelayFu:RegisterChatCommand(L["AceConsole-Commands"])

function CRDelayFu:OnEnable()
	self:ScheduleRepeatingEvent(self.Update, 1, self)
end

function CRDelayFu:OnTextUpdate()
	local crDelay = GetCorpseRecoveryDelay()
	if crDelay == 0 then
		--self:SetText(format("|cff%s%s|r", Crayon.COLOR_HEX_GREEN, L["No Delay"]))
		self:SetText('')
	else
		self:SetText(format("|cff%s%s|r", Crayon:GetThresholdHexColor(1 - crDelay/30), Abacus:FormatDurationCondensed(crDelay)))
	end
end
