ButtonSmash = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "AceHook-2.1")
local self,ButtonSmash=ButtonSmash,ButtonSmash
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
ButtonSmash.hasIcon = "Interface\\Icons\\Spell_Nature_RemoveCurse.jpg"
local GetActionInfo=GetActionInfo
local GetActionText=GetActionText
local GetPetActionInfo=GetPetActionInfo
local GetSpellName=GetSpellName
local GetSpellInfo=GetSpellInfo
local GetItemInfo=GetItemInfo

function ButtonSmash:OnInitialize()
	self:RegisterDB("ButtonSmashDB")
	self:RegisterDefaults("profile", {
		counter={totalcounter=0},
		maxreport=6,
		petbar={}
	}
	)  
end


function ButtonSmash:OnTextUpdate()
	self:SetText(self.db.profile.counter.totalcounter)
end

function ButtonSmash:UseAction(slot)
	self.db.profile.counter.totalcounter=self.db.profile.counter.totalcounter+1
	local name=GetActionText(slot)
	if not name then
		local type,id=GetActionInfo(slot)
		--local id=select(2,GetActionInfo(slot))
		if type=="item" then name=GetItemInfo(id)
		elseif type=="spell" then name=GetSpellName(id, "BOOKTYPE_SPELL")  
		end
	else name=name.." (macro)"
	end
	if not name then return end
	if not self.db.profile.counter[name] then self.db.profile.counter[name]=0 end
	self.db.profile.counter[name]=self.db.profile.counter[name]+1
	self:Update()
end

function ButtonSmash:CastPetAction(slot)
	self.db.profile.counter.totalcounter=self.db.profile.counter.totalcounter+1
	local name=select(1,GetPetActionInfo(slot))
	local global=select(4,GetPetActionInfo(slot))
	if not name then return end
	for i=1,10 do 
		local name, subtext, texture, isToken, isActive, autoCastAllowed, autoCastEnabled = GetPetActionInfo(i)
		self.db.profile.petbar[i]={name=name, subtext=subtext, isToken=isToken, isActive=isActive, autoCastAllowed=autoCastAllowed, autoCastEnabled=autoCastEnabled }
	end
	if global then
		if name=="PET_ACTION_ATTACK" then name="Attack"
		elseif name=="PET_ACTION_FOLLOW" then name="Follow"
		elseif name=="PET_ACTION_WAIT" then name="Wait"
		elseif name=="PET_MODE_AGGRESSIVE" then name="Aggressive"
		elseif name=="PET_MODE_DEFENSIVE" then name="Defensive"
		elseif name=="PET_MODE_PASSIVE" then name="Passive"
		end
	end
	
	name=name.." (pet)"
	if not self.db.profile.counter[name] then self.db.profile.counter[name]=0 end
	self.db.profile.counter[name]=self.db.profile.counter[name]+1
	self:Update()
end


local function GetSortedTable()
	local sortedtable={}
	for k,v in pairs(self.db.profile.counter) do
		if k ~= "totalcounter" then
			table.insert(sortedtable,k)
		end
	end
	table.sort(sortedtable,function(a,b) return self.db.profile.counter[a] > self.db.profile.counter[b] end)
	return sortedtable
end


function ButtonSmash:OnTooltipUpdate()
	local sortedtable=GetSortedTable()
	local cat = tablet:AddCategory(
		'columns', 2
	)
	for k,v in ipairs(sortedtable) do
		local checked=false
		local checkIcon
		
		local a= string.match(v,"(.+)[ ][(]macro[)]")
		local b= string.match(v,"(.+)[ ][(]pet[)]")
		--local c=BS:GetSpellIcon(v) 
		local c=select(3,GetSpellInfo(v))
		local d=select(10,GetItemInfo(v))
		if a then 
			checked=true 
			checkIcon=select(2,GetMacroInfo(a))
		elseif b then
			local id
			for i=1,10 do
				if self.db.profile.petbar[i].name and string.find(string.lower(self.db.profile.petbar[i].name),string.lower(b),1,true) then id = i end
			end
			if id then
				local text= self.db.profile.petbar[id].text
				local global = self.db.profile.petbar[id].isToken
				if global then 
					checked=getglobal(text) 
					checkIcon=getglobal(text) 
				else 
					checked=text
					checkIcon=text 
				end
			end
		elseif c then 
			checked=c
			checkIcon=c
		else
			checked=d
			checkIcon=d			
		end
		cat:AddLine(
			'text',"  "..v,
			'text2',"|cffffffff"..self.db.profile.counter[v].."|r",
			'hasCheck',true,
			'checked',checked,
			'checkIcon',checkIcon
		)
	end
	cat:AddLine('text'," ")
	cat:AddLine(
			'text',"|cffffffff".."Total".."|r" ,
			'text2',"|cffffffff"..self.db.profile.counter.totalcounter.."|r" 
		)
	cat:AddLine(
			'text',"|cffffffff".."Last reset".."|r" ,
			'text2',"|cffffffff"..self.db.profile.lastreset.."|r" 
		)
end

function ButtonSmash:OnEnable()
	self:SecureHook("UseAction")
	self:SecureHook("CastPetAction")
	self:SetProfile("char")
	if not self.db.profile.lastreset then self.db.profile.lastreset=date() end
	self.OnMenuRequest={
		type="group",
		args={
			reset={
				name="Reset",
				desc="Reset",
				type="execute",
				order=10,
				confirm=true,
				func=function()
					self.db.profile.counter = {totalcounter=0}
					self.db.profile.lastreset=date()
					self:Update()
					end
			},
			greport={
				name="Guild report",
				desc="Guild report",
				type="execute",
				order=20,
				func=function()
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"FuBar_ButtonSmashFu".." since "..self.db.profile.lastreset,"GUILD")
						local sortedtable=GetSortedTable()
						local i=1
						for k,v in ipairs(sortedtable) do
							if i > self.db.profile.maxreport and self.db.profile.maxreport~=0 then break end
							ChatThrottleLib:SendChatMessage("NORMAL",nil,v..": "..self.db.profile.counter[v],
							"GUILD"
							)
							i=i+1
						end
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"Total: "..self.db.profile.counter.totalcounter,"GUILD")
					end
			},
			rreport={
				name="Raid report",
				desc="Raid report",
				type="execute",
				order=30,
				func=function()
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"FuBar_ButtonSmashFu".." since "..self.db.profile.lastreset,"RAID")
						local sortedtable=GetSortedTable()
						local i=1
						for k,v in ipairs(sortedtable) do
							if i > self.db.profile.maxreport and self.db.profile.maxreport~=0 then break end
							ChatThrottleLib:SendChatMessage("NORMAL",nil,v..": "..self.db.profile.counter[v],
							"RAID"
							)
							i=i+1
						end
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"Total: "..self.db.profile.counter.totalcounter,"RAID")
					end
			},
			sreport={
				name="/Say report",
				desc="/Say report",
				type="execute",
				order=31,
				func=function()
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"FuBar_ButtonSmashFu".." since "..self.db.profile.lastreset,"SAY")
						local sortedtable=GetSortedTable()
						local i=1
						for k,v in ipairs(sortedtable) do
							if i > self.db.profile.maxreport and self.db.profile.maxreport~=0 then break end
							ChatThrottleLib:SendChatMessage("NORMAL",nil,v..": "..self.db.profile.counter[v],
							"SAY"
							)
							i=i+1
						end
						ChatThrottleLib:SendChatMessage("NORMAL",nil,"Total: "..self.db.profile.counter.totalcounter,"SAY")
					end
			},
			maxreport={
				name="Limit report lines",
				desc="For unlimited lines, set this to 0",
				type="range",
				get=function() return self.db.profile.maxreport end,
				set=function(v) self.db.profile.maxreport=v end,
				min=0,
				max=100,
				order=40,
				step=1
			}
		}
	}
end

function ButtonSmash:OnDisable()
	self:UnhookAll()
end