local Tablet = AceLibrary("Tablet-2.0");
local L = AceLibrary("AceLocale-2.2"):new("BabelFu");
local Babel = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0","AceEvent-2.0","AceConsole-2.0","AceDB-2.0");


Babel:RegisterDB("FuBar_BabelFuDB","FuBar_BabelFuDBPC");
Babel:RegisterDefaults('char', {
	language = nil,
	say = true,
	yell = true,
	guild = true,
	party = true,
});


Babel.hasIcon = true;
Babel.hasNoColor = true;
Babel.cannotHideText = true;
Babel.defaultPosition = 'CENTER';
Babel.clickableTooltip = true;

local languages = {};


function Babel:OnEnable()
	for itor=1,  GetNumLanguages() do
		local language = GetLanguageByIndex(itor);
		languages[itor] = language;
	end

	if self.db.char.language == nil then
		self.db.char.language = GetLanguageByIndex(1);
	end
	self:UpdateText()
	
end


function Babel:SetLanguageByName(name)
	-- Note that this is gaurunteed to be a value from languages 
	self.db.char.language = name;
	self:UpdateText();
end

function Babel:GetCurrentLanguage()
	return self.db.char.language;
end

function Babel:CycleLanguage()
	for itor=1,  GetNumLanguages() do
		local language = GetLanguageByIndex(itor);
		if language == self.db.char.language then
			if itor >=  GetNumLanguages() then
				self:SetLanguageByName(GetLanguageByIndex(1));
			else
				self:SetLanguageByName(GetLanguageByIndex(itor + 1));
			end
			return
		end
	end
end

function Babel:OnClick()
	Babel:CycleLanguage();
end

local optionsTable = {
	handler = Babel,
	type = 'group',
	args = {
		set = {
			type = 'text',
			name = L["Set Language"],
			desc = L["Set the language you would like to be using."],
			get = "GetCurrentLanguage",
			set = "SetLanguageByName",
			validate = languages,
			multiToggle = false,
		},
		channels = {
			type = 'group',
			name = L["Channels"],
			desc = L["Channels BabelFu will moderate."],
			args = {
				say = {
					type = 'toggle',
					name = L["Say"],
					desc = L["Manage messages in /say?"],
					get = function()
						return Babel.db.char.say;
					end,
					set = function()
						Babel.db.char.say = not Babel.db.char.say;
					end,
				},
				yell = {
					type = 'toggle',
					name = L["Yell"],
					desc = L["Manage messages in /yell?"],
					get = function()
						return Babel.db.char.yell;
					end,
					set = function()
						Babel.db.char.yell = not Babel.db.char.yell;
					end,

				},
				guild = {
					type = 'toggle',
					name = L["Guild"],
					desc = L["Manage messages in /guild?"],
					get = function()
						return Babel.db.char.guild;
					end,
					set = function()
						Babel.db.char.guild = not Babel.db.char.guild;
					end,

				},
				party = {
					type = 'toggle',
					name = L["Party"],
					desc = L["Manage messages in /party?"],
					get = function()
						return Babel.db.char.party;
					end,
					set = function()
						Babel.db.char.party = not Babel.db.char.party;
					end,

				}
			}
		}
	}
};
Babel:RegisterChatCommand(L["Slash-Commands"], optionsTable);
Babel.OnMenuRequest = optionsTable;

function Babel:OnTextUpdate()
	if self.db.char.language == nil then
		self:SetText(L["Loading..."]);
	else
		self:SetText(self.db.char.language);
	end
end

function Babel:OnTooltipUpdate()
    local cat = Tablet:AddCategory(
        'columns' , 1
    );
    
    for k, language in pairs(languages) do
        cat:AddLine(
            'text',language,
            'justify',"LEFT",
            'func','SetLanguageByName',
            'arg1',self,
            'arg2',language
        ); 
    end

	Tablet:SetHint(L["Left-click to cycle languages."]);
end




-- Hook the SendChatMessage function

local OldSendChatMessage = SendChatMessage;


-- Replace with our new one.

function SendChatMessage( msg, chatType, language, channel )
	if chatType == "SAY" and Babel.db.char.say then
		OldSendChatMessage(msg, chatType, Babel.db.char.language, channel);
	elseif chatType == "YELL" and Babel.db.char.yell then
		OldSendChatMessage(msg, chatType, Babel.db.char.language, channel);
	elseif chatType == "GUILD" and Babel.db.char.guild then
		OldSendChatMessage(msg, chatType, Babel.db.char.language, channel);
	elseif chatType == "PARTY" and Babel.db.char.party then
		OldSendChatMessage(msg, chatType, Babel.db.char.language, channel);
	else
		OldSendChatMessage(msg, chatType, language, channel )
	end
end




