AuditorFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0")

--[[ DECLARE LOCALS ]]--

local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

-- Locale
local L = AUDITOR2FU_LOCALS

local auditorFuModeTip = { L.Loot, L.Vendors, L.Quest, L.Trade, L.Mail, L.AuctionHouse, L.Train, L.Taxi, L.Repairs, L.Other, L.Reconciliation, L.Guildbank }
local auditorFuToonToPurge = "NoOne"

AuditorFu.hasIcon = true
AuditorFu.clickableTooltip = true
AuditorFu.frame = AuditorFu:CreateBasicPluginFrame("AuditorFuFrame")
AuditorFu.defaultPosition = "LEFT"
AuditorFu.title = "AuditorFu"

AuditorFu:RegisterDB("Fubar_AuditorDB")
AuditorFu:RegisterDefaults('profile', {
	enabled = 0,
	hideCharTotals = false,
	hideDetails = false,
	hideSummary = false,
	hideHourly = false,
	hideTotalInBar = false,
	showCombined = false,
	absurdDetail = false,
	absurdStyle = "loot",
	style = "total",
	cashFormat = { Bar = "Full", toolTip = "Full" },
	detachedOpen = true,
	compactMode = true
})

-- Options Table for Configuration

local optionsTable = {
	handler = AuditorFu,
	type = 'group',
	desc = L.Description,
	args = {
		toonToShow = {
			order = 1,
			type = 'text',
			name = L.CharShow,
			desc = L.CharShowDesc,
			get = function() return auditorFuToonToShow end,
			set = function(v) auditorFuToonToShow = v end,
			validate = {},
		},
		cashFormat = {
			order = 2,
			type = 'group',
			name = L.MoneyFormat,
			desc = L.MoneyFormatDesc,
			args = {
				barFormat = {
					order = 1,
					type = 'text',
					name = L.FuDisplay,
					desc = L.FuDisplayDesc,
					get = function() return AuditorFu.db.profile.cashFormat.Bar end,
					set = function(v) AuditorFu.db.profile.cashFormat.Bar = v; AuditorFu:UpdateText() end,
					validate = {["Full"] = L.FullStyle, ["Short"] = L.ShortStyle, ["Condensed"] = L.CondStyle, ["Graphical"] = L.GraphStyle},
				},
				tooltipFormat = {
					order = 2,
					type = 'text',
					name = L.TooltipDisplay,
					desc = L.TooltipDisplayDesc,
					get = function() return AuditorFu.db.profile.cashFormat.toolTip end,
					set = function(v) AuditorFu.db.profile.cashFormat.toolTip = v; AuditorFu:UpdateText() end,
					validate = {["Full"] = L.FullStyle, ["Short"] = L.ShortStyle, ["Condensed"] = L.CondStyle},
				},
				showTotalInBar = {
					order = 3,
					type = 'toggle',
					name = L.ShowTotalInBar,
					desc = L.ShowTotalInBarDesc,
					get = function() return not AuditorFu.db.profile.hideTotalInBar end,
					set = function() AuditorFu.db.profile.hideTotalInBar = not AuditorFu.db.profile.hideTotalInBar; AuditorFu:UpdateText() end,
				},
			}
		},
		timeframeDisplay = {
			order = 3,
			type = 'text',
			name = L.Timeframe,
			desc = L.TimeframeDesc,
			get = function() return AuditorFu.db.profile.style end,
			set = function(v) AuditorFu.db.profile.style = v; AuditorFu:UpdateTooltip() end,
		},
		tipDisplay = {
			order = 4,
			type = 'group',
			name = L.TipDisplay,
			desc = L.TipDisplayDesc,
			args = {
				absurdDetail = {
					order = 1,
					type = 'toggle',
					name = L.Absurd,
					desc = L.AbsurdDesc,
					get = function() return AuditorFu.db.profile.absurdDetail end,
					set = function() AuditorFu.db.profile.absurdDetail = not AuditorFu.db.profile.absurdDetail end,
					disabled = function()
								if AuditorFu.db.profile.showCombined == true then
									AuditorFu.db.profile.absurdDetail = false
									return true
								else
									return false
								end
							end,
				},
				compactMode = {
					order = 2,
					type = 'toggle',
					name = L.CompactMode,
					desc = L.CompactModeDesc,
					get = function() return AuditorFu.db.profile.compactMode end,
					set = function() AuditorFu.db.profile.compactMode = not AuditorFu.db.profile.compactMode end,
				},
				showDetails = {
					order = 3,
					type = 'toggle',
					name = L.ShowDetails,
					desc = L.ShowDetailsDesc,
					get = function() return not AuditorFu.db.profile.hideDetails end,
					set = function() AuditorFu.db.profile.hideDetails = not AuditorFu.db.profile.hideDetails end,
				},
				showHourly = {
					order = 4,
					type = 'toggle',
					name = L.ShowHourly,
					desc = L.ShowHourlyDesc,
					get = function() return not AuditorFu.db.profile.hideHourly end,
					set = function() AuditorFu.db.profile.hideHourly = not AuditorFu.db.profile.hideHourly end,
				},
				showSummary = {
					order = 5,
					type = 'toggle',
					name = L.ShowSummary,
					desc = L.ShowSummaryDesc,
					get = function() return not AuditorFu.db.profile.hideSummary end,
					set = function() AuditorFu.db.profile.hideSummary = not AuditorFu.db.profile.hideSummary end,
				},
				showTotals = {
					order = 6,
					type = 'toggle',
					name = L.ShowTotals,
					desc = L.ShowTotalsDesc,
					get = function() return not AuditorFu.db.profile.hideCharTotals end,
					set = function() AuditorFu.db.profile.hideCharTotals = not AuditorFu.db.profile.hideCharTotals end,
				},
				showCombinedTotals = {
					order = 6,
					type = 'toggle',
					name = L.ShowCombinedTotals,
					desc = L.ShowCombinedTotalsDesc,
					get = function() return AuditorFu.db.profile.showCombined end,
					set = function() AuditorFu.db.profile.showCombined = not AuditorFu.db.profile.showCombined end,
				},
			}
		},
		["-blank3-"] = {
			order = 5,
			type = 'header',
		},
		cashNotify = {
			order = 6,
			type = 'group',
			name = L.CashNotify,
			desc = L.CashNotifyDesc,
			args = {
				notifyAH = {
					order = 1,
					type = 'toggle',
					name = L.AH,
					desc = L.AHDesc,
					get = function() return Auditor.db.realm.notifyAH end,
					set = function() Auditor.db.realm.notifyAH = not Auditor.db.realm.notifyAH end,
				},
				notifyMailbox = {
					order = 3,
					type = 'toggle',
					name = L.Mailbox,
					desc = L.MailboxDesc,
					get = function() return Auditor.db.realm.notifyMailbox end,
					set = function() Auditor.db.realm.notifyMailbox = not Auditor.db.realm.notifyMailbox end,
				},
				notifyVendor = {
					order = 5,
					type = 'toggle',
					name = L.Vendor,
					desc = L.VendorDesc,
					get = function() return Auditor.db.realm.notifyVendor end,
					set = function() Auditor.db.realm.notifyVendor = not Auditor.db.realm.notifyVendor end,
				},
				notifyTrainer = {
					order = 4,
					type = 'toggle',
					name = L.Trainer,
					desc = L.TrainerDesc,
					get = function() return Auditor.db.realm.notifyTrainer end,
					set = function() Auditor.db.realm.notifyTrainer = not Auditor.db.realm.notifyTrainer end,
				},
				notifyGuildbank = {
					order = 2,
					type = 'toggle',
					name = L.Guildbank,
					desc = L.GuildbankDesc,
					get = function() return Auditor.db.realm.notifyGuildbank end,
					set = function() Auditor.db.realm.notifyGuildbank = not Auditor.db.realm.notifyGuildbank end,
				},
			}
		},
		merchOptions = {
			order = 7,
			type = 'group',
			name = L.MerchOptions,
			desc = L.MerchOptionsDesc,
			args = {
				autoRepair = {
					order = 1,
					type = 'toggle',
					name = L.AutoRepair,
					desc = L.AutoRepairDesc,
					get = function() return Auditor.db.profile.autoRepair end,
					set = function() Auditor.db.profile.autoRepair = not Auditor.db.profile.autoRepair end,
				},
				guildRepair = {
					order = 2,
					type = 'toggle',
					name = L.GuildRepair,
					desc = L.GuildRepairDesc,
					get = function() return Auditor.db.profile.guildRepair end,
					set = function() Auditor.db.profile.guildRepair = not Auditor.db.profile.guildRepair end,
				},
				autoSell = {
					order = 3,
					type = 'toggle',
					name = L.AutoSell,
					desc = L.AutoSellDesc,
					get = function() return Auditor.db.realm.sellGreys end,
					set = function() Auditor.db.realm.sellGreys = not Auditor.db.realm.sellGreys end,
				},
			}
		},
		["-blank5-"] = {
			order = 8,
			type = 'header',
		},
		timeOptions = {
			order = 9,
			type = 'group',
			name = L.TimeOffset,
			desc = L.TimeOffsetDesc,
			args = {
				enableOffset = {
					order = 1,
					type = 'toggle',
					name = L.EnableOffset,
					desc = L.EnableOffsetDesc,
					get = function() return Auditor.db.realm.useOffset end,
					set = function() Auditor.db.realm.useOffset = not Auditor.db.realm.useOffset end,
				},
				timeOffset = {
					order = 2,
					type = 'range',
					name = L.TimeOffset,
					desc = L.TimeOffsetDesc,
					get = function() return Auditor.db.realm.timeOffset end,
					set = function(timeOffset)
								Auditor.db.realm.timeOffset = timeOffset
								local dateTable = date("*t")
								for name in pairs(Auditor.db.realm.chars) do
									Auditor.db.realm[name].historical = nil
									Auditor:DataReset("session", name)
									Auditor:DataReset("day", name)
									Auditor:DataReset("week", name)
									Auditor.db.realm[name].timeDate.timeDate = time{year = dateTable.year, day = dateTable.day, month = dateTable.month, hour = 0} + (Auditor.db.realm.timeOffset * 3600)
								end
								Auditor:NewToonDB()
							end,
					min = -16,
					max = 16,
					step = 1,
					disabled = function()
								if Auditor.db.realm.useOffset == false then
									return true
								else
									return false
								end
							end,
				},
				printResetTime = {
					order = 3,
					type = 'execute',
					name = L.PrintResetTime,
					desc = L.PrintResetTimeDesc,
					func = function() Auditor:PrintResetTime() end,
				},
			}
		},
		["-blank11-"] = {
			order = 10,
			type = 'header',
		},
		resetSession = {
			order = 11,
			type = 'execute',
			name = L.RSession,
			desc = L.RSessionDesc,
			func = function() Auditor:DataReset("session");	AuditorFu:OpenMenu() end,
		},
		purge = {
			order = 12,
			type = 'group',
			name = L.Purge,
            desc = L.PurgeDesc,
		},
		filters = {
			order = 13,
			type = 'group',
			name = L.Filter,
			desc = L.FilterDesc,
		},
		["-blank4-"] = {
			order = 14,
			type = 'header',
		}
	}	
}

function AuditorFu:OnInitialize()
	self:FrameSetup()
end

function AuditorFu:OnEnable()
	-- Confirmation dialog for data purging
	StaticPopupDialogs["AUD_DATA_PURGE"] = {
	  text = "",
	  button1 = L.Popup_Yes,
	  button2 = L.Popup_No,
	  OnAccept = function()
		Auditor:PurgeData(auditorFuToonToPurge)
	  end,
	  timeout = 0,
	  whileDead = 1,
	  hideOnEscape = 1
	}

	AuditorFuFrameGoldIcon:ClearAllPoints()
	AuditorFuFrameGoldIcon:SetPoint("RIGHT", AuditorFuFrameSilverText, "LEFT", 0, -1)
	AuditorFuFrameSilverIcon:ClearAllPoints()
	AuditorFuFrameSilverIcon:SetPoint("RIGHT", AuditorFuFrameCopperText, "LEFT", 0, -1)
end

function AuditorFu:OnTextUpdate()
	if self.db.profile.cashFormat.Bar == "Graphical" then
		if self:IsIconShown() then
			self.db.profile.iconVisible = true
			self:HideIcon()
		end
		self.hasIcon = false
		AuditorFuFrameIcon:Hide()
		AuditorFuFrameText:Hide()
		local copper = GetMoney()
		local gold = floor(copper / 10000)
		local silver = mod(floor(copper / 100), 100)
		copper = mod(copper, 100)
		local width = 0
		if gold == 0 then
			AuditorFuFrameGoldIcon:Hide()
			AuditorFuFrameGoldText:Hide()
		else
			AuditorFuFrameGoldIcon:Show()
			AuditorFuFrameGoldText:Show()
			AuditorFuFrameGoldText:SetWidth(0)
			AuditorFuFrameGoldText:SetText(gold)
			width = width + AuditorFuFrameGoldIcon:GetWidth() + AuditorFuFrameGoldText:GetWidth()
		end
		if gold == 0 and silver == 0 then
			AuditorFuFrameSilverIcon:Hide()
			AuditorFuFrameSilverText:Hide()
		else
			AuditorFuFrameSilverIcon:Show()
			AuditorFuFrameSilverText:Show()
			AuditorFuFrameSilverText:SetWidth(0)
			AuditorFuFrameSilverText:SetText(silver)
			width = width + AuditorFuFrameSilverIcon:GetWidth() + AuditorFuFrameSilverText:GetWidth()
		end
		AuditorFuFrameCopperIcon:Show()
		AuditorFuFrameCopperText:Show()
		AuditorFuFrameCopperText:SetWidth(0)
		AuditorFuFrameCopperText:SetText(copper)
		width = width + AuditorFuFrameCopperIcon:GetWidth() + AuditorFuFrameCopperText:GetWidth()
		self.frame:SetWidth(width)
	else
		if not self.hasIcon then
			self.hasIcon = true
			if self.db.profile.iconVisible then
				self:ShowIcon()
			end
		end
		self.db.profile.iconVisible = false
		AuditorFuFrameGoldIcon:Hide()
		AuditorFuFrameSilverIcon:Hide()
		AuditorFuFrameCopperIcon:Hide()
		AuditorFuFrameGoldText:Hide()
		AuditorFuFrameSilverText:Hide()
		AuditorFuFrameCopperText:Hide()
		if self:IsTextShown() == true then
			AuditorFuFrameText:Show()
		else
			AuditorFuFrameText:Hide()
		end
		
		-- New mini-option for showing realm total in FuBar
		local realmWealth = 0
		if self.db.profile.hideTotalInBar == false then
			for _,charWealth in pairs(Auditor.db.realm.chars) do
				local charWealth = charWealth
				realmWealth = realmWealth + charWealth
			end
			if self.db.profile.cashFormat.Bar == "Full" then
				self:SetText(Auditor:FormatMoneyFull(GetMoney(), true).." /"..Auditor:FormatMoneyFull(realmWealth, true))
			elseif self.db.profile.cashFormat.Bar == "Short" then
				self:SetText(Auditor:FormatMoneyShort(GetMoney(), true).." /"..Auditor:FormatMoneyShort(realmWealth, true))
			else
				self:SetText(Auditor:FormatMoneyCondensed(GetMoney(), true).."/"..Auditor:FormatMoneyCondensed(realmWealth, true))
			end
		else
			if self.db.profile.cashFormat.Bar == "Full" then
				self:SetText(Auditor:FormatMoneyFull(GetMoney(), true))
			elseif self.db.profile.cashFormat.Bar == "Short" then
				self:SetText(Auditor:FormatMoneyShort(GetMoney(), true))
			else
				self:SetText(Auditor:FormatMoneyCondensed(GetMoney(), true))
			end
		end
		self:CheckWidth(true)
	end
end

function AuditorFu:OnTooltipUpdate()
	Auditor:UpdateTimeFrame()
	
	-- Initialise Local Variables
	local style = self.db.profile.style
	local absurdStyle = self.db.profile.absurdStyle
	local allTotal = 0
	local netIn = 0
	local netOut = 0
	local netTotal = 0
	local cashIn = {}
	local cashOut = {}
	local categoryDisplay = ""
	local absurdCategoryDisplay = ""
	local numberOfToonsInTotalCount = 0
	local sessionHours = ((time() - auditorSessionTime) / 3600)
			
	-- Retrieve Cash Data
	-- What data are we showing?
	-- Combined
	
	if AuditorFu.db.profile.showCombined == true then
		-- Force Day mode if it is not already in a compatible display mode
		if self.db.profile.style ~= "day" and self.db.profile.style ~= "total" then
			self.db.profile.style = "day"
			style = "day"
		end
		-- Setup tables and stuff
		for i = 1,12 do
				cashIn[i] = 0
				cashOut[i] = 0
		end
		local t = {}
		for name in pairs(Auditor.db.realm.chars) do
			table.insert(t, name)
		end
		-- Gather data for toons logged on today's date for day view, or all toons if it's in total view
		if AuditorFu.db.profile.style == "day" then
			for _,name in pairs(t) do
				if Auditor.db.realm[name].timeDate.niceDate == Auditor.db.realm[auditorPlayer].timeDate.niceDate then
					for i = 1, 12 do
						cashIn[i] = cashIn[i] + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings
						cashOut[i] = cashOut[i] + Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
						netIn = netIn + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings
						netOut = netOut + Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
						netTotal = netTotal + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings - Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
					end
					numberOfToonsInTotalCount = numberOfToonsInTotalCount + 1
				end
			end
		else
			for _,name in pairs(t) do
				for i = 1, 12 do
					cashIn[i] = cashIn[i] + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings
					cashOut[i] = cashOut[i] + Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
					netIn = netIn + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings
					netOut = netOut + Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
					netTotal = netTotal + Auditor.db.realm[name].data[auditorLogMode[i]][style].incomings - Auditor.db.realm[name].data[auditorLogMode[i]][style].outgoings
				end
				numberOfToonsInTotalCount = numberOfToonsInTotalCount + 1
			end
		end
	-- Single toon
	else
		for i = 1, 12 do
			cashIn[i] = Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].incomings
			cashOut[i] = Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].outgoings
			netIn = netIn + Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].incomings
			netOut = netOut + Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].outgoings
			netTotal = netTotal + Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].incomings - Auditor.db.realm[auditorFuToonToShow].data[auditorLogMode[i]][style].outgoings
		end
	end
	
	-- Set Tooltip Display Prefs
	-- Timeframe
	if style == "session" then
		categoryDisplay = L.Session
	elseif style == "day" then
		categoryDisplay = L.Day
	elseif style == "week" then
		categoryDisplay = L.Week
	else
		categoryDisplay = L.Total
	end
	--AbsurdCategory
	if absurdStyle == "loot" then
		absurdCategoryDisplay = L.Loot
	elseif absurdStyle == "merch" then
		absurdCategoryDisplay = L.Vendors
	elseif absurdStyle == "quest" then
		absurdCategoryDisplay = L.Quest
	elseif absurdStyle == "trade" then
		absurdCategoryDisplay = L.Trade
	elseif absurdStyle == "mail" then
		absurdCategoryDisplay = L.Mail
	elseif absurdStyle == "ah" then
		absurdCategoryDisplay = L.AuctionHouse
	elseif absurdStyle == "train" then
		absurdCategoryDisplay = L.Train
	elseif absurdStyle == "taxi" then
		absurdCategoryDisplay = L.Taxi
	elseif absurdStyle == "repairs" then
		absurdCategoryDisplay = L.Repairs
	elseif absurdStyle == "other" then
		absurdCategoryDisplay = L.Other
	elseif absurdStyle == "reconciliation" then
		absurdCategoryDisplay = L.Reconciliation
	elseif absurdStyle == "guildbank" then
		absurdCategoryDisplay = L.Guildbank
	end
			
	-- Construct Tooltip Display
	-- Normal display
	if self.db.profile.absurdDetail == false then
		-- Showing Combined
		if AuditorFu.db.profile.showCombined == true then
			local cat = tablet:AddCategory(
		        'text', "Combined :: "..numberOfToonsInTotalCount.." Characters",
				'textR', 1,	'textG', 0.8,	'textB', 0,
				'justify', "CENTER",
				'font', GameTooltipHeaderText
			)
			cat:AddLine()
		-- Showing current toon
		elseif auditorFuToonToShow == auditorPlayer then
			local cat = tablet:AddCategory(
		        'text', auditorFuToonToShow.." :: "..L.LoggedOn,
				'textR', 1,	'textG', 0.8,	'textB', 0,
				'justify', "CENTER",
				'font', GameTooltipHeaderText
			)
			cat:AddLine()
		-- Showing some other toon
		else
			local cat = tablet:AddCategory(
		        'text', auditorFuToonToShow.." :: "..Auditor.db.realm[auditorFuToonToShow].timeDate.niceDate,
				'textR', 1,	'textG', 0.8,	'textB', 0,
				'justify', "CENTER",
				'font', GameTooltipHeaderText
			)
			cat:AddLine()
		end
			
		local cat = tablet:AddCategory(
	        'text', L.Timeframe,
			'text2', categoryDisplay,
			'textR', 0,	'textG', 1,	'textB', 0,
			'text2R', 1, 'text2G', 0.8, 'text2B', 0,
			'columns', 2,
			'func', function() -- Allow click to cycle through timeframe
						if AuditorFu.db.profile.showCombined == true then
							if style == "day" then
								style = "total"
								categoryDisplay = L.Total
							elseif style == "total" then
								style = "day"
								categoryDisplay = L.Day
							end
						else
							if style == "session" then
								style = "day"
								categoryDisplay = L.Day
							elseif style == "day" then
								style = "week"
								categoryDisplay = L.Week
							elseif style == "week" then
								style = "total"
								categoryDisplay = L.Total
							elseif style == "total" then
								style = "session"
								categoryDisplay = L.Session
							end
						end
						self.db.profile.style = style
					end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', "Interface\\Buttons\\UI-PlusButton-Up"
	    )
		
		cat:AddLine()
		
		local cat = tablet:AddCategory(
	        'text', L.Cashflow,
			'textR', 0,	'textG', 1,	'textB', 0,
			'columns', 3,
			'child_textR', 1, 'child_textG', 0.8, 'child_textB', 0,
			'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
			'child_text3R', 1, 'child_text3G', 1, 'child_text3B', 1,
			'func', function() AuditorFu.db.profile.hideDetails = not AuditorFu.db.profile.hideDetails end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', AuditorFu.db.profile.hideDetails and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
		)
		
	    if AuditorFu.db.profile.hideDetails == false then
			if netTotal ~= 0 then
				cat:AddLine(
					'text', "    "..L.Source,
					'textR', 1,	'textG', 1,	'textB', 1,
			        'text2', L.Incomings,
			        'text3', L.Outgoings
			    )
			else
				cat:AddLine(
					'text', "    "..L.NoTrans
				)
			end
				
			-- Sources, incomings, outgoings
			for i = 1, 12 do
				-- Compact Mode
				if AuditorFu.db.profile.compactMode == true then
					if cashIn[i] ~= 0 or cashOut[i] ~= 0 then
						cat:AddLine(
						'text', "    "..auditorFuModeTip[i]..":",
						'text2', Auditor:MoneyStyle(cashIn[i]),
						'text3', Auditor:MoneyStyle(cashOut[i])
						)
					end
				else
					cat:AddLine(
					'text', "    "..auditorFuModeTip[i]..":",
					'text2', Auditor:MoneyStyle(cashIn[i]),
					'text3', Auditor:MoneyStyle(cashOut[i])
					)
				end
			end
		else
			cat:AddLine()
		end

		local cat = tablet:AddCategory(
			'text', L.Summary,
			'textR', 0,
			'textG', 1,
			'textB', 0,
			'columns', 2,
			'child_textR', 1, 'child_textG', 0.8, 'child_textB', 0,
			'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
			'func', function() AuditorFu.db.profile.hideSummary = not AuditorFu.db.profile.hideSummary end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', AuditorFu.db.profile.hideSummary and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)
			
		if AuditorFu.db.profile.hideSummary == false then
			cat:AddLine(
				'text', "    "..L.Incomings..":",
				'text2', Auditor:MoneyStyle(netIn, true)
			)
				
			cat:AddLine(
				'text', "    "..L.Outgoings..":",
				'text2', string.gsub((Auditor:MoneyStyle((netOut * -1), true)), "-", "")
			)
				
			if netTotal >= 0 then
				cat:AddLine(
					'text', "    "..L.NetProfit..":",
					'text2', Auditor:MoneyStyle(netTotal, true)
				)
				-- Gold per hour
				if (AuditorFu.db.profile.hideHourly == false) and (style == "session") and (auditorFuToonToShow == auditorPlayer) then
					cat:AddLine(
						'text', "    "..L.GainPerHour..":",
						'text2', Auditor:MoneyStyle((netTotal/sessionHours), true)
					)
				end
			else
				cat:AddLine(
					'text', "    "..L.NetLoss..":",
					'text2', string.gsub((Auditor:MoneyStyle(netTotal, true)), "-", "")
				)
				-- Gold per hour
				if (AuditorFu.db.profile.hideHourly == false) and (style == "session") and (auditorFuToonToShow == auditorPlayer) then
					cat:AddLine(
						'text', "    "..L.LossPerHour..":",
						'text2', string.gsub((Auditor:MoneyStyle((netTotal/sessionHours), true)), "-", "")
					)
				end
			end
						
		else
			cat:AddLine()
		end
	-- Absurd Details display stuff
	else
		if auditorFuToonToShow == auditorPlayer then
			local cat = tablet:AddCategory(
		        'text', auditorFuToonToShow,
				'textR', 1,	'textG', 0.8,	'textB', 0,
				'justify', "CENTER",
				'font', GameTooltipHeaderText
			)
			cat:AddLine()
		else
			local cat = tablet:AddCategory(
		        'text', auditorFuToonToShow.." :: "..Auditor.db.realm[auditorFuToonToShow].timeDate.niceDate,
				'textR', 1,	'textG', 0.8,	'textB', 0,
				'justify', "CENTER",
				'font', GameTooltipHeaderText
			)
			cat:AddLine()
		end
			
		local cat = tablet:AddCategory(
	        'text', L.Source,
			'text2', absurdCategoryDisplay,
			'textR', 0,	'textG', 1,	'textB', 0,
			'text2R', 1, 'text2G', 0.8, 'text2B', 0,
			'columns', 2,
			'func', function() -- Allow click to cycle through sources
						if absurdStyle == "loot" then
							absurdStyle = "merch"
							absurdCategoryDisplay = L.Vendors
						elseif absurdStyle == "merch" then
							absurdStyle = "quest"
							absurdCategoryDisplay = L.Quest
						elseif absurdStyle == "quest" then
							absurdStyle = "trade"
							absurdCategoryDisplay = L.Trade
						elseif absurdStyle == "trade" then
							absurdStyle = "mail"
							absurdCategoryDisplay = L.Mail
						elseif absurdStyle == "mail" then
							absurdStyle = "ah"
							absurdCategoryDisplay = L.AuctionHouse
						elseif absurdStyle == "ah" then
							absurdStyle = "train"
							absurdCategoryDisplay = L.Train
						elseif absurdStyle == "train" then
							absurdStyle = "taxi"
							absurdCategoryDisplay = L.Taxi
						elseif absurdStyle == "taxi" then
							absurdStyle = "repairs"
							absurdCategoryDisplay = L.Repairs
						elseif absurdStyle == "repairs" then
							absurdStyle = "other"
							absurdCategoryDisplay = L.Other
						elseif absurdStyle == "other" then
							absurdStyle = "reconciliation"
							absurdCategoryDisplay = L.Reconciliation
						elseif absurdStyle == "reconciliation" then
							absurdStyle = "guildbank"
							absurdCategoryDisplay = L.Guildbank
						elseif absurdStyle == "guildbank" then
							absurdStyle = "loot"
							absurdCategoryDisplay = L.Loot
						end
						self.db.profile.absurdStyle = absurdStyle
					end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', "Interface\\Buttons\\UI-PlusButton-Up"
	    )
		cat:AddLine()
		
		local cat = tablet:AddCategory(
	        'text', L.Absurd,
			'textR', 0,	'textG', 1,	'textB', 0,
			'columns', 3,
			'child_textR', 1, 'child_textG', 0.8, 'child_textB', 0,
			'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,
			'child_text3R', 1, 'child_text3G', 1, 'child_text3B', 1,
			'func', function() AuditorFu.db.profile.hideDetails = not AuditorFu.db.profile.hideDetails end,
			'hasCheck', true,
			'checked', true,
			'checkIcon', AuditorFu.db.profile.hideDetails and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
		)
		
		if AuditorFu.db.profile.hideDetails == false then
			cat:AddLine(
				'text', "    "..L.Timeframe,
				'textR', 1,	'textG', 1,	'textB', 1,
		        'text2', L.Incomings,
		        'text3', L.Outgoings
		    )
			
			cat:AddLine(
				'text', "    "..L.Absd_Session..":",
				'text2', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["session"].incomings),
				'text3', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["session"].outgoings)
			)
			
			-- Historical Days, incomings, outgoings
			for i = 1, 7 do
				cat:AddLine(
				'text', "    "..L["Absd_"..i]..":",
				'text2', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].historical[auditorHDay[(8-i)]][absurdStyle].incomings),
				'text3', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].historical[auditorHDay[(8-i)]][absurdStyle].outgoings)
				)
			end
			
			cat:AddLine(
				'text', "    "..L.Absd_Week..":",
				'text2', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["week"].incomings),
				'text3', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["week"].outgoings)
			)
			
			cat:AddLine(
				'text', "    "..L.Absd_Total..":",
				'text2', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["total"].incomings),
				'text3', Auditor:MoneyStyle(Auditor.db.realm[auditorFuToonToShow].data[absurdStyle]["total"].outgoings)
			)
		else
			cat:AddLine()
		end
	end
	
	local cat = tablet:AddCategory(
					'text', L.Characters,
					'textR', 0,
					'textG', 1,
					'textB', 0,
					'columns', 3,
					'child_textR', 1, 'child_textG', 0.8, 'child_textB', 0,
					'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1,				
					'func', function() AuditorFu.db.profile.hideCharTotals = not AuditorFu.db.profile.hideCharTotals end,
					'hasCheck', true,
					'checked', true,
					'checkIcon', AuditorFu.db.profile.hideCharTotals and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
				)
	
	-- Character Totals, ordered by wealth
	if AuditorFu.db.profile.hideCharTotals == false then
		local total = 0
		local addedCat = false
		if next(Auditor.db.realm.chars) ~= UnitName("player") or next(Auditor.db.realm.chars, UnitName("player")) then
			local t = {}
			for name in pairs(Auditor.db.realm.chars) do
				table.insert(t, name)
			end
			if not self.sort_func then
				self.sort_func = function(alpha, bravo)
					return Auditor.db.realm.chars[alpha] < Auditor.db.realm.chars[bravo]
				end
			end
			table.sort(t, self.sort_func)
			for _,name in pairs(t) do
				if not AuditorFu:IsFiltered(name) == true then
					local value = Auditor.db.realm.chars[name]
					
					if name == UnitName("player") then
						cat:AddLine(
							'textR', 1,	'textG', 0,	'textB', 0,
							'text', "    "..name..":",
							'text2', Auditor.db.realm[name].timeDate.niceDate,
							'text3', Auditor:MoneyStyle(value),
							'arg1', name,
							'func', function(name) auditorFuToonToShow = name end
						)
					else
						cat:AddLine(
							'text', "    "..name..":",
							'text2', Auditor.db.realm[name].timeDate.niceDate,
							'text3', Auditor:MoneyStyle(value),
							'arg1', name,
							'func', function(name) auditorFuToonToShow = name end
						)
					end
					total = total + value
				end
			end
		else
			total = GetMoney()
		end
		local cat = tablet:AddCategory(
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'columns', 2,
		'child_textR', 1, 'child_textG', 0.8, 'child_textB', 0,
		'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1
		)
		
		-- Colour the totals if combined mode is active, and allow clicking total to activate combined mode
		if AuditorFu.db.profile.showCombined == true then
			cat:AddLine(
				'textR', 1,	'textG', 0,	'textB', 0,
				'text', L.NetTotal..":",
				'text2', Auditor:MoneyStyle(total),
				'func', function() AuditorFu.db.profile.showCombined = not AuditorFu.db.profile.showCombined end,
				'hasCheck', true,
				'checked', true,
				'checkIcon', not AuditorFu.db.profile.showCombined and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)
		else
			cat:AddLine(
				'text', L.NetTotal..":",
				'text2', Auditor:MoneyStyle(total),
				'func', function() AuditorFu.db.profile.showCombined = not AuditorFu.db.profile.showCombined end,
				'hasCheck', true,
				'checked', true,
				'checkIcon', not AuditorFu.db.profile.showCombined and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)
		end
	else
	cat:AddLine()
	end
end

function AuditorFu:FrameSetup()
	local frame = self.frame
	local icon = frame:CreateTexture("AuditorFuFrameIcon", "ARTWORK")
	icon:SetWidth(16)
	icon:SetHeight(16)
	icon:SetPoint("LEFT", frame, "LEFT")
	self.iconFrame = icon

	local text = frame:CreateFontString("AuditorFuFrameText", "OVERLAY")
	text:SetJustifyH("RIGHT")
	text:SetPoint("RIGHT", frame, "RIGHT", 0, 1)
	text:SetFontObject(GameFontNormal)
	self.textFrame = text

	self:SetIcon(true)

	local goldIcon = frame:CreateTexture("AuditorFuFrameGoldIcon", "ARTWORK")
	goldIcon:SetWidth(16)
	goldIcon:SetHeight(16)
	goldIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	goldIcon:SetTexCoord(0, 0.25, 0, 1)

	local silverIcon = frame:CreateTexture("AuditorFuFrameSilverIcon", "ARTWORK")
	silverIcon:SetWidth(16)
	silverIcon:SetHeight(16)
	silverIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	silverIcon:SetTexCoord(0.25, 0.5, 0, 1)

	local copperIcon = frame:CreateTexture("AuditorFuFrameCopperIcon", "ARTWORK")
	copperIcon:SetWidth(16)
	copperIcon:SetHeight(16)
	copperIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	copperIcon:SetTexCoord(0.5, 0.75, 0, 1)

	local goldText = frame:CreateFontString("AuditorFuFrameGoldText", "OVERLAY")
	goldText:SetJustifyH("RIGHT")
	goldText:SetPoint("RIGHT", goldIcon, "LEFT", 0, 1)
	goldText:SetFontObject(GameFontNormal)

	local silverText = frame:CreateFontString("AuditorFuFrameSilverText", "OVERLAY")
	silverText:SetJustifyH("RIGHT")
	silverText:SetPoint("RIGHT", silverIcon, "LEFT", 0, 1)
	silverText:SetFontObject(GameFontNormal)

	local copperText = frame:CreateFontString("AuditorFuFrameCopperText", "OVERLAY")
	copperText:SetJustifyH("RIGHT")
	copperText:SetPoint("RIGHT", copperIcon, "LEFT", 0, 1)
	copperText:SetFontObject(GameFontNormal)

	copperIcon:SetPoint("RIGHT", frame, "RIGHT")
	silverIcon:SetPoint("RIGHT", copperText, "LEFT")
	goldIcon:SetPoint("RIGHT", silverText, "LEFT")
end

function AuditorFu:SetFontSize(size)
	if AuditorFuFrameGoldIcon == nil then
		self.fontSize = size
		return
	end
	AuditorFuFrameGoldIcon:SetWidth(size)
	AuditorFuFrameGoldIcon:SetHeight(size)
	AuditorFuFrameSilverIcon:SetWidth(size)
	AuditorFuFrameSilverIcon:SetHeight(size)
	AuditorFuFrameCopperIcon:SetWidth(size)
	AuditorFuFrameCopperIcon:SetHeight(size)
	self.iconFrame:SetWidth(16)
	self.iconFrame:SetHeight(16)
	local font,_,flags = AuditorFuFrameGoldText:GetFont()
	if font ~= nil then
		AuditorFuFrameGoldText:SetFont(font, size, flags)
		AuditorFuFrameSilverText:SetFont(font, size, flags)
		AuditorFuFrameCopperText:SetFont(font, size, flags)
		self.textFrame:SetFont(font, size)
	end
	self:UpdateText()
end

function AuditorFu:OnMenuRequest()
	if (not self.cached_options) then 
		-- Purge/Filter/ToonToShow settings
		local showTable = optionsTable.args.toonToShow.validate
		local filterTable = optionsTable.args.filters.args
		local purgeTable = optionsTable.args.purge.args
		showTable = {}
		filterTable = {}
		purgeTable = {}
		optionsTable.args.toonToShow.validate = showTable
		optionsTable.args.filters.args = filterTable
		optionsTable.args.purge.args = purgeTable
		
		for name in pairs(Auditor.db.realm.chars) do
			local name = name
			showTable[name] = name
			
			filterTable[name] = {}
			filterTable[name].type = 'toggle'
			filterTable[name].name = name
			filterTable[name].desc = L.Filter..L.For..name..L.FromTotals
			filterTable[name].set  = function() AuditorFu:ToggleFiltered(name) end
			filterTable[name].get  = function() return AuditorFu:IsFiltered(name) end
			
			purgeTable[name] = {}
			purgeTable[name].type = 'execute'
			purgeTable[name].name = name
			purgeTable[name].desc = L.Purge..L.For..name
			purgeTable[name].func = function() auditorFuToonToPurge = name; StaticPopupDialogs["AUD_DATA_PURGE"].text = L.Popup_Purge..name..L.Popup_Purge2..name.."."; StaticPopup_Show("AUD_DATA_PURGE") end
		end
		
		-- Inject Total option into tables
		self.cached_options = optionsTable
	end
	
	-- Limit timeframes available to show for combined totals so data isn't pointless
	optionsTable.args.timeframeDisplay.validate = {}
	if AuditorFu.db.profile.showCombined == true then
		optionsTable.args.timeframeDisplay.validate = {["day"] = L.Day, ["total"] = L.Total}
	else
		optionsTable.args.timeframeDisplay.validate = {["session"] = L.Session, ["day"] = L.Day, ["week"] = L.Week, ["total"] = L.Total}
	end
	
	dewdrop:FeedAceOptionsTable(self.cached_options)
end

function AuditorFu:IsFiltered(name)
	return Auditor.db.realm[name].hidden
end

function AuditorFu:ToggleFiltered(name)
	Auditor.db.realm[name].hidden = not Auditor.db.realm[name].hidden
end