local L = AceLibrary("AceLocale-2.2"):new("FuBar_ArenaFu")
local G = AceLibrary("Glory-2.0")
local print = print
if DEFAULT_CHAT_FRAME then
	function print(key, value)
		DEFAULT_CHAT_FRAME:AddMessage("|cff00ccffArena|rFu - |cffffff7f" .. tostring(key) .. " => |r" .. tostring(value) .. "|cffffff7f|r")
	end
end

local opts = {
	type = "group",
	args = {
		text = {
			type = "group",
			name = L["Text"],
			desc = L["Text Settings"],
			args = {
				honorpoint = {
					type = "toggle",
					name = L["Show Honor Points"],
					desc = L["Toggles display of honor points"],
					get = function() 
						return FuBar_ArenaFu.db.profile.text.honor
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.text.honor = v;
						FuBar_ArenaFu:OnTextUpdate()
					end,
					order = 1,
				},
				arenapoints = {
					type = "toggle",
					name = L["Show Arena Points"], 
					desc = L["Toggles display of arena points"],
					get = function() 
						return FuBar_ArenaFu.db.profile.text.arena
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.text.arena = v;
						FuBar_ArenaFu:OnTextUpdate()
					end,
					order = 2,
				},
				arenateam = {
					type = "toggle",
					name = L["Show Arena Team Info"], 
					desc = L["Toggles display of arena team info"],
					get = function() 
						return FuBar_ArenaFu.db.profile.text.arenateam
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.text.arenateam = v;
						FuBar_ArenaFu:OnTextUpdate()
					end,
					order = 3,
				},
				shorttext = {
					type = "toggle",
					name = L["Short Text"],
					desc = L["Toggle display text type short or long"],
					get = function()
						return FuBar_ArenaFu.db.profile.text.short
					end,
					set = function(v)
						FuBar_ArenaFu.db.profile.text.short = v;
						FuBar_ArenaFu:OnTextUpdate()
					end,
					order = 4,
				},
			}, 
			order = 1,
		},
		tooltip = {
			type = "group", 
			name = L["Tooltip"], 
			desc = L["Tooltip Settings"], 
			args = {
				honorpoint = {
					type = "toggle",
					name = L["Show Honor Info"],
					desc = L["Toggles display of honor info"],
					get = function() 
						return FuBar_ArenaFu.db.profile.tooltip.honor
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.tooltip.honor = v; 
					end,
					order = 1,
				},
				arenapoints = {
					type = "toggle",
					name = L["Show Arena Info"], 
					desc = L["Toggles display of arena info"],
					get = function() 
						return FuBar_ArenaFu.db.profile.tooltip.arena
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.tooltip.arena = v; 
					end,
					order = 2,
				},
				arenateam = {
					type = "toggle",
					name = L["Show Arena Team Info"], 
					desc = L["Toggles display of arena team info"],
					get = function() 
						return FuBar_ArenaFu.db.profile.tooltip.arenateam
					end,
					set = function(v) 
						FuBar_ArenaFu.db.profile.tooltip.arenateam = v; 
					end,
					order = 2,
				},
			}, order = 2,
		},
		calculate = {
			type = "group", 
			name = L["Calculate"], 
			desc = L["Calculate Arena Points and Arena Rating"], 
			args = {
				rating = {
					type = "text",
					name = L["Rating"],
					desc = L["Calcuate Arena Points from Rating"],
					get = false,
					set = function(v)
						print(getglobal("ARENA_TEAM_5V5").. " "..L["Points"],G:GetArenaPointsFromRating(v,5))
						print(getglobal("ARENA_TEAM_3V3").. " "..L["Points"],G:GetArenaPointsFromRating(v,3))
						print(getglobal("ARENA_TEAM_2V2").. " "..L["Points"],G:GetArenaPointsFromRating(v,2))
					end,
					usage = L["<rating>"],
					validate = function(v)
						return tonumber(v)
					end,
					order = 1,
				},
				point = {
					type = "text",
					name = L["Points"],
					desc = L["Calcuate Arena Rating from Points"],
					get = false,
					set = function(v)
						print(getglobal("ARENA_TEAM_5V5").. " "..L["Rating"],G:GetArenaRatingFromPoints(v,5))
						print(getglobal("ARENA_TEAM_3V3").. " "..L["Rating"],G:GetArenaRatingFromPoints(v,3))
						print(getglobal("ARENA_TEAM_2V2").. " "..L["Rating"],G:GetArenaRatingFromPoints(v,2))
					end,
					usage = L["<points>"],
					validate = function(v)
						return tonumber(v)
					end,
					order = 2,
				},
			}, 
			order = 3,
		},
		estimated = {
			type = "toggle",
			name = L["Show Estimated Points"],
			desc = L["Display estimated Points in PvP Frame"],
			get = function() 
				return FuBar_ArenaFu.db.profile.estimated
			end,
			set = function(v)
				FuBar_ArenaFu.db.profile.estimated = v; 
				FuBar_ArenaFu:OnDataUpdate()
			end,
			order = 4,
		},
	
	},
}

FuBar_ArenaFu:RegisterChatCommand({"/arenafu"}, opts)
FuBar_ArenaFu.OnMenuRequest = opts
