local tablet = AceLibrary("Tablet-2.0")
local G = AceLibrary("Glory-2.0")
local BC = AceLibrary("Babble-Class-2.2")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_ArenaFu")

FuBar_ArenaFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
local FuBar_ArenaFu = FuBar_ArenaFu
FuBar_ArenaFu.revision = tonumber(string.sub("$Revision: 39845 $", 12, -3)) or 1

FuBar_ArenaFu.hasIcon = "Interface\\PVPFrame\\PVP-ArenaPoints-Icon"
FuBar_ArenaFu.hasNoColor = true
FuBar_ArenaFu.clickableTooltip = true
FuBar_ArenaFu:RegisterDB("FuBar_ArenaFuDB")
FuBar_ArenaFu:RegisterDefaults("profile", {
	tooltip = {
		honor = true,
		arena = true,
	},
	text = {
		honor = true,
		arena = true,
	},
	estimated = true
})

local 	hk, cp, hPoints, thePoint, totalPoint

--[[function FuBar_ArenaFu:OnInitialize()
	FuBar_ArenaFu:OnEnable()
end]]

function FuBar_ArenaFu:OnEnable()
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "OnDataUpdate");
	self:RegisterEvent("ARENA_TEAM_UPDATE", "OnDataUpdate");
	self:RegisterEvent("ARENA_TEAM_ROSTER_UPDATE", "OnDataUpdate");
	self:RegisterEvent("PLAYER_PVP_KILLS_CHANGED", "OnDataUpdate");
	self:RegisterEvent("PLAYER_PVP_RANK_CHANGED", "OnDataUpdate");
	self:RegisterEvent("HONOR_CURRENCY_UPDATE", "OnDataUpdate");
end

function FuBar_ArenaFu:getTeamPoints(id)

	local teamName, teamSize, teamRating, weekPlayed, weekWins, seasonPlayed, seasonWins, playerPlayed, teamRank = GetArenaTeam(id);

	playedPercent = (playerPlayed / weekPlayed) * 100;

	if (weekPlayed < 10 or playedPercent < 30) then
			return 0;
	else
		return G:GetArenaPointsFromRating(teamRating, teamSize)
	end
end

function FuBar_ArenaFu:OnDataUpdate()
	hk, cp = GetPVPSessionStats();
	hPoints = GetHonorCurrency() + cp;

	thePoint = 0
	for i = 1, 3 do
		local tPoint, tSize = self:getTeamPoints(i)
		if thePoint < tPoint then
			thePoint = tPoint
		end
	end
	totalPoint = thePoint + GetArenaCurrency()
	if self.db.profile.estimated then
		PVPFrameHonorPoints:SetText("|cffffcc00"..GetHonorCurrency().."|r  +  |cff00ff00"..cp.."|r|cffffffff  =  |r|cff00ccff"..hPoints.."|r")
		PVPFrameArenaPoints:SetText("|cffffcc00"..GetArenaCurrency().."|r|cffffffff  +  |r|cff00ff00"..thePoint.."|r|cffffffff  =  |r|cff00ccff"..totalPoint.."|r")
	end
	self:OnTextUpdate()

end

function FuBar_ArenaFu:OnTextUpdate()
	local Arena_Text = ""
	if self.db.profile.text.honor then
		if self.db.profile.text.short then
			Arena_Text = L["H: "].."|cff00ccff"..cp.."|r"
		else
			Arena_Text = L["Honor: "].."|cff00ccff"..cp.."|r"
		end
		if self.db.profile.text.arena then
			if self.db.profile.text.short then
				Arena_Text = Arena_Text.." / "..L["A: "].."|cff00ccff"..thePoint.."|r"
			else
				Arena_Text = Arena_Text.." / " ..L["Arena: "].."|cff00ccff"..thePoint.."|r"
			end
		end
	else
		if self.db.profile.text.arena then
			if self.db.profile.text.short then
				Arena_Text = L["A: "].."|cff00ccff"..thePoint.."|r"
			else
				Arena_Text = L["Arena: "].."|cff00ccff"..thePoint.."|r"
			end
		end

	end
	if self.db.profile.text.arenateam then
		ArenaTeamRoster(1);
		ArenaTeamRoster(2);
		ArenaTeamRoster(3);
		local teamText
		local OnlineCount = { }
		for i = 1, 3 do
			local teamName, teamSize = GetArenaTeam(i);
			if teamName then
				local onlineCount = -1
				for j = 1, 10 do
					local _, _, _, _, online = GetArenaTeamRosterInfo(i, j);
					if online then
						onlineCount = onlineCount + 1
					end
				end
				OnlineCount[teamSize] = onlineCount
			end
		end
		for k , v in pairs(OnlineCount) do
			if v > 0 then
				if not teamText then
					if self.db.profile.text.short then
						teamText = L["O: "]..k.."|cff00ccff("..v..")|r"
					else
						teamText = L["Online: "]..k.."|cff00ccff("..v..")|r"
					end
				else
					teamText = teamText..", "..k.."|cff00ccff("..v..")|r"
				end

			end
		end
		if Arena_Text ~= "" and teamText then
			Arena_Text = Arena_Text.." / "..teamText
		elseif teamText then
			Arena_Text = teamText
		end
	end
	if Arena_Text == "" then
		Arena_Text = "|cff00ccffArena|rFu"
	end

	self:SetText(Arena_Text)
end

function FuBar_ArenaFu:OnTooltipUpdate()
	local cat
	if self.db.profile.tooltip.honor then
		cat = tablet:AddCategory(
			'columns', 2,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1
		)
		cat:AddLine(
			'text', getglobal("HONOR_CONTRIBUTION_POINTS"),
			'textR', 1,
			'textG', 1,
			'textB', 1,
			'text2', GetHonorCurrency(),
			'text2R', 1,
			'text2G', 1,
			'text2B', 0
		)
		cat = tablet:AddCategory(
			'columns', 3,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1
		)
		cat:AddLine(
			'text', getglobal("HONORABLE_KILLS"),
			'textR', 0,
			'textG', 1,
			'textB', 0,
			'text2', getglobal("HONOR_ESTIMATED_TOOLTIP"),
			'text2R', 0,
			'text2G', 1,
			'text2B', 0,
			'text3', L["Estimated Honor Points"],
			'text3R', 0,
			'text3G', 1,
			'text3B', 0
		)
		cat:AddLine(
			'text', hk,
			'textR', 1,
			'textG', 1,
			'textB', 1,
			'text2', cp == 0 and L["No Estimated Honor Points"] or cp,
			'text2R', 1,
			'text2G', 1,
			'text2B', 0,
			'text3', cp ~= 0 and hPoints or "",
			'text3R', 0,
			'text3G', 0.8,
			'text3B', 1
		)
		cat:AddLine(
		'text', ""
		)
	end
	if self.db.profile.tooltip.arena then
		cat = tablet:AddCategory(
			'columns', 2,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1
		)
		cat:AddLine(
			'text', getglobal("ARENA_POINTS"),
			'textR', 1,
			'textG', 1,
			'textB', 1,
			'text2', GetArenaCurrency(),
			'text2R', 1,
			'text2G', 1,
			'text2B', 0
		)
		cat = tablet:AddCategory(
			'columns', 6,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1
		)
		cat:AddLine(
			'text', getglobal("ARENA_TEAM"),
			'textR', 0,
			'textG', 1,
			'textB', 0,
			'text2', L["Team Name"],
			'text2R', 0,
			'text2G', 1,
			'text2B', 0,
			'text3', getglobal("GAMES").."/"..getglobal("WIN_LOSS"),
			'text3R', 0,
			'text3G', 1,
			'text3B', 0,
			'text4', getglobal("RATING"),
			'text4R', 0,
			'text4G', 1,
			'text4B', 0,
			'text5', L["Estimated Arena Point"],
			'text5R', 0,
			'text5G', 1,
			'text5B', 0,
			'text6', L["Online"],
			'text6R', 0,
			'text6G', 1,
			'text6B', 0
		)
		for i= 1, 3 do
			local teamName, teamSize, teamRating, weekPlayed, weekWins, seasonPlayed, seasonWins, playerPlayed, teamRank = GetArenaTeam(i);
			if teamName then
				local expectPoint = G:GetArenaPointsFromRating(teamRating, teamSize)
				local onlineCount = -1
				for j = 1, 10 do
					local name, rank, level, class, online = GetArenaTeamRosterInfo(i, j);
					if online then
						onlineCount = onlineCount + 1
					end
				end
				cat:AddLine(
					'text', getglobal("ARENA_TEAM_"..teamSize.."V"..teamSize),
					'textR', 1,
					'textG', 1,
					'textB', 1,
					'text2', teamName,
					'text2R', 1,
					'text2G', 1,
					'text2B', 0,
					'text3', weekPlayed.."/"..weekWins.."-"..weekPlayed-weekWins,
					'text3R', 1,
					'text3G', 1,
					'text3B', 1,
					'text4', teamRating,
					'text4R', 1,
					'text4G', 1,
					'text4B', 0,
					'text5', expectPoint,
					'text5R', 0,
					'text5G', 1,
					'text5B', 0,
					'text6', onlineCount,
					'text6R', 0,
					'text6G', 1,
					'text6B', 0,
					'func', 'OnTeamClick',
					'arg1', self,
					'arg2', i
				)
			end
		end
		cat:AddLine(
			'text', ""
		)
		cat = tablet:AddCategory(
			'columns', 2,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1
		)
		cat:AddLine(
			'text', L["Total Estimated Arena Point"]..":",
			'textR', 0,
			'textG', 1,
			'textB', 0,
			'text2', totalPoint,
			'text2R', 0,
			'text2G', 0.8,
			'text2B', 1
		)
	end
	if self.db.profile.tooltip.arenateam then
		ArenaTeamRoster(1);
		ArenaTeamRoster(2);
		ArenaTeamRoster(3);
		for i = 1, 3 do
			local numMembers = GetNumArenaTeamMembers(i, 1);
			if numMembers then
				local teamName, teamSize  = GetArenaTeam(i);
				if teamName then
					cat = tablet:AddCategory(
						'columns', 2,
						'child_textR', 1,
						'child_textG', 1,
						'child_textB', 0,
						'child_text2R', 1,
						'child_text2G', 1,
						'child_text2B', 0
					)
					cat:AddLine(
						'text', teamName,
						'text2', teamSize.."vs"..teamSize
					)			
					cat = tablet:AddCategory(
						'columns', 4,
						'child_textR', 0.5,
						'child_textG', 0.5,
						'child_textB', 0.5,
						'child_text2R', 0.5,
						'child_text2G', 0.5,
						'child_text2B', 0.5,
						'child_text3R', 0.5,
						'child_text3G', 0.5,
						'child_text3B', 0.5,
						'child_text4R', 0.5,
						'child_text4G', 0.5,
						'child_text4B', 0.5
					)
					cat:AddLine(
						'text', getglobal("NAME"),
						'textR', 0,
						'textG', 1,
						'textB', 0,
						'text2', getglobal("CLASS"),
						'text2R', 0,
						'text2G', 1,
						'text2B', 0,
						'text3', getglobal("PLAYED"),
						'text3R', 0,
						'text3G', 1,
						'text3B', 0,
						'text4', getglobal("WIN_LOSS"),
						'text4R', 0,
						'text4G', 1,
						'text4B', 0
					)			
					for j = 1, numMembers do
						local name, rank, level, class, online, played, win, seasonPlayed, seasonWin = GetArenaTeamRosterInfo(i, j);
						local r, g, b;
						if online and UnitName("player") ~= name then
							if ( rank > 0 ) then
								r = 1.0;
								g = 1.0;
								b = 1.0;
							else
								r = 1.0;
								g = 0.82;
								b = 0.0;
							end
							cat:AddLine(
								'text', "|cff"..BC:GetHexColor(class)..name.."|r",
								'text2', class,
								'text2R', r,
								'text2G', g,
								'text2B', b,
								'text3', played,
								'text3R', r,
								'text3G', g,
								'text3B', b,
								'text4', win.."-"..played-win,
								'text4R', r,
								'text4G', g,
								'text4B', b,
								'func', 'OnNameClick',
								'arg1', self,
								'arg2', name
							)			
						elseif UnitName("player") ~= name then
							cat:AddLine(
								'text', name,
								'text2', class,
								'text3', played,
								'text4', win.."-"..played-win
							)			
						end
					end
				end
			end
		end
	end
	tablet:SetHint(L["|cffeda55fClick|r Team to toggle team detail window.\n|cffeda55fALT-Click|r Team to invite online team player.\n|cffeda55fClick|r Player to whispher to player.\n|cffeda55fALT-Click|r Player to invite player."])
end

function FuBar_ArenaFu:OnClick()
	ToggleCharacter("PVPFrame")
end

function FuBar_ArenaFu:OnNameClick(name)
	if not name then return end
	if IsAltKeyDown() then
		InviteUnit(name)
	else
		SetItemRef("player:"..name, "|Hplayer:"..name.."|h["..name.."|h", "LeftButton")
	end
end

function FuBar_ArenaFu:OnTeamClick(id)
	if not id then return end
	if IsAltKeyDown() then
		local numMembers = GetNumArenaTeamMembers(id, 1);
		for i = 1, numMembers do
			local name, _, _, _, online = GetArenaTeamRosterInfo(id, i);
			if online and UnitName("player") ~= name then
				InviteUnit(name)
			end
		end
	else
		if getglobal("PVPTeamDetails"):IsShown() then
			local currentShow = tonumber(getglobal("PVPTeamDetailsSize"):GetText():sub(2,2))
			local _, teamSize = GetArenaTeam(id)
			if teamSize == currentShow then
				HideUIPanel(CharacterFrame);
			else
				PVPTeam_OnClick(id)
			end
		else
			ShowUIPanel(CharacterFrame);
			CharacterFrame_ShowSubFrame("PVPFrame");
			PVPTeam_OnClick(id)
		end
	end
end
