AmmoFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0")

AmmoFu.version = "2.0." .. string.sub("$Revision: 61389 $", 12, -3)
AmmoFu.date = string.sub("$Date: 2008-02-15 02:01:52 -0500 (Fri, 15 Feb 2008) $", 8, 17)
AmmoFu.hasIcon = "Interface\\AddOns\\FuBar_AmmoFu\\arrow"
AmmoFu.cannotDetachTooltip = true

--Localize globals
local NUM_BAG_SLOTS = NUM_BAG_SLOTS
local GetItemInfo, GetContainerNumSlots, GetInventoryItemCount, GetInventoryItemLink, ContainerIDToInventoryID, GetInventoryItemQuality = 
	    GetItemInfo, GetContainerNumSlots, GetInventoryItemCount, GetInventoryItemLink, ContainerIDToInventoryID, GetInventoryItemQuality
local class = select(2,UnitClass("player"))
AmmoFu.playerIsWarlock = (class == "WARLOCK")
AmmoFu.canUseAmmo = (class == "ROGUE" or class == "HUNTER" or class == "WARRIOR")
AmmoFu.ammoSlotId = GetInventorySlotInfo("ammoSlot")
AmmoFu.rangedSlotId = GetInventorySlotInfo("rangedSlot")

AmmoFu:RegisterDB("AmmoFuDB")
AmmoFu:RegisterDefaults('profile', {
	showPercent = false,
})

local Tablet = AceLibrary("Tablet-2.0")
local Crayon = AceLibrary("Crayon-2.0")
local Gratuity = AceLibrary("Gratuity-2.0")

local L = AceLibrary("AceLocale-2.2"):new("FuBar_AmmoFu")

function AmmoFu:IsShowingPercent()
	return self.db.profile.showPercent
end

function AmmoFu:ToggleShowingPercent()
	self.db.profile.showPercent = not self.db.profile.showPercent
	self:UpdateText()
end

function AmmoFu:OnEnable()
--	if self.playerIsWarlock or self.canUseAmmo then
		self:RegisterBucketEvent({"ITEM_LOCK_CHANGED", "UNIT_MODEL_CHANGED", "BAG_UPDATE","UNIT_INVENTORY_CHANGED"}, 5, "Update")
--	end
end

local options = {
	type = 'group',
	args = {
		percent = {
			type = 'toggle',
			name = L["Show as percentage"],
			desc = L["Toggle to show remaining ammunition as a percentage"],
			get = "IsShowingPercent",
			set = "ToggleShowingPercent",
		}
	},
	handler = AmmoFu
}
AmmoFu:RegisterChatCommand(L["AceConsole-Commands"], options)
AmmoFu.OnMenuRequest = options

function AmmoFu:OnClick()
	for i = 1, NUM_BAG_SLOTS do
		local link = GetInventoryItemLink("player", ContainerIDToInventoryID(i))
		if link then
			local subtype = select(7, GetItemInfo(link))
			if subtype == L["Soul Bag"] or subtype == L["Ammo Pouch"] or subtype == L["Quiver"] then
				ToggleBag(i)
			end
		end
	end
end

function AmmoFu:OnTextUpdate()

	local current = 0
	local total = 0
	if self.playerIsWarlock then
		self:SetIcon("shard")
		for i = 1, NUM_BAG_SLOTS do
			local link = GetInventoryItemLink("player", ContainerIDToInventoryID(i))
			if link then
				local subtype = select(7, GetItemInfo(link))
				if subtype == L["Soul Bag"] then
					local size = GetContainerNumSlots(i)
					if size ~= nil and size > 0 then
						total = total + size
					end
				end
			end
		end
		current = GetItemCount(6265)
		if current > total then
			total = current
		end
		if total < 4 then	--There should be no bags smaller than 4 slots
			total = 4
		end
	elseif self.canUseAmmo then
		local isThrown = false
		local link = GetInventoryItemLink("player", self.rangedSlotId)
		if link then
			local subtype = select(7, GetItemInfo(link))
			if GetInventoryItemQuality("player", self.rangedSlotId) ~= nil and subtype == L["Thrown"] then
				self:SetIcon("knife")
				Gratuity:SetInventoryItem("player", self.rangedSlotId)
				current, total = Gratuity:FindDeformat(DURABILITY_TEMPLATE, nil, nil, nil, true)
			elseif GetInventoryItemQuality("player", self.ammoSlotId) ~= nil then
				self:SetIcon("arrow")
				current = GetInventoryItemCount("player", self.ammoSlotId)
				total = 0
				--Ignore player's backpack at index 0
				for i = 1, NUM_BAG_SLOTS do
					local link = GetInventoryItemLink("player", ContainerIDToInventoryID(i))
					if link then
						local subtype = select(7, GetItemInfo(link))
						if subtype == L["Quiver"] or subtype == L["Ammo Pouch"] then
							local size = GetContainerNumSlots(i)
							if size ~= nil and size > 0 then
								total = total + size * 200
							end
						end
					end
				end
				if total == 0 then
					total = 200
				end
			else
				self:SetIcon("arrow")
				current = 0
				total = 0
			end
		end
	else
		self:SetIcon("arrow")
		current = 0
		total = 0
	end

	local color
	if total == 0 then
		color = Crayon.COLOR_HEX_RED
        
		if self:IsShowingPercent() then
			self:SetText(format("|cff%s%d%%|r", color, 0))	-- if total is 0, report 0%
		else
			self:SetText(format("|cff%s%d|r", color, 0))	-- if total is 0, report 0
		end
	else
		color = Crayon:GetThresholdHexColor(current / total)

		if self:IsShowingPercent() then
			self:SetText(format("|cff%s%d%%|r", color, current / total * 100))
		else
			self:SetText(format("|cff%s%d|r", color, current))
		end
	end

end

function AmmoFu:OnTooltipUpdate()
	for i = 1, NUM_BAG_SLOTS do
		local link = GetInventoryItemLink("player", ContainerIDToInventoryID(i))
		if link then
			local subtype = select(7, GetItemInfo(link))
			if subtype == L["Soul Bag"] then
				Tablet:SetHint(L["Click to open your shard bag"])
				break
			elseif subtype == L["Ammo Pouch"] or subtype == L["Quiver"] then
				Tablet:SetHint(L["Click to open your ammunition bag"])
				break
			end
		end
	end
end

