﻿local tablet = AceLibrary("Tablet-2.0")
local deformat = AceLibrary("Deformat-2.0")
local PT = AceLibrary("LibPeriodicTable-3.1")

AlchemyFu = AceLibrary("AceAddon-2.0"):new(
"FuBarPlugin-2.0",
"AceEvent-2.0",
"AceConsole-2.0",
"AceDB-2.0")

local addon = AlchemyFu

local options = {
	type = "group",
	args = {
		reset = {
			type = "execute",
			name = "Reset statistics",
			desc = "Reset all data collected.",
			func = function(v)
				AlchemyFu.db.profile.counts = {}
				AlchemyFu.db.profile.creations = {}
				AlchemyFu:UpdateTooltip()
			end,
		},
	},
}

addon.hasIcon = "Interface\\Icons\\Trade_Alchemy"

function addon:OnInitialize()
	local revision = tonumber((string.match("$Revision: 31661 $", "^.-(%d+).-$"))) or 1
	if not self.version then self.version = "1.0" end
	self.version = self.version .. "." .. revision
	self.revision = revision

	self.name = "AlchemyFu"
	self:RegisterDB("AlchemyFuDB")
	self:RegisterDefaults("profile", {
		counts = {},
		creations = {},
	})
	self.OnMenuRequest = options
	self.clickableTooltip = true
end

function addon:OnEnable()
	self:RegisterEvent("CHAT_MSG_LOOT")
end

function addon:CHAT_MSG_LOOT(msg)
	local item, amount = deformat(msg, LOOT_ITEM_CREATED_SELF_MULTIPLE)
	if not item or not amount then
		item, amount = deformat(msg, LOOT_ITEM_CREATED_SELF), 1
	end

	if not item then return end

	local itemName, itemLink, itemRarity = GetItemInfo(item)
	if not itemLink then return	end

	local itemId = tonumber(select(3, itemLink:find("item:(%d+):")))
	if not itemId or not PT:ItemInSet(itemId, "Tradeskill.Crafted.Alchemy") then return	end

	-- Track creations, how many we have made of one item
	self.db.profile.creations[itemId] = (self.db.profile.creations[itemId] and self.db.profile.creations[itemId] or 0) + amount

	-- Track procs
	if not self.db.profile.counts[itemId] then
		self.db.profile.counts[itemId] = {}
	end

	self.db.profile.counts[itemId][amount] = (self.db.profile.counts[itemId][amount] and self.db.profile.counts[itemId][amount] or 0) + 1

	self:UpdateTooltip()
end

local currentExpand = nil
function addon:SetCurrentExpand(itemId)
	if currentExpand == itemId then
		currentExpand = nil
	else
		currentExpand = itemId
	end
	self:UpdateTooltip()
end

function addon:SendToChat(itemId)
	if not ChatFrameEditBox:IsVisible() then
		ChatFrameEditBox:Show()
	end

	local total = self.db.profile.creations[itemId]
	
	local str = ("I have created %dx%s."):format(total, select(2, GetItemInfo(itemId)))
	
	local data = self.db.profile.counts[itemId]
	local max = table.maxn(data)
	for i = 1, math.max(5, max) do
		local p_amount = data[i] or 0
		if p_amount > 0 then
			local percent = ((i * p_amount)/total)*100
			str = str .. (" x%d: %d%%"):format(i, percent)
		end
	end

	ChatFrameEditBox:Insert(str)
end

function addon:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 0,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)

	cat:AddLine(
		'textR', 1,
		'textG', 0.5,
		'textB', 0,
		'text2R', 1,
		'text2G', 0.5,
		'text2B', 0,
		'text', "Potion",
		'text2', "Amount"
	)

	local total, totalProc = 0, 0
	for itemId, amount in pairs(self.db.profile.creations) do
		cat:AddLine(
			'text', select(2, GetItemInfo(itemId)),
			'text2', (itemId == currentExpand) and "" or amount,
			'func', 'SetCurrentExpand',
			'arg1', self,
			'arg2', itemId
		)

		if itemId == currentExpand then
			local subcat = cat:AddCategory(
				'columns', 3,
				'child_textR', 0,
				'child_textG', 1,
				'child_textB', 0,
				'child_text2R', 1,
				'child_text2G', 1,
				'child_text2B', 1
			)
			subcat:AddLine(
				'textR', 1,
				'textG', 0.5,
				'textB', 0,
				'text2R', 1,
				'text2G', 0.5,
				'text2B', 0,
				'text', "Proc",
				'text2', "Count"
			)

			local data = self.db.profile.counts[itemId]
			--table.sort(data)
			local max = table.maxn(data)
			for i = 1, math.max(5, max) do
				local p_amount = data[i] or 0
				subcat:AddLine(
					'text', "   x" .. i,
					'text2', p_amount
				--	'text3', (((i * p_amount)/amount)*100) .. "%"
				)
			end
			subcat:AddLine(
				'text', "Total",
				'text2', amount
			)

			subcat:AddLine(
				'text', "Send data to chat frame",
				'textR', 1,
				'textG', 1,
				'textB', 0,
				'func', "SendToChat",
				'arg1', self,
				'arg2', itemId
			)
		end


		for p_amount, p_count in pairs(self.db.profile.counts[itemId]) do
			if p_amount > 1 then
				totalProc = totalProc + (p_count * p_amount)
			end
		end

		total = total + amount
	end


	cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)

	cat:AddLine(
		'textR', 1,
		'textG', 0.5,
		'textB', 0,
		'text', "Summary"
	)

	cat:AddLine(
		'text', "Total created",
		'text2', total
	)

	cat:AddLine(
		'text', "Total created /wo procs",
		'text2', total-totalProc
	)

	cat:AddLine(
		'text', "Total created /w procs",
		'text2', totalProc
	)

	tablet:SetHint("Click a potion to expand details")
end
