﻿AddonSpamFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")
AddonSpamFu:RegisterDB("AddonSpamFuDB")
AddonSpamFu:RegisterDefaults('profile', {
    sort = "name",
    trackwhisper = true,
    trackraid = true,
    trackparty = true,
    trackguild = false,
    trackbg = false,
    renameprefix = true,
    displaychatframe = "none",
  }
)

local tablet = AceLibrary("Tablet-2.0")
local roster = AceLibrary("Roster-2.1")

local strlen = string.len
local strformat = string.format
local tsort = table.sort
local strgsub = string.gsub
local DisplayChatFrame
local playername
local runTime --Incremented every second to keep track of how long we've been watching
local dataChanged --Flag which is set when we receive a new Addon Message. While it's not set, we don't do any sorting

AddonSpamFu.revision = tonumber(("$Revision: 75899 $"):sub(12, -3))

local L = AceLibrary("AceLocale-2.2"):new("AddonSpamFu")
L:RegisterTranslations("enUS", function()
  return {
    ["Sort By"] = true,
    ["Sort Tooltip Lines By"] = true,
    ["Name"] = true,
    ["Bytes"] = true,
    ["Track"] = true,
    ["Choose which types of addon messages to track"] = true,
    ["Toggles recording %s addon messages"] = true, --"%s" is replaced by WHISPER, GUILD, PARTY, BATTLEGROUND, or RAID
    ["Rename Prefixes"] = true,
    ["Display Messages in"] = true,
    ["Toggles renaming ambiguous prefixes. Only affects future data"] = true,
    ["Choose where to display Addon Messages"] = true,
    ["Don't Display"] = true,
    ["No Data Observed Yet"] = true,
    ["# Msgs"] = true,
    ["Collecting for"] = true,
    ["My Spam"] = true,
    ["HINT"] = "|cffeda55fShift Click|r to clear data, |cffeda55fRight-click|r for options"
  }
end)
--deDE translation courtesy of Farook
L:RegisterTranslations("deDE", function()
  return {
    ["Sort By"] = "Sortieren nach",
    ["Sort Tooltip Lines By"] = "Tooltip-Zeilen sortieren nach",
    ["Name"] = "Name",
    ["Bytes"] = "Bytes",
    ["Track"] = "Track",
    ["Choose which types of addon messages to track"] = "Ausw\195\164hlen welche Arten von Addon-Nachrichten zur\195\188ckverfolgt werden sollen",
    ["Toggles recording %s addon messages"] = "Schalten die Aufzeichnung von %s-Addon-Nachrichten ein/aus",
    ["Rename Prefixes"] = "Vorwahlen umbenennen",
    ["Display Messages in"] = "Nachrichten anzeigen in",
    ["Toggles renaming ambiguous prefixes. Only affects future data"] = "Schaltet das Umbenennen von unklaren Vorwahlen ein/aus. Hat nur Auswirkungen auf k\195\188nftige Daten",
    ["Choose where to display Addon Messages"] = "Ausw\195\164hlen wo die Addon-Nachrichten angezeigt werden sollen",
    ["Don't Display"] = "Nicht anzeigen",
    ["No Data Observed Yet"] = "Bisher keine Daten beobachtet!",
    ["# Msgs"] = "# Msgs",
    ["Collecting for"] = "Sammelnd f\195\188r",
    ["My Spam"] = "Mein Spam",
    ["HINT"] = "|cffeda55fSHIFT-Klick|r um Daten zu l\195\182schen, |cffeda55fRechtsklick|r f\195\188r die Optionen"
  }
end)

L:RegisterTranslations("koKR", function() return {
  ["Sort By"] = "정렬",
  ["Sort Tooltip Lines By"] = "툴팁 정렬",
  ["Name"] = "이름",
  ["Bytes"] = "용량",
  ["Track"] = "집계",
  ["Choose which types of addon messages to track"] = "어떤 애드온 메세지를 집계할지 선택하세요",
  ["Toggles recording %s addon messages"] = "%s 애드온 메세지 집계를 켬/끔", --"%s" is replaced by WHISPER, GUILD, PARTY, BATTLEGROUND, or RAID
  ["Rename Prefixes"] = "접두사 재설정",
  ["Display Messages in"] = "메세지 표시: ",
  ["Toggles renaming ambiguous prefixes. Only affects future data"] = "접두사를 재설정하여 표시합니다. 설정 후 집계에만 적용됩니다.",
  ["Choose where to display Addon Messages"] = "애드온 메세지를 표시할 곳을 선택하세요",
  ["Don't Display"] = "표시하지 않음",
  ["No Data Observed Yet"] = "집계되지 않음",
  ["# Msgs"] = "# 메세지",
  ["Collecting for"] = "집계 시간: ",
  ["My Spam"] = "내가 보낸 정보",
  ["HINT"] = "초기화: |cffeda55f쉬프트 클릭|r, 옵션: |cffeda55f오른쪽 클릭|r"
} end)

local options = {
  type = "group",
  args = {
    sort = {
      order = 20,
      name = L["Sort By"],
      desc = L["Sort Tooltip Lines By"],
      type = "text",
      get = function() return AddonSpamFu.db.profile.sort end,
      set = function(value)
              AddonSpamFu.db.profile.sort = value
              if value == "name" then
                tsort(AddonSpamFu.sortedSpam, AddonSpamFu.sorts.NAME)
              else
                dataChanged = true
              end
              AddonSpamFu:UpdateTooltip()
            end,
      validate = {name = L["Name"], amount = L["Bytes"]},
    },
    track = {
      type = "group",
      order = 30,
      name = L["Track"],
      desc = L["Choose which types of addon messages to track"],
      args = {
        trackwhisper = {
          type = 'toggle',
          name = "WHISPER",
          desc = strformat(L["Toggles recording %s addon messages"], "WHISPER"),
          get = function() return AddonSpamFu.db.profile.trackwhisper end,
          set = function() AddonSpamFu.db.profile.trackwhisper = not AddonSpamFu.db.profile.trackwhisper end,
        },
        trackraid = {
          type = 'toggle',
          name = "RAID",
          desc = strformat(L["Toggles recording %s addon messages"], "RAID"),
          get = function() return AddonSpamFu.db.profile.trackraid end,
          set = function() AddonSpamFu.db.profile.trackraid = not AddonSpamFu.db.profile.trackraid end,
        },
        trackparty = {
          type = 'toggle',
          name = "PARTY",
          desc = strformat(L["Toggles recording %s addon messages"], "PARTY"),
          get = function() return AddonSpamFu.db.profile.trackparty end,
          set = function() AddonSpamFu.db.profile.trackparty = not AddonSpamFu.db.profile.trackparty end,
        },
        trackguild = {
          type = 'toggle',
          name = "GUILD",
          desc = strformat(L["Toggles recording %s addon messages"], "GUILD"),
          get = function() return AddonSpamFu.db.profile.trackguild end,
          set = function() AddonSpamFu.db.profile.trackguild = not AddonSpamFu.db.profile.trackguild end,
        },
        trackbg = {
          type = 'toggle',
          name = "BATTLEGROUND",
          desc = strformat(L["Toggles recording %s addon messages"], "BATTLEGROUND"),
          get = function() return AddonSpamFu.db.profile.trackbg end,
          set = function() AddonSpamFu.db.profile.trackbg = not AddonSpamFu.db.profile.trackbg end,
        },
      },
    },
    renameprefix = {
      type = 'toggle',
      name = L["Rename Prefixes"],
      desc = L["Toggles renaming ambiguous prefixes. Only affects future data"],
      order = 10,
      get = function() return AddonSpamFu.db.profile.renameprefix end,
      set = function() AddonSpamFu.db.profile.renameprefix = not AddonSpamFu.db.profile.renameprefix end,
    },
    displaychatframe = {
      type = "text",
      name = L["Display Messages in"],
      desc = L["Choose where to display Addon Messages"],
      order = 40,
      get = function() return AddonSpamFu.db.profile.displaychatframe end,
      set = function(chatframename)
              if chatframename ~= "none" then
                DisplayChatFrame = _G[chatframename]
              else
                DisplayChatFrame = nil
              end
              AddonSpamFu.db.profile.displaychatframe = chatframename
            end,
      validate = {
        none = L["Don't Display"],
        ChatFrame1 = "ChatFrame1",
        ChatFrame2 = "ChatFrame2",
        ChatFrame3 = "ChatFrame3",
        ChatFrame4 = "ChatFrame4",
        ChatFrame5 = "ChatFrame5",
        ChatFrame6 = "ChatFrame6",
        ChatFrame7 = "ChatFrame7"
      },
    },
  },
}

-- FuBar Initializations
AddonSpamFu.hasIcon = "Interface\\Icons\\INV_Letter_16"
AddonSpamFu.clickableTooltip = true
AddonSpamFu.OnMenuRequest = options
AddonSpamFu.defaultPosition = "LEFT"

function AddonSpamFu:OnInitialize()
  playername = UnitName("player")
  if self.db.profile.displaychatframe ~= "none" then
    DisplayChatFrame = _G[self.db.profile.displaychatframe]
  end

  self.SpamData = {}
  self.sortedSpam = {}
  self.sortedPrefixes = {}
  self.translatePrefixes = {
    -- Obvious ones are in the list so that they will be found right away and
    -- we can avoid attempting to string.match the complex prefixes
    ArenaMaster = "Arena Master",
    BigWigs = "BigWigs",
      BWVQ = "BigWigs", --BigWigs version query
      BWVR = "BigWigs", --BigWigs version response
    CastCommLib = "CastCommLib",
    DamageMeters = "DamageMeters",
    ForteWarlock = "ForteWarlock",
    GUILDMAP = "GuildMap",
    HealBot = "HealBot",
    lugMD = "lugMD",
    PartyCastingBars = "PartyCastingBars",
    QuestAnnouncer = "QuestAnnouncer",  --enUS, deDE, zhCN http://www.wowinterface.com/downloads/fileinfo.php?id=5343
    Rupture = "Rupture",
    SmartRes = "SmartRes",
    SSPVP = "SSPVP",
    VisualHeal = "VisualHeal",
    ["X-Perl"] = "X-Perl",

    --AceComm Hashes
    ["\198\137h"] = "Violation",
    ["\252\245G"] = "QuestsFu",
    ["2\224\237"] = "Cartographer [Guild Positions]",
      CGP = "Cartographer [Guild Positions]",
    ["\137\016"] = "Cartographer [Notes]",
      CaN = "Cartographer [Notes]",
    ["\1813T"] = "Recount",
      ["RECOUNT"] = "Recount",
    ["\1675B"] = "Recap",
    ["h\031Y"] = "InventoryLib-2.0",
    [".\136="] = "Proximo",
    ["p\190\246"] = "SimpleMD",
    ["\1484\008"] = "VanasKoS",
    ["QQ6"] = "TooltipExchange",  -- TooltipExchange protocol 6
    ["\1613["] = "BagPress",
    [")\252$"] = "AceComm [VersionCheck]", --Hash of "Version". VersionChecker also uses
    ["\234\218\230"] = "Gladiator",
    ["k\227D"] = "GPSLib",
--    ["\235\1742"] = "Unknown",
--    ["\198\232\192"] = "Unknown",  --"[\198\232\192][ca-\002m\007\178A+\129\246\230\199\182E\161\203][RAID][A Mage]"
--    ["D?"] = "ControlArena",
--      BGGQ = "Gladiator",

    ALF_T = "Arena Live Frames",
    ArenaUnitFrames = "Arena Unit Frames",
    ["Audio Effects"] = "AFX",
    AucAdvAskPrice = "Auctioneer",
    BFC = "Battlefield Commander",
    chatmod = "ChatMOD",
    CTRA = "CTRaidAssist",
    DTMR = "DoTimer",
    FBAM = "Fishing Buddy",
    GathX = "Gatherer",
    GMSD = "GatherMate Sharing",
    gqAccept = "Guild Quests",
      gqLogout = "Guild Quests",
      gqRemove = "Guild Quests",
      gqReply = "Guild Quests",
    GC3 = "GroupCalendar",
      ["GC3/"] = "GroupCalendar",  -- Does this one actually get sent?
      GC4 = "GroupCalendar",
      ["GC4/"] = "GroupCalendar",  -- Does this one actually get sent?
    GDALootlist = "GetDKP",
    HealBot_Heals = "HealBot",
    HealComm = "HealComm-2.0",
    IHL = "IncomingHealsLib-1.0",
    KALIFCMSG = "Forecast",
    KLHTM = "KLHThreatMeter",
    LGP = "LibGuildPositions-1.0",
    ["LOOT_OPENED"] = "AceEvent-2.0 [Loot Opened]",
    LVBM = "Deadly Boss Mods",
      ["LVBM NSP"] = "Deadly Boss Mods",  --"[LVBM NSP][REQ VER 2.71][RAID][<Name1>]" "[LVBM NSP][VER 2.71][RAID][<Name2>]"
      --DBM* = "Deadly Boss Mods",
    MS1 = "MinnaStats",
    NECB = "Natur EnemyCastBar",
      NECBCHAT = "Natur EnemyCastBar",
      NECBCTRA = "Natur EnemyCastBar",
    ["Nurfed:Lyt"] = "Nurfed Layout",
    oRA = "oRA2",
    oRA3 = "oRA3",
    ["<<PiraCore>>"] = "PiraMod",
    Pit = "PitBull",
    PLPWR = "PallyPower",
    Quecho = "Quecho",
      Quecho2 = "Quecho", --turned in
      Quecho3 = "Quecho", --accepted
    QHpr = "QuestHelper",
    ["R\195\159"] = "RecipeBook",
    RID = "Raid ID",
    RTM = "RezzTextMonitor",
    SSAF = "SSArena Frames",
    StinkyQ = "StinkyQueue",
    --$Tranq* = "SimpleTranqShot",
    SWSudX21 = "SW_Stats",
      SWSHSX21 = "SW_Stats",
      SWSudX22 = "SW_Stats",
      SWSHSX22 = "SW_Stats",
      SWSVC7w7 = "SW_Stats",
    TAL = "LibRockComm-1.0",
      UnT = "LibRockComm-1.0",
      VER = "LibRockComm-1.0",
    Thr = "Threat-1.0",
    TL2 = "Threat-2.0",
      ["TL2\001"] = "Threat-2.0",
      ["TL2\002"] = "Threat-2.0",
      ["TL2\003"] = "Threat-2.0",
    tradeDispenser = "Trade Dispenser",
    VisualHeal = "VisualHeal",
    WIM = "WoW Instant Messenger",
      ["WIM_W2W"] = "WoW Instant Messenger",
    WL_LOOTCOOLDOWN_NPC = "Wowhead Looter",
      WL_LOOTCOOLDOWN_OBJECT = "Wowhead Looter",
    WRUGSAUTH = "WRUGS Anti-Spam"
  }

  self.sorts ={
    NAME =  function(a,b)
              if a.totalData == 0 then  --Make sure that stuff with 0 entries is put at the end of the table
                return false
              elseif b.totalData == 0 then
                return true
              end
              return a.name < b.name
            end,
    AMOUNT =  function(a,b)
                if a.totalData == b.totalData then
                  return self.sorts.NAME(a, b)
                else
                  return ( a.totalData > b.totalData )
                end
            end,
  }

  self:RegisterChatCommand({"/addonspamfu", "/asf"}, options, "ADDONSPAMFU")

  if(IsInGuild()) then
    GuildRoster()
  end

  --Hook SendAddonMessage functions only once
  hooksecurefunc("SendAddonMessage", function(...) if self.isEnabled then self:SendAddonMessage(...) end end)
  if ChatThrottleLib then
    hooksecurefunc(ChatThrottleLib,"SendAddonMessage", function(_, _, ...) if self.isEnabled then self:SendAddonMessage(...) end end)
  end
end

function AddonSpamFu:OnEnable()
  self.isEnabled=true
  runTime = 0
  self:ScheduleRepeatingEvent(self.EverySec, 1, self)
  self:RegisterEvent("CHAT_MSG_ADDON", "AddMessage")

  self:UpdateText()
end

function AddonSpamFu:OnDisable()
  self.isEnabled=false
  self.SpamData = {}
  self.sortedSpam = {}
  self.sortedPrefixes = {}
end

function AddonSpamFu:EverySec()
  runTime = runTime + 1
  self:UpdateTooltip()
end

function AddonSpamFu:OnClickGroup(name)
  if not self.SpamData[name].classColor then
    self.SpamData[name].classColor = self:GetClassColorfromName(name)
  end
  if (self.SpamData[name].isCollapsed) then
    self.SpamData[name].isCollapsed = nil
  else
    self.SpamData[name].isCollapsed = true
  end
  self:UpdateTooltip()
end

function AddonSpamFu:OnClick()
  if IsShiftKeyDown() then
    if self.sortedSpam[1] then self.sortedSpam[1].totalData = 0 end
    runTime = 0

    for name, nametable in pairs(self.SpamData) do
      self.SpamData[name].msgCount = 0
      self.SpamData[name].totalData = 0
      for prefix, _ in pairs(nametable.prefixes) do
        self.SpamData[name].prefixes[prefix].data = 0
        self.SpamData[name].prefixes[prefix].msgCount = 0
      end
    end
    self:UpdateText()
  end
end

--Update the sorted table's amount values
function AddonSpamFu:updateSortSpamAmounts()
  for index, nametable in pairs(self.sortedSpam) do
    self.sortedSpam[index].totalData = self.SpamData[nametable.name].totalData
  end
  tsort(self.sortedSpam, self.sorts.AMOUNT)
end

local function escapeChar(c)
    return ("\\%03d"):format(c:byte())
end

function AddonSpamFu:OnTooltipUpdate()
  if self.db.profile.sort == "amount" and dataChanged then
    self:updateSortSpamAmounts()
    dataChanged = nil
  end

  tablet:SetHint( L["HINT"] )
  local cat = tablet:AddCategory(
    'columns', 3
  )

  local min = math.floor( runTime/60 )
  local sec = math.floor(runTime - min*60)
  if sec < 10 then
    sec = ":0"..sec
  else
    sec = ":"..sec
  end

  if not self.sortedSpam[1] or self.sortedSpam[1].totalData == 0 then
    cat:AddLine(
      'text2', L["No Data Observed Yet"],
      'text2R', 1,
      'text2G', 1,
      'text2B', 1
    )
    cat:AddLine(
      'text', " "
    )
    cat:AddLine(
      'text2', L["Collecting for"]..": "..min..sec
    )
    return
  end

  cat:AddLine(
    'text', L["Name"]..(self.db.profile.sort == "name" and "*" or ""),
    'text2', L["# Msgs"],
    'text3', L["Bytes"]..(self.db.profile.sort == "amount" and "*" or "").." -"
  )
  --Add a line for each name with name and total
  for _, sortednametable in pairs(self.sortedSpam) do
    local nametable = self.SpamData[sortednametable.name]
    if  nametable.totalData > 0 then
      cat:AddLine(
        'hasCheck', true,
        'checked', true,
        'checkIcon', nametable.isCollapsed and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up",
        'func', 'OnClickGroup',
        'arg1', self,
        'arg2', sortednametable.name,
        'text', "|cff"..(nametable.classColor or "cccccc")..sortednametable.name.."|r"..(roster:GetUnitIDFromName(sortednametable.name) and "*" or ""),
        'text2', nametable.msgCount,
        'text2R', 1,
        'text2G', 1,
        'text2B', 1,
        'text3', nametable.totalData.." -",
        'text3R', 1,
        'text3G', 1,
        'text3B', 1
      )
      if not nametable.isCollapsed then
        --Make the sorted prefix table
        local prefixIndex = 1
        for prefix, prefixData in pairs(nametable.prefixes) do
          if prefixData.data > 0 then
            if not self.sortedPrefixes[prefixIndex] then
              self.sortedPrefixes[prefixIndex] = {}
            end
            self.sortedPrefixes[prefixIndex].name = prefix
            self.sortedPrefixes[prefixIndex].totalData = prefixData.data
            prefixIndex = prefixIndex + 1
          end
        end

        local numPrefixes = prefixIndex-1 --Keep track of how many prefixes we need to display

        while( prefixIndex <= #self.sortedPrefixes ) do
          self.sortedPrefixes[prefixIndex].totalData = 0
          prefixIndex = prefixIndex + 1
        end
        if self.db.profile.sort == "name" then
          tsort(self.sortedPrefixes, self.sorts.NAME)
        else
          tsort(self.sortedPrefixes, self.sorts.AMOUNT)
        end

        for loopvar=1,numPrefixes do
          cat:AddLine(
            'text', "   "..strgsub(self.sortedPrefixes[loopvar].name, "[%c\092\128-\255]", escapeChar),
            'text2', nametable.prefixes[self.sortedPrefixes[loopvar].name].msgCount,
            'text3', self.sortedPrefixes[loopvar].totalData.." -"
          )
        end
      end
    end
  end
  cat:AddLine(
    'text', " "
  )

  cat:AddLine(
    'text', L["Collecting for"],
    'text3', min..sec.." -"
  )
end

function AddonSpamFu:OnTextUpdate()
  local totalData = (self.SpamData[playername] and self.SpamData[playername].totalData) or 0

  if self:IsTextColored() then
    self:SetText("|cffffffff"..L["My Spam"]..":|r |cffffff00"..totalData.."|r")
  else
    self:SetText(L["My Spam"]..": "..totalData)
  end
end

function AddonSpamFu:GetClassHexColor(class)
	local color = RAID_CLASS_COLORS[class]

	if not color then
		return "cccccc"
	else
		return ("%.2x%.2x%.2x"):format(color.r*255,color.g*255,color.b*255);
	end
end

function AddonSpamFu:GetClassColorfromName(name)
  if roster then
    local unit = roster:GetUnitObjectFromName(name)
    if unit then
      return self:GetClassHexColor(unit.class)
    end
  end

  if IsInGuild() then
    local numInGuild = GetNumGuildMembers(false)
    local currname, class
    while numInGuild > 0 do
      currname,_,_,_,_,_,_,_,_,_,class = GetGuildRosterInfo(numInGuild)
      if currname == name then
        return self:GetClassHexColor(class)
      end
      numInGuild = numInGuild - 1
    end
  end

  return "cccccc"
end

function AddonSpamFu:SendAddonMessage(prefix,data,msgtype,destination)
  --If this is an outgoing whisper message
  if msgtype == "WHISPER" and destination and destination ~= "" then
    self:AddMessage(prefix, data, msgtype, playername, destination)
  end
--  self.hooks["SendAddonMessage"](...)
end

function AddonSpamFu:AddMessage(prefix, msg, msgtype, name, destination)
  if (msg == nil) then
    msg = ""
  end
  local origPrefix = prefix
  local showRenamedPrefix = false

  if not destination then
    destination = ""
  else
    destination = " to "..destination..", from "
  end

  if self.db.profile.renameprefix then
    --Special Cases
    if self.translatePrefixes[prefix] then
      prefix = self.translatePrefixes[prefix]
      showRenamedPrefix = true
    elseif prefix:match("^DBM") then
      prefix = self.translatePrefixes.LVBM
      showRenamedPrefix = true
    elseif prefix:match("^EXAMINER#") then
      prefix = "Examiner"
      showRenamedPrefix = true
    elseif prefix:match("^$Tranq") then
      prefix = "SimpleTranqShot"
      showRenamedPrefix = true
    else
      -- Add this to the prefix table so it'll be found faster next time
      self.translatePrefixes[prefix] = prefix
    end
  end

  if DisplayChatFrame then
    if (not AddonSpamFu.db.profile.trackraid and msgtype == "RAID") or
       (not AddonSpamFu.db.profile.trackparty and msgtype == "PARTY") or
       (not AddonSpamFu.db.profile.trackguild and msgtype == "GUILD") or
       (not AddonSpamFu.db.profile.trackwhisper and msgtype == "WHISPER") or
       (not AddonSpamFu.db.profile.trackbg and msgtype == "BATTLEGROUND")
    then
      DisplayChatFrame:AddMessage(( (showRenamedPrefix and prefix..": |cffffbbbb[") or "|cffffbbbb[")..origPrefix.."]["..msg.."]["..msgtype.."]|r"..destination.."|cffffbbbb["..name.."]|r")
      return
    end
    DisplayChatFrame:AddMessage(( (showRenamedPrefix and prefix..": |cffa3feba[") or "|cffa3feba[")..origPrefix.."]["..msg.."]["..msgtype.."]|r"..destination.."|cffa3feba["..name.."]|r")
  end

  local dataLen = strlen(origPrefix) + strlen(msg)

  if dataLen == 0 then return end

  dataChanged = true
  --If we have created a table entry for this character name already
  if self.SpamData[name] then
    if not self.SpamData[name].classColor then
      self.SpamData[name].classColor = self:GetClassColorfromName(name)
    end
    if not self.SpamData[name].prefixes[prefix] then
      self.SpamData[name].prefixes[prefix] = {}
    end
    self.SpamData[name].prefixes[prefix].data = (self.SpamData[name].prefixes[prefix].data or 0) + dataLen
    self.SpamData[name].prefixes[prefix].msgCount = (self.SpamData[name].prefixes[prefix].msgCount or 0) + 1
    self.SpamData[name].msgCount = self.SpamData[name].msgCount + 1
    self.SpamData[name].totalData = self.SpamData[name].totalData + dataLen
    --Update spam amounts just to get  the amount over 0
    if self.db.profile.sort == "name" then
      if self.sortedSpam[1].totalData == 0 then
        self:updateSortSpamAmounts()
        tsort(self.sortedSpam, self.sorts.NAME)
      end
    end
  else  --New character name, add it to the table
    self.SpamData[name] = { msgCount = 1, totalData = dataLen, classColor = self:GetClassColorfromName(name) }
    self.SpamData[name].isCollapsed = true
    self.SpamData[name].prefixes = {}
    self.SpamData[name].prefixes[prefix] = { data = dataLen, msgCount = 1 }

    --Make sure that the new player name gets into the sorted table
    table.insert(self.sortedSpam, {name = name, totalData = dataLen})
    if self.db.profile.sort == "name" then
      tsort(self.sortedSpam, self.sorts.NAME)
    end
  end

  --If our own data changed, update the FuBar Text
  if name == playername then
    self:UpdateText()
  end
end
