local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AbramsFu")

local GetDodgeChance = GetDodgeChance
local GetParryChance = GetParryChance
local GetBlockChance = GetBlockChance
local UnitArmor = UnitArmor
local UnitDefense = UnitDefense
local UnitLevel = UnitLevel
local GetCombatRating = GetCombatRating

AbramsFu = Rock:NewAddon("AbramsFu", "LibFuBarPlugin-3.0", "LibRockConfig-1.0", "LibRockDB-1.0", "LibRockEvent-1.0")

AbramsFu:SetDatabase("AbramsFuDB")
AbramsFu:SetDatabaseDefaults("profile", {
	ar = 0,
	ag = 1,
	ab = 0,
	drr = 0,
	drg = .5,
	drb = 1,
	armr = 1,
	armg = 1,
	armb = 1,
	hr = 0,
	hg = .5,
	hb = 1,
	lr = 0,
	lg = 1,
	lb = 0,
	vr = 1,
	vg = 1,
	vb = 1,
	fuBarLabel = L["none"],
	showFuBarAV = true,
	showFuBarDR = true,
	showFuBarArmor = false,
	displayPrecisionFuBar = 2,
	showToolTipDefense = true,
	showToolTipCombat = true,
	showToolTipArmor = true,
	showToolTipDR = true,
	displayPrecisionToolTip = 2,
	showIcon = false,
	showText = true,
	baselineLevel = 0,
	alwaysUseBaseline = false,
})

AbramsFu.version = "1.0." .. string.sub("$Revision: 66823 $", 12, -3)
AbramsFu.date = string.sub("$Date: 2008-03-28 21:53:49 -0400 (Fri, 28 Mar 2008) $", 8, 17)
AbramsFu:SetFuBarOption("clickableTooltip", false)
AbramsFu:SetFuBarOption("defaultPosition", "CENTER")
AbramsFu:SetFuBarOption("hasIcon", true)
AbramsFu:SetFuBarOption("iconPath", "Interface\\Icons\\Spell_Holy_DevotionAura" )
AbramsFu:SetFuBarOption("tooltipType","GameTooltip")

function AbramsFu:OnInitialize()
  local optionsTable = {
    name = L["rockname"],
    desc = L["desc"],
    type = "group",
	  handler = AbramsFu,
    args = {
      colorg = {
        type = "group",
        name = L["colgn"],
        desc = L["colgd"],
        args = {
		      avoidcolor = {
			      type = "color",
			      name = L["avcn"],
			      desc = L["avcd"],
			      get = "GetAvoidanceColor",
			      set = "SetAvoidanceColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
		      drcolor = {
			      type = "color",
			      name = L["drcn"],
			      desc = L["avcd"],
			      get = "GetDRColor",
			      set = "SetDRColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
		      armcolor = {
			      type = "color",
			      name = L["armcn"],
			      desc = L["armcd"],
			      get = "GetArmorColor",
			      set = "SetArmorColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
		      headcolor = {
			      type = "color",
			      name = L["hcn"],
			      desc = L["hcd"],
			      get = "GetHeaderColor",
			      set = "SetHeaderColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
		      labelcolor = {
			      type = "color",
			      name = L["lcn"],
			      desc = L["lcd"],
			      get = "GetLabelColor",
			      set = "SetLabelColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
		      valuecolor = {
			      type = "color",
			      name = L["vcn"],
			      desc = L["vcd"],
			      get = "GetValueColor",
			      set = "SetValueColor",
			      disabled = function()
				      return not AbramsFu:IsFuBarTextColored()
		        end
		      },
	      },
      },
      fubarg = {
        type = "group",
        name = L["fubargn"],
        desc = L["fubargd"],
        args = {
		      showfbav = {
			      type = "toggle",
			      name = L["fbshavn"],
			      desc = L["fbshavd"],
			      get = "IsShowFuBarAV",
			      set = "ToggleShowFuBarAV",
		      },
		      showfbdr = {
			      type = "toggle",
			      name = L["fbshdrn"],
			      desc = L["fbshdrd"],
			      get = "IsShowFuBarDR",
			      set = "ToggleShowFuBarDR",
		      },
		      showfbarm = {
			      type = "toggle",
			      name = L["fbsharmn"],
			      desc = L["fbsharmd"],
			      get = "IsShowFuBarArmor",
			      set = "ToggleShowFuBarArmor",
		      },
		      labeltype = {
		        type = "text",
		        name = L["fblabeln"],
		        desc = L["fblabeld"],
		        get = "GetFuBarLabel",
		        set = "SetFuBarLabel",
		        validate = { L["none"],L["short"],L["long"] },
		      },
		      fbprecision = {
		        type = 'number',
		        name = L["fbprecn"],
		        desc = L["fbprecd"],
		        min = 0,
		        max = 4,
		        step = 1,
		        get = "GetFuBarDisplayPrecision",
		        set = "SetFuBarDisplayPrecision",
		      },
		    },
		  },
      tooltipg = {
        type = "group",
        name = L["tooltipgn"],
        desc = L["tooltipgd"],
        args = {
		      showttdef = {
			      type = "toggle",
			      name = L["ttshdefn"],
			      desc = L["ttshdefd"],
			      get = "IsShowToolTipDefense",
			      set = "ToggleShowToolTipDefense",
		      },
		      showttct = {
			      type = "toggle",
			      name = L["ttshcomn"],
			      desc = L["ttshcomd"],
			      get = "IsShowToolTipCombat",
			      set = "ToggleShowToolTipCombat",
		      },
		      showttarm = {
			      type = "toggle",
			      name = L["ttsharmn"],
			      desc = L["ttsharmd"],
			      get = "IsShowToolTipArmor",
			      set = "ToggleShowToolTipArmor",
		      },
		      showttdr = {
			      type = "toggle",
			      name = L["ttshdrn"],
			      desc = L["ttshdrd"],
			      get = "IsShowToolTipDR",
			      set = "ToggleShowToolTipDR",
		      },
		      ttprecision = {
		        type = 'number',
		        name = L["ttprecn"],
		        desc = L["ttprecd"],
		        min = 0,
		        max = 4,
		        step = 1,
		        get = "GetToolTipDisplayPrecision",
		        set = "SetToolTipDisplayPrecision",
		      },
        },
      },
		  calcg = {
		    type = "group",
		    name = L["calcgn"],
		    desc = L["calcgd"],
		    args = {
		      baseline = {
		        type = 'number',
		        name = L["blvln"],
		        desc = L["blvld"],
		        min = 0,
		        max = 73,
		        step = 1,
		        get = "GetBaselineLevel",
		        set = "SetBaselineLevel",
		      },
		      alwaysbl = {
			      type = "toggle",
			      name = L["alwaysbln"],
			      desc = L["alwaysbld"],
			      get = "IsAlwaysUseBaseline",
			      set = "ToggleAlwaysUseBaseline",
		      },
		    },
		  },
    }
  }
  AbramsFu:SetConfigTable(optionsTable)
  AbramsFu.OnMenuRequest = optionsTable
end

function AbramsFu:OnEnable()
  self:AddEventListener("Blizzard","PLAYER_ENTERING_WORLD","UpdateData")
  self:AddEventListener("Blizzard","CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS","UpdateData")
  self:AddEventListener("Blizzard","CHAT_MSG_SPELL_AURA_GONE_SELF","UpdateData")
  self:AddEventListener("Blizzard","UNIT_INVENTORY_CHANGED","UpdateData")
  self:AddEventListener("Blizzard","PLAYER_TARGET_CHANGED","UpdateData")
  self:AddEventListener("Blizzard","CHARACTER_POINTS_CHANGED","UpdateData")
  self:AddEventListener("Blizzard","PLAYER_LEVEL_UP","UpdateData") 
end

function AbramsFu:OnDisable()
  self:RemoveAllEventListeners()
end

function AbramsFu:UpdateData(namespace, event)
  self:UpdateFuBarText()
end


function AbramsFu:GetAvoidance()
	local baseDefense, armorDefense = UnitDefense("player")
	local totalDefense = baseDefense + armorDefense
	local maxDefense = self:GetMaxDefense()
	local avoid = (GetBlockChance() + GetParryChance() + GetDodgeChance())
	if totalDefense and maxDefense and (totalDefense > maxDefense) then
		avoid = avoid + (((totalDefense - maxDefense) + self:GetAnticipationBonus())*0.04 + 5)
	end
	return avoid
end

function AbramsFu:GetMaxDefense()
  local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier 
  local skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDescription
  local skillIndex
	for skillIndex = 1, GetNumSkillLines() do
		skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(skillIndex)
		if skillName == "Defense" then
			return skillMaxRank
		end
	end
end

function AbramsFu:GetAnticipationBonus()
  local bonus = 0
	local ucClass, ucEngClass = UnitClass("player")
	local nameTalent, iconPath, tier, column, currentRank, maxRank, isExceptional, meetsPrereq
  if (ucEngClass == "PALADIN") then
	  nameTalent, iconPath, tier, column, currentRank, maxRank, isExceptional, meetsPrereq = GetTalentInfo(2, 9)
	  if (currentRank > 0) then
		  bonus = 4*currentRank
	  end
	elseif (ucEngClass == "WARRIOR") then
		nameTalent, iconPath, tier, column, currentRank, maxRank, isExceptional, meetsPrereq = GetTalentInfo(3, 3)
		if currentRank > 0 then
  		bonus = 4*currentRank
  	end
  end
  return bonus
end

function AbramsFu:GetResilienceEffect()
	local level = UnitLevel("player")
	local rating = GetCombatRating(CR_CRIT_TAKEN_MELEE)
	local bonus = 0
	local factor = 0
	if (level < 11) then
		factor = (25 / 26)
	elseif (level < 61) then
		factor  = 25 * ((level-8)/52)
	elseif (level < 71) then
		factor  = 25 * (82/(262 - (3*level)))
	else
		factor  = 25 * ((level+12)/52)
	end
		bonus = factor * rating
	return bonus
end

function AbramsFu:GetDR()
  local dr = 0 
  local baseDR = self:GetBaseDR()
  dr = baseDR
  return dr
end

function AbramsFu:GetBaseDR()
  local dr = 0
  local calcLevel = self:GetCalcLevel()
  local baseArmor, totalArmor, nobuffArmor, armorBuffs, armorDebuffs = UnitArmor("player")
  if calcLevel < 60 then
    dr = (totalArmor / (totalArmor+400+85*calcLevel)) * 100
  else
    dr = (totalArmor / (totalArmor+400+85*(calcLevel+4.5*(calcLevel-59)))) * 100
  end
  return dr
end

function AbramsFu:GetHexColor(r,g,b)
  return string.format("%02x%02x%02x", r * 255, g * 255, b * 255)
end

function AbramsFu:GetBaselineLevel()
  return self.db.profile.baselineLevel
end

function AbramsFu:SetBaselineLevel(value)
  self.db.profile.baselineLevel = value
  self:UpdateFuBarPlugin()
end  

function AbramsFu:IsAlwaysUseBaseline()
  return self.db.profile.alwaysUseBaseline
end

function AbramsFu:ToggleAlwaysUseBaseline()
  self.db.profile.alwaysUseBaseline = not self.db.profile.alwaysUseBaseline
  self:UpdateFuBarPlugin()
  return self.db.profile.showFuBarDR
end

function AbramsFu:GetCalcLevel()
  if self.db.profile.alwaysUseBaseline then
    return self.db.profile.baselineLevel
  end
  local calcLevel = UnitLevel("target")
  if calcLevel == 0 then
    calcLevel = self.db.profile.baselineLevel
    if calcLevel == 0 then
      calcLevel = UnitLevel("player")
    end 
  end
  return calcLevel
end

function AbramsFu:OnUpdateFuBarText()
  displayString = ""
  formatString = string.format("%%s|cff%%s%%.%df%%%%|r ",self.db.profile.displayPrecisionFuBar)
  if self.db.profile.showFuBarAV then
    if self.db.profile.fuBarLabel == L["short"] then
      displayString = string.format("%s%s",displayString,L["shortAV"])
    elseif self.db.profile.fuBarLabel == L["long"] then
      displayString = string.format("%s%s",displayString,L["longAV"])
    end
    displayString = string.format(formatString,displayString,self:GetAvoidanceHexColor(),
      self:GetAvoidance())
  end
  if self.db.profile.showFuBarDR then
    if self.db.profile.fuBarLabel == L["short"] then
      displayString = string.format("%s%s",displayString,L["shortDR"])
    elseif self.db.profile.fuBarLabel == L["long"] then
      displayString = string.format("%s%s",displayString,L["longDR"])
    end
    displayString = string.format(formatString,displayString,self:GetDRHexColor(),
      self:GetDR())
  end
  if self.db.profile.showFuBarArmor then
    local baseArmor, totalArmor, nobuffArmor, armorBuffs, armorDebuffs = UnitArmor("player")
    if self.db.profile.fuBarLabel == L["short"] then
      displayString = string.format("%s%s",displayString,L["shortArmor"])
    elseif self.db.profile.fuBarLabel == L["long"] then
      displayString = string.format("%s%s",displayString,L["longArmor"])
    end
    displayString = string.format("%s|cff%s%d|r ",displayString,self:GetArmorHexColor(),
      totalArmor)
  end  
  self:SetFuBarText(displayString)
end

function AbramsFu:GetAvoidanceColor()
	return self.db.profile.ar, self.db.profile.ag, self.db.profile.ab
end

function AbramsFu:SetAvoidanceColor(r, g, b)
	self.db.profile.ar = r
	self.db.profile.ag = g
	self.db.profile.ab = b
	self:UpdateFuBarText()
end

function AbramsFu:GetAvoidanceHexColor()
	return self:GetHexColor(self.db.profile.ar, self.db.profile.ag, self.db.profile.ab)
end

function AbramsFu:GetDRColor()
	return self.db.profile.drr, self.db.profile.drg, self.db.profile.drb
end

function AbramsFu:SetDRColor(r, g, b)
	self.db.profile.drr = r
	self.db.profile.drg = g
	self.db.profile.drb = b
	self:UpdateFuBarText()
end

function AbramsFu:GetDRHexColor()
	return self:GetHexColor(self.db.profile.drr, self.db.profile.drg, self.db.profile.drb)
end

function AbramsFu:GetArmorColor()
	return self.db.profile.armr, self.db.profile.armg, self.db.profile.armb
end

function AbramsFu:SetArmorColor(r, g, b)
	self.db.profile.armr = r
	self.db.profile.armg = g
	self.db.profile.armb = b
	self:UpdateFuBarText()
end

function AbramsFu:GetArmorHexColor()
	return self:GetHexColor(self.db.profile.armr, self.db.profile.armg, self.db.profile.armb)
end

function AbramsFu:IsShowFuBarAV()
  return self.db.profile.showFuBarAV
end

function AbramsFu:ToggleShowFuBarAV()
  self.db.profile.showFuBarAV = not self.db.profile.showFuBarAV
  self:UpdateFuBarPlugin()
  return self.db.profile.showFuBarAV
end

function AbramsFu:IsShowFuBarDR()
  return self.db.profile.showFuBarDR
end

function AbramsFu:ToggleShowFuBarDR()
  self.db.profile.showFuBarDR = not self.db.profile.showFuBarDR
  self:UpdateFuBarPlugin()
  return self.db.profile.showFuBarDR
end

function AbramsFu:IsShowFuBarArmor()
  return self.db.profile.showFuBarArmor
end

function AbramsFu:ToggleShowFuBarArmor()
  self.db.profile.showFuBarArmor = not self.db.profile.showFuBarArmor
  self:UpdateFuBarPlugin()
  return self.db.profile.showFuBarArmor
end

function AbramsFu:GetFuBarDisplayPrecision()
  return self.db.profile.displayPrecisionFuBar
end

function AbramsFu:SetFuBarDisplayPrecision(value)
  self.db.profile.displayPrecisionFuBar = value
  self:UpdateFuBarPlugin()
end  

function AbramsFu:GetFuBarLabel()
  return self.db.profile.fuBarLabel
end

function AbramsFu:SetFuBarLabel(value)
  self.db.profile.fuBarLabel = value
  self:UpdateFuBarPlugin()
end  

function AbramsFu:OnUpdateFuBarTooltip()
  local level = UnitLevel("player")
  local calcLevel = self:GetCalcLevel()
  local resilience = GetCombatRating(CR_CRIT_TAKEN_MELEE)
  local baseDefense, armorDefense = UnitDefense("player")
  local totalDefense = baseDefense + armorDefense
  local anticipation = self:GetAnticipationBonus()
  local baseArmor, totalArmor, nobuffArmor, armorBuffs, armorDebuffs = UnitArmor("player")
  local armorEnhancements = nobuffArmor - baseArmor
  local defenseEffect = (totalDefense - calcLevel * 5) * 0.04
  local resilienceEffect = self.GetResilienceEffect()
  local missChance = max(0, 5 + defenseEffect)
  local dodgeChance = GetDodgeChance()
  local parryChance = GetParryChance()
  local blockChance = GetBlockChance()
  local critChance = max(0, 5 - defenseEffect - resilienceEffect)
  local crushChance = 0
  local hitChance = 100 - missChance - dodgeChance - parryChance - blockChance - critChance - crushChance
  local formatPercentString = string.format("%%.%df%%%%",self.db.profile.displayPrecisionToolTip)
  
  if (calcLevel - level) > 2 then
    crushChance = 15 + max(0, (level * 5 - totalDefense) * 0.02)
  end
  baseDefense = baseDefense - anticipation
  
  GameTooltip:AddLine(L["name"])
  GameTooltip:AddLine(" ")

  if self.db.profile.showToolTipDefense then
    GameTooltip:AddLine(L["defcalc"],self.db.profile.hr,self.db.profile.hg,self.db.profile.hb)
    if baseDefense == totalDefense then
      GameTooltip:AddDoubleLine(L["tdef"],string.format("%d",totalDefense),self.db.profile.lr, 
        self.db.profile.lg, self.db.profile.lb, self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    else
      GameTooltip:AddDoubleLine(L["bdef"],string.format("%d",baseDefense),self.db.profile.lr, 
        self.db.profile.lg, self.db.profile.lb, self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      if armorDefense > 0 then
        GameTooltip:AddDoubleLine(L["abon"],string.format("+%d",armorDefense),
          self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
          self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      end
      if anticipation > 0 then
        GameTooltip:AddDoubleLine(L["anti"],string.format("+%d",anticipation),
          self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
          self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      end
      GameTooltip:AddDoubleLine(L["tdef"],string.format("%d",totalDefense),self.db.profile.lr, 
        self.db.profile.lg, self.db.profile.lb, self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    end
    GameTooltip:AddLine(" ")
  end

  if self.db.profile.showToolTipCombat then
    GameTooltip:AddLine(L["ct"],self.db.profile.hr,self.db.profile.hg,self.db.profile.hb)
    GameTooltip:AddDoubleLine(L["mc"],string.format(formatPercentString,missChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["dc"],string.format(formatPercentString,dodgeChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["pc"],string.format(formatPercentString,parryChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["bc"],string.format(formatPercentString,blockChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["tc"],string.format(formatPercentString,critChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["cc"],string.format(formatPercentString,crushChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    GameTooltip:AddDoubleLine(L["hc"],string.format(formatPercentString,hitChance),
      self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      GameTooltip:AddLine(" ")
  end

  if self.db.profile.showToolTipArmor then
    GameTooltip:AddLine(L["armor"],self.db.profile.hr,self.db.profile.hg,self.db.profile.hb)
    if baseArmor == totalArmor then
      GameTooltip:AddDoubleLine(L["armor"],string.format("%d",totalArmor),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
        self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    else
      GameTooltip:AddDoubleLine(L["ba"],string.format("%d",baseArmor),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
        self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      if armorEnhancements > 0 then
        GameTooltip:AddDoubleLine(L["ak"],string.format("+%d",armorEnhancements),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
          self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      end
      if armorBuffs > 0 then
        GameTooltip:AddDoubleLine(L["ab"],string.format("+%d",armorBuffs),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
          self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      end
      if armorDebuffs < 0 then
        GameTooltip:AddDoubleLine(L["ad"],string.format("%d",armorDebuffs),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
          self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
      end
      GameTooltip:AddDoubleLine(L["ta"],string.format("%d",totalArmor),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
        self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
    end
    GameTooltip:AddLine(" ")
  end

  if self.db.profile.showToolTipDR then
    GameTooltip:AddLine(L["dr"],self.db.profile.hr,self.db.profile.hg,self.db.profile.hb)
    GameTooltip:AddDoubleLine(L["badr"],string.format(formatPercentString,self:GetBaseDR()),self.db.profile.lr, self.db.profile.lg, self.db.profile.lb, 
      self.db.profile.vr, self.db.profile.vg, self.db.profile.vb)
  end
  
end

function AbramsFu:GetHeaderColor()
	return self.db.profile.hr, self.db.profile.hg, self.db.profile.hb
end

function AbramsFu:SetHeaderColor(r, g, b)
	self.db.profile.hr = r
	self.db.profile.hg = g
	self.db.profile.hb = b
end

function AbramsFu:GetLabelColor()
	return self.db.profile.lr, self.db.profile.hg, self.db.profile.lb
end

function AbramsFu:SetLabelColor(r, g, b)
	self.db.profile.lr = r
	self.db.profile.lg = g
	self.db.profile.lb = b
end

function AbramsFu:GetValueColor()
	return self.db.profile.vr, self.db.profile.vg, self.db.profile.vb
end

function AbramsFu:SetValueColor(r, g, b)
	self.db.profile.vr = r
	self.db.profile.vg = g
	self.db.profile.vb = b
end

function AbramsFu:GetToolTipDisplayPrecision()
  return self.db.profile.displayPrecisionToolTip
end

function AbramsFu:SetToolTipDisplayPrecision(value)
  self.db.profile.displayPrecisionToolTip = value
  self:UpdateFuBarPlugin()
end  

function AbramsFu:IsShowToolTipDefense()
  return self.db.profile.showToolTipDefense
end

function AbramsFu:ToggleShowToolTipDefense()
  self.db.profile.showToolTipDefense = not self.db.profile.showToolTipDefense
  self:UpdateFuBarPlugin()
  return self.db.profile.showToolTipDefense
end

function AbramsFu:IsShowToolTipCombat()
  return self.db.profile.showToolTipCombat
end

function AbramsFu:ToggleShowToolTipCombat()
  self.db.profile.showToolTipCombat = not self.db.profile.showToolTipCombat
  self:UpdateFuBarPlugin()
  return self.db.profile.showToolTipCombat
end

function AbramsFu:IsShowToolTipArmor()
  return self.db.profile.showToolTipArmor
end

function AbramsFu:ToggleShowToolTipArmor()
  self.db.profile.showToolTipArmor = not self.db.profile.showToolTipArmor
  self:UpdateFuBarPlugin()
  return self.db.profile.showToolTipArmor
end

function AbramsFu:IsShowToolTipDR()
  return self.db.profile.showToolTipDR
end

function AbramsFu:ToggleShowToolTipDR()
  self.db.profile.showToolTipDR = not self.db.profile.showToolTipDR
  self:UpdateFuBarPlugin()
  return self.db.profile.showToolTipDR
end

