--- -----------------------------------------------------------------------------------------------------------
--- AEmotesFU mod by: ZacWolf<zac@zacwolf.com - www.zacwolf.com> 
--- 				      - ZacWolf-The Thorium Brotherhood
---          	  	 	  - EarthBrother-<EatMorChikin>-The Thorium Brotherhood
--- 					  - http://www.wowace.com/wiki/AEmotes
---        			  	  - http://eatmorchikin.guildportal.com
---         		      - http://www.zacwolf.com
---
--- This addon adds combination audio clips and character emotes to the game.  
--- -----------------------------------------------------------------------------------------------------------
--- How to Install
--- 
--- * Unzip the package into: World of Warcraft\Interface\AddOns\
--- * Your zip software must preserve directory structures.
--- 
--- For this addon to actually do anything you need to add additional artist mods:
--- These can be found at: http://www.wowace.com/wiki/AEmotes
--- -----------------------------------------------------------------------------------------------------------
--- == Changes==

--- -----------------------------------------------------------------------------------------------------------
--- == Notes ==

--- -----------------------------------------------------------------------------------------------------------
--- == License ==
--- The AEmotesFU mod is released under the GNU General Public License (GPL) 
--- For the full licence text please see gpl-v2.txt
--- Unofficial translations of the GPL can be found here: 
--- [http://www.gnu.org/licenses.../translations.html] 
--- -----------------------------------------------------------------------------------------------------------
local L 							= AceLibrary("AceLocale-2.2"):new("AEmotesFu")
local AceEvent 						= AceLibrary("AceEvent-2.0")
local Dewdrop 						= AceLibrary("Dewdrop-2.0")
local Tablet 						= AceLibrary("Tablet-2.0")
local Crayon						= AceLibrary("Crayon-2.0")
local FuBarPlugin 					= AceLibrary("FuBarPlugin-2.0")

AEmotesFu 							= AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
AEmotesFu.name						= "AEmotesFU"
AEmotesFu.date 						= string.sub("$Date: 2006-12-10 22:49:00 -0500 (Sun, 10 Dec 2006) $", 8, 17)
AEmotesFu.hasIcon					= true
AEmotesFu.clickableTooltip 			= true
AEmotesFu.tooltipHiddenWhenEmpty	= true
AEmotesFu.cannotHideText 			= true

AEmotesFu:RegisterDB("AEmotesFuDB")
AEmotesFu:RegisterDefaults('profile', { hiddenArtists = {} } )

L:RegisterTranslations("enUS", 
	function() 
		return { 
			TOOLTIP_HINT = "Click track to aemote\nShift-click to view the text message",
			TOOLTIP_HINT_NOTRACKS = "You have no AEmote_{Artist} addons installed..."
		} 
	end
)

function AEmotesFu:OnDataUpdate()

end

function AEmotesFu:OnTextUpdate()
    self:SetText("AEmotes")
end
-- ----------------------------------------------
-- Setup the FuTooltip Contents
--
-- This loads the artists from the AEMOTE addon,
-- and creates a menu to play the various aemotes
-- ----------------------------------------------
function AEmotesFu:OnTooltipUpdate()
	if (AEMOTES and AEMOTES.artists) then
		for _,artist in pairs(AEMOTES.artists) do
			if (AEMOTES[artist] and AEMOTES[artist].parms) then
	local 		r,g,b 	= 0.749,1,0.749
    local 		cat 	= Tablet:AddCategory(
							'id', artist, 'text', artist,
							'columns', 1,
							'hideBlankLine', true, 'showWithoutChildren', true,
							'checked', true, 'hasCheck', true, 'checkIcon', self.db.profile.hiddenArtists[artist] and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up",
							'func', 'ToggleArtist', 'arg1', self, 'arg2', artist,
							'textR', r, 'textG', g, 'textB', b,
							'child_func', 'ArtistClick', 'child_arg1', self, 'child_arg2', artist
						  )
				if (not self.db.profile.hiddenArtists[artist]) then
	    			for _,parm in pairs(AEMOTES[artist].parms) do
						self:AddTrackToCategory(cat, artist, parm.track);
					end
				end
			end
		end
		Tablet:SetHint(L["TOOLTIP_HINT"])
	else
	    Tablet:SetHint(L["TOOLTIP_HINT_NOTRACKS"])
	end
end

function AEmotesFu:AddTrackToCategory(cat, artist, track)
	cat:AddLine(
			'text', track,
			'textR', 1, 'textG', 1, 'textB', 1,
			'func', 'TrackClick', 'arg1', self, 'arg2', artist, 'arg3', track,
			'indentation', 55
		)
end

function AEmotesFu:ToggleArtist(artist)
	if self.db.profile.hiddenArtists[artist] then
		self.db.profile.hiddenArtists[artist] = false
	else
		self.db.profile.hiddenArtists[artist] = true
	end
	-- Refresh in place
	self:UpdateTooltip()
end

-- ----------------------------------------------
-- Functions to process various clicks in the
-- tooltip
-- ----------------------------------------------
function AEmotesFu:ArtistClick(artist)
    self:ToggleArtist(artist)
end

function AEmotesFu:TrackClick(artist,track)
    if (AEMOTES[artist] and AEMOTES[artist].parms) then
		local parm;
		for _,parm in pairs(AEMOTES[artist].parms) do
			if (parm.track==track) then
				-- The AEMOTES addons looks for the various "SAY" 
				-- messages, and plays the appropriate audio file
				-- and character emote
				if IsShiftKeyDown()then
					DEFAULT_CHAT_FRAME:AddMessage("AEMOTE artist:"..artist.." track:"..track.." msg:* "..parm.msgs.common.." *");
				else
					SendChatMessage("* "..parm.msgs.common.." *", "SAY");
				end
				break;
			end
		end
	end
end
