-- Forte Class Addon v0.992 by Xus 07-10-2008 for Patch 2.4.x
local FW = FW;
local ST = FW:Module("Timer");
local GetTime = GetTime;

local r, g, b, a;

local t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21;
local s1, s2, s3, s4, s5;

local NORMAL = 0;
local HIDDEN = 1;
local FADING = 2;
local REMOVE = 3;
local FAILED = 4;

local FADE_SHOW = {FW.L.SHORT_HIDE,FW.L.SHORT_FADE,FW.L.SHORT_REMOVED,FW.L.SHORT_RESISTED,FW.L.SHORT_IMMUNE,FW.L.SHORT_EVADED,FW.L.SHORT_REFLECTED};

local NUM_TIMERS = 15;

FW.ST = {};
local ActiveDots = {};
local ST_OnTimerFade = {};
local ST_OnTimerBreak = {};

local pauzed;
local pauzedq = {};

-- http://www.wowwiki.com/Diminishing_returns
-- i'll use the combat log to track this completely seperately
-- and simply look inside this new tracking table to see if my spell
-- will be affected
-- (preferably warn when immune even before you cast)
-- I will add an extra type bar to show returns as well, so you know
-- when your spell will have the full duration again

local ST_Diminish = {
	-- name	PVP PVE category
	--Druid
	["Bash"] =  			{1,0,"Stun"},
	["Entangling Roots"] =  {1,0,"Root"},
	["Hibernate"] =  		{1,0,"Sleep"},
	["Cyclone"] =  			{1,1,"Blind/Cyclone"},
	["Celestial Focus"] =  	{1,1,"Stun Proc "},
	--Hunter  
	--Freezing Trap  No  No  None  
	--Entrapment  Yes  TBD  None  
	--Wyvern Sting  TBD  TBD  Sleep
	--Mage
	["Frost Nova"] = 		{1,0,"Root"},
	["Polymorph"] = 		{1,0,"Gouge/Polymorph/Sap"},
	["Impact"] = 			{1,1,"Stun"},
	["Frostbite"] = 		{1,0,"Root Proc"},
	--Shaman  
	--Frost Shock  No (in 2.3)  No  None 
	["Stoneclaw Totem"] = 	{1,1,"Stun Proc"},
	--Earth Shock  No  No  None  
	--Paladin
	["Hammer of Justice"] = {1,1,"Stun"},
	["Seal of Justice"] = 	{1,1,"Stun Proc"},
	--Priest
	["Psychic Scream"] = 	{1,0,"Fear"},
	["Mind Control"] = 		{1,0,"Charm"},
	["Blackout"] = 			{1,1,"Stun Proc"},
	--Rogue
	["Sap"] = 				{1,0,"Gouge/Polymorph/Sap"},
	["Gouge"] = 			{1,0,"Gouge/Polymorph/Sap"},
	["Blind"] = 			{1,1,"Blind/Cyclone"},
	["Cheap Shot"] = 		{1,1,"Stun"},
	["Kidney Shot"] = 		{1,1,"Kidney Shot"},
	["Mace Specialization"] = {1,1,"Stun Proc"},
	--Warlock 
	["Fear"] = 				{1,0,"Fear"},
	["Seduction"] = 		{1,0,"Fear"},
	["Howl of Terror"] = 	{1,0,"Fear"},
	["Death Coil"] = 		{1,0,"Horror"},
	["Shadowfury"] = 		{1,0,"Stun"},
	--Warrior
	["Mace Specialization (Stun)"] = {1,1,"Stun Proc"},
	["Charge"] = 			{1,1,"Stun"},
	["Intercept"] = 		{1,1,"Stun"},
	["Concussion"] = 		{1,1,"Stun"},
	--Hamstring  No  No  None  
};

local FW_RaidIconCoords  = {
	{0.00,0.25,0.00,0.25},
	{0.25,0.50,0.00,0.25},
	{0.50,0.75,0.00,0.25},
	{0.75,1.00,0.00,0.25},
	{0.00,0.25,0.25,0.50},
	{0.25,0.50,0.25,0.50},
	{0.50,0.75,0.25,0.50},
	{0.75,1.00,0.25,0.50}
};

--[[
FW.ST

1:Duration Timer
2:Last Timer Update
3:Duration of Spell
4:Target
5:Is Dot
6:Is Magic/Curse/Crowd Control etc
7:Texture
8:Name
9:Target Type (0:trash 1:boss 2:player)
10:belongs to your target << gonna be ready to check for removal
11:belongs to your focus << gonna be ???
12:Expire msg given
13:Unique ID (still using this to sort by)
14:Timer state 0:normal 1:hiding 2:expired 3:removed 4+:failed
15:Timer fading size/alpha
16:Stacks or similar
17:Remove time
18:Filter
19:Raid target icon
20:GUID
21:Currently used maximum time (#3 is always the real max time)
]]

local SORT={
	TIMER =		{ORDER=	{1},		ASC={1}, 	ORDER2=	{13,1},		ASC2={1,1}},
}

local types = {
	"MagicEnable",
	"CurseEnable",
	"CrowdEnable",
	"PetEnable",
	"BuffEnable",
	"CrowdEnable",
	"DebuffsEnable",
	"HealEnable",
	"FriendlyBuffEnable"
};

	--istype: 0=stackabledebuff,1=magic,2=curse,3=cc,4=pet,(5=powerup),6=enslave/charm,(7=tdebuff),8=heal,9=friendlybuff,10=stackable
	--add: 0=just rename the debuff, 1=add an extra debuff (make sure this new debuff is registered as a spell too)
function FW:RegisterSpell(spell,hastarget, duration, isdot, istype, reducedinpvp, texture, newname, add)
	FW.Track[spell]={hastarget,duration,isdot,istype,reducedinpvp,texture,newname,add};
end

function FW:RegisterSpellModRank(spell,rank,mod)
	if not FW.Track[spell]["r"] then FW.Track[spell]["r"] = {};end
	FW.Track[spell]["r"][rank] = mod;
end

function FW:RegisterSpellModSetB(spell,setb,num,mod)
	if not FW.SetBonus[setb] then FW.SetBonus[setb] = 0; end
	if not FW.Track[spell]["s"] then FW.Track[spell]["s"] = {};end
	if not FW.Track[spell]["s"][setb] then FW.Track[spell]["s"][setb] = {};end
	FW.Track[spell]["s"][setb][num] = mod;
end

function FW:RegisterSpellModTlnt(spell,tal,num,mod)
	if not FW.Talent[tal] then FW.Talent[tal] = 0; end
	if not FW.Track[spell]["t"] then FW.Track[spell]["t"] = {};end
	if not FW.Track[spell]["t"][tal] then FW.Track[spell]["t"][tal] = {};end
	FW.Track[spell]["t"][tal][num] = mod;
end

function FW:RegisterSpellModComb(spell,points,mod)
	if not FW.Track[spell]["c"] then FW.Track[spell]["c"] = {};end
	FW.Track[spell]["c"][points] = mod;
end

function FW:RegisterBuff(buff,duration,hiddencd)
	FW.TrackBuffs[buff]={duration,hiddencd};
end

function FW:RegisterDebuff(debuff,duration,texture)
	FW.TrackDebuffs[debuff]={duration,texture};
end

local function ST_Exception(set)
	if UnitName("target") then
		FC_Saved.Exceptions[UnitName("target")] = set;
	end
end

local function ST_STSetExpandTexture()
	if FW.Settings.TimerExpand then
		FWSTFrameExpand:SetTexCoord(-0.25,1,-0.25,0,0.75,1,0.75,0);
	else
		FWSTFrameExpand:SetTexCoord(-0.25,0,-0.25,1,0.75,0,0.75,1);
	end
end

local function ST_STSetSideTexture()
	if FW.Settings.TimerTime then
		FWSTFrameSide:SetTexCoord(-0.25,1,-0.25,0,0.75,1,0.75,0);
		FWSTFrameSide:SetTexCoord(0,0, 1,0, 0,1, 1,1);
	else
		FWSTFrameSide:SetTexCoord(-0.25,0,-0.25,1,0.75,0,0.75,1);
		FWSTFrameSide:SetTexCoord(0,1, 1,1, 0,0, 1,0);
	end
end

local function ST_TimerLock()
	if FW.Settings.TimerDisableButtons then
		FWSTFrame:EnableMouse(false);
		FWSTFrameExpandButton:EnableMouse(false);
		FWSTFrameSideButton:EnableMouse(false);
	else
		FWSTFrame:EnableMouse(true);
		FWSTFrameExpandButton:EnableMouse(true);
		FWSTFrameSideButton:EnableMouse(true);
	end
end

local function ST_TimerShow()
	if FW.Settings.Timer then
		ST_TimerLock();
		FWSTFrame:Show();
		FWSTBars:Show();
		FWSTBackground:Show();
		FWSTFrame:SetScale(FW.Settings.TimerScale);
		FWSTBars:SetScale(FW.Settings.TimerScale);
		FWSTBackground:SetScale(FW.Settings.TimerScale);
		FWSTFrame:SetWidth(FW.Settings.TimerWidth+FW.BORDER*2);
		FWSTBars:SetWidth(FW.Settings.TimerWidth+FW.BORDER*2);
		FWSTBackground:SetBackdropColor(unpack(FW.Settings.TimerBgColor));
		FWSTBackground:SetBackdropBorderColor(unpack(FW.Settings.TimerBgColor));
		if not FW.Settings.TimerDisableButtons then
			FWSTTexture:Show();
			FWSTFrameTitle:Show();
			FWSTFrameExpand:Show();
			FWSTFrameSide:Show();
		else
			FWSTTexture:Hide();
			FWSTFrameTitle:Hide();
			FWSTFrameExpand:Hide();
			FWSTFrameSide:Hide();
		end
		FWSTFrameTitle:SetFont(FW.Settings.TimerFont,FW.Settings.TimerFontSize);
		for i=1,NUM_TIMERS,1 do
			getglobal("FWSTBar"..i):ClearAllPoints();
			getglobal("FWSTLabel"..i):ClearAllPoints();
			getglobal("FWSTBar"..i):SetWidth(FW.Settings.TimerWidth-FW.Settings.TimerHeight-1);
			getglobal("FWSTLabel"..i):SetWidth(FW.Settings.TimerWidth);
			getglobal("FWSTBar"..i):SetHeight(FW.Settings.TimerHeight);
			getglobal("FWSTBar"..i):SetStatusBarTexture(FW.Settings.TimerTexture);
			getglobal("FWSTBar"..i.."Back"):SetTexture(FW.Settings.TimerTexture);
			
			getglobal("FWSTBar"..i.."Button"):SetWidth(FW.Settings.TimerHeight);
			getglobal("FWSTBar"..i.."Button"):SetHeight(FW.Settings.TimerHeight);
			
			getglobal("FWSTBar"..i.."Time"):SetTextColor(unpack(FW.Settings.TimerTimeColor));
			
			getglobal("FWSTBar"..i.."Spark"):SetWidth(FW.Settings.TimerHeight);
			getglobal("FWSTBar"..i.."Spark"):SetHeight(FW.Settings.TimerHeight*2);
			
			getglobal("FWSTBar"..i.."RaidTargetIcon"):SetWidth(FW.Settings.TimerHeight);
			getglobal("FWSTBar"..i.."RaidTargetIcon"):SetHeight(FW.Settings.TimerHeight);
			getglobal("FWSTBar"..i.."RaidTargetIcon"):SetAlpha(FW.Settings.TimerRaidTargetsAlpha);
			
			getglobal("FWSTBar"..i.."Name"):SetFont(FW.Settings.TimerFont,FW.Settings.TimerFontSize);
			getglobal("FWSTBar"..i.."Time"):SetFont(FW.Settings.TimerFont,FW.Settings.TimerFontSize);
			getglobal("FWSTLabel"..i.."Text"):SetFont(FW.Settings.TimerLabelFont,FW.Settings.TimerLabelFontSize);
			
			if FW.Settings.TimerTime then 
				getglobal("FWSTBar"..i.."Time"):SetPoint("TOPRIGHT", getglobal("FWSTBar"..i), "TOPRIGHT", -1, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..i), "BOTTOMRIGHT", -1, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("TOPLEFT", getglobal("FWSTBar"..i), "TOPRIGHT", -FW.Settings.TimerTimeSpace, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("BOTTOMLEFT", getglobal("FWSTBar"..i), "BOTTOMRIGHT", -FW.Settings.TimerTimeSpace, 0);
				
				if FW.Settings.TimerMaximizeName then
					getglobal("FWSTBar"..i.."RaidTargetIcon"):SetPoint("CENTER", getglobal("FWSTBar"..i), "CENTER",(-FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight)/2, 0);
					
					getglobal("FWSTBar"..i.."Name"):SetPoint("TOPLEFT", getglobal("FWSTBar"..i), "TOPLEFT", 1, 0);
					getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMLEFT", getglobal("FWSTBar"..i), "BOTTOMLEFT", 1, 0);
				else
					getglobal("FWSTBar"..i.."RaidTargetIcon"):SetPoint("CENTER", getglobal("FWSTBar"..i), "CENTER",-FW.Settings.TimerHeight/2, 0);
					
					getglobal("FWSTBar"..i.."Name"):SetPoint("TOPLEFT", getglobal("FWSTBar"..i), "TOPLEFT",FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight, 0);
					getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMLEFT", getglobal("FWSTBar"..i), "BOTTOMLEFT",FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight, 0);
				end
				
				getglobal("FWSTBar"..i.."Name"):SetPoint("TOPRIGHT", getglobal("FWSTBar"..i), "TOPRIGHT", -FW.Settings.TimerTimeSpace, 0);
				getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..i), "BOTTOMRIGHT", -FW.Settings.TimerTimeSpace, 0);
			else
				getglobal("FWSTBar"..i.."Time"):SetPoint("TOPLEFT", getglobal("FWSTBar"..i), "TOPLEFT", 1, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("BOTTOMLEFT", getglobal("FWSTBar"..i), "BOTTOMLEFT", 1, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("TOPRIGHT", getglobal("FWSTBar"..i), "TOPLEFT", FW.Settings.TimerTimeSpace, 0);
				getglobal("FWSTBar"..i.."Time"):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..i), "BOTTOMLEFT", FW.Settings.TimerTimeSpace, 0);
				
				getglobal("FWSTBar"..i.."Name"):SetPoint("TOPLEFT", getglobal("FWSTBar"..i), "TOPLEFT", FW.Settings.TimerTimeSpace, 0);
				getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMLEFT", getglobal("FWSTBar"..i), "BOTTOMLEFT", FW.Settings.TimerTimeSpace, 0);
				
				if FW.Settings.TimerMaximizeName then
					getglobal("FWSTBar"..i.."RaidTargetIcon"):SetPoint("CENTER", getglobal("FWSTBar"..i), "CENTER",(FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight)/2, 0);
				
					getglobal("FWSTBar"..i.."Name"):SetPoint("TOPRIGHT", getglobal("FWSTBar"..i), "TOPRIGHT", -1, 0);
					getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..i), "BOTTOMRIGHT", -1, 0);
				else
				
					getglobal("FWSTBar"..i.."RaidTargetIcon"):SetPoint("CENTER", getglobal("FWSTBar"..i), "CENTER",-FW.Settings.TimerHeight/2, 0);

					getglobal("FWSTBar"..i.."Name"):SetPoint("TOPRIGHT", getglobal("FWSTBar"..i), "TOPRIGHT", -FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight, 0);
					getglobal("FWSTBar"..i.."Name"):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..i), "BOTTOMRIGHT", -FW.Settings.TimerTimeSpace-FW.Settings.TimerHeight, 0);
				end
			end	
		end
		if FW.Settings.TimerExpand == true then
			if not FW.Settings.TimerDisableButtons then
				FWSTBars:SetPoint("BOTTOMLEFT", FWSTFrame,"BOTTOMLEFT", 0, 0);
				FWSTLabel1:SetPoint("BOTTOMRIGHT", FWSTBars, "BOTTOMRIGHT",-FW.BORDER,19);
			else
				FWSTBars:SetPoint("BOTTOMLEFT", FWSTFrame,"BOTTOMLEFT", 0, 19-FW.BORDER);
				FWSTLabel1:SetPoint("BOTTOMRIGHT", FWSTBars, "BOTTOMRIGHT",-FW.BORDER,FW.BORDER);
			end
			for i=2,NUM_TIMERS,1 do
				getglobal("FWSTLabel"..i):SetPoint("BOTTOMRIGHT", getglobal("FWSTBar"..(i-1)), "TOPRIGHT", 0, 0);
			end
			for i=1,NUM_TIMERS,1 do
				getglobal("FWSTBar"..i):SetPoint("BOTTOMRIGHT", getglobal("FWSTLabel"..i), "TOPRIGHT", 0, 0);
			end
		else
			if not FW.Settings.TimerDisableButtons then
				FWSTBars:SetPoint("TOPLEFT", FWSTFrame,"TOPLEFT", 0, 0);
				FWSTLabel1:SetPoint("TOPRIGHT", FWSTBars, "TOPRIGHT",-FW.BORDER,-19);
			else
				FWSTBars:SetPoint("TOPLEFT", FWSTFrame,"TOPLEFT", 0, -19+FW.BORDER);
				FWSTLabel1:SetPoint("TOPRIGHT", FWSTBars, "TOPRIGHT",-FW.BORDER,-FW.BORDER);
			end
			for i=2,NUM_TIMERS,1 do
				getglobal("FWSTLabel"..i):SetPoint("TOPRIGHT", getglobal("FWSTBar"..(i-1)), "BOTTOMRIGHT", 0, 0);
			end
			for i=1,NUM_TIMERS,1 do
				getglobal("FWSTBar"..i):SetPoint("TOPRIGHT", getglobal("FWSTLabel"..i), "BOTTOMRIGHT", 0, 0);
			end
		end
		ST_STSetExpandTexture();
		ST_STSetSideTexture();
	else
		FWSTFrame:Hide();
		FWSTBars:Hide();
		FWSTBackground:Hide();
	end
end

local function ST_TimerScale()
	ST_TimerShow();
	FW:CorrectPosition(FWSTFrame);
end

local function ST_Fade(i,t,instant)
	if FW:GET(FW.ST,i,14) ~= t --[[<=1]] then
		if instant then
			FW:SET(FW.ST,i,17,GetTime());
		else
			FW:SET(FW.ST,i,17,GetTime()+FW.Settings.TimerFadeTime);
		end
		FW:SET(FW.ST,i,14,t);
	end
end

local function ST_BreakMessages(unit,mark,spell)
	for i, f in ipairs(ST_OnTimerBreak) do
		f(unit,mark,spell);
	end
end

local highestduration = 0;
local function ST_VisibleType(t)
	t = types[t];
	return t==true or FW.Settings[t];
end

local function ST_VisibleInTimer() -- using this in multiple functions, make sure the args are all set
	return t15>0 and ST_VisibleType(t6) and t18~=FW.FILTER_HIDE and (not FW.Settings.TimerTarget or t13<=0 or t20==FW.target or t20==FW.focus);
end

local function ST_UpdateSpellTimers()--preferably only remove timers in this function and not outside
	local t = GetTime();
	local i = 1;
	highestduration = 0;
	
	while i <= FW:ROWS(FW.ST) do
		t1,t2,t3,t4,_,t6,_,t8,t9,t10,t11,t12,t13,t14,t15,_,t17,t18,t19,t20,t21 = FW:GET(FW.ST,i);
		t1=t1+t2-t;

		if not FW.Settings.TimerForceMax then
			if FW.Settings.TimerOneMax and ST_VisibleInTimer() then
				if t3 > highestduration then
					if FW.Settings.TimerMaxTimeEnable and t3 > FW.Settings.TimerMaxTime then
						highestduration = FW.Settings.TimerMaxTime;
					else
						highestduration = t3
					end
				end
			else
				if FW.Settings.TimerMaxTimeEnable and t3 > FW.Settings.TimerMaxTime then
					FW:SET(FW.ST,i,21, FW.Settings.TimerMaxTime);
				else
					FW:SET(FW.ST,i,21, t3);
				end
			end
		end
		
		-- fade messages if time <= X sec
		if t12 == 0 and t14<=HIDDEN then -- marked as not expiring
			for index,f in ipairs(ST_OnTimerFade) do
				f(t4,t19,t8,t1,i);
			end
		end
		-- counting
		FW:SET(FW.ST,i,1, t1);
		FW:SET(FW.ST,i,2, t);
		
		if t14<=HIDDEN and t1<=0 then
			-- normal fade
			ST_Fade(i,FADING);
		end
		
		if t14==NORMAL then -- normal counting down
			if (not FW.Settings.TimerHideLongerNoBoss or t9~=1) and FW.Settings.TimerHideLongerEnable and t1>=FW.Settings.TimerHideLonger then
				FW:SET(FW.ST,i,14, HIDDEN);
				FW:SET(FW.ST,i,17, t+FW.Settings.TimerHideTime);
			end
			i=i+1;
		else -- special
			if t14 == HIDDEN and ( (FW.Settings.TimerHideLongerNoBoss and t9==1) or not FW.Settings.TimerHideLongerEnable or t1<FW.Settings.TimerHideLonger) then
				FW:SET(FW.ST,i,14, NORMAL);
				t15=1;
			else
				if t <= t17 then
					t15=1;
				elseif FW.Settings.TimerFade and t<t17+FW.Settings.TimerFadeSpeed then 
					t15=1-math.pow( ((t-t17)/FW.Settings.TimerFadeSpeed),3);
				else
					t15=0;
				end	
			end
			
			if t15<=0 and t14~=HIDDEN then
				FW:REMOVE(FW.ST,i);
			else 
				FW:SET(FW.ST,i,15, t15);
				i=i+1;
			end
		end
	
	end
	i = 1;
	if FW.Settings.TimerForceMax then
		highestduration = FW.Settings.TimerMaxTime;
		while i <= FW:ROWS(FW.ST) do
			local m = FW:GET(FW.ST,i,21);
			FW:SET(FW.ST,i,21,  m+(highestduration-m)/10);
			i=i+1;
		end
	elseif FW.Settings.TimerOneMax then
		while i <= FW:ROWS(FW.ST) do
			local m = FW:GET(FW.ST,i,21);
			FW:SET(FW.ST,i,21,  m+(highestduration-m)/10);
			i=i+1;
		end
	end
end

local function ST_ClearMobTimers()
	--FW:ShowDebug("clear timer");
	local i = 1;
	while i <= FW:ROWS(FW.ST) do
		_,_,_,_,_,t6,_,_,t9 = FW:GET(FW.ST,i);
		if t6 < 5 and t9 < 2 then -- remove all non-player timers except charms
			FW:REMOVE(FW.ST,i);
		else
			i=i+1;
		end
	end
end

--main tracking for spells cast by you (type6: 8+ = friendly buff)
local function ST_CorrectionScan(unit)
	if pauzed then
		tinsert(pauzedq,unit);
	else
		--FW:Show("standard scan "..unit);
		local guid = UnitGUID(unit);
		if guid then -- this unit exists, which is always nice
			local t = GetTime();
			for i=1,FW:ROWS(FW.ST),1 do -- spelltimer part
				local id = FW:GET(FW.ST,i,20);
				if id == "" then -- uncertain cast, attempt to correct
					local t1,t2,t3,t4,_,t6,_,t8,_,_,_,_,t13,t14,_,_,_,_,t19 = FW:GET(FW.ST,i);
					t1=t1+t2-t;-- because this can be triggered at any time, i need to update this now first
					local left; -- can be unfriendly or friendly now!
					if t6<8 then left = FW:UnitHasYourDebuff(unit,t8);
					else left = FW:UnitHasYourBuff(unit,t8);end
					-- does this unit maybe have this debuff on my timer?
					if left and left-0.75<t1 and left+0.75>t1 then
						--FW:Show("uncertain cast fixed");
						FW:SET(FW.ST,i,13, FW:GiveID(guid) );
						FW:SET(FW.ST,i,19, GetRaidTargetIndex(unit) or 0);
						FW:SET(FW.ST,i,20, guid );
						FW:SET(FW.ST,i,10, 1 ); -- since correction is done by the actual (de)buffs
					end						
				elseif id == guid then
					local t1,t2,t3,t4,_,t6,_,t8,_,t10,_,_,t13,t14,_,_,_,_,t19 = FW:GET(FW.ST,i);
					if t6<=4 or t6 >=8 then -- only check the 'normal' buff/debuff types
						t1=t1+t2-t;-- because this can be triggered at any time, i need to update this now first
						local left; -- can be unfriendly or friendly now!
						if t6<8 then left = FW:UnitHasYourDebuff(unit,t8);
						else left = FW:UnitHasYourBuff(unit,t8);end
						FW:SET(FW.ST,i,19, GetRaidTargetIndex(unit) or 0);
						if t10 == 0 then -- makes early (de)buff removing faster and hopefully bug free
							if left or (t3-t1) >= FW.Settings.BuffDelay then -- no need to match for duration here because i already have a fixed id
								t10 = 1;FW:SET(FW.ST,i,10, 1 ); -- i already see this debuff, or it should have been on already
							end						
						end
						-- do the other 'normal' stuff
						if t14 <= HIDDEN and t10 == 1 and not left then -- dont remove if only 0.75 left??? dunno why i once did this
							if not UnitIsDead(unit) then
								ST_BreakMessages(t4,t19,t8);
							end
							ST_Fade(i,REMOVE);
							--FW:Show("removing");
						end
					end
				end
			end
		end
	end
end

local function ST_TargetDebuffs()
	if FW.Settings.DebuffsEnable then
		local i = 1;	
		-- remove any debuffs that i'm tracking
		while i<= FW:ROWS(FW.ST) do
			local _,_,_,_,_,t6,t7,t8,_,_,_,_,_,t14 = FW:GET(FW.ST,i);
			if t14 <= HIDDEN and t6 == 7 and not FW:UnitHasDebuff("target",t8,t7)then
				ST_Fade(i,FADING,true);
			end
			i=i+1;
		end
		i = 1;
		local t = GetTime();
		-- scan my target for debuffs that i want to track and may not be mine
		while true do
			local debuff,_,texture,count,_,_,left = UnitDebuff("target",i);
			if debuff then
				if FW.TrackDebuffs[debuff] and FW.TrackDebuffs[debuff][2] == texture then
					local index = FW:FIND2(FW.ST,texture,7,debuff,8);
					if index then
					
						if left then
							FW.ST[index-7] = left;
							FW.ST[index-6] = t;
							FW.ST[index+6] = NORMAL;
							FW.ST[index+7] = 1;
							
						elseif FW.ST[index+8] < count then
							FW.ST[index-7] = FW.TrackDebuffs[debuff][1];
							FW.ST[index-6] = t;
							FW.ST[index+6] = NORMAL;
							FW.ST[index+7] = 1;

						end
						FW.ST[index+8] = count or 0;
					else
						FW:INSERT(FW.ST,left or FW.TrackDebuffs[debuff][1],t,FW.TrackDebuffs[debuff][1],debuff,0,7,texture,debuff,0,0,0,0,-2,0,1,count or 0,0,FW:GetFilterType(debuff),GetRaidTargetIndex("target") or 0,"none",FW.TrackDebuffs[debuff][1]);
					end
				end
				i=i+1;
			else
				break;
			end
		end
	end
end

local function ST_PetDebuffs()
	local t = GetTime();
	local i = 1;
	while i<= FW:ROWS(FW.ST) do
		local t1,t2,t3,t4,_,t6,t7,t8,_,_,_,_,_,t14,_,_,_,_,t19 = FW:GET(FW.ST,i);
		if t14 <= HIDDEN and t6 == 6 then -- handle charm spells
			t1=t1+t2-t;-- because this can be triggered at any time, i need to update this now first
			if t3-t1 >= FW.Settings.BuffDelay and t1 > 0.75 then -- debuff checking if the debuff is applied longer than/equal BuffDelay and remaining time > 0.75s
				-- exceptions
				if t8 == FW.L.INFERNO then t8 = FW.L.ENSLAVE_DEMON;end
				
				if FW:UnitHasYourDebuff("pet",t8) then
					FW:SET(FW.ST,i,19, GetRaidTargetIndex("pet") or 0);
				else
					ST_BreakMessages(t4,t19,t8);
					ST_Fade(i,REMOVE);
				end
			end
		end
		i=i+1;
	end
end

local function ST_PlayerBuffs()
	if FW.Settings.BuffEnable then
		-- remove any faded buffs that i'm tracking
		local i = 1;
		while i<= FW:ROWS(FW.ST) do
			local _,_,_,_,_,t6,t7,t8,_,_,_,_,_,t14 = FW:GET(FW.ST,i);
			if t14 <= HIDDEN and t6 == 5 and not FW:PlayerHasBuff(t8) then
				ST_Fade(i,FADING,true);
			end
			i=i+1;
		end
		local t = GetTime();
		i = 1;
		while true do
			--local buff,_,texture,count,_,left = UnitBuff("player",i);
			local buff = GetPlayerBuffName(i);
			if buff then
				if FW.TrackBuffs[buff] then
					local left = GetPlayerBuffTimeLeft(i);
					local count = GetPlayerBuffApplications(i);
					local texture = GetPlayerBuffTexture(i);
					
					local index = FW:FIND(FW.ST,buff,8);
					if index then
						FW.ST[index-7] = left or FW.TrackBuffs[buff][1];
						FW.ST[index-6] = t;
						FW.ST[index+6] = NORMAL;
						FW.ST[index+7] = 1;
						FW.ST[index+8] = count or 0;
					else
						
						FW:INSERT(FW.ST,left or FW.TrackBuffs[buff][1],t,FW.TrackBuffs[buff][1],buff,0,5,texture,buff,0,0,0,0,-2,0,1,count or 0,0,FW:GetFilterType(buff),0,"none",FW.TrackBuffs[buff][1]);
						
						if FW.Modules.Cooldown and FW.TrackBuffs[buff][2] then
							FW:HiddenCooldown(buff,FW.TrackBuffs[buff][2],texture)
						end		
					end
				end
				i=i+1;
			else
				break;
			end
		end
	end
end

local function ST_AuraChanged(unit) -- triggered by "UNIT_AURA"
	-- do special stuff
	--FW:Show("aura "..unit);
	if unit == "target" then
		ST_TargetDebuffs();
	elseif unit == "player" then
		ST_PlayerBuffs();
	elseif unit == "pet" then
		ST_PetDebuffs();
	end
	-- also do standard stuff
	ST_CorrectionScan(unit);
end

-- target/focus change tracking ONLY, doesnt look at debuffs anymore

local function ST_TargetChanged()
	FW:Changed("target");
	for i=1,FW:ROWS(FW.ST),1 do -- spelltimer part
		if FW:GET(FW.ST,i,20) == FW.target and FW:GET(FW.ST,i,14) == HIDDEN then -- briefly show hidden timers on reselect
			FW:SET(FW.ST,i,17, GetTime()+FW.Settings.TimerHideTime);
	 	end
	end
	ST_TargetDebuffs();
	ST_CorrectionScan("target");
end

local function ST_FocusChanged()
	FW:Changed("focus");
	for i=1,FW:ROWS(FW.ST),1 do -- spelltimer part
		if FW:GET(FW.ST,i,20) == FW.focus and FW:GET(FW.ST,i,14) == HIDDEN then -- briefly show hidden timers on reselect
			FW:SET(FW.ST,i,17, GetTime()+FW.Settings.TimerHideTime);
	 	end
	end
	ST_CorrectionScan("focus");
end

local function ST_MouseOverChanged() --with improvement enabled, I want to scan my mouseover target for removed debuffs
	FW:Changed("mouseover");
	ST_CorrectionScan("mouseover");
end

local scanned = {};
local function ST_ScanUnitDebuffs(unit)
	local guid = UnitGUID(unit);
	if guid and not scanned[guid] then
		scanned[guid] = 1;
		ST_CorrectionScan(unit);
	end
end
--[[
[16:07:17] 9344.733 COMBAT_LOG_EVENT_UNFILTERED 1:1219241304.96 2:SPELL_AURA_APPLIED 3:0x0000000000000000 5:-2147483648 6:0xF730004D8D02521B 7:Felblade Doomguard 8:68168 9:17800 10:Shadow Vulnerability 11:32 12:DEBUFF
[16:07:17] 9344.735 UNIT_AURA 1:target
]]

local function ST_RaidTargetScan()
	if not FW.Settings.TimerImproveRaidTarget then return;end
	FW:ERASE(scanned);
	if GetNumRaidMembers() > 0 then	
		for i=1,GetNumRaidMembers(),1 do
			--ST_ScanUnitDebuffs(FW.RAID[i]);
			ST_ScanUnitDebuffs(FW.RAID[i].."pet");
			ST_ScanUnitDebuffs(FW.RAID[i].."target");
		end
	elseif GetNumPartyMembers() > 0 then
		for i=1,GetNumPartyMembers(),1 do
			--ST_ScanUnitDebuffs(FW.PARTY[i]);
			ST_ScanUnitDebuffs(FW.PARTY[i].."pet");
			ST_ScanUnitDebuffs(FW.PARTY[i].."target");
		end
	end
end

local function Pauzed()
	if GetTime() >= pauzed then
		FW:UnregisterUpdatedEvent(Pauzed);
		--FW:Show("unpauzed");
		pauzed = nil;
		for i,u in ipairs(pauzedq) do
			ST_CorrectionScan(u);
		end
		FW:ERASE(pauzedq);
	end
end

function FW:PauzeScansFor(t)
	if not pauzed then FW:RegisterUpdatedEvent(Pauzed); end
	pauzed = GetTime() + (t or 1);
end

--local funcion ST_TargetOnlyScan()

--end

-- this is the stuff that i really only want to do on my target and pet, nothing else
-- also does a normal scan on target, focus, mouseover, pet and pettarget
-- this one doesnt use events yet
local function ST_MainScan()
	--FW:Show("mainscan");
	
	-- those never triggered by unitaura event:
	ST_CorrectionScan("mouseover");
	ST_CorrectionScan("pettarget");
end

local function ST_MobDies(name,guid) -- removes all the timers of this guid, I may still do something more with the unit name though
	for i=1,FW:ROWS(FW.ST),1 do
		if FW:GET(FW.ST,i,20) == guid then
			ST_Fade(i,REMOVE);
		end
	end
end

local function ST_RegisterImproved()
	FW:ERASE(ActiveDots);
end

local function ST_RemoveDots()
	if not FW.Settings.TimerImprove then return; end
	local i=1;
	local t = GetTime();
	
	while i<= FW:ROWS(ActiveDots) do
		t1,t2,t3 = FW:GET(ActiveDots,i);
		if t3 < t then
			FW:REMOVE(ActiveDots,i);
			if string.find(t1,"^0x") then
				for j=1,FW:ROWS(FW.ST),1 do
					_,_,_,t4,_,_,_,t8,_,t10,t11,_,_,_,_,_,_,_,_,t20 = FW:GET(FW.ST,j);
					if t20 == t1 and t8 == t2 and t20~=FW.target and t20~=FW.focus then -- no need to do this for target/focus/mouseover
						ST_Fade(j,REMOVE);
						break;
					end
				end			
			else
				for j=1,FW:ROWS(FW.ST),1 do
					_,_,_,t4,_,_,_,t8,_,t10,t11 = FW:GET(FW.ST,j);
					if t4 == t1 and t8 == t2 and t20~=FW.target and t20~=FW.focus then -- no need to do this for target/focus/mouseover
						ST_Fade(j,REMOVE);
					end
				end
			end
			FW:ShowDebug("removing "..t2.." on "..t1);
		else
			i=i+1;
		end
	end
end

local color = {
	"MagicColor",
	"CurseColor",
	"CrowdColor",
	"PetColor",
	"BuffColor",
	"CrowdColor",
	"DebuffsColor",
	"HealColor",
	"FriendlyBuffColor",
};

local function ColorVal(v,total,flag,flag2,filter,spell)
	if flag2 > REMOVE then
		if FW.Settings.HighlightEnable and v > -0.5 then
			r,g,b = FW:MixColors(-2*v,FW.Settings.HighlightColor,FW.Settings.FailColor);
		else
			r,g,b = unpack(FW.Settings.FailColor);
		end
	elseif flag2 == REMOVE then
		r,g,b = unpack(FW.Settings.FailColor);
	else	
		if FW.Settings.HighlightEnable and total-v<0.5 then
			if filter == FW.FILTER_COLOR then
				r,g,b = FW:MixColors2((total-v)*2,
				FW.Settings.ColorHighlight[1],FW.Settings.ColorHighlight[2],FW.Settings.ColorHighlight[3],
				FW.Settings.TimerFilter[spell][2],FW.Settings.TimerFilter[spell][3],FW.Settings.TimerFilter[spell][4]
				);
			else
				r,g,b = FW:MixColors((total-v)*2,FW.Settings.HighlightColor,FW.Settings[color[flag]]);
			end
		else
		 	if filter == FW.FILTER_COLOR then
				r,g,b = unpack(FW.Settings.TimerFilter[spell],2,4);
			else
				r,g,b = unpack(FW.Settings[color[flag]]);
			end
		end
	end
	--alpha
	if FW.Settings.TimerBlink and v <= 3 and v>0 then
		a=0.25+0.25*math.cos(25*math.sqrt(v));
	else
		a=0.5;
	end
end

local function ST_DrawTimers()
	if not FWSTFrame:IsShown() then return; end
	
	local n = 0;
	if FW.Settings.TimerGroupID then FW:BST(FW.ST,SORT.TIMER.ORDER2,SORT.TIMER.ASC2);else FW:BST(FW.ST,SORT.TIMER.ORDER,SORT.TIMER.ASC);end
	local index=0;
	local lastid = -2;
	local higha = 0;
	local curra = 0;
	local highh = 0;
	local h1;
	local label;
	local Bar,Spark,Label;
	local barval;
	for i=1, NUM_TIMERS, 1 do

		Bar = getglobal("FWSTBar"..i);
		Label = getglobal("FWSTLabel"..i);
		index = index+1;
		while index <= FW:ROWS(FW.ST) do -- stuff to make it 'skip' certain timers for display
			t1,_,t3,t4,_,t6,t7,t8,t9,t10,t11,_,t13,t14,t15,t16,_,t18,t19,t20,t21 = FW:GET(FW.ST,index);
			if ST_VisibleInTimer() then break; else index=index+1 end
		end
		if index <= FW:ROWS(FW.ST) and i <= FW.Settings.TimerMax then
			
			Spark = getglobal("FWSTBar"..i.."Spark");
			ColorVal(t1,t3,t6,t14,t18,t8);
			
			if t19 == 0 or not FW.Settings.TimerRaidTargets then
				getglobal("FWSTBar"..i.."RaidTargetIcon"):Hide();
			else
				getglobal("FWSTBar"..i.."RaidTargetIcon"):Show();
				getglobal("FWSTBar"..i.."RaidTargetIcon"):SetTexCoord(unpack(FW_RaidIconCoords [t19]));
			end
			
			if t1<0 then Spark:Hide();t1=0;else Spark:Show();end
			
			--t1 = curent time, t3 = total time, t21 = adapted time
			if t1>t21 then
				barval=1;
			else
				barval = t1/t21;
			end
			
			Bar:SetValue(barval);
			Bar.id = index;

			Bar:SetStatusBarColor(r,g,b);
			getglobal("FWSTBar"..i.."Back"):SetVertexColor(r,g,b,a);
			
			local lh;
			if i>1 and FW.Settings.TimerSpace > 0 then if i==2 then lh = FW.Settings.TimerSpace*h1; else lh = FW.Settings.TimerSpace*t15;end else lh = 0.01;end
			
			if t13<=0 or t20==FW.target or t14>REMOVE then curra=t15 else curra = FW.Settings.TimerNormalAlpha*t15; end
			Bar:SetAlpha(curra); 
			Label:Hide();
			if FW.Settings.TimerSpell then 
				if t13 >= 0 and FW.Settings.TimerGroupID then
				
					if lastid ~= t13 then
						if FW.Settings.TimerShowID and t13 > 0 and t9 == 0 then
							getglobal("FWSTLabel"..i.."Text"):SetText("#"..t13.." "..t4);
						else
							getglobal("FWSTLabel"..i.."Text"):SetText(t4);
						end
						if t20 == FW.target then
							getglobal("FWSTLabel"..i.."Text"):SetTextColor(unpack(FW.Settings.TimerTargetColor));
						elseif t20 == FW.focus then
							getglobal("FWSTLabel"..i.."Text"):SetTextColor(unpack(FW.Settings.TimerFocusColor));
						else
							getglobal("FWSTLabel"..i.."Text"):SetTextColor(unpack(FW.Settings.TimerNormalColor));
						end
						
						higha = curra;highh = t15;label = i;
						lh=FW.Settings.TimerLabelHeight*t15;
						Label:SetAlpha(higha);
						Label:Show();
					else
						if higha < curra then
							higha = curra;
							getglobal("FWSTLabel"..label):SetAlpha(higha);
						end
						if highh < t15 then
							n=n+(t15-highh)*FW.Settings.TimerLabelHeight;highh = t15;
							getglobal("FWSTLabel"..label):SetHeight(FW.Settings.TimerLabelHeight*highh);
						end
					end
				end
				t4 = t8;
			elseif FW.Settings.TimerGroupID and i>1 then
				if lastid ~= t13 then
					lh=FW.Settings.TimerSpacingHeight*t15;
					if i==2 then
						lh = FW.Settings.TimerSpacingHeight*h1;
						highh = h1; 
					else	
						lh = FW.Settings.TimerSpacingHeight*t15;
						highh = t15;
					end
					label = i;
				elseif label and (label~=2 or h1==1) then
					if highh < t15 then
						n=n+(t15-highh)*FW.Settings.TimerSpacingHeight;
						highh = t15;
						getglobal("FWSTLabel"..label):SetHeight(FW.Settings.TimerSpacingHeight*highh);
					end
				end
				
			end
			if i==1 then h1 = t15;end
			Label:SetHeight(lh);n=n+lh;
			
			if FW.Settings.TimerShowID and t13 > 0 and t9 == 0 and not FW.Settings.TimerSpell then
				getglobal("FWSTBar"..i.."Name"):SetText("#"..t13.." "..t4);
			elseif t16 ~= 0 then
				getglobal("FWSTBar"..i.."Name"):SetText(t4.." ("..t16..")");
			else
				getglobal("FWSTBar"..i.."Name"):SetText(t4);
			end
			Bar:SetHeight(t15*FW.Settings.TimerHeight);
			
			n = n + t15*FW.Settings.TimerHeight;
			
			if t20 == FW.target then
				getglobal("FWSTBar"..i.."Name"):SetTextColor(unpack(FW.Settings.TimerTargetColor));
			elseif t20 == FW.focus then
				getglobal("FWSTBar"..i.."Name"):SetTextColor(unpack(FW.Settings.TimerFocusColor));
			else
				getglobal("FWSTBar"..i.."Name"):SetTextColor(unpack(FW.Settings.TimerNormalColor));
			end
			if t14 > REMOVE then
				getglobal("FWSTBar"..i.."Time"):SetText(FADE_SHOW[t14]);
			else
				getglobal("FWSTBar"..i.."Time"):SetText(FW:SecToTimeD(t1));
			end
			getglobal("FWSTBar"..i.."ButtonTexture"):SetTexture(t7);
			
			Spark:SetPoint("CENTER", Bar, "LEFT",barval*Bar:GetWidth(), 0);
			
			lastid = t13;
			
			Bar:Show();
		elseif Bar:IsShown() then
			Bar:Hide();
			Label:Hide();
		end
	end
	-- bar/bg positioning
	local y3 = n-1+FW.BORDER;
	local a1;
	if FW.Settings.TimerExpand == true then 
		a1 = "TOPLEFT";
	else
		y3 = -y3;
		a1 = "BOTTOMLEFT";
	end
	if n > 0 then
		FWSTBars:SetPoint(a1, FWSTFrame, a1, 0, y3);	
	else
		FWSTBars:SetPoint(a1, FWSTFrame, a1, 0, 0);
	end
	if FW.Settings.TimerDisableButtons then
		if n >= 10 then
			FWSTBackground:Show();
		else
			FWSTBackground:Hide();
		end
	end
end

local function ST_TimerFilterChange(spell,newtype)
	for i=1,FW:ROWS(FW.ST),1 do
		if FW:GET(FW.ST,i,8)  == spell then
			FW:SET(FW.ST,i,18, newtype or 0)
		end
	end
end

local function ST_ShowTimeFor(id)
	local spell, target, timeleft = FW:GET(FW.ST,id,8),FW:GET(FW.ST,id,4),FW:GET(FW.ST,id,1);
	if spell ~= target then
		local mark = FW:GET(FW.ST,id,19);
		if mark ~= 0 then 
			target=FW.RaidIcons[mark]..target;
		end
		FW:ToGroup( string.format( FW.L.TIME_LEFT,spell,target,math.floor(timeleft) ) );
	else
		FW:ToGroup( string.format( FW.L.TIME_LEFT_NOTARGET,spell,math.floor(timeleft) ) );
	end
end

-- globally accessable

function FW:GetFadeTime(what)
	local _,_,t=string.find(FW.Settings[what.."Msg"],"([%.%d]+)");
	t = tonumber(t); return t or 0;
end

function FW:RemoveTimer_OnClick(button)
	if button == "RightButton" then
		FW:REMOVE(FW.ST,this:GetParent().id);
	else
		-- show duration
		ST_ShowTimeFor(this:GetParent().id);
	end
end

function FW:GiveID(guid)
	local high,id = 0,0;
	for i=1,FW:ROWS(FW.ST),1 do
		id = FW:GET(FW.ST,i,13);
		if high < id then high = id; end
		if FW:GET(FW.ST,i,20) == guid then
			return id;
		end
	end
	return high+1;
end

function FW:STFrameExpand_OnClick()
	FW.Settings.TimerExpand = not FW.Settings.TimerExpand;
	PlaySound("igMainMenuOptionCheckBoxOn");
	ST_STSetExpandTexture();
	ST_TimerShow();
	FW:RefreshOptions();
end

function FW:STFrameSide_OnClick()
	FW.Settings.TimerTime = not FW.Settings.TimerTime;
	PlaySound("igMainMenuOptionCheckBoxOn");
	ST_STSetSideTexture();
	ST_TimerShow();
	FW:RefreshOptions();
end

function FW:STFrame_OnClick(button)
	if this.fwmovingx then return; end
	if button == "RightButton" then
		FW:ScrollTo(FW.L.SPELL_TIMER);
	end
	PlaySound("igMainMenuOptionCheckBoxOn");
end

function FW:AddDot(unit,spell)
	if not FW.Settings.TimerImprove then return; end
	FW:ShowDebug("adding dot "..spell.." to "..unit);
	local index = FW:FIND2(ActiveDots,unit,1,spell,2);
	if index then
		ActiveDots[index+1] = GetTime()+FW.Settings.DotTicksDelay;
	else
		FW:INSERT(ActiveDots, unit,spell,GetTime()+FW.Settings.DotInitDelay);
	end
end

function FW:GetFilterType(spell)
	if FW.Settings.TimerFilter[spell] then
		return FW.Settings.TimerFilter[spell][1];
	else
		return 0;
	end
end

function FW:RegisterOnTimerFade(func)
	tinsert(ST_OnTimerFade,func);
end

function FW:RegisterOnTimerBreak(func)
	tinsert(ST_OnTimerBreak,func);
end

local function ST_CombatLogEvent()
	if arg4 == FW.PLAYER then
		if arg2 == "SPELL_PERIODIC_DAMAGE" or arg2 == "SPELL_PERIODIC_MISSED" then
			if FW.Settings.TimerImprove then 
				FW:AddDot(arg6,arg10);
				FW:AddDot(arg7,arg10);
			end
		end
		
	--[[elseif arg7 == FW.PLAYER then
		
		if arg2 == "SPELL_AURA_APPLIED" then
			ST_BuffGain(arg10,arg9);

		elseif arg2 == "SPELL_AURA_REMOVED" then	
			ST_BuffFade(arg10);
		
		-- dose isnt supported for (enemy) targets...
		elseif arg2 == "SPELL_AURA_APPLIED_DOSE" or  arg2 == "SPELL_AURA_REMOVED_DOSE" then
			ST_BuffDose(arg10,arg9,arg13);

		end]]
			
	else
		if arg2 == "UNIT_DIED" then
			ST_MobDies(arg7,arg6);
		end
	end
end

function FW:TimerOnload()
	FW:RegisterFrame("FWSTFrame",ST_TimerShow,"Timer");
	
	FW:RegisterToEvent("PLAYER_TARGET_CHANGED",		ST_TargetChanged);
	FW:RegisterToEvent("PLAYER_FOCUS_CHANGED",		ST_FocusChanged);
	FW:RegisterToEvent("UPDATE_MOUSEOVER_UNIT",		ST_MouseOverChanged);
	 
	FW:RegisterToEvent("UNIT_AURA", function() ST_AuraChanged(arg1); end);--<-- apparently also needed for powerups
	
	FW:RegisterToEvent("COMBAT_LOG_EVENT_UNFILTERED",	ST_CombatLogEvent);
	 
	FW:RegisterVariablesEvent(function()
		ST_RegisterImproved();
		
		FW:RegisterTimedEvent("AnimationInterval",	ST_UpdateSpellTimers);
		FW:RegisterTimedEvent("SpellTimerInterval",	ST_MainScan);
		FW:RegisterTimedEvent("SpellTimerInterval",	ST_RemoveDots);
		FW:RegisterTimedEvent("AnimationInterval",	ST_DrawTimers);
		FW:RegisterTimedEvent("UpdateInterval",		ST_RaidTargetScan);
	end);
	
	FW:RegisterOnLeaveCombat(function()
		if not UnitIsDeadOrGhost("player") then --  remove non-player timers when dropped from combat, keep if player died
			ST_ClearMobTimers();
		end
	end);
	FW.RegisterFilterRefresh(function()
		for i=1,FW:ROWS(FW.ST),1 do
			FW:SET(FW.ST,i,18, 0);
		end
		for spell, data in pairs(FW.Settings.TimerFilter) do
			ST_TimerFilterChange(spell,data[1])
		end
	end);
	FW:AddCommand("u",function(s)
		if s == "trash" then
			ST_Exception(0);
		elseif s == "boss" then
			ST_Exception(1);
		elseif s == "none" then
			ST_Exception(nil);
		end
	end);
	--FW:Show("Timer Module Loaded");
end

function FW:RegisterCasterBuffs()
	FW:RegisterBuff(FW.L.ESSENCE_OF_SAPPHIRON,				20);
	FW:RegisterBuff(FW.L.EPHEMERAL_POWER,					15);
	FW:RegisterBuff(FW.L.SPELL_HASTE,						06,18);
	FW:RegisterBuff(FW.L.UNSTABLE_POWER,					20);
	FW:RegisterBuff(FW.L.BLESSING_OF_THE_SILVER_CRESCENT,	20);
	FW:RegisterBuff(FW.L.RECURRING_POWER,					10);
	FW:RegisterBuff(FW.L.CALL_OF_THE_NEXUS,					10);
	FW:RegisterBuff(FW.L.HEROISM,							40);
	FW:RegisterBuff(FW.L.BLOODLUST,							40);
	FW:RegisterBuff(FW.L.LESSER_SPELL_BLASTING,				10);
	FW:RegisterBuff(FW.L.SPELL_BLASTING,					10);
	FW:RegisterBuff(FW.L.UNSTABLE_CURRENTS,					15,45);
	FW:RegisterBuff(FW.L.SPELL_POWER,						15);
	FW:RegisterBuff(FW.L.FEL_INFUSION,						20);
	FW:RegisterBuff(FW.L.ARCANE_ENERGY,						15);
	FW:RegisterBuff(FW.L.AURA_OF_THE_CRUSADE,				10);
	FW:RegisterBuff(FW.L.BAND_OF_THE_ETERNAL_SAGE,			10,45);
	FW:RegisterBuff(FW.L.MOJO_MADNESS,						20);
	FW:RegisterBuff(FW.L.FOCUS,								06);
	FW:RegisterBuff(FW.L.CRIMSON_SERPENT,					20);
end

-- Race specific spell and buffs
if FW.RACE == "Draenei" then
		FW:RegisterSpell(FW.L.GIFT_OF_THE_NAARU,1,015,0,8,00,"Interface\\Icons\\Spell_Holy_HolyProtection");
elseif FW.RACE == "Orc" then
		FW:RegisterBuff(FW.L.BLOOD_FURY, 15);
end

FW:SetMainCategory(FW.L.SPELL_TIMER,FW.ICON_ST,3,"TIMER","FWSTFrame");
	FW:SetSubCategory(FW.NIL,FW.NIL,1);
		FW:RegisterOption(FW.INF,2,FW.NON,FW.L.ST_HINT1);
		FW:RegisterOption(FW.INF,2,FW.NON,FW.L.ST_HINT2);
		
	FW:SetSubCategory(FW.L.BASIC,FW.ICON_BASIC,2)
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.ENABLE,		FW.L.ST_BASIC1_TT ,	"Timer",		ST_TimerShow);
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.LOCK,		FW.L.ST_BASIC2_TT,	"TimerDisableButtons",	ST_TimerShow);
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.EXPAND_UP,	FW.L.EXPAND_UP_TT,	"TimerExpand",		function() ST_TimerShow();ST_STSetExpandTexture();end);

	FW:SetSubCategory(FW.L.DISPLAY_MODES,FW.ICON_SPECIFIC,3)
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.DISPLAY_MODES7,	FW.L.DISPLAY_MODES7_TT,	"TimerGroupID");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.DISPLAY_MODES8,	FW.L.DISPLAY_MODES8_TT,	"TimerShowID");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.DISPLAY_MODES9,	FW.L.DISPLAY_MODES9_TT,	"TimerSpell");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.DISPLAY_MODES10,	FW.L.DISPLAY_MODES10_TT,"TimerTarget");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.FADING6,	FW.L.FADING6_TT,	"TimerNormalAlpha");		
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.COUNTDOWN_ON_RIGHT,	FW.L.COUNTDOWN_ON_RIGHT_TT,	"TimerTime",		function() ST_TimerShow();ST_STSetSideTexture();end);
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.ONEMAX,FW.L.ONEMAX_TT,		"TimerOneMax");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.FORCEMAX,FW.L.FORCEMAX_TT,	"TimerForceMax");
		FW:RegisterOption(FW.NU2,1,FW.NON,FW.L.MAXTIME,FW.L.MAXTIME_TT,		"TimerMaxTime");
		
	FW:SetSubCategory(FW.L.FADING,FW.ICON_SPECIFIC,4)
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.FADING1,	FW.L.FADING1_TT,	"TimerBlink");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.FADING2,	FW.L.FADING2_TT,	"TimerFade");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.FADING3,	FW.L.FADING3_TT,	"TimerFadeTime");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.FADING4,	FW.L.FADING4_TT,	"TimerFadeSpeed");

	FW:SetSubCategory(FW.L.EXTRA,FW.ICON_SPECIFIC,5)
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.EXTRA1,	FW.L.EXTRA1_TT,		"TimerRaidTargets");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.EXTRA2,	FW.L.EXTRA2_TT,		"TimerRaidTargetsAlpha",ST_TimerShow);	
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.EXTRA3,	FW.L.EXTRA3_TT,		"TimerImprove",		ST_RegisterImproved);
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.EXTRA4,	FW.L.EXTRA4_TT,		"TimerImproveRaidTarget");

	FW:SetSubCategory(FW.L.TIMER_HIDING,FW.ICON_SPECIFIC,6)
		
		FW:RegisterOption(FW.NU2,1,FW.NON,FW.L.DISPLAY_TYPES3,	FW.L.DISPLAY_TYPES3_TT,	"TimerHideLonger");
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.DISPLAY_TYPES11,	FW.L.DISPLAY_TYPES11_TT,"TimerHideLongerNoBoss");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.DISPLAY_TYPES4,	FW.L.DISPLAY_TYPES4_TT,	"TimerHideTime");
		FW:RegisterOption(FW.NUM,1,FW.RIG,FW.L.DISPLAY_TYPES6,	FW.L.DISPLAY_TYPES6_TT,	"TimerFailTime");
	
		FW:SetSubCategory(FW.L.COLORING_FILTERING,FW.ICON_FILTER,7);
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.HIGHLIGHT,		FW.L.FADING5_TT,			"Highlight");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.FAIL,			FW.L.DISPLAY_TYPES5_TT,		"Fail");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.MAGIC_DOT,		"",	"Magic");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.CURSE,			"",	"Curse");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.CC,				"",	"Crowd");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.PET,				FW.L.DISPLAY_TYPES10_TT,	"Pet");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.POWERUP_BUFFS,	FW.L.DISPLAY_TYPES1_TT,		"Buff");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.HEAL,			FW.L.DISPLAY_TYPES8_TT,		"Heal");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.DISPLAY_TYPES2,	FW.L.DISPLAY_TYPES2_TT,		"Debuffs");
		FW:RegisterOption(FW.CO2,1,FW.NON,FW.L.FRIENDLY_BUFFS,	FW.L.DISPLAY_TYPES9_TT,		"FriendlyBuff");
		FW:RegisterOption(FW.FIL,2,FW.NON,FW.L.CUSTOMIZE,FW.L.ST_CUSTOMIZE_TT,	"TimerFilter",		ST_TimerFilterChange);

	FW:SetSubCategory(FW.L.SIZING,FW.ICON_SIZE,8);	
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.BAR_WIDTH,					"",	"TimerWidth",		ST_TimerShow);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.BAR_HEIGHT,					"",	"TimerHeight",		ST_TimerShow);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.BAR_SPACING,					"",	"TimerSpace",		ST_TimerShow);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.SCALE,						"",	"TimerScale",		ST_TimerScale);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.UNIT_SPACING,		FW.L.UNIT_SPACING_TT,		"TimerSpacingHeight");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.UNIT_LABEL_HEIGHT,	FW.L.UNIT_LABEL_HEIGHT_TT,	"TimerLabelHeight");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.COUNTDOWN_WIDTH,		FW.L.COUNTDOWN_WIDTH_TT,	"TimerTimeSpace",	ST_TimerShow);
		FW:RegisterOption(FW.CHK,1,FW.NON,FW.L.MAXIMIZE_SPACE,		FW.L.MAXIMIZE_SPACE_TT,		"TimerMaximizeName",	ST_TimerShow);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.MAX_SHOWN,					"",					"TimerMax");	

	FW:SetSubCategory(FW.L.APPEARANCE,FW.ICON_APPEARANCE,9);	
		FW:RegisterOption(FW.COL,1,FW.NON,FW.L.NORMAL_TEXT,	FW.L.NORMAL_TEXT_TT,	"TimerNormal");
		FW:RegisterOption(FW.COL,1,FW.NON,FW.L.TARGET_TEXT,	FW.L.TARGET_TEXT_TT,	"TimerTarget");
		FW:RegisterOption(FW.COL,1,FW.NON,FW.L.FOCUS_TEXT,	FW.L.FOCUS_TEXT_TT,	"TimerFocus");
		FW:RegisterOption(FW.COL,1,FW.NON,FW.L.COUNTDOWN_TEXT,			"",	"TimerTime",	ST_TimerShow);
		FW:RegisterOption(FW.COL,1,FW.NON,FW.L.FRAME_BACKGROUND,		"",	"TimerBg",		ST_TimerShow);
		FW:RegisterOption(FW.FNT,2,FW.NON,FW.L.BAR_FONT,				"",	"TimerFont",		ST_TimerShow);
		FW:RegisterOption(FW.FNT,2,FW.NON,FW.L.LABEL_FONT,	FW.L.LABEL_FONT_TT,	"TimerLabelFont",	ST_TimerShow);
		FW:RegisterOption(FW.TXT,2,FW.NON,FW.L.BAR_TEXTURE,			"",	"TimerTexture",		ST_TimerShow);

FW:SetMainCategory(FW.L.SELF_MESSAGES,FW.ICON_SELFMESSAGE,11,"DEFAULT");
	FW:SetSubCategory(FW.NIL,FW.NIL,1);
		FW:RegisterOption(FW.INF,2,FW.NON,FW.L.SELF_MESSAGES_HINT1);
		
	FW:SetSubCategory(FW.L.SPELL_TIMER,FW.ICON_SPECIFIC,2);
		FW:RegisterOption(FW.CO2,1,FW.LEF,FW.L.SHOW_FAILED,			FW.L.SHOW_FAILED_TT,"TimerResists");

FW:SetMainCategory(FW.L.ADVANCED,FW.ICON_DEFAULT,99,"DEFAULT");
	FW:SetSubCategory(FW.L.SPELL_TIMER,FW.ICON_DEFAULT,2);
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.UPDATE_INTERVAL_SPELL_TIMER,	"",	"SpellTimerInterval");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.DELAY_TARGET_DEBUFF_CHECK,	"",	"BuffDelay");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.DELAY_DOT_TICKS_INIT,		"",	"DotInitDelay");
		FW:RegisterOption(FW.NUM,1,FW.NON,FW.L.DELAY_DOT_TICKS,			"",	"DotTicksDelay");

FW.Default.SpellTimerInterval = 0.10;
FW.Default.BuffDelay = 2; -- delay before checking if a buff is still applied (seems to be lag to server + slowness of server)
FW.Default.DotTicksDelay = 3.75; -- if no dot ticks are seen for this time, dots of this type and target are removed
FW.Default.DotInitDelay = 5; -- if no dot ticks are seen for this time after cast, dots of this type and target are removed

FW.Default.TimerDisableButtons = falCorrectPositionse;
FW.Default.TimerMax = 10;
FW.Default.TimerFont = FW.Default.Font;
FW.Default.TimerFontSize = FW.Default.FontSize;
FW.Default.TimerTexture = FW.Default.Texture;
FW.Default.Timer = true;
FW.Default.TimerShowID = false;
FW.Default.TimerGroupID = true;
FW.Default.TimerIgnoreLong = false;
FW.Default.TimerExpand = true;
FW.Default.TimerBackground = true;
FW.Default.TimerTime = true;

FW.Default.TimerBlink = true;
FW.Default.TimerMaximizeName = false;
FW.Default.TimerFade = true;
FW.Default.TimerHideTime = 2;
FW.Default.TimerFailTime = 2;
FW.Default.TimerFadeTime = 1;
FW.Default.TimerFadeSpeed = 0.5;
FW.Default.TimerSpell = false;
FW.Default.TimerLabelHeight = 14;
FW.Default.TimerSpacingHeight = 3;
FW.Default.TimerLabelFont = FW.Default.Font;
FW.Default.TimerLabelFontSize = FW.Default.FontSize;
FW.Default.TimerImprove = false;
FW.Default.TimerImproveRaidTarget = false;
FW.Default.TimerRaidTargets = false;
FW.Default.TimerRaidTargetsAlpha = 0.7;
FW.Default.TimerTarget = false;

FW.Default.TimerOneMax = false;
FW.Default.TimerMaxTimeEnable = false;
FW.Default.TimerMaxTime = 30;
FW.Default.TimerForceMax = false;
FW.Default.TimerHideLongerEnable = false;
FW.Default.TimerHideLonger = 30;
FW.Default.TimerHideLongerNoBoss = false;

FW.Default.TimerHeight = 14;
FW.Default.TimerSpace = 1;
FW.Default.TimerScale = 1;
FW.Default.TimerWidth = 250;
FW.Default.TimerNormalAlpha = 0.50;
FW.Default.TimerTimeSpace = 35;

FW.Default.TimerFilter = {};

FW.Default.CurseColor = 		{0.64,0.21,0.93};
FW.Default.CurseEnable = true;
FW.Default.CrowdColor = 		{0.00,1.00,0.50};
FW.Default.CrowdEnable = true;
FW.Default.MagicColor = 		{1.00,0.50,0.00};
FW.Default.MagicEnable = true;
FW.Default.PetColor = 			{1.00,0.00,0.95};
FW.Default.PetEnable = true;
FW.Default.BuffColor = 			{0.00,0.75,1.00};
FW.Default.BuffEnable = true;
FW.Default.HealColor = 			{0.00,1.00,0.00};
FW.Default.HealEnable = true;
FW.Default.FriendlyBuffColor = 	{1.00,1.00,0.00};
FW.Default.FriendlyBuffEnable = true;
FW.Default.DebuffsColor = 		{0.00,0.36,1.00};
FW.Default.DebuffsEnable = true;

FW.Default.TimerResistsEnable = true;
FW.Default.TimerResistsColor = 	{1.00,0.00,0.54};


FW.Default.TimerNormalColor = 	{1.00,1.00,1.00};
FW.Default.TimerTimeColor = 	{1.00,1.00,1.00};
FW.Default.TimerTargetColor = 	{1.00,1.00,1.00};
FW.Default.TimerFocusColor = 	{1.00,1.00,0.50};
FW.Default.TimerBgColor = 		{0.00,0.00,0.00,1.00};

FW.Default.HighlightColor =		{1.00,1.00,1.00};
FW.Default.HighlightEnable = true;
FW.Default.FailColor =			{1.00,0.00,0.30};
FW.Default.FailEnable = true;
