-- Core file, contains the module logic.

ForceEnchant = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceEvent-2.0","AceDB-2.0","AceDebug-2.0");
ForceEnchant:RegisterDB("ForceEnchantDB", "ForceEnchantDBPC");

local L = AceLibrary("AceLocale-2.2"):new("ForceEnchant");
local O = AceLibrary("AceLocale-2.2"):new("ForceEnchant-Option");

local opts = { 
    type='group',
    args = {
        replace = {
            type    = 'toggle',
            name    = O['Replace-Name'],
            desc    = O['Replace-Desc'],
            set     = 'toggleReplace',
            get     = 'getReplace',
        },
        inform = {
            type        = 'toggle',
            name        = O['Inform-Name'],
            desc        = O['Inform-Desc'],
            set         = 'toggleInform',
            get         = 'getInform',
            disabled    = '~getReplace',
        },
    },
};

ForceEnchant:RegisterChatCommand(L["Slash-Commands"],opts);
ForceEnchant:RegisterDefaults("profile", {
    replace = false,
    inform  = true,
} );

function ForceEnchant:toggleReplace()
    self.db.profile.replace = not self.db.profile.replace;
end

function ForceEnchant:getReplace()
    return self.db.profile.replace;
end

function ForceEnchant:toggleInform()
    self.db.profile.inform = not self.db.profile.inform;
end

function ForceEnchant:getInform()
    return self.db.profile.inform;
end

function ForceEnchant:OnEnable()
    -- Called when the addon is enabled
    self:RegisterEvent("REPLACE_ENCHANT");
end

function ForceEnchant:REPLACE_ENCHANT( old_enchant, new_enchant )
    -- Called when the REPLACE_ENCHANT event is fired
    --if not InCombatLockdown() then
        self:doReplace( old_enchant, new_enchant);
    --end
end

function ForceEnchant:doReplace( old_enchant, new_enchant )
    if not self:getReplace() then
        return;
    end
    
    ReplaceEnchant(); --wow api.

    if self:getInform() then
        self:Print( string.format( 
            '%s {%s} => {%s}', 
            L["Replace warning supressed"], 
            old_enchant, new_enchant
        ));
    end
end
