----------------------------
--      Constants         --
----------------------------

local CASTING_SOUND_FILE = "Interface\\AddOns\\FocusInterruptSounds\\casting.wav"
local CC_SOUND_FILE = "Interface\\AddOns\\FocusInterruptSounds\\cc.wav"
local INTERRUPTED_SOUND_FILE = "Interface\\AddOns\\FocusInterruptSounds\\interrupted.wav"
local POLYMORPH_SOUND_FILE = "Interface\\AddOns\\FocusInterruptSounds\\sheep.wav"
local INNERVATE_SOUND_FILE = "Interface\\AddOns\\FocusInterruptSounds\\innervate.wav"

local SCHOOL_PHYSICAL	= 0x01;
local SCHOOL_HOLY	= 0x02;
local SCHOOL_FIRE	= 0x04;
local SCHOOL_NATURE	= 0x08;
local SCHOOL_FROST	= 0x10;
local SCHOOL_SHADOW	= 0x20;
local SCHOOL_ARCANE	= 0x40;
local SCHOOL_ALL	= 0x7F;

local MOB_BLACKLIST = {
	"Ashtongue Elementalist",
	"Ashtongue Mystic",
	"Ashtongue Spiritbinder",
	"Ashtongue Stormcaller",
	"Bonechewer Blood Prophet",
	"Coilskar Sea-Caller",
	"Coilskar Soothsayer",
	"Dragon Turtle",
	"Shadowmoon Blood Mage",
	"Shadowmoon Deathshaper",
	"Sunblade Cabalist",
	"Sunblade Dusk Priest",
};

local CC_SPELLS = {
	"Cyclone",
	"Fear",
	"Polymorph",
	"Seduction",
};

local CC_SPELLS_BREAK_ON_DAMAGE = {
	"Polymorph",
	"Seduction",
};

local CHANNELED_SPELLS = {
	"Arcane Missiles",
	"Drain Life",
	"Drain Mana",
	"Mind Flay",
	"Tranquility",
};

local BLACKLIST_SPELLS = {
	["*"] = {
		"Blaze",
		"Blinding Passion",
		"Corrosion",
		"Corruption",
		"Divine Wrath",
		"Empowered Smite",
		"Ghost Wolf",
		"Immolate",
		"Mass Dispel",
		"Powerful Attraction",
		"Searing Pain",
		"Starfire",
		},
	["Shade of Aran"] = {"Arcane Missiles"},
};

local INSTACAST_SELF_BUFFS = {
	["Nature's Swiftness"] = SCHOOL_NATURE,
	["Presence of Mind"] = SCHOOL_ALL,
};

------------------------------
--      Initialization      --
------------------------------

FocusInterruptSounds = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0")

function FocusInterruptSounds:OnInitialize()

end


function FocusInterruptSounds:OnEnable()
	_, self.strClassName = UnitClass("player");

	self.fIsPetInterrupt = false;
	self.fAntiCCIsDamage = false;
	self.fHasPurge = false;

	if ("WARLOCK" == self.strClassName) then
		self.strInterruptSpellName = "Spell Lock";
		self.iInterruptSchool = SCHOOL_SHADOW;
		self.fIsPetInterrupt = true;
		self.str30YardSpellName = "Shoot";
		self.fHasPurge = true;
	elseif ("MAGE" == self.strClassName) then
		self.strInterruptSpellName = "Counterspell";
		self.iInterruptSchool = SCHOOL_ARCANE;
		self.str30YardSpellName = "Shoot";
		self.fHasPurge = true;
	elseif ("SHAMAN" == self.strClassName) then
		self.strInterruptSpellName = "Earth Shock";
		self.iInterruptSchool = SCHOOL_NATURE;
		self.strAntiCCSpellName = "Grounding Totem";
		self.str30YardSpellName = "Lightning Bolt";
		self.fHasPurge = true;
	elseif ("WARRIOR" == self.strClassName) then
		self.strInterruptSpellName = "Pummel";
		self.iInterruptSchool = SCHOOL_PHYSICAL;
		self.str30YardSpellName = "Shoot";
	elseif ("ROGUE" == self.strClassName) then
		self.strInterruptSpellName = "Kick";
		self.iInterruptSchool = SCHOOL_PHYSICAL;
		self.strAntiCCSpellName = "Cloak of Shadows";
		self.str30YardSpellName = "Shoot";
	elseif ("PRIEST" == self.strClassName) then
		self.strInterruptSpellName = "Silence";
		self.iInterruptSchool = SCHOOL_SHADOW;
		self.strAntiCCSpellName = "Shadow Word: Death";
		self.fAntiCCIsDamage = true;
		self.str30YardSpellName = "Shadow Word: Pain";
		self.fHasPurge = true;
	elseif ("HUNTER" == self.strClassName) then
		self.strInterruptSpellName = "Silencing Shot";
		self.iInterruptSchool = SCHOOL_PHYSICAL;
		self.strAntiCCSpellName = "Feign Death";
		self.str30YardSpellName = "Arcane Shot";
		self.fHasPurge = true;
	elseif ("DRUID" == self.strClassName) then
		self.strInterruptSpellName = "Feral Charge";
		self.iInterruptSchool = SCHOOL_PHYSICAL;
		self.str30YardSpellName = "Faerie Fire";
	end


	-- Only do stuff for classes with an interrupted or silence
	if (nil ~= self.strInterruptSpellName or nil ~= self.strAntiCCSpellName) then
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		self:PrintMessage("Add-on activated for the class " .. self.strClassName);
	else
		self:PrintMessage("Add-on disabled for the class " .. self.strClassName);
	end
end

function FocusInterruptSounds:OnDisable()

end

------------------------------
--        Functions         --
------------------------------

function FocusInterruptSounds:PrintMessage(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cff7fff7fFIS|r: " .. msg);
end

function FocusInterruptSounds:FInArray(element, array)
	local i = 1;

	if (nil ~= array) then
		while (nil ~= array[i]) do
			if (element == array[i]) then
				return true;
			end
			i = i + 1;
		end
	end

	return false;
end

function FocusInterruptSounds:FIsBlacklistSpell(strSpellId, strSpellName, iSpellSchool, strMobName)
	return (0 ~= bit.band(iSpellSchool, SCHOOL_PHYSICAL))
			or self:FInArray(strSpellName, BLACKLIST_SPELLS["*"])
			or self:FInArray(strSpellName, BLACKLIST_SPELLS[strMobName]);
end

function FocusInterruptSounds:FIsChanneledSpell(strSpellId, strSpellName, iSpellSchool)
	return self:FInArray(strMobName, CHANNELED_SPELLS);
end

function FocusInterruptSounds:FIsCCSpell(strSpellId, strSpellName, iSpellSchool, fOnlyCCBreakingOnDamage)

	if (fOnlyCCBreakingOnDamage) then
		return self:FInArray(strSpellName, CC_SPELLS_BREAK_ON_DAMAGE);
	else
		return self:FInArray(strSpellName, CC_SPELLS);
	end
end

function FocusInterruptSounds:FIsMobBlacklisted(strMobName)
	return self:FInArray(strMobName, MOB_BLACKLIST);
end

function FocusInterruptSounds:FIsFocusImmuneOrInstacast(iInterruptSchool, strSpellId, strSpellName, iSpellSchool)

	-- Go through recently cast instacast buffs
	if (nil ~= this.lastInstacastSelfBuffName
		and GetTime() - this.lastInstacastSelfBuffTime < 1
		and 0 ~= bit.band(iSpellSchool, INSTACAST_SELF_BUFFS[this.lastInstacastSelfBuffName])
	) then
		return true;
	end

	-- Go through the focus's buffs
	for i = 1, 40 do
		local strBuffName, _, _, _, _, _ = UnitBuff("focus", i);
		if ("Divine Shield" == strBuffName
			or "Divine Protection" == strBuffName
			or (0 ~= bit.band(iInterruptSchool, SCHOOL_PHYSICAL) and "Blessing of Protection" == strBuffName)
			or (0 ~= bit.band(iInterruptSchool, SCHOOL_SHADOW) and "Nether Protection" == strBuffName)
			or ("Shadow Trance" == strBuffName and "Shadow Bolt" == strSpellName)
		) then
			return true;
		end

		local iInstacastSchool = INSTACAST_SELF_BUFFS[strSpellName];
		if (nil ~= iInstacastSchool and 0 ~= bit.band(iSpellSchool, iInstacastSchool)) then
			return true;
		end
	end

	return false;
end

function FocusInterruptSounds:FIsPetSpellAvailable(strSpellName)

	-- Verify that the pet can act (i.e. isn't feared)
	if (not GetPetActionsUsable()) then
		return false;
	end

	-- Verify that the spell isn't on cooldown (also checks existence)
	iStartTime, _, fSpellEnabled = GetSpellCooldown(strSpellName, BOOKTYPE_PET);
	if (iStartTime ~= 0 or not fSpellEnabled) then
		return false;
	end

	-- Verify mana/energy
	_, _, _, iCost, _, _, _, _, _ = GetSpellInfo(strSpellName);
	if (UnitMana("playerpet") < iCost) then
		return false;
	end

	return true;
end

function FocusInterruptSounds:FIsSpellAvailable(strSpellName)

	-- Verify that the spell isn't on cooldown
	iStartTime, _, fSpellEnabled = GetSpellCooldown(strSpellName);
	if (iStartTime ~= 0 or not fSpellEnabled) then
		return false;
	end

	-- Verify mana/energy
	_, _, _, iCost, _, _, _, _, _ = GetSpellInfo(strSpellName);
	if (UnitMana("player") < iCost) then
		return false;
	end

	return true;
end

function FocusInterruptSounds:COMBAT_LOG_EVENT_UNFILTERED(iTimestamp, strEventType, strSourceGuid, strSourceName, iSourceFlags, strDestGuid, strDestName, iDestFlags, varParam1, varParam2, varParam3, varParam4, varParam5, varParam6, ...)

	local fHandled = false;

	-- Felmyst sounds
	if (not fHandled
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
		and "PRIEST" == self.strClassName
		and "SPELL_CAST_START" == strEventType
		and "Gas Nova" == varParam2
	) then
		self:PrintMessage(strSourceName .. " is casting |cffff4444" .. varParam2 .. "|r!");
		PlaySoundFile(CASTING_SOUND_FILE);
		fHandled = true;
	end

	-- Your partner is sheeped, play a sound
	if (not fHandled
		and 0 ~= bit.band(iDestFlags, COMBATLOG_OBJECT_AFFILIATION_PARTY)
		and 0 ~= bit.band(iDestFlags, COMBATLOG_OBJECT_REACTION_FRIENDLY)
		and "SPELL_AURA_APPLIED" == strEventType
		and "Polymorph" == varParam2
		and IsActiveBattlefieldArena()
	) then
		self:PrintMessage(strDestName .. " is Sheeped!");
		PlaySoundFile(POLYMORPH_SOUND_FILE);
		fHandled = true;
	end

	-- Enemy player in an arena is innervated, play a sound
	if (not fHandled
		and 0 ~= bit.band(iDestFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
		and "SPELL_AURA_APPLIED" == strEventType
		and ((IsActiveBattlefieldArena() and "Innervate" == varParam2)
				or (self.fHasPurge and "Pyrogenics" == varParam2)
				or (self.fHasPurge and "Rune Shield" == varParam2))
	) then
		self:PrintMessage(strDestName .. " has " .. varParam2 .. "!");
		PlaySoundFile(INNERVATE_SOUND_FILE);
		fHandled = true;
	end

	-- Track instacast buffs
	if (0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_FOCUS)
		and "SPELL_CAST_SUCCESS" == strEventType
		and nil ~= INSTACAST_SELF_BUFFS[varParam2]
	) then
		this.lastInstacastSelfBuffName = varParam2;
		this.lastInstacastSelfBuffTime = GetTime();
	end

	-- Play a sound when the Focus starts casting
	if (not fHandled
		and nil ~= self.strInterruptSpellName
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_FOCUS)
		and (("SPELL_CAST_START" == strEventType and not self:FIsBlacklistSpell(varParam1, varParam2, varParam3, strSourceName))
			or ("SPELL_CAST_SUCCESS" == strEventType and self:FIsChanneledSpell(varParam1, varParam2, varParam3)))
		and not self:FIsFocusImmuneOrInstacast(self.iInterruptSchool, varParam1, varParam2, varParam3)
		and (0 == bit.band(iSourceFlags, COMBATLOG_OBJECT_CONTROL_NPC) or not self:FIsMobBlacklisted(strSourceName))
	) then
		if ((self.fIsPetInterrupt and self:FIsPetSpellAvailable(self.strInterruptSpellName))
			or (not self.fIsPetInterrupt and self:FIsSpellAvailable(self.strInterruptSpellName))
		) then
			self:PrintMessage(strSourceName .. " is casting |cffff4444" .. varParam2 .. "|r!");
			PlaySoundFile(CASTING_SOUND_FILE);
			fHandled = true;
		end
	end

	-- Play a sound when a hostile player is attempting to CC you
	if (nil ~= self.strAntiCCSpellName
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
		and "SPELL_CAST_START" == strEventType
		and self:FIsCCSpell(varParam1, varParam2, varParam3, self.fAntiCCIsDamage)
	) then
		if (self:FIsSpellAvailable(self.strAntiCCSpellName) and (IsActiveBattlefieldArena() or 1 == IsSpellInRange(self.str30YardSpellName, strTarget))) then
			self:PrintMessage(strSourceName .. " is casting CC: |cffffcc44" .. varParam2 .. "|r.");
			if (not fHandled) then
				PlaySoundFile(CC_SOUND_FILE);
				fHandled = true;
			end
		else
			self:PrintMessage(strSourceName .. " is casting CC: |cffffcc44" .. varParam2 .. "|r (far away/inactionable).");
		end
	end

	-- Play sound when you interrupt a hostile target
	if (not fHandled
		and "SPELL_INTERRUPT" == strEventType
		and 0 ~= bit.band(iSourceFlags, COMBATLOG_OBJECT_AFFILIATION_MINE)
		and 0 ~= bit.band(iDestFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)
	) then
		self:PrintMessage("Successfully interrupted |cffaaffff" .. varParam5 .. "|r.");
		PlaySoundFile(INTERRUPTED_SOUND_FILE);
		fHandled = true;
	end
end
