-- Prevent multi-loading
if not FLOLIB_VERSION or FLOLIB_VERSION < 1.1 then

-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

FLOLIB_POSITION = "Position";
FLOLIB_POSITIONS = { unlock = "Unlocked", lock = "Locked", auto = "Automatic" };
FLOLIB_SHOWBORDERS = "Show borders";
FLOLIB_LAYOUT = "Layout";
FLOLIB_CONFIRM_RESET = "Do you really want to reset '%s'? The interface will be reloaded.";

-------------------------------------------------------------------------------
-- French localization
-------------------------------------------------------------------------------

if (GetLocale() == "frFR") then

FLOLIB_POSITION = "Position";
FLOLIB_POSITIONS.unlock = "Déverrouillée";
FLOLIB_POSITIONS.lock = "Verrouillée";
FLOLIB_POSITIONS.auto = "Automatique";
FLOLIB_SHOWBORDERS = "Afficher les cadres";
FLOLIB_LAYOUT = "Disposition";
FLOLIB_CONFIRM_RESET = "Voulez-vous vraiment réinitialiser '%s' ? L'interface sera rechargée.";

end

-------------------------------------------------------------------------------
-- German localization
-------------------------------------------------------------------------------

if (GetLocale() == "deDE") then

FLOLIB_POSITION = "Position";
FLOLIB_POSITIONS.unlock = "Entriegelte";
FLOLIB_POSITIONS.lock = "Verriegelte";
FLOLIB_POSITIONS.auto = "Automatische";
FLOLIB_SHOWBORDERS = "Ränder zeigen";
FLOLIB_LAYOUT = "Layout";
FLOLIB_CONFIRM_RESET = "Möchtet Ihr wirklich '%s' zurücksetzen? Die Schnittstelle wird neu geladen.";

end

-------------------------------------------------------------------------------
-- Spanish localization
-------------------------------------------------------------------------------

if (GetLocale() == "esES") then

FLOLIB_POSITION = "Posición";
FLOLIB_POSITIONS.unlock = "Desatrancada";
FLOLIB_POSITIONS.lock = "Cerrada";
FLOLIB_POSITIONS.auto = "Automática";
FLOLIB_SHOWBORDERS = "Mostrar bordes";
FLOLIB_LAYOUT = "Disposición";
FLOLIB_CONFIRM_RESET = "¿Seguro que quieres reajustar '%s'? El interfaz será recargado.";

end



-------------------------------------------------------------------------------
-- Simplified Chinese localization
-------------------------------------------------------------------------------

if (GetLocale() == "zhCN") then

FLOLIB_POSITION = "位置";
FLOLIB_POSITIONS.unlock = "开锁";
FLOLIB_POSITIONS.lock = "锁着";
FLOLIB_POSITIONS.auto = "自动";
FLOLIB_SHOWBORDERS = "显示疆界";
FLOLIB_LAYOUT = "格式";
FLOLIB_CONFIRM_RESET = "您真正地想要重新设置 '%s' 吗? 界面将被重新载入。";

end

-------------------------------------------------------------------------------
-- Russian localization
-------------------------------------------------------------------------------

if (GetLocale() == "ruRU") then

FLOLIB_POSITION = "Положение";
FLOLIB_POSITIONS.unlock = "Свободное";
FLOLIB_POSITIONS.lock = "Фиксированное";
FLOLIB_POSITIONS.auto = "Автоматическое";
FLOLIB_SHOWBORDERS = "Показывать границы";
FLOLIB_LAYOUT = "Вывод";
FLOLIB_CONFIRM_RESET = "Вы действительно хотите сбросить'%s'? Интерфейс будет перезагружен.";

end


end
