-- Bartender3 license as I used some of its code
--[[
Copyright (c) 2007, Hendrik Leppkes < h.leppkes@gmail.com >
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are 
met:

    * Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution.
    * Neither the name of the Bartender3 Development Team nor the names of 
       its contributors may be used to endorse or promote products derived 
       from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]

-- FlexBar2 license
--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]

-- First make sure that the TextSubs module is loaded
local Zoomed = FlexBar2:NewModule("Zoomed");

-- Create a ButtonMixin, this will be mixed into every button object
Zoomed.ButtonMixin = {};

function Zoomed.ButtonMixin:Activate()
	-- Remove the border from the icons themselves
	self.Frame.Icon:SetTexCoord(0.08, 0.92, 0.08, 0.92);
	-- Make the icons slightly wider so there is no 0.5px blank space between them
	self.Frame.Icon:SetPoint("TOPLEFT", self.Frame, "TOPLEFT", -0.5, 0.5);
	self.Frame.Icon:SetPoint("BOTTOMRIGHT", self.Frame, "BOTTOMRIGHT", 0.5, -0.5);
	-- Put the icon's draw order above the normaltexture
	self.Frame.Icon:SetDrawLayer("BORDER");
	self.Frame:GetNormalTexture():SetDrawLayer("BACKGROUND");
	-- Resize the checked texture so it doesn't look ugly
	if(self.Frame.CheckedTexture) then
		self.Frame.CheckedTexture:SetPoint("TOPLEFT", self.Frame, "TOPLEFT", -1, 1); 
		self.Frame.CheckedTexture:SetPoint("BOTTOMRIGHT", self.Frame, "BOTTOMRIGHT", 1, -1);
	end
end

function Zoomed.ButtonMixin:Deactivate()
	-- Undo everything
	self.Frame.Icon:SetTexCoord(0, 1, 0, 1);
	self.Frame.Icon:SetPoint("TOPLEFT", self.Frame, "TOPLEFT", 0, 0); 
	self.Frame.Icon:SetPoint("BOTTOMRIGHT", self.Frame, "BOTTOMRIGHT", 0, 0);
	self.Frame.Icon:SetDrawLayer("BACKGROUND");
	self.Frame:GetNormalTexture():SetDrawLayer("ARTWORK");
	if(self.Frame.CheckedTexture) then
		self.Frame.CheckedTexture:SetPoint("TOPLEFT", self.Frame, "TOPLEFT", 0, 0); 
		self.Frame.CheckedTexture:SetPoint("BOTTOMRIGHT", self.Frame, "BOTTOMRIGHT", 0, 0);
	end
end
