--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- First make sure that the TextSubs module is loaded
if(FlexBar2:HasModule("TextSubs")) then
	local ComboPoints = FlexBar2:NewModule("ComboPoints");

	-- Create a ButtonMixin, this will be mixed into every button object
	ComboPoints.ButtonMixin = {};

	-- Create a local function to update textsubs, it should be registered on activate and unregsitered on deactivate
	local UpdateComboPoints = function(self) self:UpdateTextSub("cp"); end;
	function ComboPoints.ButtonMixin:Activate()
		self:AddEventListener("PLAYER_COMBO_POINTS", UpdateComboPoints);
	end

	function ComboPoints.ButtonMixin:Deactivate()
		self:RemoveEventListener("PLAYER_COMBO_POINTS", UpdateComboPoints);
	end

	-- Register $(cp)
	FlexBar2:GetModule("TextSubs"):RegisterTextSub("cp", function() return GetComboPoints(); end);
end
