local BuffDur = FlexBar2:NewModule("BuffDur", "LibRockEvent-1.0");
-- If this var is incremented, SetDefaults() will be called for this module thus resetting all its settings.
BuffDur.Version = 1;
BuffDur.ButtonMixin = {};

local Aura = Rock("LibSpecialEvents-Aura-3.0");

function BuffDur.ButtonMixin:Activate()
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffGained", "AddNewPlayerBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffLost", "DelPlayerBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffRefreshed", "RefreshPlayerBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffRefreshed", "RefreshUnitBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffGained", "AddNewUnitBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffLost", "DelUnitBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffGained", "AddNewUnitDebuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffLost", "DelUnitDebuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffRefreshed", "RefreshUnitDebuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "AuraTargetChanged", "UpdateBuffDuration");
  self:AddEventListener("FlexBar2_EventManager", "ActionChanged", "UpdateBuffDuration");
end

function BuffDur.ButtonMixin:Deactivate()
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffGained", "AddNewPlayerBuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffLost", "DelPlayerBuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "PlayerBuffRefreshed", "RefreshPlayerBuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffGained", "AddNewUnitDebuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffLost", "DelUnitDebuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "AuraTargetChanged", "BuffDurTargetChange");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffRefreshed", "RefreshUnitBuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffGained", "AddNewUnitBuff");
  self:RemoveEventListener("LibSpecialEvents-Aura-3.0", "UnitBuffLost", "DelUnitBuff");
  self:AddEventListener("LibSpecialEvents-Aura-3.0", "UnitDebuffRefreshed", "RefreshUnitDebuff");
  self:RemoveEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");  
  self:RemoveEventListener("FlexBar2_EventManager", "ActionChanged", "UpdateBuffDuration");
  self.DurBuffIcon = nil;
  self.DurEndTime = 0;
end

function BuffDur:GetBuffDuration(Icon, Unit, Buff)
	local buffs;
  
  if(Buff == 1) then
    buffs = Aura.vars.buffs[Unit];
  else
    buffs = Aura.vars.debuffs[Unit];
  end

  if(buffs == nil) then
    return nil
  end
  
  for buffIndex in pairs(buffs.index) do
    if(Icon == buffs.icon[buffIndex]) then
      return buffs.timeEnd[buffIndex]
    end
  end
end

function BuffDur:UpdateButtonDuration(Button, Icon, Unit, Buff)
  local Index, TimeLeft;

  if(Buff == 1) then
    Index = Aura:UnitHasBuff(Unit, nil, nil, Icon);
  else
    Index = Aura:UnitHasDebuff(Unit, nil, nil, Icon);
  end

  if(Index == nil) then
    return nil;
  end

  TimeLeft = BuffDur:GetBuffDuration(Icon, Unit, Buff) or nil;
  if(TimeLeft == nil or TimeLeft == 0) then
    Button.DurEndTime = 0;
    Button.BurBuffIcon = nil;
    Button:UpdateTextSub("buffdur");
    Button:RemoveEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
    return Index;
  end
  Button.DurEndTime = TimeLeft;
  Button.DurBuffIcon = Icon;
  Button:UpdateTextSub("buffdur");
  Button:AddEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
  return Index;
end

function BuffDur.ButtonMixin:UpdateBuffDuration(Event, NameSpace, Dispatcher, Button)
  local Icon = self:GetActionTexture();

  if(Event == "ActionChanged" and Button ~= self) then
    return;
  end

  if(Icon == nil) then
    return;
  end

  -- If we passed in a unit paramter, check that
  if(self.DurBuffUnit ~= nil and BuffDur:UpdateButtonDuration(self, Icon, self.DurBuffUnit, 1) ~= nil) then
    return;
  end

  -- If this button has a unit, check that 
  local Unit = self:GetModifiedAttribute("unit");
  if(Unit ~= nil and BuffDur:UpdateButtonDuration(self, Icon, Unit, 1) ~= nil) then
    return;
  end

  -- Check target buffs
  if(BuffDur:UpdateButtonDuration(self, Icon, "target", 1) ~= nil) then
    return;
  end

  -- Then Check target debuffs
  if(BuffDur:UpdateButtonDuration(self, Icon, "target", 0) ~= nil) then
    return;
  end

  -- Then finally player buffs
  if(BuffDur:UpdateButtonDuration(self, Icon, "player", 1) ~= nil) then
    return;
  end
end

function BuffDur.ButtonMixin:RefreshUnitDebuff(Event, NameSpace, Dispatcher, unit, name, count, dispelType, icon, rank, index, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil) then
    return;
  end

  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
end

function BuffDur.ButtonMixin:RefreshUnitBuff(Event, NameSpace, Dispatcher, unit, name, index, count, icon, rank, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil) then
    return;
  end

  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
end

function BuffDur.ButtonMixin:RefreshPlayerBuff(Event, NameSpace, Dispatcher, name, index, count, icon, rank, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil) then
    return;
  end
  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
end

function BuffDur.ButtonMixin:AddNewPlayerBuff(Event, NameSpace, Dispatcher, name, index, count, icon, rank, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil) then
    return;
  end
  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
  self:AddEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
end 

function BuffDur.ButtonMixin:DelPlayerBuff(Event, NameSpace, Dispatcher, name, count, icon, rank)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  self.DurEndTime = 0;
  self.DurBuffIcon = nil;
  self:RemoveEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
  self:UpdateTextSub("buffdur");
end

function BuffDur.ButtonMixin:AddNewUnitBuff(Event, Namespace, Dispatcher, unit, name, index, count, icon, rank, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil or timeLeft == 0) then
    return;
  end

  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
  self:AddEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration"); 
end

function BuffDur.ButtonMixin:DelUnitBuff(Event, NameSpace, Dispatcher, unit, name, count, icon, rank, duration)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  self.DurEndTime = 0;
  self.DurBuffIcon = nil;
  self:RemoveEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
  self:UpdateTextSub("buffdur");
end

function BuffDur.ButtonMixin:AddNewUnitDebuff(Event, NameSpace, Dispatcher, unit, name, count, dispelType, icon, rank, index, duration, timeLeft)
  local Icon = self:GetActionTexture();

  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  if(timeLeft == nil) then
    return;
  end
  self.DurEndTime = GetTime() + timeLeft;
  self.DurBuffIcon = Icon;
  self:AddEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration"); 
end 

function BuffDur.ButtonMixin:DelUnitDebuff(Event, Namespace, Dispatcher, unit, name, count, dispelType, icon, rank, duration)
  local Icon = self:GetActionTexture();


  -- Either we dont have a spell on this button, or this event isnt for us
  if(Icon == nil or Icon ~= icon) then
    return;
  end

  self.DurEndTime = 0;
  self.DurBuffIcon = nil;
  self:RemoveEventListener("FlexBar2_EventManager", "UPDATE", "UpdateDuration");
  self:UpdateTextSub("buffdur");
end

function BuffDur.ButtonMixin:UpdateDuration()
  self:UpdateTextSub("buffdur")
end

function BuffDur:RegisterBuffDur()
  TextSubs:RegisterTextSub("buffdur", function(Button, Unit)
    local TimeLeft = 0;
    local SecondsLeft;

    if(Button.DurBuffUnit == nil) then
      Button.DurBuffUnit = Unit;
    end

    if(Button.DurBuffIcon == nil or Button.DurBuffIcon ~= Button:GetActionTexture()) then
      return "";
    end

    if(Button.DurEndTime == nil or Button.DurEndTime <= 0) then
      return "";
    end

    TimeLeft = floor(Button.DurEndTime - GetTime() + 0.5);

    if(TimeLeft < 0) then
      return "";
    elseif(TimeLeft < 60) then
      return TimeLeft .. "s";
    else
      return floor(TimeLeft/60 + 0.5) .. "m"; 
    end
  end);
end

if(FlexBar2:HasModule("TextSubs")) then
  local TextSubs = FlexBar2:GetModule("TextSubs");

  if(Rock("LibRockEvent-1.0"):IsFullyInitialized()) then
    BuffDur:RegisterBuffDur();
  else
    BuffDur:AddEventListener("LibRockEvent-1.0", "FullyInitialized", BuffDur.RegisterBuffDur);
  end
end

