--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- SlashCommands --
local SlashCommands = FlexBar2.SlashCommands;
local function SlashCommand_Tooltip(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ShowTooltip = Params.tooltip;
	local ButtonList = FlexBar2.Buttons;
	-- Force a state reset after applying the new settings to make sure the button actualy gets it
	if(ShowTooltip == "true") then
		FlexBar2:ApplySetting(ButtonTable, "ShowTooltip", true);
	else
		FlexBar2:ApplySetting(ButtonTable, "ShowTooltip", false);
		
	end
	-- Loop through given button range
	for _, ButtonName in ipairs(ButtonTable) do
		if(ShowTooltip == "true") then
			ButtonList[ButtonName]:EnableTooltip();
		else
			ButtonList[ButtonName]:DisableTooltip();
		end
	end
end

-- Localize this neat verify function for faster access
local VerifyExistance = FlexBar2.SlashCommands.VerifyExistance;
-- AddCommand format :AddCommand(Command, Function, Group, Help)
-- AddParam format :AddParam(Command, Param, Required, AllowedValues, DefaultValue, VerifyFunc) 
-- everything here should be self explainative knowing the syntax
SlashCommands:AddCommand("settooltip", SlashCommand_Tooltip, "tooltip", "tooltip=<true/false>");
SlashCommands:SetAlias("settooltip", "tooltip");
	SlashCommands:AddParam("settooltip", "tooltip", true, {"true", "false"}, nil, nil);
	SlashCommands:AddParam("settooltip", "button", true, nil, nil, VerifyExistance)

