--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- SlashCommands --

-- /fb settext command
local function SlashCommand_SetText(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local Field = tonumber(Params.field);
	local Text = Params.text;
	local Red = Params.red;
	local Blue = Params.blue;
	local Green = Params.green;
	local Alpha = Params.alpha;
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		local InfoTable = Button.InfoTable.TextSubs[Field]
		if(Text) then
			InfoTable.Text = Text;
			Button:SetTextFieldText(Field, Text);
		end
		if(Red or Blue or Green or Alpha) then
			InfoTable.Red = Red or InfoTable.Red;
			InfoTable.Green = Green or InfoTable.Green;
			InfoTable.Blue = Blue or InfoTable.Blue;
			InfoTable.Alpha = Alpha or InfoTable.Alpha;
			Button:SetTextFieldColor(Field, Red or InfoTable.Red, Green or InfoTable.Green, Blue or InfoTable.blue, Alpha or InfoTable.Alpha);
		end
	end
end

-- /fb gettext command
local function SlashCommand_GetText(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local Field = tonumber(Params.field);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		FlexBar2:Print(Button.Name .. " has as text [" .. (Button:GetTextFieldText(Field) or "nil") .. "]");
	end
end


local SlashCommands = FlexBar2.SlashCommands;
-- Localize this neat verify function for faster access
local VerifyExistance = FlexBar2.SlashCommands.VerifyExistance;
-- AddCommand format :AddCommand(Command, Function, Group, Help)
-- AddParam format :AddParam(Command, Param, Required, AllowedValues, DefaultValue, VerifyFunc) 
-- everything here should be self explainative knowing the syntax
SlashCommands:AddCommand("settext", SlashCommand_SetText, "text", "button=<Button> field=<1-5> (text=<text>) (red=<Red %>) (green=<Green %) (blue=<Blue %) (alpha=<Alpha %>)");
SlashCommands:SetAlias("settext", "text");
	SlashCommands:AddParam("settext", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("settext", "field", true, {"1", "2", "3", "4", "5"}, nil, nil);
SlashCommands:AddCommand("gettext", SlashCommand_GetText, "text", "button=<Button> field=<1-5>");
	SlashCommands:AddParam("gettext", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("gettext", "field", true, {"1", "2", "3", "4", "5"}, nil, nil);
