--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]

local SpellCache =  FlexBar2:NewModule("SpellCache", "LibRockEvent-1.0");
-- If this var is incremented, SetDefaults() will be called for this module thus resetting all its settings. Though there are no settings for this module, it has to be declared
SpellCache.Version = 1;

local Cache = {};
SpellCache.Cache = Cache;

function SpellCache:OnEnable()
	-- Schedule a cache update on initial loading
    SpellCache.ScheduleUpdate = true;
	-- Schedule a cache update when new spells are learned
    self:AddEventListener("LEARNED_SPELL_IN_TAB", function() SpellCache.ScheduleUpdate = true; self:DispatchEvent("SpellCacheUpdate"); end);
end

function SpellCache:BuildSpellCache()
    FlexBar2:Debug("Building SpellCache");
	-- Clear the old cache first
    for SpellName, _ in pairs(Cache) do 
        Cache[SpellName] = nil;
    end
	for TabId = 1, GetNumSpellTabs() do
		local TabName, _, TabOffset, TabNumSpells = GetSpellTabInfo(TabId);  
		for SpellSlot = TabOffset + 1, TabOffset + TabNumSpells do
			local SpellName, SpellRank = GetSpellName(SpellSlot, BOOKTYPE_SPELL);
			Cache[SpellName] = SpellSlot;
			Cache[SpellName .. "()"] = SpellSlot;
			Cache[SpellName .. "(" .. SpellRank .. ")"] = SpellSlot;
		end
	end
end

-- Small function to get something from the cache easely
function SpellCache:GetSpellInfo(SpellName)
	-- If an update is scheduled, update before returning stuff
	if(SpellCache.ScheduleUpdate == true) then
		SpellCache:BuildSpellCache();
		SpellCache.ScheduleUpdate = false;
	end
    return Cache[SpellName];
end

