--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
FlexBar2.OO = {};
-- Object Handlers, loop through all mixins and call said functions
-- Note: Only Initialize is handled by the OO API, the rest has to be called manualy.
-- Loadsettings handler
local Handlers = {
	-- Loadsettings handler
	LoadSettings = function(self, ...)
		local ModulesState = FlexBar2.db.profile.Modules;
		for _, Mixin in pairs(self.MixinList) do
			local LoadSettings = Mixin.LoadSettings;
			if(ModulesState[Mixin.MixinName] ~= false and type(LoadSettings) == "function") then
				LoadSettings(self, ...);
			end
		end
	end,
	-- UpdateSettings handler
	UpdateSettings = function(self, ...)
		local ModulesState = FlexBar2.db.profile.Modules;
		for _, Mixin in pairs(self.MixinList) do
			local UpdateSettings = Mixin.UpdateSettings;
			if(ModulesState[Mixin.MixinName] ~= false and type(UpdateSettings) == "function") then
				UpdateSettings(self, ...);
			end
		end
	end,

	-- SetDefaults handler
	SetDefaults = function(self, ...)
		local ModulesState = FlexBar2.db.profile.Modules;
		for _, Mixin in pairs(self.MixinList) do
			local SetDefaults = Mixin.SetDefaults;
			if(ModulesState[Mixin.MixinName] ~= false and type(SetDefaults) == "function") then
				SetDefaults(self, ...);
			end
		end
	end,
	-- Initialize handler
	Load = function(self, ...)
		for _, Mixin in pairs(self.MixinList) do
			local Load = Mixin.Load;
			if(type(Load) == "function") then
				Load(self, ...);
			end
		end
	end,
	-- Activate handler
	Activate = function(self, ...)
		local ModulesState = FlexBar2.db.profile.Modules;
		for _, Mixin in pairs(self.MixinList) do
			local Activate = Mixin.Activate;
			if(ModulesState[Mixin.MixinName] ~= false and type(Activate) == "function") then
				Activate(self, ...);
			end
		end
	end,
	-- Deactivate handler
	Deactivate = function(self, ...)
		local ModulesState = FlexBar2.db.profile.Modules;
		for _, Mixin in pairs(self.MixinList) do
			local Deactivate = Mixin.Deactivate;
			if(ModulesState[Mixin.MixinName] ~= false and type(Deactivate) == "function") then
				Deactivate(self, ...);
			end
		end
	end
};

local mts = setmetatable({}, {__index=function(self, key)
	self[key] = {__index = key};
	return self[key];
end, __mode='kv'})
-- Class handlers
-- new: create a new object and call the Initialize methods
local new = function(Class, ...)
	local Object = {};
	Object.uid = string.match(tostring(Object), "table: (.*)"); 
	setmetatable(Object, mts[Class]);
	Object:Initialize(...);
	return Object;
end
	function FlexBar2.OO.Class(MixinList)
	FlexBar2:Debug("creating new class");
	local Class = {};
	Class.MixinList = MixinList;
	Class.new = new;
	-- Loop through all mixins to include their stuff in the class
	for i, Mixin in ipairs(MixinList) do
		for Name, Value in pairs(Mixin) do
			-- Check for conflicts, only include non-conflicting stuff
			if(Class[Name] == nil) then
				Class[Name] = Value;
			-- Handlers are allowed to conflict, the rest ain't
			elseif(Handlers[Name] == nil and Name ~= "MixinName") then
				error("OO Namespace conflict on " .. Name);
			end
		end
	end
	for HandlerName, HandlerFunction in pairs(Handlers) do
		Class[HandlerName] = HandlerFunction;
	end
	return Class;
end
