--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- SlashCommands --
local SlashCommands = FlexBar2.SlashCommands;


-- /fb getbinding command
local function SlashCommand_GetBinding(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	-- ToButtonTable command abuse, it serves us well
	local ButtonList = FlexBar2.Buttons;
	for Key, ButtonName in ipairs(ButtonTable) do
		FlexBar2:Print(ButtonName .. " is bound to [" .. (ButtonList[ButtonName]:GetBinding() or "") .. "]");
	end
end


-- /fb setbinding command
local function SlashCommand_SetBinding(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	-- ToButtonTable command abuse, it serves us well
	local BindingsList = { string.split(";", Params.binding) };
	local ButtonList = FlexBar2.Buttons;
	if(Params.binding ~= "" and #ButtonTable ~= #BindingsList) then FlexBar2:Print("number of bindings given does not match the numbers of buttons given"); return; end
	for Key, ButtonName in ipairs(ButtonTable) do
		if(Params.binding == "") then
			ButtonList[ButtonName]:SetBinding();
		else
			ButtonList[ButtonName]:SetBinding(BindingsList[Key]);

		end
	end
end

-- Localize this neat verify function for faster access
local VerifyExistance = FlexBar2.SlashCommands.VerifyExistance;

-- Helper verification function
local VerifyBinding = function(BindingString)
	if(BindingString == "") then return true; end
	local BindingList = { string.split(";", BindingString) };
	for _, Binding in ipairs(BindingList) do
		if(Binding == "MM") then Binding = "BUTTON3"; end
		if(not FlexBar2:GetModule("Keybindings"):ValidateBinding(Binding)) then
			return "Invalid keybinding";
		end
	end
	return true;
end

-- AddCommand format :AddCommand(Command, Function, Group, Help)
-- AddParam format :AddParam(Command, Param, Required, AllowedValues, DefaultValue, VerifyFunc) 
-- everything here should be self explainative knowing the syntax
SlashCommands:AddCommand("setbinding", SlashCommand_SetBinding, "keybinding", "button=<Button> binding=<Key>");
SlashCommands:SetAlias("setbinding", "bind");
SlashCommands:SetAlias("setbinding", "binding");
	SlashCommands:AddParam("setbinding", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("setbinding", "binding", false, nil, "", VerifyBinding);
SlashCommands:AddCommand("getbinding", SlashCommand_GetBinding, "keybinding", "button=<Button> binding=<Key>");
SlashCommands:SetAlias("getbinding", "getbind");
	SlashCommands:AddParam("getbinding", "button", true, nil, nil, VerifyExistance);
