--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
local ItemCache =  FlexBar2:NewModule("ItemCache", "LibRockEvent-1.0");
-- If this var is incremented, SetDefaults() will be called for this module thus resetting all its settings. Though there are no settings for this module, it has to be declared
ItemCache.Version = 1;

local Cache = {};
ItemCache.Cache = Cache;

function ItemCache:OnEnable()
	-- Schedule an update on initial loading
	ItemCache.ScheduleUpdate = true;
	-- Schedule a cache update when those events trigger
	self:AddEventListener("BAG_UPDATE", function() ItemCache.ScheduleUpdate = true; ItemCache:DispatchEvent("ItemsChanged"); end);
	self:AddEventListener("UNIT_INVENTORY_CHANGED", function(UnitId) if(UnitId == "player") then ItemCache.ScheduleUpdate = true; ItemCache:DispatchEvent("ItemsChanged"); end end);
end

function ItemCache:BuildItemCache()
    FlexBar2:Debug("Building ItemCache");
	-- Clear the old cache first
    for ItemLink, _ in pairs(Cache) do
        for Info, _ in pairs(Cache[ItemLink]) do
            Cache[ItemLink][Info] = nil;
        end
    end
	-- Loop through all bags
    for Bag = 0, 4 do
		-- loop through all slots in current bag
        for Slot =1, GetContainerNumSlots(Bag) do
			-- Get itemlink
            local ItemLink = GetContainerItemLink(Bag, Slot);
            if(ItemLink) then
				-- Strip out the SHITTY uniqueID FUCK and replace it by zero
				ItemLink = string.gsub(ItemLink, "(.*):(.-)$", "%1:0");
				-- Put itemlink: in front of the itemlink :p
                ItemLink = "itemlink:" .. ItemLink
				-- Sanity check 
                if(type(Cache[ItemLink]) ~= "table") then Cache[ItemLink] = {}; end
				-- Save bag id & bagslot
                Cache[ItemLink].Bag = Bag;
                Cache[ItemLink].BagSlot = Slot;
            end
        end
    end
	-- Loop through all equiped slots
    for Slot = 0, 23 do
		-- Get itemlink
        local ItemLink = GetInventoryItemLink("player", Slot);
        if(ItemLink) then
			-- Strip out the SHITTY uniqueID FUCK and replace it by zero
				ItemLink = string.gsub(ItemLink, "(.*):(.-)$", "%1:0");
			-- Put itemlink: in front of the itemlink :p
            ItemLink = "itemlink:" .. ItemLink;
			-- Sanity check
            if(type(Cache[ItemLink]) ~= "table") then Cache[ItemLink] = {}; end
			-- Save inventory slot
            Cache[ItemLink].InvSlot = Slot;
        end
    end
end

-- Small function to get something from the cache easely
function ItemCache:GetItemInfo(ItemLink)
	if(ItemLink) then
		-- If an update is scheduled, update before returning stuff
		if(ItemCache.ScheduleUpdate == true) then
			ItemCache:BuildItemCache();
			ItemCache.ScheduleUpdate = false;
		end
		-- Strip out the UniqueID FUCK
		ItemLink = string.gsub(ItemLink, "(.*):(.-)$", "%1:0");
		return Cache[ItemLink] or Cache["itemlink:" .. ItemLink] or false;
	end
end
